"use strict";const Logger=require("./connection/logger"),retrieveBSON=require("./connection/utils").retrieveBSON,MongoError=require("./error").MongoError,MongoNetworkError=require("./error").MongoNetworkError,collationNotSupported=require("./utils").collationNotSupported,ReadPreference=require("./topologies/read_preference"),isUnifiedTopology=require("./utils").isUnifiedTopology,executeOperation=require("../operations/execute_operation"),Readable=require("stream").Readable,SUPPORTS=require("../utils").SUPPORTS,MongoDBNamespace=require("../utils").MongoDBNamespace,mergeOptions=require("../utils").mergeOptions,OperationBase=require("../operations/operation").OperationBase,BSON=retrieveBSON(),Long=BSON.Long,CursorState={INIT:0,OPEN:1,CLOSED:2,GET_MORE:3};function handleCallback(r,t,e){try{r(t,e)}catch(t){process.nextTick(function(){throw t})}}class CoreCursor extends Readable{constructor(r,t,e,o){super({objectMode:!0}),o=o||{},t instanceof OperationBase&&(this.operation=t,t=this.operation.ns.toString(),o=this.operation.options,e=this.operation.cmd||{}),this.pool=null,this.server=null,this.disconnectHandler=o.disconnectHandler,this.bson=r.s.bson,this.ns=t,this.namespace=MongoDBNamespace.fromString(t),this.cmd=e,this.options=o,this.topology=r,this.cursorState={cursorId:null,cmd:e,documents:o.documents||[],cursorIndex:0,dead:!1,killed:!1,init:!1,notified:!1,limit:o.limit||e.limit||0,skip:o.skip||e.skip||0,batchSize:o.batchSize||e.batchSize||1e3,currentLimit:0,transforms:o.transforms,raw:o.raw||e&&e.raw},"object"==typeof o.session&&(this.cursorState.session=o.session);r=r.s.options;"boolean"==typeof r.promoteLongs?this.cursorState.promoteLongs=r.promoteLongs:"boolean"==typeof o.promoteLongs&&(this.cursorState.promoteLongs=o.promoteLongs),"boolean"==typeof r.promoteValues?this.cursorState.promoteValues=r.promoteValues:"boolean"==typeof o.promoteValues&&(this.cursorState.promoteValues=o.promoteValues),"boolean"==typeof r.promoteBuffers?this.cursorState.promoteBuffers=r.promoteBuffers:"boolean"==typeof o.promoteBuffers&&(this.cursorState.promoteBuffers=o.promoteBuffers),"boolean"==typeof r.bsonRegExp?this.cursorState.bsonRegExp=r.bsonRegExp:"boolean"==typeof o.bsonRegExp&&(this.cursorState.bsonRegExp=o.bsonRegExp),r.reconnect&&(this.cursorState.reconnect=r.reconnect),this.logger=Logger("Cursor",r),"number"==typeof e?(this.cursorState.cursorId=Long.fromNumber(e),this.cursorState.lastCursorId=this.cursorState.cursorId):e instanceof Long&&(this.cursorState.cursorId=e,this.cursorState.lastCursorId=e),this.operation&&(this.operation.cursorState=this.cursorState)}setCursorBatchSize(r){this.cursorState.batchSize=r}cursorBatchSize(){return this.cursorState.batchSize}setCursorLimit(r){this.cursorState.limit=r}cursorLimit(){return this.cursorState.limit}setCursorSkip(r){this.cursorState.skip=r}cursorSkip(){return this.cursorState.skip}_next(r){nextFunction(this,r)}clone(){const r=mergeOptions({},this.options);return delete r.session,this.topology.cursor(this.ns,this.cmd,r)}isDead(){return!0===this.cursorState.dead}isKilled(){return!0===this.cursorState.killed}isNotified(){return!0===this.cursorState.notified}bufferedCount(){return this.cursorState.documents.length-this.cursorState.cursorIndex}readBufferedDocuments(r){var t=this.cursorState.documents.length-this.cursorState.cursorIndex;let e=this.cursorState.documents.slice(this.cursorState.cursorIndex,this.cursorState.cursorIndex+(r<t?r:t));if(this.cursorState.transforms&&"function"==typeof this.cursorState.transforms.doc)for(let r=0;r<e.length;r++)e[r]=this.cursorState.transforms.doc(e[r]);return 0<this.cursorState.limit&&this.cursorState.currentLimit+e.length>this.cursorState.limit&&(e=e.slice(0,this.cursorState.limit-this.cursorState.currentLimit),this.kill()),this.cursorState.currentLimit=this.cursorState.currentLimit+e.length,this.cursorState.cursorIndex=this.cursorState.cursorIndex+e.length,e}kill(r){this.cursorState.dead=!0,this.cursorState.killed=!0,this.cursorState.documents=[],null==this.cursorState.cursorId||this.cursorState.cursorId.isZero()||!1===this.cursorState.init?r&&r(null,null):this.server.killCursors(this.ns,this.cursorState,r)}rewind(){this.cursorState.init&&(this.cursorState.dead||this.kill(),this.cursorState.currentLimit=0,this.cursorState.init=!1,this.cursorState.dead=!1,this.cursorState.killed=!1,this.cursorState.notified=!1,this.cursorState.documents=[],this.cursorState.cursorId=null,this.cursorState.cursorIndex=0)}_read(){if(this.s&&this.s.state===CursorState.CLOSED||this.isDead())return this.push(null);this._next((r,t)=>r?(this.listeners("error")&&0<this.listeners("error").length&&this.emit("error",r),this.isDead()||this.close(),this.emit("end"),this.emit("finish")):this.cursorState.streamOptions&&"function"==typeof this.cursorState.streamOptions.transform&&null!=t?this.push(this.cursorState.streamOptions.transform(t)):(this.push(t),void(null===t&&this.isDead()&&this.once("end",()=>{this.close(),this.emit("finish")}))))}_endSession(r,t){"function"==typeof r&&(t=r,r={}),r=r||{};const e=this.cursorState.session;return e&&(r.force||e.owner===this)?(this.cursorState.session=void 0,this.operation&&this.operation.clearSession(),e.endSession(t),!0):(t&&t(),!1)}_getMore(o){this.logger.isDebug()&&this.logger.debug(`schedule getMore call for query [${JSON.stringify(this.query)}]`);let r=this.cursorState.batchSize;0<this.cursorState.limit&&this.cursorState.currentLimit+r>this.cursorState.limit&&(r=this.cursorState.limit-this.cursorState.currentLimit);const s=this.cursorState;this.server.getMore(this.ns,s,r,this.options,(r,t,e)=>{(r||s.cursorId&&s.cursorId.isZero())&&this._endSession(),o(r,t,e)})}_initializeCursor(o){const s=this;if(isUnifiedTopology(s.topology)&&s.topology.shouldCheckForSessionSupport())s.topology.selectServer(ReadPreference.primaryPreferred,r=>{r?o(r):this._initializeCursor(o)});else{const n=(r,t)=>{if(r)return i(r);r=t.message;if(Array.isArray(r.documents)&&1===r.documents.length){var e=r.documents[0];if(r.queryFailure)return i(new MongoError(e),null);if(!s.cmd.find||s.cmd.find&&!1===s.cmd.virtual){if(e.$err||e.errmsg)return i(new MongoError(e),null);if(null!=e.cursor&&"string"!=typeof e.cursor){t=e.cursor.id;return e.cursor.ns&&(s.ns=e.cursor.ns),s.cursorState.cursorId="number"==typeof t?Long.fromNumber(t):t,s.cursorState.lastCursorId=s.cursorState.cursorId,s.cursorState.operationTime=e.operationTime,Array.isArray(e.cursor.firstBatch)&&(s.cursorState.documents=e.cursor.firstBatch),i(null,r)}}}e=r.cursorId||0;s.cursorState.cursorId=e instanceof Long?e:Long.fromNumber(e),s.cursorState.documents=r.documents,s.cursorState.lastCursorId=r.cursorId,s.cursorState.transforms&&"function"==typeof s.cursorState.transforms.query&&(s.cursorState.documents=s.cursorState.transforms.query(r)),i(null,r)};if(s.operation)return s.logger.isDebug()&&s.logger.debug(`issue initial query [${JSON.stringify(s.cmd)}] with flags [${JSON.stringify(s.query)}]`),void executeOperation(s.topology,s.operation,(r,t)=>{if(r)i(r);else{if(s.server=s.operation.server,s.cursorState.init=!0,null!=s.cursorState.cursorId)return i();n(r,t)}});const r={};return s.cursorState.session&&(r.session=s.cursorState.session),s.operation?r.readPreference=s.operation.readPreference:s.options.readPreference&&(r.readPreference=s.options.readPreference),s.topology.selectServer(r,(r,t)=>{if(r){const e=s.disconnectHandler;return null!=e?e.addObjectAndMethod("cursor",s,"next",[o],o):o(r)}return s.server=t,s.cursorState.init=!0,collationNotSupported(s.server,s.cmd)?o(new MongoError(`server ${s.server.name} does not support collation`)):null!=s.cursorState.cursorId?i():(s.logger.isDebug()&&s.logger.debug(`issue initial query [${JSON.stringify(s.cmd)}] with flags [${JSON.stringify(s.query)}]`),void(null==s.cmd.find?(r=Object.assign({session:s.cursorState.session},s.options),t.command(s.ns,s.cmd,r,n)):t.query(s.ns,s.cmd,s.cursorState,s.options,n)))});function i(r,t){const e=s.cursorState;if((r||e.cursorId&&e.cursorId.isZero())&&s._endSession(),0===e.documents.length&&e.cursorId&&e.cursorId.isZero()&&!s.cmd.tailable&&!s.cmd.awaitData)return setCursorNotified(s,o);o(r,t)}}}}function isConnectionDead(r,t){if(r.pool&&r.pool.isDestroyed()){r.cursorState.killed=!0;const e=new MongoNetworkError(`connection to host ${r.pool.host}:${r.pool.port} was destroyed`);return _setCursorNotifiedImpl(r,()=>t(e)),!0}return!1}function isCursorDeadButNotkilled(r,t){return!(!r.cursorState.dead||r.cursorState.killed)&&(r.cursorState.killed=!0,setCursorNotified(r,t),!0)}function isCursorDeadAndKilled(r,t){return!(!r.cursorState.dead||!r.cursorState.killed)&&(handleCallback(t,new MongoError("cursor is dead")),!0)}function isCursorKilled(r,t){return!!r.cursorState.killed&&(setCursorNotified(r,t),!0)}function setCursorDeadAndNotified(r,t){r.cursorState.dead=!0,setCursorNotified(r,t)}function setCursorNotified(r,t){_setCursorNotifiedImpl(r,()=>handleCallback(t,null,null))}function _setCursorNotifiedImpl(r,t){if(r.cursorState.notified=!0,r.cursorState.documents=[],r.cursorState.cursorIndex=0,!r.cursorState.session)return t();r._endSession(t)}function nextFunction(o,s){if(o.cursorState.notified)return s(new Error("cursor is exhausted"));if(!isCursorKilled(o,s)&&!isCursorDeadButNotkilled(o,s)&&!isCursorDeadAndKilled(o,s))if(o.cursorState.init)if(0<o.cursorState.limit&&o.cursorState.currentLimit>=o.cursorState.limit)o.kill(()=>setCursorDeadAndNotified(o,s));else if(o.cursorState.cursorIndex!==o.cursorState.documents.length||Long.ZERO.equals(o.cursorState.cursorId)){if(o.cursorState.documents.length===o.cursorState.cursorIndex&&o.cmd.tailable&&Long.ZERO.equals(o.cursorState.cursorId))return handleCallback(s,new MongoError({message:"No more documents in tailed cursor",tailable:o.cmd.tailable,awaitData:o.cmd.awaitData}));if(o.cursorState.documents.length===o.cursorState.cursorIndex&&Long.ZERO.equals(o.cursorState.cursorId))setCursorDeadAndNotified(o,s);else if(0<o.cursorState.limit&&o.cursorState.currentLimit>=o.cursorState.limit)o.kill(()=>setCursorDeadAndNotified(o,s));else{o.cursorState.currentLimit+=1;let r=o.cursorState.documents[o.cursorState.cursorIndex++];r&&!r.$err?(o.cursorState.transforms&&"function"==typeof o.cursorState.transforms.doc&&(r=o.cursorState.transforms.doc(r)),handleCallback(s,null,r)):o.kill(()=>setCursorDeadAndNotified(o,function(){handleCallback(s,new MongoError(r?r.$err:void 0))}))}}else{if(o.cursorState.documents=[],o.cursorState.cursorIndex=0,o.topology.isDestroyed())return s(new MongoNetworkError("connection destroyed, not possible to instantiate cursor"));isConnectionDead(o,s)||o._getMore(function(r,t,e){return r?handleCallback(s,r):(o.connection=e,0===o.cursorState.documents.length&&o.cmd.tailable&&Long.ZERO.equals(o.cursorState.cursorId)?handleCallback(s,new MongoError({message:"No more documents in tailed cursor",tailable:o.cmd.tailable,awaitData:o.cmd.awaitData})):0===o.cursorState.documents.length&&o.cmd.tailable&&!Long.ZERO.equals(o.cursorState.cursorId)?nextFunction(o,s):0<o.cursorState.limit&&o.cursorState.currentLimit>=o.cursorState.limit?setCursorDeadAndNotified(o,s):void nextFunction(o,s))})}else{if(!o.topology.isConnected(o.options)){if("server"===o.topology._type&&!o.topology.s.options.reconnect)return s(new MongoError("no connection available"));if(null!=o.disconnectHandler)return o.topology.isDestroyed()?s(new MongoError("Topology was destroyed")):void o.disconnectHandler.addObjectAndMethod("cursor",o,"next",[s],s)}o._initializeCursor((r,t)=>{r||null===t?s(r,t):nextFunction(o,s)})}}SUPPORTS.ASYNC_ITERATOR&&(CoreCursor.prototype[Symbol.asyncIterator]=require("../async/async_iterator").asyncIterator),module.exports={CursorState:CursorState,CoreCursor:CoreCursor};