"use strict";const inherits=require("util").inherits,EventEmitter=require("events").EventEmitter,MongoError=require("../error").MongoError,MongoTimeoutError=require("../error").MongoTimeoutError,MongoWriteConcernError=require("../error").MongoWriteConcernError,Logger=require("./logger"),f=require("util").format,Msg=require("./msg").Msg,CommandResult=require("./command_result"),MESSAGE_HEADER_SIZE=require("../wireprotocol/shared").MESSAGE_HEADER_SIZE,COMPRESSION_DETAILS_SIZE=require("../wireprotocol/shared").COMPRESSION_DETAILS_SIZE,opcodes=require("../wireprotocol/shared").opcodes,compress=require("../wireprotocol/compression").compress,compressorIDs=require("../wireprotocol/compression").compressorIDs,uncompressibleCommands=require("../wireprotocol/compression").uncompressibleCommands,apm=require("./apm"),Buffer=require("safe-buffer").Buffer,connect=require("./connect"),updateSessionFromResponse=require("../sessions").updateSessionFromResponse,eachAsync=require("../utils").eachAsync,makeStateMachine=require("../utils").makeStateMachine,now=require("../../utils").now,DISCONNECTED="disconnected",CONNECTING="connecting",CONNECTED="connected",DRAINING="draining",DESTROYING="destroying",DESTROYED="destroyed",stateTransition=makeStateMachine({[DISCONNECTED]:[CONNECTING,DRAINING,DISCONNECTED],[CONNECTING]:[CONNECTING,CONNECTED,DRAINING,DISCONNECTED],[CONNECTED]:[CONNECTED,DISCONNECTED,DRAINING],[DRAINING]:[DRAINING,DESTROYING,DESTROYED],[DESTROYING]:[DESTROYING,DESTROYED],[DESTROYED]:[DESTROYED]}),CONNECTION_EVENTS=new Set(["error","close","timeout","parseError","connect","message"]);var _id=0,Pool=function(e,n){if(EventEmitter.call(this),this.topology=e,this.s={state:DISCONNECTED,cancellationToken:new EventEmitter},this.s.cancellationToken.setMaxListeners(1/0),this.options=Object.assign({host:"localhost",port:27017,size:5,minSize:0,connectionTimeout:3e4,socketTimeout:0,keepAlive:!0,keepAliveInitialDelay:12e4,noDelay:!0,ssl:!1,checkServerIdentity:!0,ca:null,crl:null,cert:null,key:null,passphrase:null,rejectUnauthorized:!1,promoteLongs:!0,promoteValues:!0,promoteBuffers:!1,bsonRegExp:!1,reconnect:!0,reconnectInterval:1e3,reconnectTries:30,domainsEnabled:!1,legacyCompatMode:!0},n),this.id=_id++,this.retriesLeft=this.options.reconnectTries,this.reconnectId=null,this.reconnectError=null,!n.bson||n.bson&&("function"!=typeof n.bson.serialize||"function"!=typeof n.bson.deserialize))throw new Error("must pass in valid bson parser");this.logger=Logger("Pool",n),this.availableConnections=[],this.inUseConnections=[],this.connectingConnections=0,this.executing=!1,this.queue=[],this.numberOfConsecutiveTimeouts=0,this.connectionIndex=0;const o=this;this._messageHandler=messageHandler(this),this._connectionCloseHandler=function(e){connectionFailureHandler(o,"close",e,this)},this._connectionErrorHandler=function(e){connectionFailureHandler(o,"error",e,this)},this._connectionTimeoutHandler=function(e){connectionFailureHandler(o,"timeout",e,this)},this._connectionParseErrorHandler=function(e){connectionFailureHandler(o,"parseError",e,this)}};function resetPoolState(e){e.inUseConnections=[],e.availableConnections=[],e.connectingConnections=0,e.executing=!1,e.numberOfConsecutiveTimeouts=0,e.connectionIndex=0,e.retriesLeft=e.options.reconnectTries,e.reconnectId=null}function connectionFailureHandler(e,n,o,t){if(t){if(t._connectionFailHandled)return;t._connectionFailHandled=!0,t.destroy(),removeConnection(e,t),t.flush(o)}if("timeout"===n&&(e.numberOfConsecutiveTimeouts=e.numberOfConsecutiveTimeouts+1,e.numberOfConsecutiveTimeouts>e.options.reconnectTries))return e.numberOfConsecutiveTimeouts=0,e.destroy(!0),e.emit("close",e);0===e.socketCount()&&(e.state!==DESTROYED&&e.state!==DESTROYING&&e.state!==DRAINING&&e.options.reconnect&&stateTransition(e,DISCONNECTED),e.emit(n="error"===n?"close":n,o)),!e.reconnectId&&e.options.reconnect&&(e.reconnectError=o,e.reconnectId=setTimeout(attemptReconnect(e),e.options.reconnectInterval)),totalConnectionCount(e)<e.minSize&&createConnection(e)}function attemptReconnect(o,t){return function(){if(o.emit("attemptReconnect",o),o.state!==DESTROYED&&o.state!==DESTROYING){if(o.retriesLeft=o.retriesLeft-1,o.retriesLeft<=0){o.destroy();var e=new MongoTimeoutError(`failed to reconnect after ${o.options.reconnectTries} attempts with interval ${o.options.reconnectInterval} ms`,o.reconnectError);return o.emit("reconnectFailed",e),void("function"==typeof t&&t(e))}o.reconnectId=null,createConnection(o,(e,n)=>{null==e&&(o.reconnectId=null,o.retriesLeft=o.options.reconnectTries,o.emit("reconnect",o)),"function"==typeof t&&t(e,n)})}else"function"==typeof t&&t(new MongoError("Cannot create connection when pool is destroyed"))}}function moveConnectionBetween(e,n,o){var t=n.indexOf(e);-1!==t&&(n.splice(t,1),o.push(e))}function messageHandler(c){return function(e,n){for(var o=null,t=0;t<n.workItems.length;t++)n.workItems[t].requestId===e.responseTo&&(o=n.workItems[t],n.workItems.splice(t,1));function i(e,n,o,t){if(!e.options.domainsEnabled)return process.nextTick(function(){return n(o,t)});n(o,t)}if(o&&o.monitoring&&moveConnectionBetween(n,c.inUseConnections,c.availableConnections),c.numberOfConsecutiveTimeouts=0,o&&o.socketTimeout&&n.resetSocketTimeout(),c.logger.isDebug()&&c.logger.debug(f("message [ %s ] received from %s:%s",e.raw.length,c.options.host,c.options.port)),c.executing||process.nextTick(function(){_execute(c)()}),o&&!o.immediateRelease){try{e.parse(o)}catch(e){return i(c,o.cb,new MongoError(e))}if(e.documents[0]&&(s=e.documents[0],(r=o.session)&&updateSessionFromResponse(r,s),c.topology&&s.$clusterTime&&(c.topology.clusterTime=s.$clusterTime)),o.command&&e.documents[0]){var r=e.documents[0];if(r.writeConcernError){var s=new MongoWriteConcernError(r.writeConcernError,r);return i(c,o.cb,s)}if(0===r.ok||r.$err||r.errmsg||r.code)return i(c,o.cb,new MongoError(r))}e.hashedName=n.hashedName,i(c,o.cb,null,new CommandResult(o.fullResult?e:e.documents[0],n,e))}}}function totalConnectionCount(e){return e.availableConnections.length+e.inUseConnections.length+e.connectingConnections}function destroy(n,e,t,o){stateTransition(n,DESTROYING),n.s.cancellationToken.emit("cancel"),eachAsync(e,(e,n)=>{for(const o of CONNECTION_EVENTS)e.removeAllListeners(o);e.on("error",()=>{}),e.destroy(t,n)},e=>{e?"function"==typeof o&&o(e,null):(resetPoolState(n),n.queue=[],stateTransition(n,DESTROYED),"function"==typeof o&&o(null,null))})}function serializeCommand(i,r,s){var e=r.toBin();if(!!!i.options.agreedCompressor||!canCompress(r))return s(null,e);const n=Buffer.concat(e),c=n.slice(MESSAGE_HEADER_SIZE),a=n.readInt32LE(12);compress(i,c,function(e,n){if(e)return s(e,null);const o=Buffer.alloc(MESSAGE_HEADER_SIZE);o.writeInt32LE(MESSAGE_HEADER_SIZE+COMPRESSION_DETAILS_SIZE+n.length,0),o.writeInt32LE(r.requestId,4),o.writeInt32LE(0,8),o.writeInt32LE(opcodes.OP_COMPRESSED,12);const t=Buffer.alloc(COMPRESSION_DETAILS_SIZE);return t.writeInt32LE(a,0),t.writeInt32LE(c.length,4),t.writeUInt8(compressorIDs[i.options.agreedCompressor],8),s(null,[o,t,n])})}function canCompress(e){e=e instanceof Msg?e.command:e.query,e=Object.keys(e)[0];return!uncompressibleCommands.has(e)}function remove(e,n){for(var o=0;o<n.length;o++)if(n[o]===e)return n.splice(o,1),!0}function removeConnection(e,n){remove(n,e.availableConnections)||remove(n,e.inUseConnections)}function createConnection(o,t){o.state!==DESTROYED&&o.state!==DESTROYING?(o.connectingConnections++,connect(o.options,o.s.cancellationToken,(e,n)=>(o.connectingConnections--,e?(o.logger.isDebug()&&o.logger.debug(`connection attempt failed with error [${JSON.stringify(e)}]`),!o.reconnectId&&o.options.reconnect?o.state===CONNECTING&&o.options.legacyCompatMode?void t(e):(o.reconnectError=e,void(o.reconnectId=setTimeout(attemptReconnect(o,t),o.options.reconnectInterval))):void("function"==typeof t&&t(e))):o.state===DESTROYED||o.state===DESTROYING?("function"==typeof t&&t(new MongoError("Pool was destroyed after connection creation")),void n.destroy()):(n.on("error",o._connectionErrorHandler),n.on("close",o._connectionCloseHandler),n.on("timeout",o._connectionTimeoutHandler),n.on("parseError",o._connectionParseErrorHandler),n.on("message",o._messageHandler),o.availableConnections.push(n),"function"==typeof t&&t(null,n),void _execute(o)())))):"function"==typeof t&&t(new MongoError("Cannot create connection when pool is destroyed"))}function flushMonitoringOperations(e){for(var n,o=0;o<e.length;o++)e[o].monitoring&&(n=e[o],e.splice(o,1),n.cb(new MongoError({message:"no connection available for monitoring",driver:!0})))}function _execute(s){return function(){if(s.state!==DESTROYED&&!s.executing)if(s.executing=!0,0<s.connectingConnections)s.executing=!1;else{for(;;){var e=totalConnectionCount(s);if(0===s.availableConnections.length){flushMonitoringOperations(s.queue),e<s.options.size&&0<s.queue.length&&createConnection(s);break}if(0===s.queue.length)break;var n=null,o=s.availableConnections.filter(e=>0===e.workItems.length);if(!(n=0===o.length?s.availableConnections[s.connectionIndex++%s.availableConnections.length]:o[s.connectionIndex++%o.length]).isConnected()){removeConnection(s,n),flushMonitoringOperations(s.queue);break}o=s.queue.shift();if(o.monitoring){var t=!1;for(let e=0;e<s.availableConnections.length;e++)if(s.availableConnections[e].isConnected()&&0===s.availableConnections[e].workItems.length){t=!0,n=s.availableConnections[e];break}if(!t){s.queue.unshift(o),e<s.options.size&&0<s.queue.length&&createConnection(s),setTimeout(()=>_execute(s)(),10);break}}if(e<s.options.size&&0<n.workItems.length){s.queue.unshift(o),createConnection(s);break}var i=o.buffer;o.monitoring&&moveConnectionBetween(n,s.availableConnections,s.inUseConnections),o.noResponse||n.workItems.push(o),o.immediateRelease||"number"!=typeof o.socketTimeout||n.setSocketTimeout(o.socketTimeout);var r=!0;if(Array.isArray(i))for(let e=0;e<i.length;e++)r=n.write(i[e]);else r=n.write(i);if(o.noResponse&&"function"==typeof o.cb&&o.cb(null,null),!1===r){s.queue.unshift(o),removeConnection(s,n),flushMonitoringOperations(s.queue);break}}s.executing=!1}}}inherits(Pool,EventEmitter),Object.defineProperty(Pool.prototype,"size",{enumerable:!0,get:function(){return this.options.size}}),Object.defineProperty(Pool.prototype,"minSize",{enumerable:!0,get:function(){return this.options.minSize}}),Object.defineProperty(Pool.prototype,"connectionTimeout",{enumerable:!0,get:function(){return this.options.connectionTimeout}}),Object.defineProperty(Pool.prototype,"socketTimeout",{enumerable:!0,get:function(){return this.options.socketTimeout}}),Object.defineProperty(Pool.prototype,"state",{enumerable:!0,get:function(){return this.s.state}}),Pool.prototype.socketCount=function(){return this.availableConnections.length+this.inUseConnections.length},Pool.prototype.allConnections=function(){return this.availableConnections.concat(this.inUseConnections)},Pool.prototype.get=function(){return this.allConnections()[0]},Pool.prototype.isConnected=function(){if(this.state===DESTROYED||this.state===DESTROYING)return!1;for(var e=this.availableConnections.concat(this.inUseConnections),n=0;n<e.length;n++)if(e[n].isConnected())return!0;return!1},Pool.prototype.isDestroyed=function(){return this.state===DESTROYED||this.state===DESTROYING},Pool.prototype.isDisconnected=function(){return this.state===DISCONNECTED},Pool.prototype.connect=function(o){if(this.state!==DISCONNECTED)throw new MongoError("connection in unlawful state "+this.state);stateTransition(this,CONNECTING),createConnection(this,(e,n)=>{if(e)return"function"==typeof o?(this.destroy(),void o(e)):(this.state===CONNECTING&&this.emit("error",e),void this.destroy());if(stateTransition(this,CONNECTED),this.minSize)for(let e=0;e<this.minSize;e++)createConnection(this);"function"==typeof o?o(null,n):this.emit("connect",this,n)})},Pool.prototype.auth=function(e,n){"function"==typeof n&&n(null,null)},Pool.prototype.logout=function(e,n){"function"==typeof n&&n(null,null)},Pool.prototype.unref=function(){this.availableConnections.concat(this.inUseConnections).forEach(function(e){e.unref()})},Pool.prototype.destroy=function(e,t){var i=this;if("function"==typeof e&&(t=e,e=!1),this.state!==DESTROYED&&i.state!==DESTROYING){if(stateTransition(this,DRAINING),e){for(e=i.availableConnections.concat(i.inUseConnections);0<i.queue.length;){var n=i.queue.shift();"function"==typeof n.cb&&n.cb(new MongoError("Pool was force destroyed"))}return destroy(i,e,{force:!0},t)}this.reconnectId&&clearTimeout(this.reconnectId),function e(){if(i.state!==DESTROYED&&i.state!==DESTROYING)if(flushMonitoringOperations(i.queue),0===i.queue.length){for(var n=i.availableConnections.concat(i.inUseConnections),o=0;o<n.length;o++)if(0<n[o].workItems.length)return setTimeout(e,1);destroy(i,n,{force:!1},t)}else _execute(i)(),setTimeout(e,1);else"function"==typeof t&&t()}()}else"function"==typeof t&&t(null,null)},Pool.prototype.reset=function(n){var e;this.s.state===CONNECTED?(this.s.cancellationToken.emit("cancel"),e=this.availableConnections.concat(this.inUseConnections),eachAsync(e,(e,n)=>{for(const o of CONNECTION_EVENTS)e.removeAllListeners(o);e.destroy({force:!0},n)},e=>{e&&"function"==typeof n?n(e,null):(resetPoolState(this),createConnection(this,()=>{"function"==typeof n&&n(null,null)}))})):"function"==typeof n&&n(new MongoError("pool is not connected, reset aborted"))},Pool.prototype.write=function(o,t,i){var r,s,c=this;if("function"==typeof t&&(i=t),t=t||{},"function"!=typeof i&&!t.noResponse)throw new MongoError("write method must provide a callback");this.state!==DESTROYED&&this.state!==DESTROYING?this.state!==DRAINING?(this.options.domainsEnabled&&process.domain&&"function"==typeof i&&(r=i,i=process.domain.bind(function(){for(var e=new Array(arguments.length),n=0;n<arguments.length;n++)e[n]=arguments[n];process.nextTick(function(){r.apply(null,e)})})),(s={cb:i,raw:!1,promoteLongs:!0,promoteValues:!0,promoteBuffers:!1,bsonRegExp:!1,fullResult:!1}).promoteLongs="boolean"!=typeof t.promoteLongs||t.promoteLongs,s.promoteValues="boolean"!=typeof t.promoteValues||t.promoteValues,s.promoteBuffers="boolean"==typeof t.promoteBuffers&&t.promoteBuffers,s.bsonRegExp="boolean"==typeof t.bsonRegExp&&t.bsonRegExp,s.raw="boolean"==typeof t.raw&&t.raw,s.immediateRelease="boolean"==typeof t.immediateRelease&&t.immediateRelease,s.documentsReturnedIn=t.documentsReturnedIn,s.command="boolean"==typeof t.command&&t.command,s.fullResult="boolean"==typeof t.fullResult&&t.fullResult,s.noResponse="boolean"==typeof t.noResponse&&t.noResponse,s.session=t.session||null,s.socketTimeout=t.socketTimeout,s.monitoring=t.monitoring,s.requestId=o.requestId,c.options.monitorCommands&&(this.emit("commandStarted",new apm.CommandStartedEvent(this,o)),s.started=now(),s.cb=(e,n)=>{e?c.emit("commandFailed",new apm.CommandFailedEvent(this,o,e,s.started)):n&&n.result&&(0===n.result.ok||n.result.$err)?c.emit("commandFailed",new apm.CommandFailedEvent(this,o,n.result,s.started)):c.emit("commandSucceeded",new apm.CommandSucceededEvent(this,o,n,s.started)),"function"==typeof i&&i(e,n)}),serializeCommand(c,o,(e,n)=>{if(e)throw e;s.buffer=n,t.monitoring?c.queue.unshift(s):c.queue.push(s),c.executing||process.nextTick(function(){_execute(c)()})})):i(new MongoError("pool is draining, new operations prohibited")):i(new MongoError("pool destroyed"))},Pool._execute=_execute,module.exports=Pool;