"use strict";const EventEmitter=require("events").EventEmitter,crypto=require("crypto"),debugOptions=require("./utils").debugOptions,parseHeader=require("../wireprotocol/shared").parseHeader,decompress=require("../wireprotocol/compression").decompress,Response=require("./commands").Response,BinMsg=require("./msg").BinMsg,MongoNetworkError=require("../error").MongoNetworkError,MongoNetworkTimeoutError=require("../error").MongoNetworkTimeoutError,MongoError=require("../error").MongoError,Logger=require("./logger"),OP_COMPRESSED=require("../wireprotocol/shared").opcodes.OP_COMPRESSED,OP_MSG=require("../wireprotocol/shared").opcodes.OP_MSG,MESSAGE_HEADER_SIZE=require("../wireprotocol/shared").MESSAGE_HEADER_SIZE,Buffer=require("safe-buffer").Buffer,Query=require("./commands").Query,CommandResult=require("./command_result");let _id=0;const DEFAULT_MAX_BSON_MESSAGE_SIZE=67108864,DEBUG_FIELDS=["host","port","size","keepAlive","keepAliveInitialDelay","noDelay","connectionTimeout","socketTimeout","ssl","ca","crl","cert","rejectUnauthorized","promoteLongs","promoteValues","promoteBuffers","bsonRegExp","checkServerIdentity"];let connectionAccountingSpy=void 0,connectionAccounting=!1,connections={};class Connection extends EventEmitter{constructor(e,o){if(super(),!(o=o||{}).bson)throw new TypeError("must pass in valid bson parser");this.id=_id++,this.options=o,this.logger=Logger("Connection",o),this.bson=o.bson,this.tag=o.tag,this.maxBsonMessageSize=o.maxBsonMessageSize||DEFAULT_MAX_BSON_MESSAGE_SIZE,this.helloOk=void 0,this.port=o.port||27017,this.host=o.host||"localhost",this.socketTimeout="number"==typeof o.socketTimeout?o.socketTimeout:0,this.keepAlive="boolean"!=typeof o.keepAlive||o.keepAlive,this.keepAliveInitialDelay="number"==typeof o.keepAliveInitialDelay?o.keepAliveInitialDelay:12e4,this.connectionTimeout="number"==typeof o.connectionTimeout?o.connectionTimeout:3e4,this.keepAliveInitialDelay>this.socketTimeout&&(this.keepAliveInitialDelay=Math.round(this.socketTimeout/2)),this.logger.isDebug()&&this.logger.debug(`creating connection ${this.id} with options [${JSON.stringify(debugOptions(DEBUG_FIELDS,o))}]`),this.responseOptions={promoteLongs:"boolean"!=typeof o.promoteLongs||o.promoteLongs,promoteValues:"boolean"!=typeof o.promoteValues||o.promoteValues,promoteBuffers:"boolean"==typeof o.promoteBuffers&&o.promoteBuffers,bsonRegExp:"boolean"==typeof o.bsonRegExp&&o.bsonRegExp},this.flushing=!1,this.queue=[],this.writeStream=null,this.destroyed=!1,this.timedOut=!1;const t=crypto.createHash("sha1");t.update(this.address),this.hashedName=t.digest("hex"),this.workItems=[],this.socket=e,this.socket.once("error",errorHandler(this)),this.socket.once("timeout",timeoutHandler(this)),this.socket.once("close",closeHandler(this)),this.socket.on("data",dataHandler(this)),connectionAccounting&&addConnection(this.id,this)}setSocketTimeout(e){this.socket&&this.socket.setTimeout(e)}resetSocketTimeout(){this.socket&&this.socket.setTimeout(this.socketTimeout)}static enableConnectionAccounting(e){e&&(connectionAccountingSpy=e),connectionAccounting=!0,connections={}}static disableConnectionAccounting(){connectionAccounting=!1,connectionAccountingSpy=void 0}static connections(){return connections}get address(){return`${this.host}:${this.port}`}unref(){null!=this.socket?this.socket.unref():this.once("connect",()=>this.socket.unref())}flush(e){for(;0<this.workItems.length;){const o=this.workItems.shift();o.cb&&o.cb(e)}}destroy(e,o){if("function"==typeof e&&(o=e,e={}),e=Object.assign({force:!1},e),connectionAccounting&&deleteConnection(this.id),null!=this.socket)return e.force||this.timedOut?(this.socket.destroy(),this.destroyed=!0,void("function"==typeof o&&o(null,null))):void this.socket.end(e=>{this.destroyed=!0,"function"==typeof o&&o(e,null)});this.destroyed=!0}write(o){if(this.logger.isDebug())if(Array.isArray(o))for(let e=0;e<o.length;e++)this.logger.debug(`writing buffer [ ${o[e].length} ] to ${this.address}`);else this.logger.debug(`writing buffer [ ${o.length} ] to ${this.address}`);if(!1!==this.socket.destroyed)return!1;if(!Array.isArray(o))return this.socket.write(o,"binary"),!0;for(let e=0;e<o.length;e++)this.socket.write(o[e],"binary");return!0}toString(){return""+this.id}toJSON(){return{id:this.id,host:this.host,port:this.port}}isConnected(){return!this.destroyed&&(!this.socket.destroyed&&this.socket.writable)}command(e,o,t,s){"function"==typeof t&&(s=t,t={});const n=this;var r="number"==typeof t.socketTimeout?t.socketTimeout:0,t=n.options.bson;const i=new Query(t,e,o,{numberToSkip:0,numberToReturn:1}),c=()=>{};function u(e,o){s(e,o),s=c}function l(e){n.resetSocketTimeout(),CONNECTION_ERROR_EVENTS.forEach(e=>n.removeListener(e,l)),n.removeListener("message",a),null==e&&(e=new MongoError(`runCommand failed for connection to '${n.address}'`)),n.on("error",c),u(e)}function a(e){var o;e.responseTo===i.requestId&&(n.resetSocketTimeout(),CONNECTION_ERROR_EVENTS.forEach(e=>n.removeListener(e,l)),n.removeListener("message",a),e.parse({promoteValues:!0}),0===(o=e.documents[0]).ok||o.$err||o.errmsg||o.code?u(new MongoError(o)):u(void 0,new CommandResult(o,this,e)))}n.setSocketTimeout(r),CONNECTION_ERROR_EVENTS.forEach(e=>n.once(e,l)),n.on("message",a),n.write(i.toBin())}}const CONNECTION_ERROR_EVENTS=["error","close","timeout","parseError"];function deleteConnection(e){delete connections[e],connectionAccountingSpy&&connectionAccountingSpy.deleteConnection(e)}function addConnection(e,o){connections[e]=o,connectionAccountingSpy&&connectionAccountingSpy.addConnection(e,o)}function errorHandler(o){return function(e){connectionAccounting&&deleteConnection(o.id),o.logger.isDebug()&&o.logger.debug(`connection ${o.id} for [${o.address}] errored out with [${JSON.stringify(e)}]`),o.emit("error",new MongoNetworkError(e),o)}}function timeoutHandler(e){return function(){connectionAccounting&&deleteConnection(e.id),e.logger.isDebug()&&e.logger.debug(`connection ${e.id} for [${e.address}] timed out`),e.timedOut=!0,e.emit("timeout",new MongoNetworkTimeoutError(`connection ${e.id} to ${e.address} timed out`,{beforeHandshake:null==e.ismaster}),e)}}function closeHandler(o){return function(e){connectionAccounting&&deleteConnection(o.id),o.logger.isDebug()&&o.logger.debug(`connection ${o.id} with for [${o.address}] closed`),e||o.emit("close",new MongoNetworkError(`connection ${o.id} to ${o.address} closed`),o)}}function processMessage(s,n){const r=parseHeader(n);if(r.opCode===OP_COMPRESSED){r.fromCompressed=!0;var e=MESSAGE_HEADER_SIZE;r.opCode=n.readInt32LE(e),e+=4,r.length=n.readInt32LE(e);var o=n[e+=4];e++,decompress(o,n.slice(e),(e,o)=>{if(e)s.emit("error",e);else if(o.length===r.length){const t=r.opCode===OP_MSG?BinMsg:Response;s.emit("message",new t(s.bson,n,r,o,s.responseOptions),s)}else s.emit("error",new MongoError("Decompressing a compressed message from the server failed. The message is corrupt."))})}else{const t=r.opCode===OP_MSG?BinMsg:Response;s.emit("message",new t(s.bson,n,r,n.slice(MESSAGE_HEADER_SIZE),s.responseOptions),s)}}function dataHandler(r){return function(e){for(;0<e.length;)if(0<r.bytesRead&&0<r.sizeOfMessage){var o=r.sizeOfMessage-r.bytesRead;o>e.length?(e.copy(r.buffer,r.bytesRead),r.bytesRead=r.bytesRead+e.length,e=Buffer.alloc(0)):(e.copy(r.buffer,r.bytesRead,0,o),e=e.slice(o),o=r.buffer,r.buffer=null,r.sizeOfMessage=0,r.bytesRead=0,r.stubBuffer=null,processMessage(r,o))}else if(null!=r.stubBuffer&&0<r.stubBuffer.length)4<r.stubBuffer.length+e.length?(s=Buffer.alloc(r.stubBuffer.length+e.length),r.stubBuffer.copy(s,0),e.copy(s,r.stubBuffer.length),e=s,r.buffer=null,r.sizeOfMessage=0,r.bytesRead=0,r.stubBuffer=null):(n=Buffer.alloc(r.stubBuffer.length+e.length),r.stubBuffer.copy(n,0),e.copy(n,r.stubBuffer.length),e=Buffer.alloc(0));else if(4<e.length){var t,s=e[0]|e[1]<<8|e[2]<<16|e[3]<<24;if(s<0||s>r.maxBsonMessageSize){var n={err:"socketHandler",trace:"",bin:r.buffer,parseState:{sizeOfMessage:s,bytesRead:r.bytesRead,stubBuffer:r.stubBuffer}};return void r.emit("parseError",n,r)}4<s&&s<r.maxBsonMessageSize&&s>e.length?(r.buffer=Buffer.alloc(s),e.copy(r.buffer,0),r.bytesRead=e.length,r.sizeOfMessage=s,r.stubBuffer=null,e=Buffer.alloc(0)):4<s&&s<r.maxBsonMessageSize&&s===e.length?(t=e,r.buffer=null,r.sizeOfMessage=0,r.bytesRead=0,r.stubBuffer=null,e=Buffer.alloc(0),processMessage(r,t)):s<=4||s>r.maxBsonMessageSize?(r.emit("parseError",{err:"socketHandler",trace:null,bin:e,parseState:{sizeOfMessage:s,bytesRead:0,buffer:null,stubBuffer:null}},r),r.buffer=null,r.sizeOfMessage=0,r.bytesRead=0,r.stubBuffer=null,e=Buffer.alloc(0)):(t=e.slice(0,s),r.buffer=null,r.sizeOfMessage=0,r.bytesRead=0,r.stubBuffer=null,e=e.slice(s),processMessage(r,t))}else r.stubBuffer=Buffer.alloc(e.length),e.copy(r.stubBuffer,0),e=Buffer.alloc(0)}}module.exports=Connection;