"use strict";const net=require("net"),tls=require("tls"),Connection=require("./connection"),MongoError=require("../error").MongoError,MongoNetworkError=require("../error").MongoNetworkError,MongoNetworkTimeoutError=require("../error").MongoNetworkTimeoutError,defaultAuthProviders=require("../auth/defaultAuthProviders").defaultAuthProviders,AuthContext=require("../auth/auth_provider").AuthContext,WIRE_CONSTANTS=require("../wireprotocol/constants"),makeClientMetadata=require("../utils").makeClientMetadata,MAX_SUPPORTED_WIRE_VERSION=WIRE_CONSTANTS.MAX_SUPPORTED_WIRE_VERSION,MAX_SUPPORTED_SERVER_VERSION=WIRE_CONSTANTS.MAX_SUPPORTED_SERVER_VERSION,MIN_SUPPORTED_WIRE_VERSION=WIRE_CONSTANTS.MIN_SUPPORTED_WIRE_VERSION,MIN_SUPPORTED_SERVER_VERSION=WIRE_CONSTANTS.MIN_SUPPORTED_SERVER_VERSION;let AUTH_PROVIDERS;function connect(r,e,n){"function"==typeof e&&(n=e,e=void 0);const t=r&&r.connectionType?r.connectionType:Connection;null==AUTH_PROVIDERS&&(AUTH_PROVIDERS=defaultAuthProviders(r.bson)),makeConnection(void 0!==r.family?r.family:0,r,e,(e,o)=>{e?n(e,o):performInitialHandshake(new t(o,r),r,n)})}function isModernConnectionType(e){return!(e instanceof Connection)}function checkSupportedServer(e,o){var r=e&&"number"==typeof e.maxWireVersion&&e.maxWireVersion>=MIN_SUPPORTED_WIRE_VERSION,n=e&&"number"==typeof e.minWireVersion&&e.minWireVersion<=MAX_SUPPORTED_WIRE_VERSION;if(r){if(n)return null;const t=`Server at ${o.host}:${o.port} reports minimum wire version ${e.minWireVersion}, but this version of the Node.js Driver requires at most ${MAX_SUPPORTED_WIRE_VERSION} (MongoDB ${MAX_SUPPORTED_SERVER_VERSION})`;return new MongoError(t)}const t=`Server at ${o.host}:${o.port} reports maximum wire version ${e.maxWireVersion||0}, but this version of the Node.js Driver requires at least ${MIN_SUPPORTED_WIRE_VERSION} (MongoDB ${MIN_SUPPORTED_SERVER_VERSION})`;return new MongoError(t)}function performInitialHandshake(c,a,r){function u(e,o){e&&c&&c.destroy(),r(e,o)}const l=a.credentials;if(!l||l.mechanism.match(/DEFAULT/i)||AUTH_PROVIDERS[l.mechanism]){const m=new AuthContext(c,l,a);prepareHandshakeDocument(m,(e,i)=>{if(e)return u(e);const o=Object.assign({},a);(a.connectTimeoutMS||a.connectionTimeout)&&(o.socketTimeout=a.connectTimeoutMS||a.connectionTimeout),i.helloOk=!!a.useUnifiedTopology;const s=(new Date).getTime();c.command("admin.$cmd",i,o,(e,o)=>{if(e)u(e);else{const n=o.result;if(0!==n.ok){"isWritablePrimary"in n&&(n.ismaster=n.isWritablePrimary),a.useUnifiedTopology&&n.helloOk&&(c.helloOk=!0);o=checkSupportedServer(n,a);if(o)u(o);else if(isModernConnectionType(c)||n.compression&&((r=i.compression.filter(e=>-1!==n.compression.indexOf(e))).length&&(c.agreedCompressor=r[0]),a.compression&&a.compression.zlibCompressionLevel&&(c.zlibCompressionLevel=a.compression.zlibCompressionLevel)),c.ismaster=n,c.lastIsMasterMS=(new Date).getTime()-s,n.arbiterOnly||!l)u(void 0,c);else{Object.assign(m,{response:n});var r=l.resolveAuthMechanism(n);const t=AUTH_PROVIDERS[r.mechanism];t.auth(m,e=>e?u(e):void u(void 0,c))}}else u(new MongoError(n))}})})}else u(new MongoError(`authMechanism '${l.mechanism}' not supported`))}function prepareHandshakeDocument(e,o){var r=e.options,n=e.connection.serverApi,t=r.compression&&r.compression.compressors?r.compression.compressors:[],t={[n?"hello":"ismaster"]:!0,client:r.metadata||makeClientMetadata(r),compression:t};const i=e.credentials;if(i){if(i.mechanism.match(/DEFAULT/i)&&i.username)return Object.assign(t,{saslSupportedMechs:`${i.source}.${i.username}`}),void AUTH_PROVIDERS["scram-sha-256"].prepare(t,e,o);const s=AUTH_PROVIDERS[i.mechanism];return null==s?o(new MongoError(`No AuthProvider for ${i.mechanism} defined.`)):void s.prepare(t,e,o)}o(void 0,t)}const LEGAL_SSL_SOCKET_OPTIONS=["pfx","key","passphrase","cert","ca","ciphers","NPNProtocols","ALPNProtocols","servername","ecdhCurve","secureProtocol","secureContext","session","minDHSize","crl","rejectUnauthorized"];function parseConnectOptions(e,o){const r="string"==typeof o.host?o.host:"localhost";return-1!==r.indexOf("/")?{path:r}:{family:e,host:r,port:"number"==typeof o.port?o.port:27017,rejectUnauthorized:!1}}function parseSslOptions(e,o){const r=parseConnectOptions(e,o);for(const n in o)null!=o[n]&&-1!==LEGAL_SSL_SOCKET_OPTIONS.indexOf(n)&&(r[n]=o[n]);return!1===o.checkServerIdentity?r.checkServerIdentity=function(){}:"function"==typeof o.checkServerIdentity&&(r.checkServerIdentity=o.checkServerIdentity),null!=r.servername||net.isIP(r.host)||(r.servername=r.host),r}const SOCKET_ERROR_EVENTS=new Set(["error","close","timeout","parseError"]);function makeConnection(e,o,r,n){var t="boolean"==typeof o.ssl&&o.ssl,i="boolean"!=typeof o.keepAlive||o.keepAlive;let s="number"==typeof o.keepAliveInitialDelay?o.keepAliveInitialDelay:12e4;var c="boolean"!=typeof o.noDelay||o.noDelay,a="number"==typeof o.connectionTimeout?o.connectionTimeout:"number"==typeof o.connectTimeoutMS?o.connectTimeoutMS:3e4;const u="number"==typeof o.socketTimeoutMS?o.socketTimeoutMS:"number"==typeof o.socketTimeout?o.socketTimeout:0,l="boolean"!=typeof o.rejectUnauthorized||o.rejectUnauthorized;s>u&&(s=Math.round(u/2));let m;const E=function(e,o){e&&m&&m.destroy(),n(e,o)};try{t?(m=tls.connect(parseSslOptions(e,o)),"function"==typeof m.disableRenegotiation&&m.disableRenegotiation()):m=net.createConnection(parseConnectOptions(e,o))}catch(e){return E(e)}m.setKeepAlive(i,s),m.setTimeout(a),m.setNoDelay(c);const p=t?"secureConnect":"connect";let S;function R(o){return e=>{SOCKET_ERROR_EVENTS.forEach(e=>m.removeAllListeners(e)),S&&r.removeListener("cancel",S),m.removeListener(p,h),E(connectionFailureError(o,e))}}function h(){if(SOCKET_ERROR_EVENTS.forEach(e=>m.removeAllListeners(e)),S&&r.removeListener("cancel",S),m.authorizationError&&l)return E(m.authorizationError);m.setTimeout(u),E(null,m)}SOCKET_ERROR_EVENTS.forEach(e=>m.once(e,R(e))),r&&(S=R("cancel"),r.once("cancel",S)),m.once(p,h)}function connectionFailureError(e,o){switch(e){case"error":return new MongoNetworkError(o);case"timeout":return new MongoNetworkTimeoutError("connection timed out");case"close":return new MongoNetworkError("connection closed");case"cancel":return new MongoNetworkError("connection establishment was cancelled");default:return new MongoNetworkError("unknown network error")}}module.exports=connect;