"use strict";const crypto=require("crypto"),Buffer=require("safe-buffer").Buffer,retrieveBSON=require("../connection/utils").retrieveBSON,MongoError=require("../error").MongoError,AuthProvider=require("./auth_provider").AuthProvider,emitWarningOnce=require("../../utils").emitWarning,BSON=retrieveBSON(),Binary=BSON.Binary;let saslprep;try{saslprep=require("saslprep")}catch(e){}class ScramSHA extends AuthProvider{constructor(e,r){super(e),this.cryptoMethod=r||"sha1"}prepare(t,n,o){const a=this.cryptoMethod;"sha256"===a&&null==saslprep&&emitWarningOnce("Warning: no saslprep library specified. Passwords will not be sanitized"),crypto.randomBytes(24,(e,r)=>{if(e)return o(e);Object.assign(n,{nonce:r});e=n.credentials,e=Object.assign({},t,{speculativeAuthenticate:Object.assign(makeFirstMessage(a,e,r),{db:e.source})});o(void 0,e)})}auth(e,r){var t=e.response;t&&t.speculativeAuthenticate?continueScramConversation(this.cryptoMethod,t.speculativeAuthenticate,e,r):executeScram(this.cryptoMethod,e,r)}}function cleanUsername(e){return e.replace("=","=3D").replace(",","=2C")}function clientFirstMessageBare(e,r){return Buffer.concat([Buffer.from("n=","utf8"),Buffer.from(e,"utf8"),Buffer.from(",r=","utf8"),Buffer.from(r.toString("base64"),"utf8")])}function makeFirstMessage(e,r,t){r=cleanUsername(r.username);return{saslStart:1,mechanism:"sha1"===e?"SCRAM-SHA-1":"SCRAM-SHA-256",payload:new Binary(Buffer.concat([Buffer.from("n,,","utf8"),clientFirstMessageBare(r,t)])),autoAuthorize:1,options:{skipEmptyExchange:!0}}}function executeScram(t,n,o){const e=n.connection;var r=n.credentials,a=n.nonce,s=r.source,a=makeFirstMessage(t,r,a);e.command(`${s}.$cmd`,a,(e,r)=>{e=resolveError(e,r);if(e)return o(e);continueScramConversation(t,r.result,n,o)})}function continueScramConversation(e,r,t,n){const o=t.connection;var a=t.credentials,s=t.nonce;const i=a.source;var c=cleanUsername(a.username),u=a.password;let f;if("sha256"===e)f=saslprep?saslprep(u):u;else try{f=passwordDigest(c,u)}catch(e){return n(e)}const l=Buffer.isBuffer(r.payload)?new Binary(r.payload):r.payload;t=parsePayload(l.value()),a=parseInt(t.i,10);if(a&&a<4096)n(new MongoError(`Server returned an invalid iteration count ${a}`),!1);else{u=t.s;const p=t.r;if(p.startsWith("nonce"))n(new MongoError(`Server returned an invalid nonce: ${p}`),!1);else{const h=`c=biws,r=${p}`;t=HI(f,Buffer.from(u,"base64"),a,e),u=HMAC(e,t,"Client Key"),a=HMAC(e,t,"Server Key"),t=H(e,u),s=[clientFirstMessageBare(c,s),l.value().toString("base64"),h].join(",");const d=`p=${xor(u,HMAC(e,t,s))}`;t=[h,d].join(",");const m=HMAC(e,a,s);t={saslContinue:1,conversationId:r.conversationId,payload:new Binary(Buffer.from(t))};o.command(`${i}.$cmd`,t,(e,r)=>{e=resolveError(e,r);if(e)return n(e);const t=r.result;r=parsePayload(t.payload.value());if(compareDigest(Buffer.from(r.v,"base64"),m)){if(!t||!1!==t.done)return n(e,t);e={saslContinue:1,conversationId:t.conversationId,payload:Buffer.alloc(0)};o.command(`${i}.$cmd`,e,n)}else n(new MongoError("Server returned an invalid signature"))})}}}function parsePayload(e){const r={},t=e.split(",");for(let e=0;e<t.length;e++){var n=t[e].split("=");r[n[0]]=n[1]}return r}function passwordDigest(e,r){if("string"!=typeof e)throw new MongoError("username must be a string");if("string"!=typeof r)throw new MongoError("password must be a string");if(0===r.length)throw new MongoError("password cannot be empty");const t=crypto.createHash("md5");return t.update(`${e}:mongo:${r}`,"utf8"),t.digest("hex")}function xor(r,t){Buffer.isBuffer(r)||(r=Buffer.from(r)),Buffer.isBuffer(t)||(t=Buffer.from(t));var n=Math.max(r.length,t.length);const o=[];for(let e=0;e<n;e+=1)o.push(r[e]^t[e]);return Buffer.from(o).toString("base64")}function H(e,r){return crypto.createHash(e).update(r).digest()}function HMAC(e,r,t){return crypto.createHmac(e,r).update(t).digest()}let _hiCache={},_hiCacheCount=0;function _hiCachePurge(){_hiCache={},_hiCacheCount=0}const hiLengthMap={sha256:32,sha1:20};function HI(e,r,t,n){var o=[e,r.toString("base64"),t].join("_");if(void 0!==_hiCache[o])return _hiCache[o];n=crypto.pbkdf2Sync(e,r,t,hiLengthMap[n],n);return 200<=_hiCacheCount&&_hiCachePurge(),_hiCache[o]=n,_hiCacheCount+=1,n}function compareDigest(r,t){if(r.length!==t.length)return!1;if("function"==typeof crypto.timingSafeEqual)return crypto.timingSafeEqual(r,t);let n=0;for(let e=0;e<r.length;e++)n|=r[e]^t[e];return 0===n}function resolveError(e,r){if(e)return e;r=r.result;return r.$err||r.errmsg?new MongoError(r):void 0}class ScramSHA1 extends ScramSHA{constructor(e){super(e,"sha1")}}class ScramSHA256 extends ScramSHA{constructor(e){super(e,"sha256")}}module.exports={ScramSHA1:ScramSHA1,ScramSHA256:ScramSHA256};