"use strict";const deprecate=require("util").deprecate,deprecateOptions=require("./utils").deprecateOptions,emitWarningOnce=require("./utils").emitWarningOnce,checkCollectionName=require("./utils").checkCollectionName,ObjectID=require("./core").BSON.ObjectID,MongoError=require("./core").MongoError,normalizeHintField=require("./utils").normalizeHintField,decorateCommand=require("./utils").decorateCommand,decorateWithCollation=require("./utils").decorateWithCollation,decorateWithReadConcern=require("./utils").decorateWithReadConcern,formattedOrderClause=require("./utils").formattedOrderClause,ReadPreference=require("./core").ReadPreference,unordered=require("./bulk/unordered"),ordered=require("./bulk/ordered"),ChangeStream=require("./change_stream"),executeLegacyOperation=require("./utils").executeLegacyOperation,WriteConcern=require("./write_concern"),ReadConcern=require("./read_concern"),MongoDBNamespace=require("./utils").MongoDBNamespace,AggregationCursor=require("./aggregation_cursor"),CommandCursor=require("./command_cursor"),ensureIndex=require("./operations/collection_ops").ensureIndex,group=require("./operations/collection_ops").group,parallelCollectionScan=require("./operations/collection_ops").parallelCollectionScan,removeDocuments=require("./operations/common_functions").removeDocuments,save=require("./operations/collection_ops").save,updateDocuments=require("./operations/common_functions").updateDocuments,AggregateOperation=require("./operations/aggregate"),BulkWriteOperation=require("./operations/bulk_write"),CountDocumentsOperation=require("./operations/count_documents"),CreateIndexesOperation=require("./operations/create_indexes"),DeleteManyOperation=require("./operations/delete_many"),DeleteOneOperation=require("./operations/delete_one"),DistinctOperation=require("./operations/distinct"),DropCollectionOperation=require("./operations/drop").DropCollectionOperation,DropIndexOperation=require("./operations/drop_index"),DropIndexesOperation=require("./operations/drop_indexes"),EstimatedDocumentCountOperation=require("./operations/estimated_document_count"),FindOperation=require("./operations/find"),FindOneOperation=require("./operations/find_one"),FindAndModifyOperation=require("./operations/find_and_modify"),FindOneAndDeleteOperation=require("./operations/find_one_and_delete"),FindOneAndReplaceOperation=require("./operations/find_one_and_replace"),FindOneAndUpdateOperation=require("./operations/find_one_and_update"),GeoHaystackSearchOperation=require("./operations/geo_haystack_search"),IndexesOperation=require("./operations/indexes"),IndexExistsOperation=require("./operations/index_exists"),IndexInformationOperation=require("./operations/index_information"),InsertManyOperation=require("./operations/insert_many"),InsertOneOperation=require("./operations/insert_one"),IsCappedOperation=require("./operations/is_capped"),ListIndexesOperation=require("./operations/list_indexes"),MapReduceOperation=require("./operations/map_reduce"),OptionsOperation=require("./operations/options_operation"),RenameOperation=require("./operations/rename"),ReIndexOperation=require("./operations/re_index"),ReplaceOneOperation=require("./operations/replace_one"),StatsOperation=require("./operations/stats"),UpdateManyOperation=require("./operations/update_many"),UpdateOneOperation=require("./operations/update_one"),executeOperation=require("./operations/execute_operation"),mergeKeys=["ignoreUndefined"];function Collection(e,t,o,n,i,r){checkCollectionName(n);var s=(null==r||null==r.slaveOk?e:r).slaveOk,p=(null==r||null==r.serializeFunctions?e.s.options:r).serializeFunctions,a=(null==r||null==r.raw?e.s.options:r).raw,l=(null==r||null==r.promoteLongs?e.s.options:r).promoteLongs,c=(null==r||null==r.promoteValues?e.s.options:r).promoteValues,d=(null==r||null==r.promoteBuffers?e.s.options:r).promoteBuffers,u=(null==r||null==r.bsonRegExp?e.s.options:r).bsonRegExp,o=new MongoDBNamespace(o,n),n=r.promiseLibrary||Promise;i=null==i?ObjectID:i,this.s={pkFactory:i,db:e,topology:t,options:r,namespace:o,readPreference:ReadPreference.fromOptions(r),slaveOk:s,serializeFunctions:p,raw:a,promoteLongs:l,promoteValues:c,promoteBuffers:d,bsonRegExp:u,internalHint:null,collectionHint:null,promiseLibrary:n,readConcern:ReadConcern.fromOptions(r),writeConcern:WriteConcern.fromOptions(r)}}Object.defineProperty(Collection.prototype,"dbName",{enumerable:!0,get:function(){return this.s.namespace.db}}),Object.defineProperty(Collection.prototype,"collectionName",{enumerable:!0,get:function(){return this.s.namespace.collection}}),Object.defineProperty(Collection.prototype,"namespace",{enumerable:!0,get:function(){return this.s.namespace.toString()}}),Object.defineProperty(Collection.prototype,"readConcern",{enumerable:!0,get:function(){return(null==this.s.readConcern?this.s.db:this.s).readConcern}}),Object.defineProperty(Collection.prototype,"readPreference",{enumerable:!0,get:function(){return(null==this.s.readPreference?this.s.db:this.s).readPreference}}),Object.defineProperty(Collection.prototype,"writeConcern",{enumerable:!0,get:function(){return(null==this.s.writeConcern?this.s.db:this.s).writeConcern}}),Object.defineProperty(Collection.prototype,"hint",{enumerable:!0,get:function(){return this.s.collectionHint},set:function(e){this.s.collectionHint=normalizeHintField(e)}});const DEPRECATED_FIND_OPTIONS=["maxScan","fields","snapshot","oplogReplay"];function _findAndModify(e,t,o,n,i){const r=Array.prototype.slice.call(arguments,1);return i="function"==typeof r[r.length-1]?r.pop():void 0,t=r.length&&r.shift()||[],o=r.length?r.shift():null,n=r.length&&r.shift()||{},(n=Object.assign({},n)).readPreference=ReadPreference.PRIMARY,executeOperation(this.s.topology,new FindAndModifyOperation(this,e,t,o,n),i)}Collection.prototype.find=deprecateOptions({name:"collection.find",deprecatedOptions:DEPRECATED_FIND_OPTIONS,optionsIndex:1},function(e,t,o){"object"==typeof o&&emitWarningOnce("Third parameter to `find()` must be a callback or undefined");let n=e;"function"!=typeof o&&("function"==typeof t?(o=t,t=void 0):null==t&&(o="function"==typeof n?n:void 0,n="object"==typeof n?n:void 0)),n=null==n?{}:n;var i,r=n;if(Buffer.isBuffer(r)){e=r[0]|r[1]<<8|r[2]<<16|r[3]<<24;if(e!==r.length){const l=new Error("query selector raw message size does not match message header size ["+r.length+"] != ["+e+"]");throw l.name="MongoError",l}}null!=n&&"ObjectID"===n._bsontype&&(n={_id:n});let s=(t=t||{}).projection||t.fields;s&&!Buffer.isBuffer(s)&&Array.isArray(s)&&(s=s.length?s.reduce((e,t)=>(e[t]=1,e),{}):{_id:1});let p=Object.assign({},t);for(i in this.s.options)-1!==mergeKeys.indexOf(i)&&(p[i]=this.s.options[i]);if(p.skip=t.skip||0,p.limit=t.limit||0,p.raw=("boolean"==typeof t.raw?t:this.s).raw,p.hint=null!=t.hint?normalizeHintField(t.hint):this.s.collectionHint,p.timeout=void 0===t.timeout?void 0:t.timeout,p.slaveOk=(null!=t.slaveOk?t:this.s.db).slaveOk,p.readPreference=ReadPreference.resolve(this,p),null==p.readPreference||"primary"===p.readPreference&&"primary"===p.readPreference.mode||(p.slaveOk=!0),null!=n&&"object"!=typeof n)throw MongoError.create({message:"query selector must be an object",driver:!0});const a={find:this.s.namespace.toString(),limit:p.limit,skip:p.skip,query:n};"boolean"==typeof t.allowDiskUse&&(a.allowDiskUse=t.allowDiskUse),"boolean"==typeof p.awaitdata&&(p.awaitData=p.awaitdata),"boolean"==typeof p.timeout&&(p.noCursorTimeout=!p.timeout),decorateCommand(a,p,["session","collation"]),s&&(a.fields=s),p.db=this.s.db,p.promiseLibrary=this.s.promiseLibrary,null==p.raw&&"boolean"==typeof this.s.raw&&(p.raw=this.s.raw),null==p.promoteLongs&&"boolean"==typeof this.s.promoteLongs&&(p.promoteLongs=this.s.promoteLongs),null==p.promoteValues&&"boolean"==typeof this.s.promoteValues&&(p.promoteValues=this.s.promoteValues),null==p.promoteBuffers&&"boolean"==typeof this.s.promoteBuffers&&(p.promoteBuffers=this.s.promoteBuffers),null==p.bsonRegExp&&"boolean"==typeof this.s.bsonRegExp&&(p.bsonRegExp=this.s.bsonRegExp),a.sort&&(a.sort=formattedOrderClause(a.sort)),decorateWithReadConcern(a,this,t);try{decorateWithCollation(a,this,t)}catch(e){if("function"==typeof o)return o(e,null);throw e}t=this.s.topology.cursor(new FindOperation(this,this.s.namespace,a,p),p);if("function"!=typeof o)return t;o(null,t)}),Collection.prototype.insertOne=function(e,t,o){"function"==typeof t&&(o=t,t={}),t=t||{},this.s.options.ignoreUndefined&&((t=Object.assign({},t)).ignoreUndefined=this.s.options.ignoreUndefined);t=new InsertOneOperation(this,e,t);return executeOperation(this.s.topology,t,o)},Collection.prototype.insertMany=function(e,t,o){"function"==typeof t&&(o=t,t={}),t=t?Object.assign({},t):{ordered:!0};t=new InsertManyOperation(this,e,t);return executeOperation(this.s.topology,t,o)},Collection.prototype.bulkWrite=function(e,t,o){if("function"==typeof t&&(o=t,t={}),t=t||{ordered:!0},!Array.isArray(e))throw MongoError.create({message:"operations must be an array of documents",driver:!0});t=new BulkWriteOperation(this,e,t);return executeOperation(this.s.topology,t,o)},Collection.prototype.insert=deprecate(function(e,t,o){return"function"==typeof t&&(o=t,t={}),t=t||{ordered:!1},e=Array.isArray(e)?e:[e],!0===t.keepGoing&&(t.ordered=!1),this.insertMany(e,t,o)},"collection.insert is deprecated. Use insertOne, insertMany or bulkWrite instead."),Collection.prototype.updateOne=function(e,t,o,n){return"function"==typeof o&&(n=o,o={}),o=Object.assign({},o),this.s.options.ignoreUndefined&&((o=Object.assign({},o)).ignoreUndefined=this.s.options.ignoreUndefined),executeOperation(this.s.topology,new UpdateOneOperation(this,e,t,o),n)},Collection.prototype.replaceOne=function(e,t,o,n){return"function"==typeof o&&(n=o,o={}),o=Object.assign({},o),this.s.options.ignoreUndefined&&((o=Object.assign({},o)).ignoreUndefined=this.s.options.ignoreUndefined),executeOperation(this.s.topology,new ReplaceOneOperation(this,e,t,o),n)},Collection.prototype.updateMany=function(e,t,o,n){return"function"==typeof o&&(n=o,o={}),o=Object.assign({},o),this.s.options.ignoreUndefined&&((o=Object.assign({},o)).ignoreUndefined=this.s.options.ignoreUndefined),executeOperation(this.s.topology,new UpdateManyOperation(this,e,t,o),n)},Collection.prototype.update=deprecate(function(e,t,o,n){return"function"==typeof o&&(n=o,o={}),o=o||{},this.s.options.ignoreUndefined&&((o=Object.assign({},o)).ignoreUndefined=this.s.options.ignoreUndefined),executeLegacyOperation(this.s.topology,updateDocuments,[this,e,t,o,n])},"collection.update is deprecated. Use updateOne, updateMany, or bulkWrite instead."),Collection.prototype.deleteOne=function(e,t,o){"function"==typeof t&&(o=t,t={}),t=Object.assign({},t),this.s.options.ignoreUndefined&&((t=Object.assign({},t)).ignoreUndefined=this.s.options.ignoreUndefined);t=new DeleteOneOperation(this,e,t);return executeOperation(this.s.topology,t,o)},Collection.prototype.removeOne=Collection.prototype.deleteOne,Collection.prototype.deleteMany=function(e,t,o){"function"==typeof t&&(o=t,t={}),t=Object.assign({},t),this.s.options.ignoreUndefined&&((t=Object.assign({},t)).ignoreUndefined=this.s.options.ignoreUndefined);t=new DeleteManyOperation(this,e,t);return executeOperation(this.s.topology,t,o)},Collection.prototype.removeMany=Collection.prototype.deleteMany,Collection.prototype.remove=deprecate(function(e,t,o){return"function"==typeof t&&(o=t,t={}),t=t||{},this.s.options.ignoreUndefined&&((t=Object.assign({},t)).ignoreUndefined=this.s.options.ignoreUndefined),executeLegacyOperation(this.s.topology,removeDocuments,[this,e,t,o])},"collection.remove is deprecated. Use deleteOne, deleteMany, or bulkWrite instead."),Collection.prototype.save=deprecate(function(e,t,o){return"function"==typeof t&&(o=t,t={}),t=t||{},this.s.options.ignoreUndefined&&((t=Object.assign({},t)).ignoreUndefined=this.s.options.ignoreUndefined),executeLegacyOperation(this.s.topology,save,[this,e,t,o])},"collection.save is deprecated. Use insertOne, insertMany, updateOne, or updateMany instead."),Collection.prototype.findOne=deprecateOptions({name:"collection.find",deprecatedOptions:DEPRECATED_FIND_OPTIONS,optionsIndex:1},function(e,t,o){"object"==typeof o&&emitWarningOnce("Third parameter to `findOne()` must be a callback or undefined"),"function"==typeof e&&(o=e,e={},t={}),"function"==typeof t&&(o=t,t={}),e=e||{},t=t||{};t=new FindOneOperation(this,e,t);return executeOperation(this.s.topology,t,o)}),Collection.prototype.rename=function(e,t,o){"function"==typeof t&&(o=t,t={}),t=Object.assign({},t,{readPreference:ReadPreference.PRIMARY});t=new RenameOperation(this,e,t);return executeOperation(this.s.topology,t,o)},Collection.prototype.drop=function(e,t){"function"==typeof e&&(t=e,e={}),e=e||{};e=new DropCollectionOperation(this.s.db,this.collectionName,e);return executeOperation(this.s.topology,e,t)},Collection.prototype.options=function(e,t){"function"==typeof e&&(t=e,e={}),e=e||{};e=new OptionsOperation(this,e);return executeOperation(this.s.topology,e,t)},Collection.prototype.isCapped=function(e,t){"function"==typeof e&&(t=e,e={}),e=e||{};e=new IsCappedOperation(this,e);return executeOperation(this.s.topology,e,t)},Collection.prototype.createIndex=function(e,t,o){"function"==typeof t&&(o=t,t={}),t=t||{};t=new CreateIndexesOperation(this,this.collectionName,e,t);return executeOperation(this.s.topology,t,o)},Collection.prototype.createIndexes=function(e,t,o){"function"==typeof t&&(o=t,t={}),"number"!=typeof(t=t?Object.assign({},t):{}).maxTimeMS&&delete t.maxTimeMS;t=new CreateIndexesOperation(this,this.collectionName,e,t);return executeOperation(this.s.topology,t,o)},Collection.prototype.dropIndex=function(e,t,o){const n=Array.prototype.slice.call(arguments,1);o="function"==typeof n[n.length-1]?n.pop():void 0,(t=n.length&&n.shift()||{}).readPreference=ReadPreference.PRIMARY;t=new DropIndexOperation(this,e,t);return executeOperation(this.s.topology,t,o)},Collection.prototype.dropIndexes=function(e,t){"function"==typeof e&&(t=e,e={}),"number"!=typeof(e=e?Object.assign({},e):{}).maxTimeMS&&delete e.maxTimeMS;e=new DropIndexesOperation(this,e);return executeOperation(this.s.topology,e,t)},Collection.prototype.dropAllIndexes=deprecate(Collection.prototype.dropIndexes,"collection.dropAllIndexes is deprecated. Use dropIndexes instead."),Collection.prototype.reIndex=deprecate(function(e,t){"function"==typeof e&&(t=e,e={}),e=e||{};e=new ReIndexOperation(this,e);return executeOperation(this.s.topology,e,t)},"collection.reIndex is deprecated. Use db.command instead."),Collection.prototype.listIndexes=function(e){return new CommandCursor(this.s.topology,new ListIndexesOperation(this,e),e)},Collection.prototype.ensureIndex=deprecate(function(e,t,o){return"function"==typeof t&&(o=t,t={}),t=t||{},executeLegacyOperation(this.s.topology,ensureIndex,[this,e,t,o])},"collection.ensureIndex is deprecated. Use createIndexes instead."),Collection.prototype.indexExists=function(e,t,o){"function"==typeof t&&(o=t,t={}),t=t||{};t=new IndexExistsOperation(this,e,t);return executeOperation(this.s.topology,t,o)},Collection.prototype.indexInformation=function(e,t){const o=Array.prototype.slice.call(arguments,0);t="function"==typeof o[o.length-1]?o.pop():void 0,e=o.length&&o.shift()||{};e=new IndexInformationOperation(this.s.db,this.collectionName,e);return executeOperation(this.s.topology,e,t)},Collection.prototype.count=deprecate(function(e,t,o){const n=Array.prototype.slice.call(arguments,0);return o="function"==typeof n[n.length-1]?n.pop():void 0,e=n.length&&n.shift()||{},"function"==typeof(t=n.length&&n.shift()||{})&&(o=t,t={}),t=t||{},executeOperation(this.s.topology,new EstimatedDocumentCountOperation(this,Object.assign({query:e},t)),o)},"collection.count is deprecated, and will be removed in a future version. Use Collection.countDocuments or Collection.estimatedDocumentCount instead"),Collection.prototype.estimatedDocumentCount=function(e,t){"function"==typeof e&&(t=e,e={}),e=e||{};e=new EstimatedDocumentCountOperation(this,e);return executeOperation(this.s.topology,e,t)},Collection.prototype.countDocuments=function(e,t,o){const n=Array.prototype.slice.call(arguments,0);o="function"==typeof n[n.length-1]?n.pop():void 0,e=n.length&&n.shift()||{},t=n.length&&n.shift()||{};t=new CountDocumentsOperation(this,e,t);return executeOperation(this.s.topology,t,o)},Collection.prototype.distinct=function(e,t,o,n){const i=Array.prototype.slice.call(arguments,1);n="function"==typeof i[i.length-1]?i.pop():void 0;var r=i.length&&i.shift()||{},s=i.length&&i.shift()||{},s=new DistinctOperation(this,e,r,s);return executeOperation(this.s.topology,s,n)},Collection.prototype.indexes=function(e,t){"function"==typeof e&&(t=e,e={}),e=e||{};e=new IndexesOperation(this,e);return executeOperation(this.s.topology,e,t)},Collection.prototype.stats=function(e,t){const o=Array.prototype.slice.call(arguments,0);t="function"==typeof o[o.length-1]?o.pop():void 0,e=o.length&&o.shift()||{};e=new StatsOperation(this,e);return executeOperation(this.s.topology,e,t)},Collection.prototype.findOneAndDelete=function(e,t,o){return"function"==typeof t&&(o=t,t={}),t=t||{},this.s.options.ignoreUndefined&&((t=Object.assign({},t)).ignoreUndefined=this.s.options.ignoreUndefined),executeOperation(this.s.topology,new FindOneAndDeleteOperation(this,e,t),o)},Collection.prototype.findOneAndReplace=deprecateOptions({name:"collection.findOneAndReplace",deprecatedOptions:["returnOriginal"],optionsIndex:2},function(e,t,o,n){return"function"==typeof o&&(n=o,o={}),o=o||{},this.s.options.ignoreUndefined&&((o=Object.assign({},o)).ignoreUndefined=this.s.options.ignoreUndefined),executeOperation(this.s.topology,new FindOneAndReplaceOperation(this,e,t,o),n)}),Collection.prototype.findOneAndUpdate=deprecateOptions({name:"collection.findOneAndUpdate",deprecatedOptions:["returnOriginal"],optionsIndex:2},function(e,t,o,n){return"function"==typeof o&&(n=o,o={}),o=o||{},this.s.options.ignoreUndefined&&((o=Object.assign({},o)).ignoreUndefined=this.s.options.ignoreUndefined),executeOperation(this.s.topology,new FindOneAndUpdateOperation(this,e,t,o),n)}),Collection.prototype.findAndModify=deprecate(_findAndModify,"collection.findAndModify is deprecated. Use findOneAndUpdate, findOneAndReplace or findOneAndDelete instead."),Collection.prototype._findAndModify=_findAndModify,Collection.prototype.findAndRemove=deprecate(function(e,t,o,n){const i=Array.prototype.slice.call(arguments,1);return n="function"==typeof i[i.length-1]?i.pop():void 0,t=i.length&&i.shift()||[],(o=i.length&&i.shift()||{}).remove=!0,executeOperation(this.s.topology,new FindAndModifyOperation(this,e,t,null,o),n)},"collection.findAndRemove is deprecated. Use findOneAndDelete instead."),Collection.prototype.aggregate=function(e,t,o){if(Array.isArray(e))"function"==typeof t&&(o=t,t={}),null==t&&null==o&&(t={});else{const i=Array.prototype.slice.call(arguments,0);o=i.pop();var n=i[i.length-1];t=n&&(n.readPreference||n.explain||n.cursor||n.out||n.maxTimeMS||n.hint||n.allowDiskUse)?i.pop():{},e=i}t=new AggregationCursor(this.s.topology,new AggregateOperation(this,e,t),t);if("function"!=typeof o)return t;o(null,t)},Collection.prototype.watch=function(e,t){return e=e||[],t=t||{},Array.isArray(e)||(t=e,e=[]),new ChangeStream(this,e,t)},Collection.prototype.parallelCollectionScan=deprecate(function(e,t){return"function"==typeof e&&(t=e,e={numCursors:1}),e.numCursors=e.numCursors||1,e.batchSize=e.batchSize||1e3,(e=Object.assign({},e)).readPreference=ReadPreference.resolve(this,e),e.promiseLibrary=this.s.promiseLibrary,e.session&&(e.session=void 0),executeLegacyOperation(this.s.topology,parallelCollectionScan,[this,e,t],{skipSessions:!0})},"parallelCollectionScan is deprecated in MongoDB v4.1"),Collection.prototype.geoHaystackSearch=deprecate(function(e,t,o,n){const i=Array.prototype.slice.call(arguments,2);n="function"==typeof i[i.length-1]?i.pop():void 0,o=i.length&&i.shift()||{};o=new GeoHaystackSearchOperation(this,e,t,o);return executeOperation(this.s.topology,o,n)},"geoHaystackSearch is deprecated, and will be removed in a future version."),Collection.prototype.group=deprecate(function(e,t,o,n,i,r,s,p){const a=Array.prototype.slice.call(arguments,3);return p="function"==typeof a[a.length-1]?a.pop():void 0,n=a.length?a.shift():null,i=a.length?a.shift():null,r=a.length?a.shift():null,s=a.length&&a.shift()||{},"function"!=typeof i&&(r=i,i=null),!Array.isArray(e)&&e instanceof Object&&"function"!=typeof e&&"Code"!==e._bsontype&&(e=Object.keys(e)),"function"==typeof n&&(n=n.toString()),"function"==typeof i&&(i=i.toString()),r=null==r||r,executeLegacyOperation(this.s.topology,group,[this,e,t,o,n,i,r,s,p])},"MongoDB 3.6 or higher no longer supports the group command. We recommend rewriting using the aggregation framework."),Collection.prototype.mapReduce=function(e,t,o,n){if("function"==typeof o&&(n=o,o={}),null==o.out)throw new Error("the out option parameter must be defined, see mongodb docs for possible values");"function"==typeof e&&(e=e.toString()),"function"==typeof t&&(t=t.toString()),"function"==typeof o.finalize&&(o.finalize=o.finalize.toString());o=new MapReduceOperation(this,e,t,o);return executeOperation(this.s.topology,o,n)},Collection.prototype.initializeUnorderedBulkOp=function(e){return null==(e=e||{}).ignoreUndefined&&(e.ignoreUndefined=this.s.options.ignoreUndefined),e.promiseLibrary=this.s.promiseLibrary,unordered(this.s.topology,this,e)},Collection.prototype.initializeOrderedBulkOp=function(e){return null==(e=e||{}).ignoreUndefined&&(e.ignoreUndefined=this.s.options.ignoreUndefined),e.promiseLibrary=this.s.promiseLibrary,ordered(this.s.topology,this,e)},Collection.prototype.getLogger=function(){return this.s.db.s.logger},module.exports=Collection;