"use strict";const Denque=require("denque"),EventEmitter=require("events").EventEmitter,Logger=require("../core/connection/logger"),makeCounter=require("../utils").makeCounter,MongoError=require("../core/error").MongoError,Connection=require("./connection").Connection,eachAsync=require("../core/utils").eachAsync,connect=require("../core/connection/connect"),relayEvents=require("../core/utils").relayEvents,errors=require("./errors"),PoolClosedError=errors.PoolClosedError,WaitQueueTimeoutError=errors.WaitQueueTimeoutError,events=require("./events"),ConnectionPoolCreatedEvent=events.ConnectionPoolCreatedEvent,ConnectionPoolClosedEvent=events.ConnectionPoolClosedEvent,ConnectionCreatedEvent=events.ConnectionCreatedEvent,ConnectionReadyEvent=events.ConnectionReadyEvent,ConnectionClosedEvent=events.ConnectionClosedEvent,ConnectionCheckOutStartedEvent=events.ConnectionCheckOutStartedEvent,ConnectionCheckOutFailedEvent=events.ConnectionCheckOutFailedEvent,ConnectionCheckedOutEvent=events.ConnectionCheckedOutEvent,ConnectionCheckedInEvent=events.ConnectionCheckedInEvent,ConnectionPoolClearedEvent=events.ConnectionPoolClearedEvent,kLogger=Symbol("logger"),kConnections=Symbol("connections"),kPermits=Symbol("permits"),kMinPoolSizeTimer=Symbol("minPoolSizeTimer"),kGeneration=Symbol("generation"),kConnectionCounter=Symbol("connectionCounter"),kCancellationToken=Symbol("cancellationToken"),kWaitQueue=Symbol("waitQueue"),kCancelled=Symbol("cancelled"),VALID_POOL_OPTIONS=new Set(["ssl","bson","connectionType","serverApi","monitorCommands","socketTimeout","credentials","compression","host","port","localAddress","localPort","family","hints","lookup","path","ca","cert","sigalgs","ciphers","clientCertEngine","crl","dhparam","ecdhCurve","honorCipherOrder","key","privateKeyEngine","privateKeyIdentifier","maxVersion","minVersion","passphrase","pfx","secureOptions","secureProtocol","sessionIdContext","allowHalfOpen","rejectUnauthorized","pskCallback","ALPNProtocols","servername","checkServerIdentity","session","minDHSize","secureContext","maxPoolSize","minPoolSize","maxIdleTimeMS","waitQueueTimeoutMS"]);function resolveOptions(o,e){var n=Array.from(VALID_POOL_OPTIONS).reduce((e,n)=>(Object.prototype.hasOwnProperty.call(o,n)&&(e[n]=o[n]),e),{});return Object.freeze(Object.assign({},e,n))}class ConnectionPool extends EventEmitter{constructor(e){if(super(),e=e||{},this.closed=!1,this.options=resolveOptions(e,{connectionType:Connection,maxPoolSize:"number"==typeof e.maxPoolSize?e.maxPoolSize:100,minPoolSize:"number"==typeof e.minPoolSize?e.minPoolSize:0,maxIdleTimeMS:"number"==typeof e.maxIdleTimeMS?e.maxIdleTimeMS:0,waitQueueTimeoutMS:"number"==typeof e.waitQueueTimeoutMS?e.waitQueueTimeoutMS:0,autoEncrypter:e.autoEncrypter,metadata:e.metadata,useUnifiedTopology:e.useUnifiedTopology}),e.minSize>e.maxSize)throw new TypeError("Connection pool minimum size must not be greater than maximum pool size");this[kLogger]=Logger("ConnectionPool",e),this[kConnections]=new Denque,this[kPermits]=this.options.maxPoolSize,this[kMinPoolSizeTimer]=void 0,this[kGeneration]=0,this[kConnectionCounter]=makeCounter(1),this[kCancellationToken]=new EventEmitter,this[kCancellationToken].setMaxListeners(1/0),this[kWaitQueue]=new Denque,process.nextTick(()=>{this.emit("connectionPoolCreated",new ConnectionPoolCreatedEvent(this)),ensureMinPoolSize(this)})}get address(){return`${this.options.host}:${this.options.port}`}get generation(){return this[kGeneration]}get totalConnectionCount(){return this[kConnections].length+(this.options.maxPoolSize-this[kPermits])}get availableConnectionCount(){return this[kConnections].length}get waitQueueSize(){return this[kWaitQueue].length}checkOut(e){if(this.emit("connectionCheckOutStarted",new ConnectionCheckOutStartedEvent(this)),this.closed)return this.emit("connectionCheckOutFailed",new ConnectionCheckOutFailedEvent(this,"poolClosed")),void e(new PoolClosedError(this));const n={callback:e},o=this;e=this.options.waitQueueTimeoutMS;e&&(n.timer=setTimeout(()=>{n[kCancelled]=!0,n.timer=void 0,o.emit("connectionCheckOutFailed",new ConnectionCheckOutFailedEvent(o,"timeout")),n.callback(new WaitQueueTimeoutError(o))},e)),this[kWaitQueue].push(n),process.nextTick(()=>processWaitQueue(this))}checkIn(e){var n=this.closed,o=connectionIsStale(this,e),o=!!(n||o||e.closed);o||(e.markAvailable(),this[kConnections].push(e)),this.emit("connectionCheckedIn",new ConnectionCheckedInEvent(this,e)),o&&destroyConnection(this,e,e.closed?"error":n?"poolClosed":"stale"),process.nextTick(()=>processWaitQueue(this))}clear(){this[kGeneration]+=1,this.emit("connectionPoolCleared",new ConnectionPoolClearedEvent(this))}close(o,n){if("function"==typeof o&&(n=o),o=Object.assign({force:!1},o),this.closed)return n();for(this[kCancellationToken].emit("cancel");this.waitQueueSize;){const e=this[kWaitQueue].pop();clearTimeout(e.timer),e[kCancelled]||e.callback(new MongoError("connection pool closed"))}this[kMinPoolSizeTimer]&&clearTimeout(this[kMinPoolSizeTimer]),"function"==typeof this[kConnectionCounter].return&&this[kConnectionCounter].return(),this.closed=!0,eachAsync(this[kConnections].toArray(),(e,n)=>{this.emit("connectionClosed",new ConnectionClosedEvent(this,e,"poolClosed")),e.destroy(o,n)},e=>{this[kConnections].clear(),this.emit("connectionPoolClosed",new ConnectionPoolClosedEvent(this)),n(e)})}withConnection(n,t){this.checkOut((e,o)=>{n(e,o,(e,n)=>{"function"==typeof t&&(e?t(e):t(void 0,n)),o&&this.checkIn(o)})})}}function ensureMinPoolSize(n){if(!n.closed&&0!==n.options.minPoolSize){var o=n.options.minPoolSize;for(let e=n.totalConnectionCount;e<o;++e)createConnection(n);n[kMinPoolSizeTimer]=setTimeout(()=>ensureMinPoolSize(n),10)}}function connectionIsStale(e,n){return n.generation!==e[kGeneration]}function connectionIsIdle(e,n){return!!(e.options.maxIdleTimeMS&&n.idleTime>e.options.maxIdleTimeMS)}function createConnection(o,t){var e=Object.assign({id:o[kConnectionCounter].next().value,generation:o[kGeneration]},o.options);o[kPermits]--,connect(e,o[kCancellationToken],(e,n)=>e?(o[kPermits]++,o[kLogger].debug(`connection attempt failed with error [${JSON.stringify(e)}]`),void("function"==typeof t&&t(e))):void(o.closed?n.destroy({force:!0}):(relayEvents(n,o,["commandStarted","commandFailed","commandSucceeded","clusterTimeReceived"]),o.emit("connectionCreated",new ConnectionCreatedEvent(o,n)),n.markAvailable(),o.emit("connectionReady",new ConnectionReadyEvent(o,n)),"function"!=typeof t?(o[kConnections].push(n),process.nextTick(()=>processWaitQueue(o))):t(void 0,n))))}function destroyConnection(e,n,o){e.emit("connectionClosed",new ConnectionClosedEvent(e,n,o)),e[kPermits]++,process.nextTick(()=>n.destroy())}function processWaitQueue(t){if(!t.closed){for(;t.waitQueueSize;){const c=t[kWaitQueue].peekFront();if(c[kCancelled])t[kWaitQueue].shift();else{if(!t.availableConnectionCount)break;var e=t[kConnections].shift(),n=connectionIsStale(t,e),o=connectionIsIdle(t,e);if(!n&&!o&&!e.closed)return t.emit("connectionCheckedOut",new ConnectionCheckedOutEvent(t,e)),clearTimeout(c.timer),t[kWaitQueue].shift(),void c.callback(void 0,e);n=e.closed?"error":n?"stale":"idle";destroyConnection(t,e,n)}}var i=t.options.maxPoolSize;t.waitQueueSize&&(i<=0||t.totalConnectionCount<i)&&createConnection(t,(e,n)=>{const o=t[kWaitQueue].shift();null==o||o[kCancelled]?null==e&&t[kConnections].push(n):(e?t.emit("connectionCheckOutFailed",new ConnectionCheckOutFailedEvent(t,e)):t.emit("connectionCheckedOut",new ConnectionCheckedOutEvent(t,n)),clearTimeout(o.timer),o.callback(e,n))})}}module.exports={ConnectionPool:ConnectionPool};