"use strict";const EventEmitter=require("events"),MessageStream=require("./message_stream"),MongoError=require("../core/error").MongoError,MongoNetworkError=require("../core/error").MongoNetworkError,MongoNetworkTimeoutError=require("../core/error").MongoNetworkTimeoutError,MongoWriteConcernError=require("../core/error").MongoWriteConcernError,CommandResult=require("../core/connection/command_result"),StreamDescription=require("./stream_description").StreamDescription,wp=require("../core/wireprotocol"),apm=require("../core/connection/apm"),updateSessionFromResponse=require("../core/sessions").updateSessionFromResponse,uuidV4=require("../core/utils").uuidV4,now=require("../utils").now,calculateDurationInMs=require("../utils").calculateDurationInMs,kStream=Symbol("stream"),kQueue=Symbol("queue"),kMessageStream=Symbol("messageStream"),kGeneration=Symbol("generation"),kLastUseTime=Symbol("lastUseTime"),kClusterTime=Symbol("clusterTime"),kDescription=Symbol("description"),kIsMaster=Symbol("ismaster"),kAutoEncrypter=Symbol("autoEncrypter");class Connection extends EventEmitter{constructor(e,t){super(t),this.id=t.id,this.address=streamIdentifier(e),this.bson=t.bson,this.socketTimeout="number"==typeof t.socketTimeout?t.socketTimeout:0,this.host=t.host||"localhost",this.port=t.port||27017,this.monitorCommands="boolean"==typeof t.monitorCommands&&t.monitorCommands,this.serverApi=t.serverApi,this.closed=!1,this.destroyed=!1,this[kDescription]=new StreamDescription(this.address,t),this[kGeneration]=t.generation,this[kLastUseTime]=now(),t.autoEncrypter&&(this[kAutoEncrypter]=t.autoEncrypter),this[kQueue]=new Map,this[kMessageStream]=new MessageStream(t),this[kMessageStream].on("message",messageHandler(this)),(this[kStream]=e).on("error",()=>{}),this[kMessageStream].on("error",e=>this.handleIssue({destroy:e})),e.on("close",()=>this.handleIssue({isClose:!0})),e.on("timeout",()=>this.handleIssue({isTimeout:!0,destroy:!0})),e.pipe(this[kMessageStream]),this[kMessageStream].pipe(e)}get description(){return this[kDescription]}get ismaster(){return this[kIsMaster]}set ismaster(e){this[kDescription].receiveResponse(e),this[kIsMaster]=e}get generation(){return this[kGeneration]||0}get idleTime(){return calculateDurationInMs(this[kLastUseTime])}get clusterTime(){return this[kClusterTime]}get stream(){return this[kStream]}markAvailable(){this[kLastUseTime]=now()}handleIssue(e){if(!this.closed){e.destroy&&this[kStream].destroy("boolean"==typeof e.destroy?void 0:e.destroy),this.closed=!0;for(const t of this[kQueue]){const o=t[1];e.isTimeout?o.cb(new MongoNetworkTimeoutError(`connection ${this.id} to ${this.address} timed out`,{beforeHandshake:null==this.ismaster})):e.isClose?o.cb(new MongoNetworkError(`connection ${this.id} to ${this.address} closed`)):o.cb("boolean"==typeof e.destroy?void 0:e.destroy)}this[kQueue].clear(),this.emit("close")}}destroy(e,t){return"function"==typeof e&&(t=e,e={}),e=Object.assign({force:!1},e),null==this[kStream]||this.destroyed?(this.destroyed=!0,void("function"==typeof t&&t())):e.force?(this[kStream].destroy(),this.destroyed=!0,void("function"==typeof t&&t())):void this[kStream].end(e=>{this.destroyed=!0,"function"==typeof t&&t(e)})}applyApiVersion(e){return this.serverApi&&(e.serverApi=this.serverApi),e}command(e,t,o,r){"function"==typeof o&&(r=o,o={}),wp.command(makeServerTrampoline(this),e,t,this.applyApiVersion(o),r)}query(e,t,o,r,s){wp.query(makeServerTrampoline(this),e,t,o,this.applyApiVersion(r),s)}getMore(e,t,o,r,s){wp.getMore(makeServerTrampoline(this),e,t,o,this.applyApiVersion(r),s)}killCursors(e,t,o){wp.killCursors(makeServerTrampoline(this),e,t,this.applyApiVersion({}),o)}insert(e,t,o,r){wp.insert(makeServerTrampoline(this),e,t,this.applyApiVersion(o),r)}update(e,t,o,r){wp.update(makeServerTrampoline(this),e,t,this.applyApiVersion(o),r)}remove(e,t,o,r){wp.remove(makeServerTrampoline(this),e,t,this.applyApiVersion(o),r)}}function makeServerTrampoline(e){const t={description:e.description,clusterTime:e[kClusterTime],s:{bson:e.bson,pool:{write:write.bind(e),isConnected:()=>!0}}};return e[kAutoEncrypter]&&(t.autoEncrypter=e[kAutoEncrypter]),t}function messageHandler(i){return function(e){if(i.emit("message",e),i[kQueue].has(e.responseTo)){var t=i[kQueue].get(e.responseTo);const s=t.cb;i[kQueue].delete(e.responseTo),e.moreToCome?i[kQueue].set(e.requestId,t):t.socketTimeoutOverride&&i[kStream].setTimeout(i.socketTimeout);try{e.parse(t)}catch(e){return void s(new MongoError(e))}if(e.documents[0]){var o=e.documents[0],r=t.session;if(r&&updateSessionFromResponse(r,o),o.$clusterTime&&(i[kClusterTime]=o.$clusterTime,i.emit("clusterTimeReceived",o.$clusterTime)),t.command){if(o.writeConcernError)return void s(new MongoWriteConcernError(o.writeConcernError,o));if(0===o.ok||o.$err||o.errmsg||o.code)return void s(new MongoError(o))}}s(void 0,new CommandResult(t.fullResult?e:e.documents[0],i,e))}}}function streamIdentifier(e){return"function"==typeof e.address?`${e.remoteAddress}:${e.remotePort}`:uuidV4().toString("hex")}function write(o,e,r){"function"==typeof e&&(r=e);const s={requestId:o.requestId,cb:r,session:(e=e||{}).session,fullResult:"boolean"==typeof e.fullResult&&e.fullResult,noResponse:"boolean"==typeof e.noResponse&&e.noResponse,documentsReturnedIn:e.documentsReturnedIn,command:!!e.command,promoteLongs:"boolean"!=typeof e.promoteLongs||e.promoteLongs,promoteValues:"boolean"!=typeof e.promoteValues||e.promoteValues,promoteBuffers:"boolean"==typeof e.promoteBuffers&&e.promoteBuffers,bsonRegExp:"boolean"==typeof e.bsonRegExp&&e.bsonRegExp,raw:"boolean"==typeof e.raw&&e.raw};this[kDescription]&&this[kDescription].compressor&&(s.agreedCompressor=this[kDescription].compressor,this[kDescription].zlibCompressionLevel&&(s.zlibCompressionLevel=this[kDescription].zlibCompressionLevel)),"number"==typeof e.socketTimeout&&(s.socketTimeoutOverride=!0,this[kStream].setTimeout(e.socketTimeout)),this.monitorCommands&&(this.emit("commandStarted",new apm.CommandStartedEvent(this,o)),s.started=now(),s.cb=(e,t)=>{e?this.emit("commandFailed",new apm.CommandFailedEvent(this,o,e,s.started)):t&&t.result&&(0===t.result.ok||t.result.$err)?this.emit("commandFailed",new apm.CommandFailedEvent(this,o,t.result,s.started)):this.emit("commandSucceeded",new apm.CommandSucceededEvent(this,o,t,s.started)),"function"==typeof r&&r(e,t)}),s.noResponse||this[kQueue].set(s.requestId,s);try{this[kMessageStream].writeCommand(o,s)}catch(e){if(!s.noResponse)return this[kQueue].delete(s.requestId),void s.cb(e)}s.noResponse&&s.cb()}module.exports={Connection:Connection};