"use strict";const Denque=require("denque"),EventEmitter=require("events"),isResumableError=require("./error").isResumableError,MongoError=require("./core").MongoError,Cursor=require("./cursor"),relayEvents=require("./core/utils").relayEvents,maxWireVersion=require("./core/utils").maxWireVersion,maybePromise=require("./utils").maybePromise,now=require("./utils").now,calculateDurationInMs=require("./utils").calculateDurationInMs,AggregateOperation=require("./operations/aggregate"),kResumeQueue=Symbol("resumeQueue"),CHANGE_STREAM_OPTIONS=["resumeAfter","startAfter","startAtOperationTime","fullDocument"],CURSOR_OPTIONS=["batchSize","maxAwaitTimeMS","collation","readPreference"].concat(CHANGE_STREAM_OPTIONS),CHANGE_DOMAIN_TYPES={COLLECTION:Symbol("Collection"),DATABASE:Symbol("Database"),CLUSTER:Symbol("Cluster")};class ChangeStream extends EventEmitter{constructor(e,r,t){super();var s=require("./collection"),o=require("./db"),i=require("./mongo_client");if(this.pipeline=r||[],this.options=t||{},this.parent=e,this.namespace=e.s.namespace,e instanceof s)this.type=CHANGE_DOMAIN_TYPES.COLLECTION,this.topology=e.s.db.serverConfig;else if(e instanceof o)this.type=CHANGE_DOMAIN_TYPES.DATABASE,this.topology=e.serverConfig;else{if(!(e instanceof i))throw new TypeError("parent provided to ChangeStream constructor is not an instance of Collection, Db, or MongoClient");this.type=CHANGE_DOMAIN_TYPES.CLUSTER,this.topology=e.topology}this.promiseLibrary=e.s.promiseLibrary,!this.options.readPreference&&e.s.readPreference&&(this.options.readPreference=e.s.readPreference),this[kResumeQueue]=new Denque,this.cursor=createChangeStreamCursor(this,t),this.closed=!1,this.on("newListener",e=>{"change"===e&&this.cursor&&0===this.listenerCount("change")&&this.cursor.on("data",e=>processNewChange(this,e))}),this.on("removeListener",e=>{"change"===e&&0===this.listenerCount("change")&&this.cursor&&this.cursor.removeAllListeners("data")})}get resumeToken(){return this.cursor.resumeToken}hasNext(e){return maybePromise(this.parent,e,t=>{getCursor(this,(e,r)=>e?t(e):void r.hasNext(t))})}next(e){return maybePromise(this.parent,e,t=>{getCursor(this,(e,r)=>e?t(e):void r.next((e,r)=>e?(this[kResumeQueue].push(()=>this.next(t)),void processError(this,e,t)):void processNewChange(this,r,t)))})}isClosed(){return this.closed||this.cursor&&this.cursor.isClosed()}close(e){return maybePromise(this.parent,e,r=>{if(this.closed)return r();if(this.closed=!0,!this.cursor)return r();const t=this.cursor;return t.close(e=>(["data","close","end","error"].forEach(e=>t.removeAllListeners(e)),this.cursor=void 0,r(e)))})}pipe(e,r){return this.pipeDestinations||(this.pipeDestinations=[]),this.pipeDestinations.push(e),this.cursor.pipe(e,r)}unpipe(e){return this.pipeDestinations&&-1<this.pipeDestinations.indexOf(e)&&this.pipeDestinations.splice(this.pipeDestinations.indexOf(e),1),this.cursor.unpipe(e)}stream(e){return this.streamOptions=e,this.cursor.stream(e)}pause(){return this.cursor.pause()}resume(){return this.cursor.resume()}}class ChangeStreamCursor extends Cursor{constructor(e,r,t){super(e,r,t),t=t||{},this._resumeToken=null,this.startAtOperationTime=t.startAtOperationTime,t.startAfter?this.resumeToken=t.startAfter:t.resumeAfter&&(this.resumeToken=t.resumeAfter)}set resumeToken(e){this._resumeToken=e,this.emit("resumeTokenChanged",e)}get resumeToken(){return this._resumeToken}get resumeOptions(){const r={};for(const t of CURSOR_OPTIONS)this.options[t]&&(r[t]=this.options[t]);var e;return(this.resumeToken||this.startAtOperationTime)&&(["resumeAfter","startAfter","startAtOperationTime"].forEach(e=>delete r[e]),this.resumeToken?(e=this.options.startAfter&&!this.hasReceived?"startAfter":"resumeAfter",r[e]=this.resumeToken):this.startAtOperationTime&&7<=maxWireVersion(this.server)&&(r.startAtOperationTime=this.startAtOperationTime)),r}cacheResumeToken(e){0===this.bufferedCount()&&this.cursorState.postBatchResumeToken?this.resumeToken=this.cursorState.postBatchResumeToken:this.resumeToken=e,this.hasReceived=!0}_processBatch(e,r){r=r.cursor;r.postBatchResumeToken&&(this.cursorState.postBatchResumeToken=r.postBatchResumeToken,0===r[e].length&&(this.resumeToken=r.postBatchResumeToken))}_initializeCursor(s){super._initializeCursor((e,r)=>{var t;e||null==r||(t=r.documents[0],null==this.startAtOperationTime&&null==this.resumeAfter&&null==this.startAfter&&7<=maxWireVersion(this.server)&&(this.startAtOperationTime=t.operationTime),this._processBatch("firstBatch",t),this.emit("init",r),this.emit("response")),s(e,r)})}_getMore(t){super._getMore((e,r)=>{e?t(e):(this._processBatch("nextBatch",r),this.emit("more",r),this.emit("response"),t(e,r))})}}function createChangeStreamCursor(r,e){const t={fullDocument:e.fullDocument||"default"};applyKnownOptions(t,e,CHANGE_STREAM_OPTIONS),r.type===CHANGE_DOMAIN_TYPES.CLUSTER&&(t.allChangesForCluster=!0);var s=[{$changeStream:t}].concat(r.pipeline),o=applyKnownOptions({},e,CURSOR_OPTIONS);const i=new ChangeStreamCursor(r.topology,new AggregateOperation(r.parent,s,e),o);if(relayEvents(i,r,["resumeTokenChanged","end","close"]),0<r.listenerCount("change")&&i.on("data",function(e){processNewChange(r,e)}),i.on("error",function(e){processError(r,e)}),r.pipeDestinations){const a=i.stream(r.streamOptions);for(var n of r.pipeDestinations)a.pipe(n)}return i}function applyKnownOptions(r,t,e){return e.forEach(e=>{t[e]&&(r[e]=t[e])}),r}const SELECTION_TIMEOUT=3e4;function waitForTopologyConnected(s,o,i){setTimeout(()=>{o&&null==o.start&&(o.start=now());var e=o.start||now(),r=o.timeout||SELECTION_TIMEOUT,t=o.readPreference;return s.isConnected({readPreference:t})?i():calculateDurationInMs(e)>r?i(new MongoError("Timed out waiting for connection")):void waitForTopologyConnected(s,o,i)},500)}function processNewChange(e,r,t){const s=e.cursor;if(null==r&&(e.closed=!0),!e.closed){if(!r||r._id)return s.cacheResumeToken(r._id),e.options.startAtOperationTime=void 0,t?t(void 0,r):e.emit("change",r);r=new Error("A change stream document has been received that lacks a resume token (_id).");return t?t(r):e.emit("error",r)}t&&t(new MongoError("ChangeStream is closed"))}function processError(t,e,s){var r=t.topology;const o=t.cursor;if(!t.closed)return o&&isResumableError(e,maxWireVersion(o.server))?(t.cursor=void 0,["data","close","end","error"].forEach(e=>o.removeAllListeners(e)),o.close(),void waitForTopologyConnected(r,{readPreference:o.options.readPreference},e=>{if(e)return n(e);const r=createChangeStreamCursor(t,o.resumeOptions);if(!s)return i(r);r.hasNext(e=>e?n(e):void i(r))})):s?s(e):t.emit("error",e);function i(e){t.cursor=e,processResumeQueue(t)}function n(e){s||(t.emit("error",e),t.emit("close")),processResumeQueue(t,e),t.closed=!0}s&&s(new MongoError("ChangeStream is closed"))}function getCursor(e,r){e.isClosed()?r(new MongoError("ChangeStream is closed.")):e.cursor?r(void 0,e.cursor):e[kResumeQueue].push(r)}function processResumeQueue(e,r){for(;e[kResumeQueue].length;){const t=e[kResumeQueue].pop();if(e.isClosed()&&!r)return void t(new MongoError("Change Stream is not open."));t(r,e.cursor)}}module.exports=ChangeStream;