"use strict";const Long=require("../core").BSON.Long,MongoError=require("../core").MongoError,ObjectID=require("../core").BSON.ObjectID,BSON=require("../core").BSON,MongoWriteConcernError=require("../core").MongoWriteConcernError,emitWarningOnce=require("../utils").emitWarningOnce,toError=require("../utils").toError,handleCallback=require("../utils").handleCallback,applyRetryableWrites=require("../utils").applyRetryableWrites,applyWriteConcern=require("../utils").applyWriteConcern,executeLegacyOperation=require("../utils").executeLegacyOperation,isPromiseLike=require("../utils").isPromiseLike,hasAtomicOperators=require("../utils").hasAtomicOperators,maxWireVersion=require("../core/utils").maxWireVersion,WRITE_CONCERN_ERROR=64,INSERT=1,UPDATE=2,REMOVE=3,bson=new BSON([BSON.Binary,BSON.Code,BSON.DBRef,BSON.Decimal128,BSON.Double,BSON.Int32,BSON.Long,BSON.Map,BSON.MaxKey,BSON.MinKey,BSON.ObjectId,BSON.BSONRegExp,BSON.Symbol,BSON.Timestamp]);class Batch{constructor(e,r){this.originalZeroIndex=r,this.currentIndex=0,this.originalIndexes=[],this.batchType=e,this.operations=[],this.size=0,this.sizeBytes=0}}const kUpsertedIds=Symbol("upsertedIds"),kInsertedIds=Symbol("insertedIds");class BulkWriteResult{constructor(e){this.result=e,this[kUpsertedIds]=void 0,this[kInsertedIds]=void 0}get insertedCount(){return"number"!=typeof this.result.nInserted?0:this.result.nInserted}get matchedCount(){return"number"!=typeof this.result.nMatched?0:this.result.nMatched}get modifiedCount(){return"number"!=typeof this.result.nModified?0:this.result.nModified}get deletedCount(){return"number"!=typeof this.result.nRemoved?0:this.result.nRemoved}get upsertedCount(){return this.result.upserted?this.result.upserted.length:0}get upsertedIds(){if(this[kUpsertedIds])return this[kUpsertedIds];this[kUpsertedIds]={};for(const e of this.result.upserted||[])this[kUpsertedIds][e.index]=e._id;return this[kUpsertedIds]}get insertedIds(){if(this[kInsertedIds])return this[kInsertedIds];this[kInsertedIds]={};for(const e of this.result.insertedIds||[])this[kInsertedIds][e.index]=e._id;return this[kInsertedIds]}get n(){return this.result.insertedCount}get ok(){return this.result.ok}get nInserted(){return this.result.nInserted}get nUpserted(){return this.result.nUpserted}get nMatched(){return this.result.nMatched}get nModified(){return this.result.nModified}get nRemoved(){return this.result.nRemoved}getInsertedIds(){return this.result.insertedIds}getUpsertedIds(){return this.result.upserted}getUpsertedIdAt(e){return this.result.upserted[e]}getRawResponse(){return this.result}hasWriteErrors(){return 0<this.result.writeErrors.length}getWriteErrorCount(){return this.result.writeErrors.length}getWriteErrorAt(e){return e<this.result.writeErrors.length?this.result.writeErrors[e]:null}getWriteErrors(){return this.result.writeErrors}getLastOp(){return this.result.lastOp}getWriteConcernError(){if(0===this.result.writeConcernErrors.length)return null;if(1===this.result.writeConcernErrors.length)return this.result.writeConcernErrors[0];{let r="";for(let e=0;e<this.result.writeConcernErrors.length;e++){var t=this.result.writeConcernErrors[e];r+=t.errmsg,0===e&&(r+=" and ")}return new WriteConcernError({errmsg:r,code:WRITE_CONCERN_ERROR})}}toJSON(){return this.result}toString(){return`BulkWriteResult(${this.toJSON(this.result)})`}isOk(){return 1===this.result.ok}}class WriteConcernError{constructor(e){this.err=e}get code(){return this.err.code}get errmsg(){return this.err.errmsg}toJSON(){return{code:this.err.code,errmsg:this.err.errmsg}}toString(){return`WriteConcernError(${this.err.errmsg})`}}class WriteError{constructor(e){this.err=e}get code(){return this.err.code}get index(){return this.err.index}get errmsg(){return this.err.errmsg}getOperation(){return this.err.op}toJSON(){return{code:this.err.code,index:this.err.index,errmsg:this.err.errmsg,op:this.err.op}}toString(){return`WriteError(${JSON.stringify(this.toJSON())})`}}function longOrConvert(e){return"number"==typeof e?Long.fromNumber(e):e}function mergeBatchResults(r,t,s,n){if(s)n=s;else if(n&&n.result)n=n.result;else if(null==n)return;if(0!==n.ok||1!==t.ok){if(0!==n.ok||0!==t.ok){if(n.opTime||n.lastOp){let e=n.lastOp||n.opTime;if("Timestamp"===e._bsontype&&(e={ts:e,t:Long.ZERO}),t.lastOp){s=longOrConvert(t.lastOp.ts);const u=longOrConvert(e.ts);if(u.greaterThan(s))t.lastOp=e;else if(u.equals(s)){s=longOrConvert(t.lastOp.t);const a=longOrConvert(e.t);a.greaterThan(s)&&(t.lastOp=e)}}else t.lastOp=e}r.batchType===INSERT&&n.n&&(t.nInserted=t.nInserted+n.n),r.batchType===REMOVE&&n.n&&(t.nRemoved=t.nRemoved+n.n);let e=0;if(Array.isArray(n.upserted)){e=n.upserted.length;for(let e=0;e<n.upserted.length;e++)t.upserted.push({index:n.upserted[e].index+r.originalZeroIndex,_id:n.upserted[e]._id})}else n.upserted&&(e=1,t.upserted.push({index:r.originalZeroIndex,_id:n.upserted}));if(r.batchType===UPDATE&&n.n&&(o=n.nModified,t.nUpserted=t.nUpserted+e,t.nMatched=t.nMatched+(n.n-e),t.nModified="number"==typeof o?t.nModified+o:null),Array.isArray(n.writeErrors))for(let e=0;e<n.writeErrors.length;e++){var i={index:r.originalIndexes[n.writeErrors[e].index],code:n.writeErrors[e].code,errmsg:n.writeErrors[e].errmsg,op:r.operations[n.writeErrors[e].index]};t.writeErrors.push(new WriteError(i))}n.writeConcernError&&t.writeConcernErrors.push(new WriteConcernError(n.writeConcernError))}}else{var o={index:t.ok=0,code:n.code||0,errmsg:n.message,op:r.operations[0]};t.writeErrors.push(new WriteError(o))}}function executeCommands(s,n,i){if(0===s.s.batches.length)return handleCallback(i,null,new BulkWriteResult(s.s.bulkResult));const o=s.s.batches.shift();s.finalOptionsHandler({options:n,batch:o,resultHandler:function(e,r){if((e&&e.driver||e&&e.message)&&!(e instanceof MongoWriteConcernError))return handleCallback(i,e);if(e&&(e.ok=0),e instanceof MongoWriteConcernError)return handleMongoWriteConcernError(o,s.s.bulkResult,e,i);var t=new BulkWriteResult(s.s.bulkResult);if(null!=mergeBatchResults(o,s.s.bulkResult,e,r))return handleCallback(i,null,t);s.handleWriteError(i,t)||executeCommands(s,n,i)}},i)}function handleMongoWriteConcernError(e,r,t,s){mergeBatchResults(e,r,null,t.result);t=new WriteConcernError({errmsg:t.result.writeConcernError.errmsg,code:t.result.writeConcernError.result});return handleCallback(s,new BulkWriteError(toError(t),new BulkWriteResult(r)),null)}class BulkWriteError extends MongoError{constructor(e,r){super(e.err||e.errmsg||e.errMessage||e),Object.assign(this,e),this.name="BulkWriteError",this.result=r}get insertedCount(){return this.result.insertedCount}get matchedCount(){return this.result.matchedCount}get modifiedCount(){return this.result.modifiedCount}get deletedCount(){return this.result.deletedCount}get upsertedCount(){return this.result.upsertedCount}get insertedIds(){return this.result.insertedIds}get upsertedIds(){return this.result.upsertedIds}}class FindOperators{constructor(e){this.s=e.s}update(e){var r="boolean"==typeof this.s.currentOp.upsert&&this.s.currentOp.upsert;const t={q:this.s.currentOp.selector,u:e,multi:!0,upsert:r};return e.hint&&(t.hint=e.hint),this.s.currentOp=null,this.s.options.addToOperationsList(this,UPDATE,t)}updateOne(e){var r="boolean"==typeof this.s.currentOp.upsert&&this.s.currentOp.upsert;const t={q:this.s.currentOp.selector,u:e,multi:!1,upsert:r};if(e.hint&&(t.hint=e.hint),!hasAtomicOperators(e))throw new TypeError("Update document requires atomic operators");return this.s.currentOp=null,this.s.options.addToOperationsList(this,UPDATE,t)}replaceOne(e){var r="boolean"==typeof this.s.currentOp.upsert&&this.s.currentOp.upsert;const t={q:this.s.currentOp.selector,u:e,multi:!1,upsert:r};if(e.hint&&(t.hint=e.hint),hasAtomicOperators(e))throw new TypeError("Replacement document must not use atomic operators");return this.s.currentOp=null,this.s.options.addToOperationsList(this,UPDATE,t)}upsert(){return this.s.currentOp.upsert=!0,this}deleteOne(){var e={q:this.s.currentOp.selector,limit:1};return this.s.currentOp=null,this.s.options.addToOperationsList(this,REMOVE,e)}delete(){var e={q:this.s.currentOp.selector,limit:0};return this.s.currentOp=null,this.s.options.addToOperationsList(this,REMOVE,e)}removeOne(){return emitWarningOnce("bulk operation `removeOne` has been deprecated, please use `deleteOne`"),this.deleteOne()}remove(){return emitWarningOnce("bulk operation `remove` has been deprecated, please use `delete`"),this.delete()}}class BulkOperationBase{constructor(e,r,t,s){this.isOrdered=s,t=null==t?{}:t;var n=r.s.namespace,i=e.bson,o=e.lastIsMaster(),u=!(!e.s.options||!e.s.options.autoEncrypter),a=o&&o.maxBsonObjectSize?o.maxBsonObjectSize:16777216,l=u?2097152:a,c=o&&o.maxWriteBatchSize?o.maxWriteBatchSize:1e3,d=(c-1).toString(10).length+2,s=Object.assign({},t),s=applyRetryableWrites(s,r.s.db),u=(s=applyWriteConcern(s,{collection:r},t)).writeConcern,o=t.promiseLibrary||Promise;this.s={bulkResult:{ok:1,writeErrors:[],writeConcernErrors:[],insertedIds:[],nInserted:0,nUpserted:0,nMatched:0,nModified:0,nRemoved:0,upserted:[]},currentBatch:null,currentIndex:0,currentBatchSize:0,currentBatchSizeBytes:0,currentInsertBatch:null,currentUpdateBatch:null,currentRemoveBatch:null,batches:[],writeConcern:u,maxBsonObjectSize:a,maxBatchSizeBytes:l,maxWriteBatchSize:c,maxKeySize:d,namespace:n,bson:i,topology:e,options:s,currentOp:null,executed:!1,collection:r,promiseLibrary:o,err:null,checkKeys:"boolean"!=typeof t.checkKeys||t.checkKeys},!0===t.bypassDocumentValidation&&(this.s.bypassDocumentValidation=!0)}insert(e){return!0!==this.s.collection.s.db.options.forceServerObjectId&&null==e._id&&(e._id=new ObjectID),this.s.options.addToOperationsList(this,INSERT,e)}find(e){if(!e)throw toError("Bulk find operation must specify a selector");return this.s.currentOp={selector:e},new FindOperators(this)}raw(r){var e=Object.keys(r)[0],t=("boolean"==typeof this.s.options.forceServerObjectId?this.s:this.s.collection.s.db).options.forceServerObjectId;if(r.updateOne&&r.updateOne.q||r.updateMany&&r.updateMany.q||r.replaceOne&&r.replaceOne.q)return r[e].multi=!r.updateOne&&!r.replaceOne,this.s.options.addToOperationsList(this,UPDATE,r[e]);if(r.updateOne||r.updateMany||r.replaceOne){if(r.replaceOne&&hasAtomicOperators(r[e].replacement))throw new TypeError("Replacement document must not use atomic operators");if((r.updateOne||r.updateMany)&&!hasAtomicOperators(r[e].update))throw new TypeError("Update document requires atomic operators");var s=!r.updateOne&&!r.replaceOne;const n={q:r[e].filter,u:r[e].update||r[e].replacement,multi:s};if(r[e].hint&&(n.hint=r[e].hint),this.isOrdered?(n.upsert=!!r[e].upsert,r.collation&&(n.collation=r.collation)):r[e].upsert&&(n.upsert=!0),r[e].arrayFilters){if(maxWireVersion(this.s.topology)<6)throw new TypeError("arrayFilters are only supported on MongoDB 3.6+");n.arrayFilters=r[e].arrayFilters}return this.s.options.addToOperationsList(this,UPDATE,n)}if(r.removeOne||r.removeMany||r.deleteOne&&r.deleteOne.q||r.deleteMany&&r.deleteMany.q)return r[e].limit=r.removeOne?1:0,this.s.options.addToOperationsList(this,REMOVE,r[e]);if(r.deleteOne||r.deleteMany){s=r.deleteOne?1:0;const i={q:r[e].filter,limit:s};return r[e].hint&&(i.hint=r[e].hint),this.isOrdered&&r.collation&&(i.collation=r.collation),this.s.options.addToOperationsList(this,REMOVE,i)}if(r.insertOne&&null==r.insertOne.document)return!0!==t&&null==r.insertOne._id&&(r.insertOne._id=new ObjectID),this.s.options.addToOperationsList(this,INSERT,r.insertOne);if(r.insertOne&&r.insertOne.document)return!0!==t&&null==r.insertOne.document._id&&(r.insertOne.document._id=new ObjectID),this.s.options.addToOperationsList(this,INSERT,r.insertOne.document);if(!r.insertMany)throw toError("bulkWrite only supports insertOne, insertMany, updateOne, updateMany, removeOne, removeMany, deleteOne, deleteMany");emitWarningOnce("bulk operation `insertMany` has been deprecated; use multiple `insertOne` ops instead");for(let e=0;e<r.insertMany.length;e++)!0!==t&&null==r.insertMany[e]._id&&(r.insertMany[e]._id=new ObjectID),this.s.options.addToOperationsList(this,INSERT,r.insertMany[e])}_handleEarlyError(e,r){if("function"!=typeof r)return this.s.promiseLibrary.reject(e);r(e,null)}bulkExecute(e,r,t){"function"==typeof r&&(t=r);r=Object.assign({},this.s.options,r);if("function"==typeof e?t=e:e&&"object"==typeof e&&(this.s.writeConcern=e),this.s.executed){e=toError("batch cannot be re-executed");return this._handleEarlyError(e,t)}if(this.isOrdered?this.s.currentBatch&&this.s.batches.push(this.s.currentBatch):(this.s.currentInsertBatch&&this.s.batches.push(this.s.currentInsertBatch),this.s.currentUpdateBatch&&this.s.batches.push(this.s.currentUpdateBatch),this.s.currentRemoveBatch&&this.s.batches.push(this.s.currentRemoveBatch)),0!==this.s.batches.length)return{options:r,callback:t};r=toError("Invalid Operation, no operations specified");return this._handleEarlyError(r,t)}execute(e,r,t){e=this.bulkExecute(e,r,t);return!e||isPromiseLike(e)?e:(r=e.options,t=e.callback,executeLegacyOperation(this.s.topology,executeCommands,[this,r,t]))}finalOptionsHandler(r,t){const e=Object.assign({ordered:this.isOrdered},r.options);null!=this.s.writeConcern&&(e.writeConcern=this.s.writeConcern),!0!==e.bypassDocumentValidation&&delete e.bypassDocumentValidation,this.operationId&&(r.resultHandler.operationId=this.operationId),this.s.options.serializeFunctions&&(e.serializeFunctions=!0),this.s.options.ignoreUndefined&&(e.ignoreUndefined=!0),!0===this.s.bypassDocumentValidation&&(e.bypassDocumentValidation=!0),!1===this.s.checkKeys&&(e.checkKeys=!1),e.retryWrites&&(r.batch.batchType===UPDATE&&(e.retryWrites=e.retryWrites&&!r.batch.operations.some(e=>e.multi)),r.batch.batchType===REMOVE&&(e.retryWrites=e.retryWrites&&!r.batch.operations.some(e=>0===e.limit)));try{r.batch.batchType===INSERT?this.s.topology.insert(this.s.namespace,r.batch.operations,e,r.resultHandler):r.batch.batchType===UPDATE?this.s.topology.update(this.s.namespace,r.batch.operations,e,r.resultHandler):r.batch.batchType===REMOVE&&this.s.topology.remove(this.s.namespace,r.batch.operations,e,r.resultHandler)}catch(e){e.ok=0,handleCallback(t,null,mergeBatchResults(r.batch,this.s.bulkResult,e,null))}}handleWriteError(e,r){if(0<this.s.bulkResult.writeErrors.length){var t=this.s.bulkResult.writeErrors[0].errmsg||"write operation failed";return handleCallback(e,new BulkWriteError(toError({message:t,code:this.s.bulkResult.writeErrors[0].code,writeErrors:this.s.bulkResult.writeErrors}),r),null),!0}if(r.getWriteConcernError())return handleCallback(e,new BulkWriteError(toError(r.getWriteConcernError()),r),null),!0}}Object.defineProperty(BulkOperationBase.prototype,"length",{enumerable:!0,get:function(){return this.s.currentIndex}}),module.exports={Batch:Batch,BulkOperationBase:BulkOperationBase,mergeBatchResults:mergeBatchResults,bson:bson,INSERT:INSERT,UPDATE:UPDATE,REMOVE:REMOVE,BulkWriteError:BulkWriteError,BulkWriteResult:BulkWriteResult};