"use strict";var Long=require("../long").Long,Double=require("../double").Double,Timestamp=require("../timestamp").Timestamp,ObjectID=require("../objectid").ObjectID,Symbol=require("../symbol").Symbol,Code=require("../code").Code,MinKey=require("../min_key").MinKey,MaxKey=require("../max_key").MaxKey,Decimal128=require("../decimal128"),Int32=require("../int_32"),DBRef=require("../db_ref").DBRef,BSONRegExp=require("../regexp").BSONRegExp,Binary=require("../binary").Binary,utils=require("./utils"),deserialize=function(e,r,n){var t=(r=null==r?{}:r)&&r.index?r.index:0,i=e[t]|e[t+1]<<8|e[t+2]<<16|e[t+3]<<24;if(i<5||e.length<i||i+t>e.length)throw new Error("corrupt bson message");if(0!==e[t+i-1])throw new Error("One object, sized correctly, with a spot for an EOO, but the EOO isn't 0x00");return deserializeObject(e,t,r,n)},deserializeObject=function(e,r,n,t){var i,o=null!=n.evalFunctions&&n.evalFunctions,l=null!=n.cacheFunctions&&n.cacheFunctions,a=null!=n.cacheFunctionsCrc32&&n.cacheFunctionsCrc32;a||(i=null);var N=null==n.fieldsAsRaw?null:n.fieldsAsRaw,B=null!=n.raw&&n.raw,S="boolean"==typeof n.bsonRegExp&&n.bsonRegExp,O=null!=n.promoteBuffers&&n.promoteBuffers,_=null==n.promoteLongs||n.promoteLongs,s=null==n.promoteValues||n.promoteValues,u=r;if(e.length<5)throw new Error("corrupt bson message < 5 bytes long");var A=e[r++]|e[r++]<<8|e[r++]<<16|e[r++]<<24;if(A<5||A>e.length)throw new Error("corrupt bson message");for(var f=t?[]:{},c=0;;){var h=e[r++];if(0===h)break;for(var w=r;0!==e[w]&&w<e.length;)w++;if(w>=e.length)throw new Error("Bad BSON Document: illegal CString");var E=t?c++:e.toString("utf8",r,w);if(r=w+1,h===BSON.BSON_DATA_STRING){var g=e[r++]|e[r++]<<8|e[r++]<<16|e[r++]<<24;if(g<=0||g>e.length-r||0!==e[r+g-1])throw new Error("bad string length in bson");f[E]=e.toString("utf8",r,r+g-1),r+=g}else if(h===BSON.BSON_DATA_OID){var D=utils.allocBuffer(12);e.copy(D,0,r,r+12),f[E]=new ObjectID(D),r+=12}else if(h===BSON.BSON_DATA_INT&&!1===s)f[E]=new Int32(e[r++]|e[r++]<<8|e[r++]<<16|e[r++]<<24);else if(h===BSON.BSON_DATA_INT)f[E]=e[r++]|e[r++]<<8|e[r++]<<16|e[r++]<<24;else if(h===BSON.BSON_DATA_NUMBER&&!1===s)f[E]=new Double(e.readDoubleLE(r)),r+=8;else if(h===BSON.BSON_DATA_NUMBER)f[E]=e.readDoubleLE(r),r+=8;else if(h===BSON.BSON_DATA_DATE){var T=e[r++]|e[r++]<<8|e[r++]<<16|e[r++]<<24,b=e[r++]|e[r++]<<8|e[r++]<<16|e[r++]<<24;f[E]=new Date(new Long(T,b).toNumber())}else if(h===BSON.BSON_DATA_BOOLEAN){if(0!==e[r]&&1!==e[r])throw new Error("illegal boolean type value");f[E]=1===e[r++]}else if(h===BSON.BSON_DATA_OBJECT){var y=r,d=e[r]|e[r+1]<<8|e[r+2]<<16|e[r+3]<<24;if(d<=0||d>e.length-r)throw new Error("bad embedded document length in bson");f[E]=B?e.slice(r,r+d):deserializeObject(e,y,n,!1),r+=d}else if(h===BSON.BSON_DATA_ARRAY){var y=r,p=n,m=r+(d=e[r]|e[r+1]<<8|e[r+2]<<16|e[r+3]<<24);if(N&&N[E]){for(var I in p={},n)p[I]=n[I];p.raw=!0}if(f[E]=deserializeObject(e,y,p,!0),0!==e[(r+=d)-1])throw new Error("invalid array terminator byte");if(r!==m)throw new Error("corrupted array bson")}else if(h===BSON.BSON_DATA_UNDEFINED)f[E]=void 0;else if(h===BSON.BSON_DATA_NULL)f[E]=null;else if(h===BSON.BSON_DATA_LONG){T=e[r++]|e[r++]<<8|e[r++]<<16|e[r++]<<24,b=e[r++]|e[r++]<<8|e[r++]<<16|e[r++]<<24,m=new Long(T,b);f[E]=_&&!0===s&&m.lessThanOrEqual(JS_INT_MAX_LONG)&&m.greaterThanOrEqual(JS_INT_MIN_LONG)?m.toNumber():m}else if(h===BSON.BSON_DATA_DECIMAL128){var v=utils.allocBuffer(16);e.copy(v,0,r,r+16),r+=16;v=new Decimal128(v);f[E]=v.toObject?v.toObject():v}else if(h===BSON.BSON_DATA_BINARY){var R=e[r++]|e[r++]<<8|e[r++]<<16|e[r++]<<24,v=R,M=e[r++];if(R<0)throw new Error("Negative binary type element size found");if(R>e.length)throw new Error("Binary type size larger than document size");if(null!=e.slice){if(M===Binary.SUBTYPE_BYTE_ARRAY){if((R=e[r++]|e[r++]<<8|e[r++]<<16|e[r++]<<24)<0)throw new Error("Negative binary type element size found for subtype 0x02");if(v-4<R)throw new Error("Binary type with subtype 0x02 contains to long binary size");if(R<v-4)throw new Error("Binary type with subtype 0x02 contains to short binary size")}f[E]=O&&s?e.slice(r,r+R):new Binary(e.slice(r,r+R),M)}else{var C="undefined"!=typeof Uint8Array?new Uint8Array(new ArrayBuffer(R)):new Array(R);if(M===Binary.SUBTYPE_BYTE_ARRAY){if((R=e[r++]|e[r++]<<8|e[r++]<<16|e[r++]<<24)<0)throw new Error("Negative binary type element size found for subtype 0x02");if(v-4<R)throw new Error("Binary type with subtype 0x02 contains to long binary size");if(R<v-4)throw new Error("Binary type with subtype 0x02 contains to short binary size")}for(w=0;w<R;w++)C[w]=e[r+w];f[E]=O&&s?C:new Binary(C,M)}r+=R}else if(h===BSON.BSON_DATA_REGEXP&&!1===S){for(w=r;0!==e[w]&&w<e.length;)w++;if(w>=e.length)throw new Error("Bad BSON Document: illegal CString");var Y=e.toString("utf8",r,w);for(w=r=w+1;0!==e[w]&&w<e.length;)w++;if(w>=e.length)throw new Error("Bad BSON Document: illegal CString");var L=e.toString("utf8",r,w);r=w+1;for(var x=new Array(L.length),w=0;w<L.length;w++)switch(L[w]){case"m":x[w]="m";break;case"s":x[w]="g";break;case"i":x[w]="i"}f[E]=new RegExp(Y,x.join(""))}else if(h===BSON.BSON_DATA_REGEXP&&!0===S){for(w=r;0!==e[w]&&w<e.length;)w++;if(w>=e.length)throw new Error("Bad BSON Document: illegal CString");for(Y=e.toString("utf8",r,w),w=r=w+1;0!==e[w]&&w<e.length;)w++;if(w>=e.length)throw new Error("Bad BSON Document: illegal CString");L=e.toString("utf8",r,w),r=w+1,f[E]=new BSONRegExp(Y,L)}else if(h===BSON.BSON_DATA_SYMBOL){if((g=e[r++]|e[r++]<<8|e[r++]<<16|e[r++]<<24)<=0||g>e.length-r||0!==e[r+g-1])throw new Error("bad string length in bson");f[E]=new Symbol(e.toString("utf8",r,r+g-1)),r+=g}else if(h===BSON.BSON_DATA_TIMESTAMP)T=e[r++]|e[r++]<<8|e[r++]<<16|e[r++]<<24,b=e[r++]|e[r++]<<8|e[r++]<<16|e[r++]<<24,f[E]=new Timestamp(T,b);else if(h===BSON.BSON_DATA_MIN_KEY)f[E]=new MinKey;else if(h===BSON.BSON_DATA_MAX_KEY)f[E]=new MaxKey;else if(h===BSON.BSON_DATA_CODE){if((g=e[r++]|e[r++]<<8|e[r++]<<16|e[r++]<<24)<=0||g>e.length-r||0!==e[r+g-1])throw new Error("bad string length in bson");var U,z=e.toString("utf8",r,r+g-1);o?l?(U=a?i(z):z,f[E]=isolateEvalWithHash(functionCache,U,z,f)):f[E]=isolateEval(z):f[E]=new Code(z),r+=g}else if(h===BSON.BSON_DATA_CODE_W_SCOPE){M=e[r++]|e[r++]<<8|e[r++]<<16|e[r++]<<24;if(M<13)throw new Error("code_w_scope total size shorter minimum expected length");if((g=e[r++]|e[r++]<<8|e[r++]<<16|e[r++]<<24)<=0||g>e.length-r||0!==e[r+g-1])throw new Error("bad string length in bson");z=e.toString("utf8",r,r+g-1),d=e[y=r+=g]|e[r+1]<<8|e[r+2]<<16|e[r+3]<<24;var j=deserializeObject(e,y,n,!1);if(r+=d,M<8+d+g)throw new Error("code_w_scope total size is to short, truncating scope");if(8+d+g<M)throw new Error("code_w_scope total size is to long, clips outer document");o?(l?(U=a?i(z):z,f[E]=isolateEvalWithHash(functionCache,U,z,f)):f[E]=isolateEval(z),f[E].scope=j):f[E]=new Code(z,j)}else{if(h!==BSON.BSON_DATA_DBPOINTER)throw new Error("Detected unknown BSON type "+h.toString(16)+' for fieldname "'+E+'", are you using the latest BSON parser');if((g=e[r++]|e[r++]<<8|e[r++]<<16|e[r++]<<24)<=0||g>e.length-r||0!==e[r+g-1])throw new Error("bad string length in bson");j=e.toString("utf8",r,r+g-1);r+=g;h=utils.allocBuffer(12);e.copy(h,0,r,r+12),D=new ObjectID(h),r+=12;h=j.split("."),j=h.shift(),h=h.join(".");f[E]=new DBRef(h,D,j)}}if(A==r-u)return f=null!=f.$id?new DBRef(f.$ref,f.$id,f.$db):f;if(t)throw new Error("corrupt array bson");throw new Error("corrupt object bson")},isolateEvalWithHash=function(functionCache,hash,functionString,object){var value=null;return null==functionCache[hash]&&(eval("value = "+functionString),functionCache[hash]=value),functionCache[hash].bind(object)},isolateEval=function(functionString){var value=null;return eval("value = "+functionString),value},BSON={},functionCache=BSON.functionCache={};BSON.BSON_DATA_NUMBER=1,BSON.BSON_DATA_STRING=2,BSON.BSON_DATA_OBJECT=3,BSON.BSON_DATA_ARRAY=4,BSON.BSON_DATA_BINARY=5,BSON.BSON_DATA_UNDEFINED=6,BSON.BSON_DATA_OID=7,BSON.BSON_DATA_BOOLEAN=8,BSON.BSON_DATA_DATE=9,BSON.BSON_DATA_NULL=10,BSON.BSON_DATA_REGEXP=11,BSON.BSON_DATA_DBPOINTER=12,BSON.BSON_DATA_CODE=13,BSON.BSON_DATA_SYMBOL=14,BSON.BSON_DATA_CODE_W_SCOPE=15,BSON.BSON_DATA_INT=16,BSON.BSON_DATA_TIMESTAMP=17,BSON.BSON_DATA_LONG=18,BSON.BSON_DATA_DECIMAL128=19,BSON.BSON_DATA_MIN_KEY=255,BSON.BSON_DATA_MAX_KEY=127,BSON.BSON_BINARY_SUBTYPE_DEFAULT=0,BSON.BSON_BINARY_SUBTYPE_FUNCTION=1,BSON.BSON_BINARY_SUBTYPE_BYTE_ARRAY=2,BSON.BSON_BINARY_SUBTYPE_UUID=3,BSON.BSON_BINARY_SUBTYPE_MD5=4,BSON.BSON_BINARY_SUBTYPE_USER_DEFINED=128,BSON.BSON_INT32_MAX=2147483647,BSON.BSON_INT32_MIN=-2147483648,BSON.BSON_INT64_MAX=Math.pow(2,63)-1,BSON.BSON_INT64_MIN=-Math.pow(2,63),BSON.JS_INT_MAX=9007199254740992,BSON.JS_INT_MIN=-9007199254740992;var JS_INT_MAX_LONG=Long.fromNumber(9007199254740992),JS_INT_MIN_LONG=Long.fromNumber(-9007199254740992);module.exports=deserialize;