Install with:
`npm install @cambium/cns-mongo`

## Description

This module has the logic to create new and reuse mongo connectio. Once the module is initialized with approriate config, CONST, logger object we can proceed to call getModel, getPlainModel to fetch collection model and perform operations.index related logic is currently disabled to avoid redis lock related dependency

## Usage Example

```javascript
const mongo = require('@cambium/cns-mongo');

mongo.initialize({ config, logger, CONST }, (err, status) => {
  let params = {
    cid: 'cnmaestro',
    mcid: '',
    dbName: 'stats',
    modelCacheKey: 'inventory',
    modelName: 'inventory',
    schemaCacheKey: 'inventory'
  };

  mongo.getModel(params, (err, model) => {
    if (err) {
      console.log(err);
    } else {
      model.updateMany(
        { a: 1 },
        { $set: { b: 10, ts: new Date() } },
        { upsert: true },
        (err, status) => {
          console.log(err, status);
        }
      );
    }
  });
});
```

## Overall Directory Structure

```
 src
  |
  |- index.js
  |- core
  |  |- cnsModel.js
  |  |- dbConn.js
  |  |- mongoDb.js

```
