"use strict";var compileSchema=require("./compile"),resolve=require("./compile/resolve"),Cache=require("./cache"),SchemaObject=require("./compile/schema_obj"),stableStringify=require("fast-json-stable-stringify"),formats=require("./compile/formats"),rules=require("./compile/rules"),$dataMetaSchema=require("./data"),util=require("./compile/util");(module.exports=Ajv).prototype.validate=validate,Ajv.prototype.compile=compile,Ajv.prototype.addSchema=addSchema,Ajv.prototype.addMetaSchema=addMetaSchema,Ajv.prototype.validateSchema=validateSchema,Ajv.prototype.getSchema=getSchema,Ajv.prototype.removeSchema=removeSchema,Ajv.prototype.addFormat=addFormat,Ajv.prototype.errorsText=errorsText,Ajv.prototype._addSchema=_addSchema,Ajv.prototype._compile=_compile,Ajv.prototype.compileAsync=require("./compile/async");var customKeyword=require("./keyword");Ajv.prototype.addKeyword=customKeyword.add,Ajv.prototype.getKeyword=customKeyword.get,Ajv.prototype.removeKeyword=customKeyword.remove,Ajv.prototype.validateKeyword=customKeyword.validate;var errorClasses=require("./compile/error_classes");Ajv.ValidationError=errorClasses.Validation,Ajv.MissingRefError=errorClasses.MissingRef,Ajv.$dataMetaSchema=$dataMetaSchema;var META_SCHEMA_ID="http://json-schema.org/draft-07/schema",META_IGNORE_OPTIONS=["removeAdditional","useDefaults","coerceTypes","strictDefaults"],META_SUPPORT_DATA=["/properties"];function Ajv(e){if(!(this instanceof Ajv))return new Ajv(e);e=this._opts=util.copy(e)||{},setLogger(this),this._schemas={},this._refs={},this._fragments={},this._formats=formats(e.format),this._cache=e.cache||new Cache,this._loadingSchemas={},this._compilations=[],this.RULES=rules(),this._getId=chooseGetId(e),e.loopRequired=e.loopRequired||1/0,"property"==e.errorDataPath&&(e._errorDataPathProperty=!0),void 0===e.serialize&&(e.serialize=stableStringify),this._metaOpts=getMetaSchemaOptions(this),e.formats&&addInitialFormats(this),e.keywords&&addInitialKeywords(this),addDefaultMetaSchema(this),"object"==typeof e.meta&&this.addMetaSchema(e.meta),e.nullable&&this.addKeyword("nullable",{metaSchema:{type:"boolean"}}),addInitialSchemas(this)}function validate(e,t){if("string"==typeof e){if(!(r=this.getSchema(e)))throw new Error('no schema with key or ref "'+e+'"')}else var e=this._addSchema(e),r=e.validate||this._compile(e);t=r(t);return!0!==r.$async&&(this.errors=r.errors),t}function compile(e,t){t=this._addSchema(e,void 0,t);return t.validate||this._compile(t)}function addSchema(e,t,r,a){if(Array.isArray(e)){for(var o=0;o<e.length;o++)this.addSchema(e[o],void 0,r,a);return this}var s=this._getId(e);if(void 0!==s&&"string"!=typeof s)throw new Error("schema id must be string");return checkUnique(this,t=resolve.normalizeId(t||s)),this._schemas[t]=this._addSchema(e,r,a,!0),this}function addMetaSchema(e,t,r){return this.addSchema(e,t,r,!0),this}function validateSchema(e,t){var r=e.$schema;if(void 0!==r&&"string"!=typeof r)throw new Error("$schema must be a string");if(!(r=r||this._opts.defaultMeta||defaultMeta(this)))return this.logger.warn("meta-schema not available"),!(this.errors=null);e=this.validate(r,e);if(!e&&t){t="schema is invalid: "+this.errorsText();if("log"!=this._opts.validateSchema)throw new Error(t);this.logger.error(t)}return e}function defaultMeta(e){var t=e._opts.meta;return e._opts.defaultMeta="object"==typeof t?e._getId(t)||t:e.getSchema(META_SCHEMA_ID)?META_SCHEMA_ID:void 0,e._opts.defaultMeta}function getSchema(e){var t=_getSchemaObj(this,e);switch(typeof t){case"object":return t.validate||this._compile(t);case"string":return this.getSchema(t);case"undefined":return _getSchemaFragment(this,e)}}function _getSchemaFragment(e,t){var r=resolve.schema.call(e,{schema:{}},t);if(r){var a=r.schema,o=r.root,s=r.baseId,r=compileSchema.call(e,a,o,void 0,s);return e._fragments[t]=new SchemaObject({ref:t,fragment:!0,schema:a,root:o,baseId:s,validate:r}),r}}function _getSchemaObj(e,t){return t=resolve.normalizeId(t),e._schemas[t]||e._refs[t]||e._fragments[t]}function removeSchema(e){if(e instanceof RegExp)return _removeAllSchemas(this,this._schemas,e),_removeAllSchemas(this,this._refs,e),this;switch(typeof e){case"undefined":return _removeAllSchemas(this,this._schemas),_removeAllSchemas(this,this._refs),this._cache.clear(),this;case"string":var t=_getSchemaObj(this,e);return t&&this._cache.del(t.cacheKey),delete this._schemas[e],delete this._refs[e],this;case"object":t=this._opts.serialize,t=t?t(e):e;this._cache.del(t);t=this._getId(e);t&&(t=resolve.normalizeId(t),delete this._schemas[t],delete this._refs[t])}return this}function _removeAllSchemas(e,t,r){for(var a in t){var o=t[a];o.meta||r&&!r.test(a)||(e._cache.del(o.cacheKey),delete t[a])}}function _addSchema(e,t,r,a){if("object"!=typeof e&&"boolean"!=typeof e)throw new Error("schema should be object or boolean");var o=this._opts.serialize,s=o?o(e):e,i=this._cache.get(s);if(i)return i;a=a||!1!==this._opts.addUsedSchema;o=resolve.normalizeId(this._getId(e));o&&a&&checkUnique(this,o);var c,i=!1!==this._opts.validateSchema&&!t;i&&!(c=o&&o==resolve.normalizeId(e.$schema))&&this.validateSchema(e,!0);t=resolve.ids.call(this,e),r=new SchemaObject({id:o,schema:e,localRefs:t,cacheKey:s,meta:r});return"#"!=o[0]&&a&&(this._refs[o]=r),this._cache.put(s,r),i&&c&&this.validateSchema(e,!0),r}function _compile(r,e){if(r.compiling)return(r.validate=o).schema=r.schema,o.errors=null,o.root=e||o,!0===r.schema.$async&&(o.$async=!0),o;var t,a;r.compiling=!0,r.meta&&(t=this._opts,this._opts=this._metaOpts);try{a=compileSchema.call(this,r.schema,e,r.localRefs)}catch(e){throw delete r.validate,e}finally{r.compiling=!1,r.meta&&(this._opts=t)}return r.validate=a,r.refs=a.refs,r.refVal=a.refVal,r.root=a.root,a;function o(){var e=r.validate,t=e.apply(this,arguments);return o.errors=e.errors,t}}function chooseGetId(e){switch(e.schemaId){case"auto":return _get$IdOrId;case"id":return _getId;default:return _get$Id}}function _getId(e){return e.$id&&this.logger.warn("schema $id ignored",e.$id),e.id}function _get$Id(e){return e.id&&this.logger.warn("schema id ignored",e.id),e.$id}function _get$IdOrId(e){if(e.$id&&e.id&&e.$id!=e.id)throw new Error("schema $id is different from id");return e.$id||e.id}function errorsText(e,t){if(!(e=e||this.errors))return"No errors";for(var r=void 0===(t=t||{}).separator?", ":t.separator,a=void 0===t.dataVar?"data":t.dataVar,o="",s=0;s<e.length;s++){var i=e[s];i&&(o+=a+i.dataPath+" "+i.message+r)}return o.slice(0,-r.length)}function addFormat(e,t){return"string"==typeof t&&(t=new RegExp(t)),this._formats[e]=t,this}function addDefaultMetaSchema(e){var t;e._opts.$data&&(t=require("./refs/data.json"),e.addMetaSchema(t,t.$id,!0)),!1!==e._opts.meta&&(t=require("./refs/json-schema-draft-07.json"),e._opts.$data&&(t=$dataMetaSchema(t,META_SUPPORT_DATA)),e.addMetaSchema(t,META_SCHEMA_ID,!0),e._refs["http://json-schema.org/schema"]=META_SCHEMA_ID)}function addInitialSchemas(e){var t=e._opts.schemas;if(t)if(Array.isArray(t))e.addSchema(t);else for(var r in t)e.addSchema(t[r],r)}function addInitialFormats(e){for(var t in e._opts.formats){var r=e._opts.formats[t];e.addFormat(t,r)}}function addInitialKeywords(e){for(var t in e._opts.keywords){var r=e._opts.keywords[t];e.addKeyword(t,r)}}function checkUnique(e,t){if(e._schemas[t]||e._refs[t])throw new Error('schema with key or id "'+t+'" already exists')}function getMetaSchemaOptions(e){for(var t=util.copy(e._opts),r=0;r<META_IGNORE_OPTIONS.length;r++)delete t[META_IGNORE_OPTIONS[r]];return t}function setLogger(e){var t=e._opts.logger;if(!1===t)e.logger={log:noop,warn:noop,error:noop};else{if(!("object"==typeof(t=void 0===t?console:t)&&t.log&&t.warn&&t.error))throw new Error("logger must implement log, warn and error methods");e.logger=t}}function noop(){}