Install with:
`npm install @cambium/cns-logger`

## Usage

Please make sure `process.name` , `process.title` is defined on top of the file before calling logger.getLogger() method

##### Logger

```js
logger = require('@cambium/cns-logger');

// Initialize logger with config object
logger.initialize(config);

/* src/common/test.js */
logger.getLogger('common/test');

logger.critical('All CRITICAL level logs');
logger.data('All DATA level logs');
logger.debug('All DEBUG level logs');
logger.error('All ERROR level logs');
logger.info('All INFO level logs');
logger.warn('All WARN level logs');

//to call process.exit(1) just invoke end method
logger.end();
```

**logger config sample object**

```json
{
  "level": "info",
  "fileInitial": "cns_",
  "override": {
    "action": "debug",
    "aurora": "",
    "configuration": "",
    "device": "",
    "ext-hooks": "",
    "monitoring": "",
    "notification": "",
    "registration": "",
    "reporting": "",
    "scheduler": "",
    "security": "",
    "subscription": "",
    "upgrade": ""
  },
  "filepath": "",
  "fileNames": {
    "error": "error.log",
    "info": "info.log",
    "debug": "debug.log",
    "exception": "exception.log"
  },
  "levels": {
    "critical": 0,
    "error": 1,
    "warn": 2,
    "info": 3,
    "data": 4,
    "debug": 5
  },
  "colors": {
    "debug": "cyan",
    "data": "green",
    "info": "white",
    "warn": "yellow",
    "error": "red",
    "critical": "magenta",
    "stats": "gray",
    "security": "red",
    "watch": "green",
    "beta": "red",
    "access": "green"
  }
}
```

> fileNames, levels, colors, filepath, fileInitial parameters are static and runtime changes will not be effective

> Override parameter can be used to override specific process's logging level

##### Syslog

```js
// For syslog
const { syslog } = require('@cambium/cns-logger');

syslog.createLogger('unique-id', {
  host: 'localhost',
  port: 514,
  localhost: 'cnmaestro' //default
  app_name: 'cnmaestro'  //default
  facility: 'local7'
});

syslog.sendLog('unique-id', 'message log', 'warn');

syslog.removeLogger('unique-id');
```

Facility types can be found [here](https://github.com/squeeks/glossy/blob/master/lib/glossy/produce.js).
