"use strict";const utils=require("util"),_=require("lodash"),{DeviceHttpClient:DeviceHttpClient}=require("../common/request"),CONST=require("../common/constants"),db=require("../common/mongo"),commonUtils=require("../common/utils"),logger=require("../common/logger").getLogger("cns-cbrs-tool.stateEngine"),RedisCache=require("../common/redis/commonCache"),stateUtils=require("./stateUtils"),message=require("./message"),defaultVal={comment:null,respErrCode:null,respErrData:null,opParams:{sdgFlag:!1,sdgMsg:null,eirpFlag:!1,eirpOp:null,chFlag:!1,chOp:null}};let config,commonCache;function initialize(e){config=e,commonCache=new RedisCache({db:"common",redis:config.redis}),e&&config.onChange((e,t)=>{config=t})}class DeviceStateManager{constructor(e,t,r={}){var{skipFccIdCheck:r}=r;this.respString=null,this.sasInfo=t,this.cid=e.cid,this.mcid=e.mcid||CONST.MSP_ACC.SUPER_ADMIN_MCID,this.isRetryRequired=0,this.lastRegTs=0,this.bandValues=_.range(3550,3700),this.isMultiGrant=!0,this.spectrumEnqStats={status:null,enqstats:null,comment:null,time:null},this.device=e,this.sasClient=new DeviceHttpClient(this.device,this.sasInfo),this.msgRetryCnt={};let s;s=commonUtils.fetchFccId(e),r||(s?(_.set(e,["ext","cbrs","fccID"],s),_.set(e,["ext","cbrs","respErrData"],"")):(logger.error("FCC Id can not be determined for provide device ",e.mode,e.eType,e.mac,e.model,e.opMode),_.set(e,["cbrs","state"],CONST.CBRS_STATES.HALT),_.set(e,["ext","cbrs","respErrData"],"FCCID not found"))),_.set(e,"ext.cbrs",Object.assign({},defaultVal,e.ext&&e.ext.cbrs||{}))}setProperty(e,t){_.set(this.device,e,t)}setState(e){_.set(this.device,["cbrs","state"],e)}getVal(e){return _.get(this.device,e)}isInSync(){return this.device.cbrs.sync!==CONST.CBRS_SYNC_STATUS.NOT_SYNCED}setDeviceProperty(e){this.device=e}async resetStateInRedis(){try{var t=this.device.ecgi||this.device.pmac||this.device.mac,t=commonUtils.getHeartBeatRediskey(t);const s=utils.promisify(commonCache.getAll.bind(commonCache));let r=await s(t);const a=utils.promisify(commonCache.expire.bind(commonCache));if(await a(t,CONST.HEARTBEAT_REDIS_EXPIRE_TIME_IN_SEC),!r)return{status:!1};if(r=_.mapValues(r,JSON.parse),[CONST.MODE_AP,CONST.MODE_RRH].includes(this.device.mode)){let{ext:e,cbrs:t}=this.device;t.state=CONST.CBRS_STATES.UNREG,e.cbrs.grantIds={},t.grant_states={},delete e.cbrs.cbsdIDTime,delete e.cbrs.cbsdID,delete e.cbrs.hbTs,delete e.cbrs.txExp,delete e.cbrs.grantID,delete e.cbrs.grantExp,r.ap.state=CONST.CBRS_STATES.UNREG,delete r.ap.grantIds,delete r.ap.grantStates,delete r.ap.cbsdid}else r[this.device.mac]&&(r[this.device.mac]={});let e=utils.promisify(commonCache.set.bind(commonCache));return r=_.mapValues(r,JSON.stringify),await e(t,r),await a(t,CONST.HEARTBEAT_REDIS_EXPIRE_TIME_IN_SEC),{error:null,status:!0}}catch(e){return{error:e}}}async updateStateIfReinit(){let{cbrs:e,ext:t}=this.device;var r=_.get(t,["cbrs","lstUpd"],0);return this.isReInit=t.cbrs.reInitTs>r,this.isReInit&&(this.device.mode===CONST.MODE_RRH||this.device.extDev||(t.cbrs.fccID&&(e.state=CONST.CBRS_STATES.UNREG,_.set(t,["cbrs","comment"],""),this.msgRetryCnt={}),await this.resetStateInRedis(),_.set(t,["cbrs","lstUpd"],Date.now()),_.set(t,["cbrs","hbTs"],null),_.set(t,["cbrs","opParams","sdgFlag"],!1))),!0}async checkState(){let e,{cbrs:t,ext:r}=this.device;var s=t.state;let a=!1;await this.updateStateIfReinit();try{return(this.device.mode===CONST.MODE_RRH&&this.device.extDev?(r.cbrs.comment="NO MSG to SEND|NON-CAMBIUM DEVICE",a=!0):0===t.sync?e=await this.execStateEngine():r.cbrs.comment="NO MSG TO SEND",e&&e.error&&"string"==typeof e.error&&e.error.includes(CONST.CUSTOM_ABORT_MSG.DE_REG_ALL))?(logger.error("De-register all received for job",this.device.mac),{error:CONST.CUSTOM_ABORT_MSG.DE_REG_ALL}):(a||await this.updateStatusInDb(),{currentState:s,newState:t.state,...e})}catch(e){return{error:e}}}async checkChannelStatus(e,t){var r={[CONST.CBRS_STATES.REG_FAIL]:1,[CONST.CBRS_STATES.REGD]:1,[CONST.CBRS_STATES.GRANT_WAIT]:1};return!e.state||r[e.state]?await this.sendGrantReqForChannel(e,t):[CONST.CBRS_STATES.GRNT,CONST.CBRS_STATES.GRNT_SUSP].includes(e.state)?await this.sendCbrsHeartBeatMessage(e,t):[CONST.CBRS_STATES.AUTHRZD].includes(e.state)?{status:!0}:[CONST.CBRS_STATES.RELG].includes(e.state)?await this.sendChannelReqliquish(e,CONST.MAX_ALLOWED_REQ_RETRY):[CONST.CBRS_STATES.HALT,CONST.CBRS_STATES.HBT_FAIL].includes(e.state)?{status:!1}:{error:`unknown state for channel ${JSON.stringify(e)} `}}async updateStatusInDb(){let e={cid:this.cid,mcid:this.mcid},t={mac:this.device.mac,"cbrs.sync":0},r={$set:{"cbrs.state":this.device.cbrs.state}};_.isEmpty(this.device.cbrs.grant_states)||(r.$set["cbrs.grant_states"]=this.device.cbrs.grant_states);let s,a=await db.updateDocInInventory(e,t,r);var i,n;0===a.matchedCount?_.set(this.device,["cbrs","sync"],1):(i={mac:this.device.mac},n={$set:{cbrs:this.device.ext.cbrs}},s=await db.updateDocInExt(e,i,n,{updateOne:!0}))}async execStateEngine(){try{let{ext:r,cbrs:s}=this.device;if([CONST.CBRS_STATES.REG_FAIL,CONST.CBRS_STATES.HALT].includes(s.state)||(_.set(r,["cbrs","comment"],""),_.set(r,["cbrs","respErrCode"],""),_.set(r,["cbrs","respErrData"],"")),r.cbrs.cbsdID||(s.state=CONST.CBRS_STATES.UNREG),[CONST.CBRS_STATES.UNREG,CONST.CBRS_STATES.REG_FAIL].includes(s.state)||!r.cbrs.cbsdID)return await this.sendRegistartionMsg();if([CONST.CBRS_STATES.REGD].includes(s.state)){if(_.isEmpty(r.cbrs.grantIds))return await this.sendCbrsGrantMessageForAll();var a=Object.entries(r.cbrs.grantIds);s.grant_states||(s.grant_states={});var i=r.cbrs.config.radio.chWidth;for(let t=0;t<a.length;t++){var[n,c]=a[t],{grantID:o,freqRange:d}=c,d=this.getGrantFreqHash(d[0],d[1]);let e=o;if(o||(delete r.cbrs.grantIds[n],delete s.grant_states[n],r.cbrs.grantIds[d]=c,e=d,s.grant_states[d]=c.state),_.set(c,["radio","chWidth"],i),(await this.checkChannelStatus(c,e)).error===CONST.CUSTOM_ABORT_MSG.DE_REG_ALL)return{error:CONST.CUSTOM_ABORT_MSG.DE_REG_ALL}}return{error:null,status:!0,device:this.device}}return[CONST.CBRS_STATES.DEREG].includes(s.state)?this.sendDeRegMsg():(logger.error("Invalid state for device ",this.device.mac),_.set(r,["cbrs","comment"],"INVALID"),_.set(r,["cbrs","lstUpd"],Date.now()),{device:this.device,remove:!0})}catch(e){return{error:e}}}async sendRegistartionMsg(){if(this.lastRegTs&&Date.now()-this.lastRegTs<CONST.MAX_ALLOWED_REG_DELAY_IN_MS)return{error:"Successive registration request delay not met",device:this.device};this.lastRegTs=Date.now();var e=message.getRegPayload(this.device);return logger.debug(`Registration payload for mac ${this.device.mac}`,e.payload),await this.sendRegistartionMsgToSaS(e)}async sendRegistartionMsgToSaS(e){let{ext:t,cbrs:r}=this.device;e=await this.sasClient.sendRequest(e,1);if(_.set(t,["cbrs","opParams","eirpFlag"],!1),_.set(t,["cbrs","opParams","chFlag"],!1),e.error){var s=_.get(e,["error","data","code"],""),a=_.get(e,["error","data","error"],"");return s?(_.set(t,["cbrs","respErrCode"],s),_.set(t,["cbrs","respErrData"],`${s} | ${a}`),s===CONST.CUSTOM_ABORT_MSG.DE_REG_ALL?{error:CONST.CUSTOM_ABORT_MSG.DE_REG_ALL,device:this.device}:(this.setNextDeviceState(r.state,s),{error:a,device:this.device})):(logger.error(`Registration error for ${this.device.mac}`,e.statusText),this.msgRetryCnt.regd?this.msgRetryCnt.regd+=1:this.msgRetryCnt.regd=1,this.msgRetryCnt.regd>=CONST.MAX_ALLOWED_REQ_RETRY?(t.cbrs.comment=`${t.cbrs.respErrCode}, ${r.state} -> HALT(Retry[${CONST.MAX_ALLOWED_REQ_RETRY}])`,_.set(t,["cbrs","respErrData"],`${e.statusCode} | Domain proxy not reachable`),this.setNextDeviceState(r.state,CONST.CODE.MAX_RETRY),{error:"Domain proxy not reachable",halt:!0,device:this.device}):(t.cbrs.comment=`${e.statusText}, Retry[${this.msgRetryCnt.regd}]`,{error:e.error,device:this.device}))}this.device.hbtimeout=e.postTimeOut;var[s]=e.data.registrationResponse,a=s.response;return _.set(t,["cbrs","respErrCode"],a.responseCode),0===a.responseCode?(_.set(t,["cbrs","respErrData"],""),_.set(t,["cbrs","cbsdID"],s.cbsdId),_.set(t,["cbrs","cbsdIDTime"],Date.now()),_.set(t,["cbrs","registeredAt"],Date.now())):_.set(t,["cbrs","respErrData"],this.setResponseErrorCodeData(s.response)),this.handelDeviceResponse(e,a.responseCode),{error:null,status:!0,device:this.device}}setNextDeviceState(e=CONST.CBRS_STATES.UNREG,t=null,r={}){stateUtils.getNextDeviceState(this.device,e,t,r)}setNextGrantState(e,t=CONST.CBRS_STATES.UNREG,r=null,s={}){stateUtils.getNextGrantState(this.device,e,t,r,s)}getFrequecyBucket(){var{ext:r,cbrs:e}=this.device,t=_.get(r,["cbrs","config","radio"]);let s=[];var r=Number(t.centerFreq-Number(t.chWidth)/2),a=Number(t.centerFreq+Number(t.chWidth)/2);if(e.multiGrant){let e=r,t=r;for(;t<=a;)t+=2.5,t%10==0?(s.push([e,t]),e=t):t===a&&s.push([e,t])}else s.push([r,a]);return{bucket:s}}getGrantFreqHash(e,t){return[e,t].join(":")}async sendCbrsGrantMessageForAll(){var{ext:t}=this.device,{bucket:r}=this.getFrequecyBucket(),e=_.get(t,["cbrs","config","radio"]),s=e.chWidth,a=e.reqEIRP;try{for(let e=0;e<r.length;e++){this.msgRetryCnt.grant={};var[i,n]=r[e],c=this.getGrantFreqHash(i,n),o=commonUtils.convertToPerdBmPerMhz(a,s),d=message.getGrantMsgPayload(t,o,i,n),o=await this.sendChannelGrantReqToSas(d,{lowerEdgeFreq:i,upperEdgeFreq:n,pos:c,radioPower:a,channelBw:s,eirpIndBmPerMHz:o,retry:CONST.MAX_ALLOWED_REQ_RETRY});if(o.error&&o.error===CONST.CUSTOM_ABORT_MSG.DE_REG_ALL)return{error:CONST.CUSTOM_ABORT_MSG.DE_REG_ALL}}return{error:null,status:!0,device:this.device}}catch(e){return{error:e,device:this.device}}}async sendGrantReqForChannel(t,r){var{ext:s}=this.device;try{this.msgRetryCnt.grant={};var a=_.get(s,["cbrs","config","radio"]),i=a.chWidth;let e;var n=_.get(t,["opParams","eirpOp"],null),[c,o]=t.freqRange,d=o-c;e=_.isNil(n)?commonUtils.convertToPerdBmPerMhz(a.reqEIRP,i):commonUtils.convertToPerdBmPerMhz(n,d);var n=commonUtils.convertTodBm(e,i),d=message.getGrantMsgPayload(s,e,c,o),{error:n,status:i}=await this.sendChannelGrantReqToSas(d,{lowerEdgeFreq:c,upperEdgeFreq:o,pos:r,radioPower:n,channelBw:i,eirpIndBmPerMHz:e,retry:CONST.MAX_ALLOWED_REQ_RETRY});return{error:n,status:i}}catch(e){return{error:e}}}async sendChannelGrantReqToSas(e,t){var{retry:r}=t,r=await this.sasClient.sendRequest(e,r);return this.handleChannelGrantRes(r,t)}handleChannelGrantRes(e,t){let{ext:r,cbrs:s}=this.device,{lowerEdgeFreq:a,upperEdgeFreq:i,pos:n,radioPower:c,channelBw:o}=t;_.has(r,["cbrs","grantIds",n])||_.set(r,["cbrs","grantIds",n],{});let d=_.get(r,["cbrs","grantIds",n]);if(d.freqRange=[a,i],_.set(d,["opParams","eirpFlag"],!1),_.set(d,["opParams","chFlag"],!1),e.error){var l=_.get(e,["error","data","code"],""),S=_.get(e,["error","data","error"],"");return l?(_.set(d,["respErrData"],`${l} | ${S}`),l===CONST.CUSTOM_ABORT_MSG.DE_REG_ALL?{error:CONST.CUSTOM_ABORT_MSG.DE_REG_ALL,device:this.device}:(this.setNextGrantState(n,CONST.CBRS_STATES.GRANT,l),{error:S,device:this.device})):(logger.error(`grant request error for ${this.device.mac}`,e.error),_.set(d,["comment"],`${r.cbrs.respErrCode}, ${s.state} -> HALT(Retry[${CONST.MAX_ALLOWED_REQ_RETRY}])`),_.set(r,["cbrs","grantIds",n,"respErrData"],`${e.statusCode}| | Domain proxy not reachable `),this.setNextGrantState(n,CONST.CBRS_STATES.GRANT,CONST.CODE.MAX_RETRY),{error:"Domain proxy not reachable",halt:!0})}var[h]=e.data.grantResponse,t=h.response,l=t.responseCode;return d.respErrData="",d.respErrCode="",delete r.cbrs.grantIds[n],_.has(s,["grant_states",n])&&delete s.grant_states[n],0===l?(n=h.grantId,_.set(r,["cbrs","grantIds",n],d),d.grantID=h.grantId,d.chType=h.channelType,d.grantExp=h.grantExpireTime,d.grantedAt=Date.now(),h.heartbeatInterval&&(d.hbInt=h.heartbeatInterval),_.set(d,["radio","grantedEirp"],c),_.set(d,["radio","grantedEirpPerMhz"],commonUtils.convertToPerdBmPerMhz(c,o))):(n=this.getGrantFreqHash(a,i),_.set(r,["cbrs","grantIds",n],d),_.set(d,["respErrCode"],l),_.set(d,["respErrData"],this.setResponseErrorCodeData(t)),_.set(d,["radio","grantedEirpPerMhz"],null)),h.operationParam&&(h.operationParam.maxEirp&&(_.set(d,["opParams","eirpFlag"],!0),[S,e]=d.freqRange,e=e-S,S=h.operationParam.maxEirp,e=commonUtils.convertTodBm(S,e),_.set(d,["opParams","eirpOp"],e),_.set(d,["opParams","eirpOpPerMhz"],S)),h.operationParam.operationFrequencyRange&&(_.set(d,["opParams","chFlag"],!0),_.set(d,["opParams","chOp"],_.get(h,["operationParam","operationFrequencyRange"],{})))),this.setChannelResponse(t,l,n)}setResponseErrorCodeData(e){let t,r=_.get(e,["responseCode"],"");return t=e.responseMessage?Array.isArray(e.responseMessage)?e.responseMessage.join("|"):e.responseMessage:e.responseData?Array.isArray(e.responseData)?e.responseData.join("|"):e.responseData:(r=r.toString(),CONST.HTTP_CODES_TO_MSG[r]),`${r} | [${t}]`}async sendCbrsHeartBeatMessage(e,t){var r=message.getGrantHrBeatPayload(this.device,e),s=e.comment||"";e.comment=s?"HBT SENT":s+"/HBT SENT",e.hrSentTs=Date.now();try{var a=await this.sendHrBeatReqToSas(r,{pos:t,state:e.state,lowerEdgeFreq:e.freqRange[0],upperEdgeFreq:e.freqRange[1]});return a.error?{error:a.error,device:this.device}:{error:null,res:!0,device:this.device}}catch(e){return{error:e,device:this.device}}}async sendHrBeatReqToSas(e,t){var{ext:r,cbrs:s}=this.device,{pos:a}=t,i=_.get(r,["cbrs","grantIds",a,"state"]),n=await this.sasClient.sendRequest(e,CONST.MAX_ALLOWED_REQ_RETRY);if(n.error){var c=_.get(n,["error","data","code"],""),e=_.get(n,["error","data","error"],"");return c?(_.set(r,["cbrs","grantIds",a,"respErrData"],`${c} | ${e}`),c===CONST.CUSTOM_ABORT_MSG.DE_REG_ALL?{error:CONST.CUSTOM_ABORT_MSG.DE_REG_ALL,device:this.device}:(this.setNextGrantState(a,i,c),{error:e,device:this.device})):(logger.error(`Heartbeat request error for ${this.device.mac}`,n.statusText),_.set(r,["cbrs","grantIds",a,"comment"],`${r.cbrs.respErrCode}, ${s.state} -> HALT(Retry[${CONST.MAX_ALLOWED_REQ_RETRY}])`),_.set(r,["cbrs","grantIds",a,"respErrData"],` ${n.statusCode} | Domain proxy not reachable`),this.setNextGrantState(a,i,CONST.CODE.MAX_RETRY),{error:"Domain proxy not reachable",halt:!0})}return logger.debug("hearbeat response ",n),_.set(r,["cbrs","grantIds",a,"respErrData"],null),_.set(r,["cbrs","grantIds",a,"respErrCode"],null),this.handleGrantHrBeatResp(n,t),{error:null,status:!0}}handleGrantHrBeatResp(e,t){var{ext:r}=this.device,{pos:s}=t,a=_.get(r,["cbrs","grantIds",s]),[i]=e.data.heartbeatResponse,n=i.response,c=i.response.responseCode,t=i.operationParam;return _.set(a,["opParams","eirpFlag"],!1),_.set(a,["opParams","chFlag"],!1),_.set(a,["hbTs"],Date.now()),_.set(a,["respErrCode"],c),0===c?_.set(a,["txExp"],i.transmitExpireTime):(_.set(a,["respErrData"],this.setResponseErrorCodeData(n)),i.transmitExpireTime&&_.set(a,["txExp"],i.transmitExpireTime)),i.heartbeatInterval&&_.set(a,["hbInt"],i.heartbeatInterval),t&&(t.maxEirp&&(_.set(a,["opParams","eirpFlag"],!0),r=i.operationParam.maxEirp,[e,i]=a.freqRange,e=i-e,e=commonUtils.convertTodBm(r,e),_.set(a,["opParams","eirpOp"],e),_.set(a,["opParams","eirpOpPerMhz"],r)),t.operationFrequencyRange&&(_.set(a,["opParams","chFlag"],!0),_.set(a,["opParams","chOp"],t.operationFrequencyRange))),this.setChannelResponse(n,c,s)}async sendDeRegMsg(){let{ext:t,cbrs:r}=this.device;var s=message.getDeRegPayload(_.get(t,["cbrs","cbsdID"])),s=await this.sasClient.sendRequest(s,CONST.MAX_ALLOWED_REQ_RETRY);if(s.error){var a=_.get(s,["error","data","code"],"");let e=_.get(s,["error","data","error"],"");return a?(_.set(t,["cbrs","respErrData"],`${a} | ${e}`),this.setNextDeviceState(CONST.CBRS_STATES.DEREG,a,s),{error:e,device:this.device}):(e=_.get(s,["statusText"],""),logger.error(`De-register request error for ${this.device.mac}`,s.statusText),t.cbrs.comment=`${t.cbrs.respErrCode}, ${r.state} -> HALT(Retry[${CONST.MAX_ALLOWED_REQ_RETRY}])`,_.set(t,["cbrs","respErrData"],`${s.statusCode} | Domain proxy not reachable`),this.setNextDeviceState(CONST.CBRS_STATES.DEREG,CONST.CODE.DEFAULT,s),{error:"Domain proxy not reachable",halt:!0})}_.set(t,["cbrs","opParams","eirpFlag"],!1),_.set(t,["cbrs","opParams","chFlag"],!1);var[a]=s.deregistrationResponse,s=a.response.responseCode;return 0===s||(t.cbrs.respErrCode=s,t.cbrs.respErrData=this.setResponseErrorCodeData(a.response)),this.setNextDeviceState(CONST.CBRS_STATES.DEREG,s,a),{error:null,status:0===s,device:this.device,remove:!0}}async sendChannelReqliquish(e,t=CONST.MAX_ALLOWED_REQ_RETRY){var{ext:r}=this.device,r=_.get(r,["cbrs","cbsdID"],null)||this.device.cbsdid,r=message.getReqlinqPayload(e.grantID,r);return await this.relinquishGrant(r,e.grantID,t)}async relinquishGrant(e,t,r=CONST.MAX_ALLOWED_REQ_RETRY){var{ext:s,cbrs:a,grantStates:i,grantIds:n}=this.device,r=await this.sasClient.sendRequest(e,r);let c=n||s.cbrs.grantIds,o=i||a.grant_states,d=c[t];s=d.state;if(r.error){var l=_.get(r,["error","data","code"],""),S=_.get(r,["error","data","error"],"");return l?(_.set(d,["respErrData"],`${l} | ${S}`),l===CONST.CUSTOM_ABORT_MSG.DE_REG_ALL?{error:CONST.CUSTOM_ABORT_MSG.DE_REG_ALL,device:this.device}:(this.setNextGrantState(t,s,l),{error:S,device:this.device})):(logger.error(`Grant relinquish request error for ${this.device.mac}`,r.error),_.set(d,["comment"],`${a.state} -> HALT(Retry[${CONST.MAX_ALLOWED_REQ_RETRY}])`),_.set(d,["respErrData"],`${r.statusCode} | Domain proxy not reachable`),this.setNextGrantState(t,s,CONST.CODE.MAX_RETRY),{error:r.error,halt:!0})}_.set(d,["opParams","eirpFlag"],!1),_.set(d,["opParams","chFlag"],!1);var[i]=r.data.relinquishmentResponse,l=_.get(i,["response","responseCode"]);return 0===l?([S,a]=d.freqRange,S=this.getGrantFreqHash(S,a),_.has(d,["opParams","eirpOp"])&&(delete d.opParams.eirpOp,delete d.opParams.eirpOpPerMhz),a=S,delete d.grantID,delete c[t],delete o[t],delete d.respErrData,delete d.respErrCode,t=S,_.set(c,[a],d)):(_.set(d,["respErrCode"],l),_.set(d,["respErrData"],this.setResponseErrorCodeData(i.response))),this.setNextGrantState(t,s,l,r),{error:null,status:r,device:this.device}}calculateCPASSCutOff(e){e=_.get(config,["cbrs","coex",e,"cPassEndTimeHHMMSS"],{});if(_.isEmpty(e))return 0;let t=new Date;return-1<e.hours&&t.setUTCHours(e.hours),-1<e.minutes&&t.setUTCMinutes(e.minutes),-1<e.seconds&&t.setUTCSeconds(e.seconds),t.setUTCMilliseconds(0),t.getTime()}async runSpectrumEnquiry(){var{ext:e,cbrs:t,cbrsLiveStatus:r}=this.device,s=e.cbrs.sas;let a=_.range(CONST.CBRS_LOWER_EDGE_FREQ_IN_HZ,CONST.CBRS_UPPER_EDGE_FREQ_IN_HZ,CONST.TEN_MHZ);var i=a.map(e=>({measFrequency:e,measBandwidth:CONST.TEN_MHZ_FLOAT,measRcvdPower:-98})),n=a.map(e=>({lowFrequency:e,highFrequency:e+CONST.CBRS_STEP_FREQ_IN_HZ}));let c;c=t.sync===CONST.CBRS.SYNC_STATUS.CONFIG_SYNCED?_.get(r,["ext","cbrs","cbsdID"],null):_.get(e,["cbrs","cbsdID"]);let o={cbsdId:c,inquiredSpectrum:n,measReport:{rcvdPowerMeasReports:i}};var d={spectrumInquiryRequest:[o]};s===CONST.SAS_COMMSCOPE&&delete o.measReport;try{var l=await this.sasClient.sendRequest({payload:JSON.stringify(d),endPoint:"/spectrumInquiry"});return l.error?(logger.error(`spectrum enquiry request failed ${this.device.mac}`,l.error),{error:l.error}):await this.handleSpectrumEnqResponse(l)}catch(e){return{error:e}}}async handleSpectrumEnqResponse(e){let{ext:t}=this.device;var r=t.cbrs.sas,s=this.calculateCPASSCutOff(r),n={GAA:"1",PAL:"2"},a={[CONST.FIVE_MHZ]:1,[CONST.TEN_MHZ]:2};_.set(t,["opParams","eirpFlag"],!1),_.set(t,["opParams","chFlag"],!1);let[c]=e.data.spectrumInquiryResponse;r=c.response.responseCode;if(_.set(t,["cbrs","respErrCode"],r),0===r){_.set(t,["cbrs","cbsdID"],c.cbsdId);var o=CONST.TEN_MHZ,e=CONST.FIVE_MHZ;let i=_.range(CONST.CBRS_LOWER_EDGE_FREQ_IN_HZ,CONST.CBRS_UPPER_EDGE_FREQ_IN_HZ,e);r=parseInt((CONST.CBRS_UPPER_EDGE_FREQ_IN_HZ-CONST.CBRS_LOWER_EDGE_FREQ_IN_HZ)/e);this.device.cbsdSpectrumAvailableStatus=Array(r).fill("0"),this.device.cbsdSpectrumMaxEirpStatus=Array(r).fill(null),this.device.cbsdSpectrumChannelTypeStatus=Array(r).fill("0"),this.device.cbsdSpectrumChannelRaking=Array(r).fill(null),c.availableChannel.forEach((e,t)=>{var r=e.maxEirp,s=e.channelType,a=_.get(e,["frequencyRange","lowFrequency"]);!a||-1!==(a=i.indexOf(a))&&(o===CONST.FIVE_MHZ?(this.device.cbsdSpectrumAvailableStatus[a]="1",this.device.cbsdSpectrumMaxEirpStatus[a]=r,this.device.cbsdSpectrumChannelTypeStatus[a]=n[s],this.device.cbsdSpectrumChannelRaking[a]=t+1):o===CONST.TEN_MHZ?(this.device.cbsdSpectrumAvailableStatus[a]="1",this.device.cbsdSpectrumAvailableStatus[a+1]="1",this.device.cbsdSpectrumMaxEirpStatus[a]=r,this.device.cbsdSpectrumMaxEirpStatus[a+1]=r,this.device.cbsdSpectrumChannelTypeStatus[a]=n[s],this.device.cbsdSpectrumChannelTypeStatus[a+1]=n[s],this.device.cbsdSpectrumChannelRaking[a]=t+1,this.device.cbsdSpectrumChannelRaking[a+1]=t+1):logger.error(`${this.device.mac} - ${e} Incorrect step freq ${o}`))});e=this.device.cbsdSpectrumMaxEirpStatus.some(e=>!!e),r=this.device.cbsdSpectrumChannelTypeStatus.some(e=>!!e);e||(this.device.cbsdSpectrumMaxEirpStatus=null),r||(this.device.cbsdSpectrumChannelTypeStatus=[]),this.spectrumEnqStats={status:!0,time:Date.now(),enqstats:this.device.cbsdSpectrumAvailableStatus.join(""),maxeirp:this.device.cbsdSpectrumMaxEirpStatus,channeltype:this.device.cbsdSpectrumChannelTypeStatus.join(""),channelrank:this.device.cbsdSpectrumChannelRaking,interval:a[CONST.TEN_MHZ],comment:null,cbsdIDTime:t.cbrs.cbsdIDTime,cPassEndInUTC:s}}else t.cbrs.respErrData=this.setResponseErrorCodeData(c.response),this.spectrumEnqStats={status:!1,time:Date.now(),enqstats:Array(30).fill("0").join(""),comment:t.cbrs.respErrData,cbsdIDTime:t.cbrs.cbsdIDTime,cPassEndInUTC:s};return{error:null,data:this.spectrumEnqStats}}async deRegDevice(e){var{cbrs:t,ext:r}=this.device;t.state===CONST.CBRS_STATES.DEREG&&(_.set(r,["cbrs","respErrCode"],""),_.set(r,["cbrs","respErrData"],""),_.set(r,["cbrs","comment"],"")),e&&(s=_.get(r,["cbrs","respErrData"],"")+e,_.set(r,["cbrs","respErrData"],s));var{error:r,status:s}=await this.sendDeRegMsg();return{error:r,status:s,device:this.device}}async cbrsDeRegistionMessageByMac(t){var e=message.getDeRegPayload(t),t=await this.sasClient.sendRequest(e,1);if(t.error){var e=_.get(t,["error","data","code"],""),r=_.get(t,["error","data","error"],"");return e?{error:`${e} | [${r}]`}:(logger.error(`De-register request for mac: ${this.device.mac} failed , error:`,t.statusText),{error:t.statusText})}{var[r]=t.data.deregistrationResponse||[];if(!r)return logger.error(`Received a empty De-register response for mac: ${this.device.mac} response:`,t),{error:"Received a empty De-register response"};const s=r.response;r=s.responseCode;let e;return 0===r?{error:null,status:"successful"}:(s&&s.responseMessage?e=Array.isArray(s.responseMessage)?s.responseMessage.join("|"):s.responseMessage:s&&s.responseData&&(e=Array.isArray(s.responseData)?s.responseData.join("|"):s.responseData),{error:`${r}[${e}]`})}}setChannelResponse(e,t,r){let{ext:s,grantIds:a}=this.device,i=a?a[r]:_.get(s,["cbrs","grantIds",r]);var n,c,o=i.state||CONST.CBRS_STATES.REGD;return s.cbrs.lstUpd=Date.now(),0!==t||(i.opParams&&i.opParams.eirpFlag&&(i.respErrData=`${i.respErrData||""} Recommended EIRP [${i.opParams.eirpOp||""} dBm]`),i.opParams&&i.opParams.chFlag&&(n=_.get(i,["opParams","chOp","lowFrequency"]),c=_.get(i,["opParams","chOp","highFrequency"]),i.respErrData=`${i.respErrData||""} Recommended Channel [${n}-${c}]`)),this.setNextGrantState(r,o,t,e),{error:null,status:e}}handelDeviceResponse(e,t){var{error:r,data:e}=e;let{ext:s,cbrs:a}=this.device;return s.cbrs.lstUpd=Date.now(),this.setNextDeviceState(a.state,t),logger.info(`Device ${this.device.mac} state is`,a.state,"code ",t),r?{error:r}:{error:null,status:e}}}module.exports={DeviceStateManager:DeviceStateManager,initialize:initialize};