"use strict";const cache=require("../common/redis"),CONST=require("../common/constants"),utils=require("../common/utils"),util=require("util"),db=require("../common/mongo"),{DeviceHttpClient:DeviceHttpClient}=require("../common/request"),messageBody=require("./message"),_=require("lodash"),CommonCache=require("../common/redis/commonCache"),Lock=require("../common/redis/lock"),{DeviceStateManager:DeviceStateManager}=require("./stateEngine"),cbsdProcedureModule=require("./cbrsProcedure").CBRSProcedure,stateUtils=require("./stateUtils"),logger=require("../common/logger").getLogger("cns-cbrs-tool.heartbeat"),HBT_STREAM="cbrs_hbt_stream",HBT_DB_SYNC_LOCK="hbt_sync_lock",HBT_PRODUCER_SYNC_LOCK="hbt_prod_lock",CBRS_STREAM_GROUP="cbrs";let config,commonCache,cacheSetPromise,lock,HBT_INTERVAL=180;function initialize(e){config=e,commonCache=new CommonCache({db:"common",redis:config.redis}),cacheSetPromise=util.promisify(commonCache.set.bind(commonCache)),lock=new Lock({db:"common",redis:config.redis}),messageBody.initialize(lock,config),config&&config.onChange(function(e,t){config=t})}process.wname=process.wname||"W0";class HeartBeat{constructor(){this.initializeHbtKey=!0,logger.info("HeartBeat initiated"),cache.stream.initialize(commonCache.cache.db),cache.stream.consume(HBT_STREAM,CBRS_STREAM_GROUP,process.wname,50,e=>{this.hbtWorker(e)})}async initializeHeartBeat(){try{await lock.acquireTTLPromise(HBT_DB_SYNC_LOCK,12e4,{})||(this.initializeHbtKey=!1),this.initializeHbtKey&&(this.initializeHbtKey=!1,logger.info("Sync data from db to cache for hearbeat"),await this.syncDbCache()),this.startPublishing()}catch(e){logger.error("Error in initializing heartBeat",e)}}async startPublishing(){logger.debug("Started heartbeat publish loop at ",new Date),await lock.acquireTTLPromise(HBT_PRODUCER_SYNC_LOCK,12e4,{})&&await this.publishToWorker(),HBT_INTERVAL=_.get(config,["cbrs","hbtIntervalInSec"])||180,await utils.sleep(HBT_INTERVAL),this.startPublishing()}async publishToWorker(){let e=0;for(;;){var t,a=await cache.stream.scan(config.cbrs.heartbeat_redis_key+"*",e);if(!a||!a[1])break;for(t of a[1])t&&cache.stream.publish(HBT_STREAM,{key:t});if(0===parseInt(a[0]))break;e=a[0]}}async reqliushAndGetGrant(e,t,a){let r=new DeviceStateManager(e,a);a=await r.sendChannelReqliquish(t,1);return a.error?(logger.error("Error in sending relinquishing grant for device ",e.mac,"for grant ",t.grantID,"error : ",a.error),{error:a.error}):{status:!0}}async hbtWorker(i){var c=i.data.key,g=Date.now();let d=new Set;logger.debug("Hearbeat worker received a sector",c);try{let n=await cache.stream.hgetall(c);if(!n)return;n=_.mapValues(n,JSON.parse);var l=n.ap;if(!l)return;logger.debug("hearbeat worker sector data ",l,i);var{token:p,proxyUrl:h}=await utils.fetchCbrsTokenUrl(l.cid),b=await utils.getSasVendor(l.cid);if(b.error)return logger.error("Error in getting sas vendor for hearbeat, for sector",b.error,c),{error:b.error};var m=b.sasVendor;if(!p)return;let t=[],o,a=[];var u={};let r=new Set;var S,b=_.get(config,`cbrs.bulkHbtCnt.${m}`,100),m=60*_.get(config,"features.cbrs.syncCutOffTimeHrs",72)*60*1e3;for await(S of messageBody.getHeartBeatBody(n,m,b))if(o=S.grantIdMacMap,S.syncExpMac.forEach(e=>r.add(e)),S.lockedDevices.forEach(d.add,d),S&&!_.isEmpty(S.hbtReq)&&!_.isEmpty(S.hbtReq.heartbeatRequest)){let e=new DeviceHttpClient(S.httpClientMacDev,{token:p,url:config.cbrs.sas_proxy_url,proxyUrl:h});var T=e.sendRequest({endPoint:"/heartbeat",payload:S.hbtReq},3);t.push(T),a.push(S.hbtReq)}var f,y=await Promise.all(t);let e=[],s=!1;if(this.lastResetTS&&g<=this.lastResetTS)return;for(let t=0;t<y.length;t++){var C=y[t],E=a[t].heartbeatRequest;if(logger.debug("Heartbeat requst response and payload: ",y[t],a[t]),C.error){let e=_.get(C,["error","data","code"],"");if(e.toString().includes(CONST.CUSTOM_ABORT_MSG.DE_REG_ALL)){logger.warn("De-reg all received for sector ",n.ap.mac);var v=Object.values(n).reduce((e,t)=>(t&&t.mac&&e.push(t.mac),e),[]);v.length&&await lock.releaseDeviceLock(v);let e=new cbsdProcedureModule({sectorMac:n.ap.mac,...n.ap});await e.handleDeRegMacs(n.ap.mac,"Deregistered after receiving DE_REG_ALL msg"),s=!0,Object.keys(n).forEach(function(e){e===n.ap.mac?(n.ap.state=CONST.CBRS.STATE.DEREGD,n.ap.grantStates={},n.ap.grantIds={}):_.isEmpty(n[e])||(n[e].state=CONST.CBRS.STATE.DEREGD,n[e].grantStates={},n[e].grantIds={})})}else this.handleFailHbt(n,o,a[t],C)}else e=e.concat({response:C.data.heartbeatResponse,reqData:E})}for(f of e)if(f){var R,D,w,I=f.response,B=f.reqData;if(I){let c=-1;for(var $ of I){let e,t,a=$.response.responseCode;c++,t=(e=0!==a?B[c].grantId:$.grantId,o[e]);let r,s,i;r=l.mac===t?n.ap:n[t],r?(s=r.grantIds,d.add(t),i=s[e],i&&((i.respErrCode=a)?i.respErrData=utils.setResponseErrorCodeData($.response):i.respErrData="",i.txExp=$.transmitExpireTime,i.hbInt=$.heartbeatInterval||i.hbInt,i.hbTs=Date.now(),delete i.opParams,delete i.sdgMsg,_.get($,"operationParam.maxEirp")&&(R=_.get($,"operationParam.maxEirp"),[w,D]=i.freqRange,w=D-w,w=utils.convertTodBm(R,w),_.set(i,"opParams.eirpOp",w),_.set(i,"opParams.eirpOpPerMhz",R),_.set(i,"opParams.eirpFlag",!0)),_.get($,"operationParam.operationFrequencyRange")&&(_.set(i,"opParams.chOp",_.get($,"operationParam.operationFrequencyRange")),_.set(i,"opParams.chFlag",!0)),stateUtils.getNextGrantState(r,i.grantID,i.state,a),i.state===CONST.CBRS_STATES.RELG&&($=await this.reqliushAndGetGrant(r,i,{token:p,url:config.cbrs.sas_proxy_url,proxyUrl:h},!1),$&&!$.error&&_.set(u,[t,e],1)))):logger.debug("Device not found ",t,e,$)}}}s||await this.saveSectorToDB(n,u),await this.saveSectorToRedis(c,n),r.size&&await this.handleSyncExpDevs(l,[...r])}catch(e){logger.error("Error encountered during heartbeat",{sector:c},e)}finally{try{0<d.size&&await lock.releaseDeviceLock(Array.from(d),CONST.LOCK_ACTION.HEARTBEAT)}catch(e){logger.error("Error releasing lock on heartbeat iteration",e)}logger.debug("Heartbeat worker acked",c),i.ack()}}async handleSyncExpDevs(e,t){let a=new cbsdProcedureModule({sectorMac:e.mac,ecgi:e.ecgi,cid:e.cid,sn:e.sn});await a.handleDeRegMacs(Array.from(t),"Deregistered after sync period expiry")}async handleFailHbt(a,r,e,s){for(var i of e.heartbeatRequest){var c=i.grantId,n=r[c],i=(a.ap.mac===n?a.ap:a[n]).grantIds;let e=(a.ap.mac===n?a.ap:a[n]).grantStates,t=i[c];n=_.get(s,["error","data","code"],""),i=_.get(s,["error","data","error"],"");t.state=e[c]=CONST.CBRS_STATES.HBT_FAIL,n?(t.respErrData=`${n} | ${i}`,t.respErrCode=n,t.state=e[c]=CONST.CBRS_STATES.HALT):(t.respErrData=s.statusText,t.respErrCode=s.statusCode)}}async saveSectorToDB(e,t){var a,r,s,i,c=e.ap.mac,n=e.ap.cid;let o={},g={},d={},l={},p={};for(a in p[c]={invMatch:{mac:c},extMatch:{mac:c},inv:{},ext:{}},e.ap.grantStates)e.ap.grantStates[a]===CONST.CBRS_STATES.HALT?(r=e.ap.grantIds[a].freqRange.join(":"),e.ap.grantStates[r]=e.ap.grantStates[a],e.ap.grantIds[r]=e.ap.grantIds[a],o[`cbrs.grant_states.${r}`]=e.ap.grantStates[a],g[`cbrs.grantIds.${r}`]=e.ap.grantIds[a],a!==r&&(d[`cbrs.grant_states.${a}`]=1,l[`cbrs.grantIds.${a}`]=1),delete e.ap.grantStates[a],delete e.ap.grantIds[a]):(o[`cbrs.grant_states.${a}`]=e.ap.grantStates[a],g[`cbrs.grantIds.${a}`]=e.ap.grantIds[a]);for(s in _.isEmpty(o)||(p[c].inv.$set=o,p[c].ext.$set=g),_.isEmpty(d)||(p[c].inv.$unset=d,p[c].ext.$unset=l),this.addUnsetStage(p,c,t),e)if("ap"!==s&&!_.isEmpty(e[s])){for(var h in p[s]={},p[s].inv={},p[s].ext={},p[s].invMatch={mac:e[s].mac},p[s].extMatch={mac:e[s].mac},e[s].grantStates)e[s].grantStates[h]===CONST.CBRS_STATES.HALT?(i=e[s].grantIds[h].freqRange.join(":"),p[s].inv.$set=p[s].inv.$set||{},p[s].inv.$unset=p[s].inv.$unset||{},p[s].ext.$set=p[s].ext.$set||{},p[s].ext.$unset=p[s].ext.$unset||{},p[s].inv.$set[`cbrs.grant_states.${i}`]=e[s].grantStates[h],p[s].ext.$set[`cbrs.grantIds.${i}`]=e[s].grantIds[h],p[s].ext.$unset[`cbrs.grantIds.${h}`]=1,p[s].inv.$unset[`cbrs.grant_states.${h}`]=1,h!==i&&(p[s].inv.$unset[`cbrs.grant_states.${h}`]=1,p[s].ext.$unset[`cbrs.grantIds.${h}`]=1),delete e[s].grantStates[h],delete e[s].grantIds[h]):(p[s].inv.$set=p[s].inv.$set||{},p[s].ext.$set=p[s].ext.$set||{},p[s].inv.$set[`cbrs.grant_states.${h}`]=e[s].grantStates[h],p[s].ext.$set[`cbrs.grantIds.${h}`]=e[s].grantIds[h]);this.addUnsetStage(p,s,t),Object.values(_.get(e,`${s}.grantStates`,{})).some(e=>CONST.GRANTED_STATES.includes(e))||(e[s]={})}await db.bulkUpdSector({cid:n,mcid:e.ap.mcid},p)}addUnsetStage(t,a,e){Object.keys(e[a]||{}).forEach(e=>{t[a].inv.$unset=t[a].inv.$unset||{},t[a].inv.$unset[`cbrs.grant_states.${e}`]=1,t[a].ext.$unset=t[a].ext.$unset||{},t[a].ext.$unset[`cbrs.grantIds.${e}`]=1})}async clearHBRedisCache(){try{var e=utils.getHeartBeatRediskey("*");await commonCache.scanAndDelete(e),logger.info("Cleared heartbeat cache on process start")}catch(e){logger.error("Error clearing redis hearbeat cache on process start",e)}}async saveSectorToRedis(e,t){t=_.mapValues(t,JSON.stringify),await cacheSetPromise(e,t)}async syncDbCache(){let r=0,s=0,i=new Set;await this.clearHBRedisCache();let c=await db.getApRRH(),n;for(;;){var o=await c.next();if(!o)break;r++;let e,t;e=_.get(o,"radio.chWidth"),e=o.cbrs.sync&&e?e.split(" ")[0]:parseInt(_.get(o,"ext.cbrs.config.radio.chBw","10").split(" ")[0]),t=o.cbrs.sync?_.get(o,"radio.rfFreq"):_.get(o,"ext.cbrs.config.radio.centerFreq"),o.cbrs.sync===CONST.CBRS_SYNC_STATUS.NOT_SYNCED&&i.add(o.cid);var g=o.ecgi||o.mac;let a={ap:{mac:o.mac,sn:o.sn,ecgi:o.ecgi,cid:o.cid,mode:o.mode,eType:o.eType,sync:o.cbrs.sync,state:o.cbrs.state,model:o.model,opMode:o.opMode,radio:_.get(o,["ext","cbrs","config","radio"],{}),grantStates:_.pickBy(_.get(o,"cbrs.grant_states",{}),e=>CONST.GRANTED_STATES.includes(e)),cbsdid:_.get(o,"ext.cbrs.cbsdID"),chBw:e,centerFreq:t,cbsdTime:_.get(o,"ext.cbrs.cbsdIDTime")}};if(_.has(o,["ext","cbrs","grantIds"])&&!_.isEmpty(o.ext.cbrs.grantIds)?a.ap.grantIds=_.pickBy(_.get(o,["ext","cbrs","grantIds"],{}),e=>CONST.GRANTED_STATES.includes(e.state)):a.ap.grantIds={},n=await db.getSectorChildData({mac:o.mac,ecgi:o.ecgi},{cid:o.cid,mcid:o.mcid},!0),n){for(;;){let t;var d=await n.next();if(!d)break;if(s++,d.cbrs.sync===CONST.CBRS_SYNC_STATUS.NOT_SYNCED&&_.get(d,"cbrs.grant_states")){let e=Object.values(d.cbrs.grant_states);e.some(e=>CONST.GRANTED_STATES.includes(e))&&(t=_.get(d,"radio.chWidth"),t=d.cbrs.sync&&t?t.split(" ")[0]:parseInt(_.get(o,"ext.cbrs.config.radio.chBw","10").split(" ")[0]),i.add(d.cid),a[d.mac]={sn:d.sn,mode:d.mode,eType:d.eType,state:d.cbrs.state,ecgi:d.ecgi,mac:d.mac,model:d.model,opMode:d.opMode,pmac:d.pmac,chBw:t,radio:_.get(d,["ext","cbrs","config","radio"],{}),grantStates:_.pickBy(d.cbrs.grant_states,e=>CONST.GRANTED_STATES.includes(e)),cbsdid:_.get(d,"ext.cbrs.cbsdID"),grantIds:_.pickBy(_.get(d,"ext.cbrs.grantIds"),e=>e&&CONST.GRANTED_STATES.includes(e.state)),cbsdTime:_.get(d,"ext.cbrs.cbsdIDTime")})}}0===Object.keys(a.ap.grantStates).length&&1===Object.keys(a).length||(g=utils.getHeartBeatRediskey(g),await this.saveSectorToRedis(g,a))}}c&&c.close(),n&&n.close(),await this.populateVendorInfoToCache([...i]),logger.info(`Sync done for ${r}-Aps, ${s}-SMs `)}async resetHeartbeatCache(){try{logger.warn("Received request to reset heartbeat cache"),this.lastResetTS=Date.now(),await this.syncDbCache()}catch(e){logger.error("Error resetting heartbeat cache",e)}}async populateVendorInfoToCache(t=[]){var a,r=t.length;for(let e=0;e<r;e++)t[e]&&({error:a}=await utils.getSasVendor(t[e]),a&&logger.error("Error occured while populating vendor info to cache for customer:",t[e],a),e&&e%100==0&&await utils.sleep(.1))}}module.exports={HeartBeat:HeartBeat,initialize:initialize};