"use strict";const utils=require("util"),os=require("os"),_=require("lodash"),async=require("async"),commonUtils=require("../common/utils"),db=require("../common/mongo"),CONST=require("../common/constants"),Lock=require("../common/redis/lock"),RedisCache=require("../common/redis/commonCache"),DeviceStateModule=require("./stateEngine"),{DeviceStateManager:DeviceStateManager}=DeviceStateModule,cpus=os.cpus().length,logger=require("../common/logger").getLogger("cns-cbrs-tool.cbrsProcedure");let commonCache,lock,config;function initialize(e){config=e,commonCache=new RedisCache({db:"common",redis:config.redis}),lock=new Lock({db:"common",redis:config.redis}),DeviceStateModule.initialize(config),e&&config.onChange(function(e,r){config=r})}class CBRSProcedure{constructor(e,r,t){this.mac=e.sectorMac,this.apDoc=null,this.sasId=null,this.stopProcedure=!1,this.sasVendor=null,this.lockedDevices=new Set,this.ecgi=e.ecgi,this.amqpClient=r,this.cid=e.cid,this.jobId=e.jobId,this.sectorDevObj={},this.deviceList=[],this.redisUpdateList=[],this.uiPublishList=[],this.storeDevDataInRedis={},this.removeDev=new Set,this.mcid=e.mcid||CONST.MSP_ACC.SUPER_ADMIN_MCID,this.statusCb=t,this.progress={inProgress:0,success:0,failed:0,remaining:0,total:0}}async fetchCbrsUserCredentials(){var{error:e,token:r,proxyUrl:t}=await commonUtils.fetchCbrsTokenUrl(this.cid);if(this.token=r,this.proxyUrl=t,e)return logger.error(`Error in fetching cbrs token and url for ${this.cid}`,e),{error:e};e=await commonUtils.fetchSaSid(this.cid);if(e.error)return logger.error("Unable to fetch UserId exiting procedure for cid",this.cid,e.error),{error:"Unable to fetch UserId for sector, exiting procedure"};this.sasId=e.sasId;e=await commonUtils.getSasVendor(this.cid);return e.error?{error:e.error}:(this.sasVendor=e.sasVendor,{status:!0})}attachSectorInfoToChildren(e,r){let t,s,i,c,o,a,n,d;d=e.cbrs.sync===CONST.CBRS.SYNC_STATUS.CONFIG_SYNCED&&e.cbrsLiveStatus&&e.cbrsLiveStatus.cbrs?(n=_.get(e,["cbrsLiveStatus","cbrs","multiGrant"]),a=_.get(e,["cbrsLiveStatus","cbrs","numGrants"]),o=!(0!==a||!n)||1!==a&&1<a,t=Number(_.get(e,["radio","chWidth"]).split(" ")[0]),s=_.get(e,["radio","rfFreq"]),i=_.get(e,["cbrsLiveStatus","cbrs","groupId"]),c=_.get(e,["cbrsLiveStatus","cbrs","sectorId"]),_.get(e,["cbrsLiveStatus","cbrs","mergeUserId"],!1)):(t=_.get(e,["ext","cbrs","config","radio","chWidth"]),s=_.get(e,["ext","cbrs","config","radio","centerFreq"]),o=_.get(e,["cbrs","multiGrant"]),i=_.get(e,["cbrs","groupId"]),c=_.get(e,["cbrs","sectorId"]),_.get(e,["cbrs","mergeUserId"],!1)),e.mode===CONST.MODE_RRH&&e.extDev||this.deviceList.push(e),r.forEach(e=>{_.set(e,["cbrs","sectorId"],c),_.set(e,["cbrs","groupId"],i),_.set(e,["ext","cbrs","sas"],this.sasVendor),_.set(e,["cbrs","multiGrant"],o),_.set(e,["ext","cbrs","config","userID"],this.sasId),_.has(e,["ext","cbrs","config","radio"])||_.set(e,["ext","cbrs","config","radio"],{}),_.set(e,["ext","cbrs","config","radio","chWidth"],t),_.set(e,["ext","cbrs","config","radio","centerFreq"],s),_.set(e,["cbrs","mergeUserId"],d),commonUtils.setEIRP(e),this.deviceList.push(e)})}checkAllDevicesSyncDone(){return this.deviceList.every(e=>{if([CONST.CBRS_STATES.HALT].includes(e.cbrs.state))return!0;var r=e.cbrs.sync!==CONST.CBRS.SYNC_STATUS.NOT_SYNCED;if(r)return!0;let t=!1;return _.isEmpty(e.ext.cbrs.grantIds)||(t=Object.values(e.ext.cbrs.grantIds).every(e=>[CONST.CBRS_STATES.HBT_FAIL,CONST.CBRS_STATES.HALT,CONST.CBRS_STATES.GRNT_SUSP,CONST.CBRS_STATES.NA,CONST.CBRS_STATES.AUTHRZD].includes(e.state))),e.cbrs.state===CONST.CBRS_STATES.REGD&&(r||t)})}async start(){try{return this.runProcedure()}catch(e){return logger.error("Error in running procedure for sector ",this.mac,e),{error:e}}}async stop(){return this.stopProcedure=!0,logger.warn(`job is abort initiated for ${this.jobId} for sector ${this.mac} for customer ${this.cid}`),!0}async runProcedure(){try{this.deviceList=[];var[e]=await db.getSectorApData(this.mac,{cid:this.cid,mcid:this.mcid});if(!e)return logger.error(`Ap mac: ${this.mac} does not exists for user ${this.cid}`),{error:`Ap mac:${this.mac} does not exists for user ${this.cid}`};logger.info("Running cbrs procedure for ",e.mac,e.cid,this.jobId),(this.apDoc=e).ecgi&&(this.ecgi=e.ecgi);var r=await db.getSectorChildData({mac:this.mac,ecgi:this.ecgi},{cid:this.cid,mcid:this.mcid}),{error:t}=await this.fetchCbrsUserCredentials();if(t)return{error:t};if(_.set(e,["ext","cbrs","sas"],this.sasVendor),_.set(e,["ext","cbrs","config","userID"],this.sasId),this.attachSectorInfoToChildren(e,r),this.checkDeRegExists())return{error:CONST.CUSTOM_ABORT_MSG.DE_REG_ALL};this.deviceList=this.deviceList.filter(e=>!this.removeDev.has(e.mac));var{err:r}=await this.loopSectorDevices();if(r===CONST.CUSTOM_ABORT_MSG.DE_REG_ALL)return await this.handleDeRegMacs(this.apDoc.mac,"Deregistered after receiving DE_REG_ALL msg"),{error:CONST.CUSTOM_ABORT_MSG.DE_REG_ALL};if(r===CONST.CUSTOM_ABORT_MSG.JOB_ABORT)return{error:CONST.CUSTOM_ABORT_MSG.JOB_ABORT};r=this.checkAllDevicesSyncDone();return logger.debug(`Check state done for ${this.deviceList.length} devices, info to store in redis for ${Object.keys(this.storeDevDataInRedis).length} devices`),_.isEmpty(this.storeDevDataInRedis)||await this.storeInRedis(),r||_.isEmpty(this.deviceList)?{error:null,status:!0}:(await commonUtils.sleep(CONST.CBRS_PROCEDURE_WAIT_TIME_FOR_NEXT_STATE_IN_SEC),this.stopProcedure?{error:CONST.CUSTOM_ABORT_MSG.JOB_ABORT}:await this.runProcedure())}catch(e){return logger.error("Error in starting cbrs procedure",e),{error:e}}}checkDeRegExists(){return this.deviceList.some(e=>{return e.ext.cbrs.respErrData===CONST.CUSTOM_ABORT_MSG.DE_REG_ALL})}async checkJobStatus(){try{return this.statusCb?await this.statusCb({cid:this.cid,mcid:this.mcid,jobId:this.jobId}):(logger.error("status check fucntion is not initialized"),!1)}catch(e){return logger.error("Error checking job status",e),!1}}allowedParallelProcCnt(){return 8<cpus?10:4<=cpus?6:1}isSkipDeviceRequire(e,r){var{ext:s,cbrs:i}=e;return!![CONST.CBRS_STATES.DEREGD,CONST.CBRS_STATES.DEREG_FAIL,CONST.CBRS_STATES.DEREG,CONST.CBRS_STATES.HALT].includes(i.state)||!!Object.values(r||{}).length&&Object.values(r||{}).every(e=>{var r=s.cbrs.reInitTs>i.lastUpd,t=i.state===CONST.CBRS_STATES.REGD;return[CONST.CBRS_STATES.GRNT_SUSP,CONST.CBRS_STATES.NA,CONST.CBRS_STATES.HALT,CONST.CBRS_STATES.HBT_FAIL,CONST.CBRS_STATES.AUTHRZD].includes(e)&&t&&!r})}loopSectorDevices(){var c=this;return new Promise(r=>{var e=_.chunk(this.deviceList,this.allowedParallelProcCnt());async.eachOfSeries(e,(e,r,s)=>{let i=[];async.eachOfSeries(e,async e=>{var{ext:r,cbrs:t}=e;if(logger.debug(`Check device state for mac: ${e.mac}`),!await c.checkJobStatus()||c.stopProcedure)throw CONST.CUSTOM_ABORT_MSG.JOB_ABORT;if(c.isSkipDeviceRequire(e,t.grant_states))return logger.debug(`Skip device mac: ${e.mac}, reInitTs: ${r.cbrs.reInitTs} , lstUpd: ${r.cbrs.lstUpd}, state: ${t.state}`),void c.removeDev.add(e.mac);await lock.acquireDeviceLock(e.mac)?(this.lockedDevices.add(e.mac),c.sectorDevObj[e.mac]?c.sectorDevObj[e.mac].setDeviceProperty(e):c.sectorDevObj[e.mac]=new DeviceStateManager(e,{token:this.token,proxyUrl:this.proxyUrl}),i.push(c.sectorDevObj[e.mac].checkState())):logger.warn("Skip device",e.mac,"in procedure iteration since could not acquire lock")},t=>t&&t.message===CONST.CUSTOM_ABORT_MSG.JOB_ABORT?(logger.warn("Job abort received for job ",this.jobId),void s(CONST.CUSTOM_ABORT_MSG.JOB_ABORT)):void Promise.all(i).then(e=>{var{error:r,data:e}=this.handleCheckStateResponse(e);if(r)return s(r);this.sendAndNotifyWatchers(e).then(()=>{s(null,{err:t,status:!0})})}))},e=>e===CONST.CUSTOM_ABORT_MSG.DE_REG_ALL?(logger.warn("De-register received for job ",this.jobId),void r({err:CONST.CUSTOM_ABORT_MSG.DE_REG_ALL})):void(e!==CONST.CUSTOM_ABORT_MSG.JOB_ABORT?(logger.info(`Status check loop done for  ${this.deviceList.length} device for sector ${this.apDoc.mac}`),r({err:e,status:!0})):r({err:CONST.CUSTOM_ABORT_MSG.JOB_ABORT})))})}handleCheckStateResponse(r){let t=[];var s=r.length;for(let e=0;e<s;e++){var i=r[e];if(i&&i.error&&i.error===CONST.CUSTOM_ABORT_MSG.DE_REG_ALL)return{error:CONST.CUSTOM_ABORT_MSG.DE_REG_ALL};var c,o,a,{device:n}=i;n&&({cbrs:c,mac:o,ext:a}=this.storeDevDataInRedis[n.mac]=n,!i.remove&&c.sync===CONST.CBRS.SYNC_STATUS.NOT_SYNCED&&c.state!==CONST.CBRS_STATES.HALT||this.removeDev.add(o),this.lockedDevices.has(o)&&this.isSkipDeviceRequire(n,c.grant_states)&&(lock.releaseDeviceLock(o),this.lockedDevices.delete(o)),t.push({mac:o,status:c.state,comment:a.cbrs.comment,grantIds:a.cbrs.grantIds||{}}))}return{error:null,data:t}}async sendAndNotifyWatchers(r){try{let e=this.deviceList;this.progress={inProgress:0,success:0,failed:0,remaining:0,total:0},e.forEach(e=>{e.cbrs.state===CONST.CBRS_STATES.UNREG?this.progress.remaining+=1:e.cbrs.state===CONST.CBRS_STATES.REGD?e.cbrs&&!_.isEmpty(e.cbrs.grant_states)&&Object.values(e.cbrs.grant_states).every(e=>CONST.GRANTED_STATES.includes(e))?this.progress.success+=1:this.progress.inProgress+=1:e.cbrs.state===CONST.CBRS_STATES.REG_FAIL||e.cbrs.state===CONST.CBRS_STATES.DEREG_FAIL?this.progress.failed+=1:e.cbrs.state===CONST.CBRS_STATES.DEREGD?this.progress.remaining+=1:e.cbrs.state===CONST.CBRS_STATES.HALT&&(this.progress.failed+=1),this.progress.total+=1});var t={cid:this.cid,jobId:this.jobId,status:"Processing",message:"The job is in progress",data:{progress:this.progress}};return this.amqpClient.publish("scheduled.jobs","scheduled.response",t),_.isEmpty(r)||(t={cid:this.cid,jobId:this.jobId,devices:r},this.amqpClient.publish("cbrs.inbound","cbrs.reg.progress",t)),{status:!0}}catch(e){return logger.error("Error in sending status notification to ui and job ",e),{status:!1}}}handleDeRegMacs(s,a){return new Promise(t=>{try{let e;var r={cid:this.cid,mcid:this.mcid};commonUtils.fetchCbrsTokenUrl(this.cid).then(o=>o.error?(logger.error("Error in fetching cbrs user credentials for mac",s,this.cid),void t({error:"Error in fetching cbrs user credentials for user:"+this.cid})):(e=Array.isArray(s)?db.getDevData(s,r,!0):db.getSectorAllDevices({mac:s},{cid:this.cid,mcid:this.mcid},!0),void e.then(r=>{if(!r)return t({error:"Error in de-registering sector devices"});let i=[],c=[];async.whilst(e=>{r.hasNext(e)},s=>{r.next(async(e,r)=>{if(e||!r)return s();await lock.acquireDeviceLockWithRetry(r.mac,CONST.LOCK_ACTION.DEREG)||(logger.error(`De-register request for mac: ${r.mac} could not be requested since could not acquire lock`),c.push(r.mac),s());let t=new DeviceStateManager(r,{token:o.token,proxyUrl:o.proxyUrl});t.cbrsDeRegistionMessageByMac().then(e=>{(!(e&&e.error&&_.isString(e.error))||e.error.includes("103")&&e.error.toLowerCase().includes("cbsd")||e.error.includes("SAS CBSD Id not found")?i:c).push(r.mac),s()})})},()=>{logger.info(`De-reg done for ${i.length}, failed for ${c.join(",")}`),r&&r.close(),this.updateDeRegStatus(i,a,!1).then(()=>_.isEmpty(c)?Promise.resolve():this.updateDeRegStatus(c,a,!0)).then(()=>{t()}).finally(()=>{_.isEmpty(i)||lock.releaseDeviceLock(i,CONST.LOCK_ACTION.DEREG),_.isEmpty(c)||lock.releaseDeviceLock(c,CONST.LOCK_ACTION.DEREG)})})})))}catch(e){return{error:e}}})}async updateDeRegStatus(e,r,t){if(!_.isEmpty(e)){var s={mac:{$in:e}},i={mac:{$in:e}},c={$set:{"cbrs.state":t?CONST.CBRS_STATES.DEREG_FAIL:CONST.CBRS_STATES.DEREGD,"cbrs.sync":CONST.CBRS.SYNC_STATUS.NOT_SYNCED,"cbrs.grant_states":{}}};try{return await db.updateDocInInventory({cid:this.cid,mcid:this.mcid},s,c),await db.updateDocInExt({cid:this.cid,mcid:this.mcid},i,{$set:{"cbrs.grantIds":{},"cbrs.respErrData":r||""},$unset:{"cbrs.cbsdID":1,"cbrs.grantExp":1,"cbrs.txExp":1,"cbrs.respErrCode":1,"cbrs.comment":1,"cbrs.config.radio.grantEIRP":1,"cbrs.cbsdIDTime":1}}),!0}catch(e){return logger.error("Error in updating de-reg status to collection",e),!1}}return!1}async storeInRedis(){try{var s=this.ecgi||this.mac,s=commonUtils.getHeartBeatRediskey(s);const c=utils.promisify(commonCache.getAll.bind(commonCache));var i=await c(s);const o=utils.promisify(commonCache.expire.bind(commonCache));await o(s,CONST.HEARTBEAT_REDIS_EXPIRE_TIME_IN_SEC),i=_.mapValues(i,JSON.parse);let r={},e,t;e=this.apDoc.cbrs.sync?_.get(this.apDoc,"radio.chWidth").split(" ")[0]:parseInt(_.get(this.apDoc,["ext","cbrs","config","radio","chBw"],"10")),t=this.apDoc.cbrs.sync?_.get(this.apDoc,["radio","rfFreq"]):_.get(this.apDoc,["ext","cbrs","config","radio","centerFreq"]),r.ap={mac:this.apDoc.mac,cid:this.apDoc.cid,ecgi:this.apDoc.ecgi,mode:this.apDoc.mode,model:this.apDoc.model,eType:this.apDoc.eType,sn:this.apDoc.sn,pmac:this.apDoc.pmac,sas:this.sasVendor,state:this.apDoc.cbrs.state,radio:_.get(this.apDoc,["ext","cbrs","config","radio"],{}),grantStates:_.pickBy(this.apDoc.cbrs.grant_states,e=>CONST.GRANTED_STATES.includes(e)),sync:this.apDoc.cbrs.sync,cbsdid:_.get(this.apDoc,["ext","cbrs","cbsdID"]),grantIds:_.pickBy(_.get(this.apDoc,"ext.cbrs.grantIds"),e=>CONST.GRANTED_STATES.includes(e.state)),chBw:e,centerFreq:t,cbsdTime:_.get(this.apDoc,["ext","cbrs","cbsdIDTime"])},Object.values(this.storeDevDataInRedis).forEach(e=>{this.validateGrantAndUpdCache(e,r,i)});const a=utils.promisify(commonCache.set.bind(commonCache));return r=_.mapValues(r,JSON.stringify),await a(s,r),await o(s,CONST.HEARTBEAT_REDIS_EXPIRE_TIME_IN_SEC),{error:null,status:!0}}catch(e){return logger.error("Error in storing sector data to cache on cbrs procedure run",e),{error:e,status:null}}}validateGrantAndUpdCache(r,t,e){var{mode:s,mac:i}=r;if(![CONST.MODE_AP,CONST.MODE_RRH].includes(s)){var c=r.cbrs.sync;if(Object.values(r.cbrs.grant_states||{}).some(e=>CONST.GRANTED_STATES.includes(e))&&0===c)if(Object.keys(e[i]||{}).length){s=_.pickBy(r.cbrs.grant_states,e=>CONST.GRANTED_STATES.includes(e)),c=_.pickBy(_.get(r,["ext","cbrs","grantIds"]),e=>CONST.GRANTED_STATES.includes(e.state));t[i]=Object.assign({},e[i],{state:r.cbrs.state,sync:r.cbrs.sync,grantStates:s||{},grantIds:c||{}})}else{let e;e=r.cbrs&&r.cbrs.sync?_.get(this.apDoc,"radio.chWidth").split(" ")[0]:parseInt(_.get(this.apDoc,["ext","cbrs","config","radio","chBw"],"10")),t[i]={eType:r.eType,mac:r.mac,mode:r.mode,sn:r.sn,pmac:r.pmac,ecgi:r.ecgi,state:r.cbrs.state,sync:r.cbrs.sync,model:r.model,chBw:e,radio:_.get(r,["ext","cbrs","config","radio"],{}),grantStates:_.pickBy(r.cbrs.grant_states,e=>CONST.GRANTED_STATES.includes(e)),cbsdid:_.get(r,["ext","cbrs","cbsdID"]),grantIds:_.pickBy(_.get(r,["ext","cbrs","grantIds"]),e=>CONST.GRANTED_STATES.includes(e.state)),cbsdTime:_.get(r,["ext","cbrs","cbsdIDTime"])}}else e[i]&&(t[i]={})}}}module.exports={CBRSProcedure:CBRSProcedure,initialize:initialize};