"use strict";const utils=require("util"),async=require("async"),_=require("lodash"),db=require("../common/mongo"),CONST=require("../common/constants"),commonUtils=require("../common/utils"),RedisCache=require("../common/redis/commonCache"),Lock=require("../common/redis/lock"),{DeviceStateManager:DeviceStateManager}=require("./stateEngine"),logger=require("../common/logger").getLogger("cns-cbrs-tool.api");let commonCache,lockCache,config;function initialize(r){config=r.config,commonCache=new RedisCache({db:"common",redis:config.redis}),lockCache=new Lock({db:"common",redis:config.redis})}async function runSpectrumEnquiry(r){var{cid:e,mac:t}=r;try{var c=await db.getApDocForSpectrumEquiry(e,t);if(!c)return logger.error("unable to find ap doc during spectrum enquiry for mac ",t,e),{error:"Ap doc does not exists"};var{error:o,token:i,proxyUrl:n}=await commonUtils.fetchCbrsTokenUrl(e);if(o)return{error:o};let r=new DeviceStateManager(c,{token:i,proxyUrl:n});var{cbrs:a,mode:o,extDev:i,ext:n}=c;if([CONST.MODE_AP,CONST.MODE_RRH].includes(o)){if(o===CONST.MODE_RRH&&i)return{error:"Can't run Spectrum Inquiry on RRH(Non-Cambium)"};if(a.sync===CONST.CBRS.SYNC_STATUS.CONFIG_SYNCED){if(!_.get(c,["cbrsLiveStatus","ext","cbrs","cbsdID"],null))return{error:"Live cbsd id is not available"}}else{if(["UNREG","REG_FAIL","DEREG","DEREGD"].includes(a.state))return{error:"Incorrect CBSD State"};if(["HALT"].includes(a.state)&&!n.cbrs.cbsdID)return{error:"Cbsd Id is missing for Spectrum enquiry"}}return await r.runSpectrumEnquiry()}return{error:"Spectrum Inquiry can be performed on AP/BHM/RRH only"}}catch(r){return logger.error("Error occured while running spectrum enquiry for mac ",t,r),{error:r}}}async function runCoexregistration(r){let t,{cid:c,pmac:o,force:i,mcid:n}=r;n=n||CONST.MSP_ACC.SUPER_ADMIN_MCID;try{if([t]=await db.getSectorApData(o,{cid:c,mcid:n}),!t)return{error:"Ap doc does not exists"};if(t.mode===CONST.MODE_RRH&&t.extDev)return{error:"external device not supported"};var{error:a,token:s,proxyUrl:u}=await commonUtils.fetchCbrsTokenUrl(c);if(a)return logger.error("Error in fetching cbrs token id ",a),{error:a};var{ext:d}=t,a=await commonUtils.fetchSaSid(c);if(a.error)return logger.error("Error in fetching sas id for cid",c,a.error,a),{error:"Unable to fetch sas id for sector, exiting procedure"};_.set(t,["ext","cbrs","config","userID"],a.sasId);a=await commonUtils.getSasVendor(c);if(a.error)return logger.error("Error in fetching sas vendor ",a.error),{error:"Unable to fetch sas vendor "};_.set(t,["ext","cbrs","sas"],a.sasVendor);let r;r=t.mode===CONST.MODE_RRH&&t.extDev?t.ecgi:t.mac.replace(":","").toLowerCase(),t.cbrs.sectorId=t.cbrs.sectorId||r;let e=new DeviceStateManager(t,{token:s,proxyUrl:u});if(!d.cbrs.cbsdID||i)if(e.isInSync())logger.warn("Device is already in sync state ",t.cbrs.sync,t.mac);else{e.setState("UNREG");s=await e.checkState();if(s.error)return s;u={cid:c,mac:e.getVal(["mac"]),"cbrs.sync":0},s={$set:{"cbrs.state":e.getVal(["cbrs","state"]),"cbrs.grant_states":e.getVal(["cbrs","grant_states"])}};await db.updateDocInInventory({cid:c,mcid:CONST.MSP_ACC.SUPER_ADMIN_MCID},u,s);u={cid:c,mac:e.getVal(["mac"])},s=e.getVal(["ext"]);await db.updateDocInExt({cid:c,mcid:CONST.MSP_ACC.SUPER_ADMIN_MCID},u,{$set:s})}return d.cbrs.cbsdID?{error:null,status:!0}:d.cbrs.respErrData?{error:d.cbrs.respErrData}:d.cbrs.comment?{error:d.cbrs.comment}:{error:"Registration request failed."}}catch(r){return logger.error("Error running coex registration for cid",c,r),{error:r}}}async function runDeRegister(r){var{mac:e,cid:t,ecgi:c}=r;try{var o=db.getSectorDevicesForDeReg(t,e,null),i=c||e,{error:n,token:a,proxyUrl:s}=await commonUtils.fetchCbrsTokenUrl(t);if(n)return{err:new Error("Error occured while getting creadential for the user")};var{error:u,sectorData:o,invUpdateList:a,extUpdateList:s}=await updateRedisForDereg(i,await iterateEachDevForDeReg(o,{token:a,proxyUrl:s}));if(u)return{status:!1,comment:"exception:::"+n};const d=utils.promisify(commonCache.set.bind(commonCache)),l=utils.promisify(commonCache.expire.bind(commonCache));i=commonUtils.getHeartBeatRediskey(i);return await d(i,o),await l(i,{expire:CONST.HEARTBEAT_REDIS_EXPIRE_TIME_IN_SEC}),await db.doInvBulkOp(t,a),await db.doExtBulkOp(t,s),{status:!0,comment:""}}catch(r){return{status:!1,comment:"exception:::"+r}}}function iterateEachDevForDeReg(e,o){return new Promise(r=>{let c=[];async.eachOf(e,(e,t)=>{let r=new DeviceStateManager(e,o);r.deRegDevice().then(({status:r})=>{r&&c.push(e),t()})},()=>{r(c)})})}function updateRedisForDereg(r,a){return new Promise(n=>{if(!a||0===a.length)return n({status:!0,comment:""});commonCache.hgetall(commonUtils.getHeartBeatRediskey(r),(r,e)=>{r&&(logger.error("Erorr in getting cached data for de-reg ",r),n({error:r})),e=e?_.mapValues(e,JSON.parse):{};const t=_.without(Object.keys(e),["ap"]),c=e.ap;let o=[],i=[];a.forEach(r=>{o.push({updateOne:{filter:{mac:r.mac},update:{$set:{"cbrs.state":r.cbrs.state,"cbrs.sync":0}}}}),i.push({updateOne:{filter:{mac:r.mac},update:{$set:setExtFields(r)}}}),[CONST.MODE_RRH,CONST.MODE_AP].includes(r.mode)?(c.cbrs=r.cbrs,c.ext=r.ext):t.includes(r.mac)&&(e[r.mac]={})}),e=_.mapValues(e,JSON.stringify),n(e,o,i)})})}function setExtFields(r){var{ext:r}=r;return{"cbrs.lstUpd":_.get(r,["cbrs","lstUpd"],0),"cbrs.cbsdIDTime":_.get(r,["cbrs","cbsdIDTime"],null),"cbrs.cbsdID":_.get(r,["cbrs","cbsdID"],null),"cbrs.config.radio.chWidth":_.get(r,["cbrs","config","radio","chWidth"],null),"cbrs.config.radio.grantEIRP":_.get(r,["cbrs","config","radio","grantEIRP"],null),"cbrs.grantIds":_.get(r,["cbrs","grantIds"],{}),"cbrs.respErrData":_.get(r,["cbrs","respErrData"],null),"cbrs.txExp":_.get(r,["cbrs","txExp"],null),"cbrs.respErrCode":_.get(r,["cbrs","respErrCode"],null)}}async function fetchSaSId(r){var{cid:e}=r;try{return await commonUtils.fetchSaSid(e)}catch(r){return{error:r}}}async function runDeRegisterByMac(e){try{var{cid:r,cbsdid:t}=e;logger.debug("Dereg by MAC is requested",e);var{error:c,token:o,proxyUrl:r}=await commonUtils.fetchCbrsTokenUrl(r);if(c)return{error:c};if(!await lockCache.acquireDeviceLockWithRetry(e.mac,CONST.LOCK_ACTION.DEREG))return logger.error("Error performing dereg by MAC",e,"Unable to acquire lock"),{error:"Unable to acquire device lock. Please try again."};const i=new DeviceStateManager(e,{token:o,proxyUrl:r},{skipFccIdCheck:!0});t=await i.cbrsDeRegistionMessageByMac(t);return await lockCache.releaseDeviceLock(e.mac),logger.debug("Response to Dereg by MAC",e,t),t}catch(r){return logger.error("Error performing dereg by MAC",e,"Error is",r),{error:r}}}module.exports={runSpectrumEnquiry:runSpectrumEnquiry,runCoexregistration:runCoexregistration,fetchSaSId:fetchSaSId,runDeRegister:runDeRegister,runDeRegisterByMac:runDeRegisterByMac,initialize:initialize};