"use strict";const utils=require("util"),_=require("lodash"),{HttpClient:HttpClient}=require("../common/request"),db=require("./mongo"),CONST=require("./constants"),CBRS_MAPPING=require("./mapper/cbrsMapper.json"),RedisCache=require("./redis/commonCache");let commonCache,config;function initialize(e){config=e.config,commonCache=new RedisCache({db:"common",redis:config.redis})}async function fetchCbrsTokenUrl(n){var i=["systemConfig",n,CONST.MSP_ACC.SUPER_ADMIN_MCID].join(CONST.REDIS.KEY_SEPARATOR);try{let e=utils.promisify(commonCache.getAll.bind(commonCache)),r=await e(i);if(r&&r.cbrsToken)return{token:r.cbrsToken,proxyUrl:r.cbrsProxyUrl};if(r=await db.fetchCbrsTokenFromDb({cid:n,mcid:CONST.MSP_ACC.SUPER_ADMIN_MCID}),!r||!r.cbrsToken)return{error:"Token does not exists in db"};let t=utils.promisify(commonCache.set.bind(commonCache));return await t(i,r),{token:r.cbrsToken,proxyUrl:r.cbrsProxyUrl}}catch(e){return{error:e}}}async function fetchSaSid(e){var r=["sasid",e,CONST.MSP_ACC.SUPER_ADMIN_MCID].join(CONST.REDIS.KEY_SEPARATOR);try{let e=utils.promisify(commonCache.get.bind(commonCache));var t=await e(r);if(t)return{sasId:t}}catch(e){}let n,i;try{n=await fetchCbrsTokenUrl(e)}catch(e){}if(!n||!n.token)return{error:"Error occured while getting token and url for SaS Id"};try{var a=await HttpClient.validateMessage(n.token,n.proxyUrl);i=a.data.sasid}catch(e){return{error:e}}return i?(await setSaSid(e,i),{error:null,sasId:i}):{error:"SaS Id fetch returned empty result"}}async function setSaSid(e,r){var t=["sasid",e,CONST.MSP_ACC.SUPER_ADMIN_MCID].join(CONST.REDIS.KEY_SEPARATOR);try{let e=utils.promisify(commonCache.set.bind(commonCache));return await e(t,r)}catch(e){return null}}async function setSasVendor(e,r){var t=["sas",e,CONST.MSP_ACC.SUPER_ADMIN_MCID].join(CONST.REDIS.KEY_SEPARATOR);try{let e=utils.promisify(commonCache.set.bind(commonCache));return await e(t,r),!0}catch(e){return!1}}async function getSasVendor(r){var t,n,i=["sas",r,CONST.MSP_ACC.SUPER_ADMIN_MCID].join(CONST.REDIS.KEY_SEPARATOR);let a;try{let e=utils.promisify(commonCache.get.bind(commonCache));return a=await e(i),a||({token:t,proxyUrl:n}=await fetchCbrsTokenUrl(r),t&&(n=await HttpClient.validateMessage(t,n),a=n.data.sas,a&&await setSasVendor(r,a))),{sasVendor:a}}catch(e){return{error:e}}}function getApName(e){let{model:r,mode:t}=e;if(t===CONST.MODE_RRH)return e.get("extDev")?CONST.LTE_RRH_TP:r;if(t===CONST.MODE_AP){if("450"===r.toString())return CONST.PMP_450_CONNECTORIZED;if("450i"===r)return _.get(e,["ext","cbrs","config","ant","gainInt"],0)?CONST.PMP_450I_INTEGRATED:CONST.PMP_450I_CONNECTORIZED;if("450m"===r)return CONST.PMP_450M}return""}function getSmName(e){let{eType:r,model:t}=e;if(r===CONST.ETYPE_CNRANGER)return CONST.LTE_SM;if(r===CONST.ETYPE_PMP){e=_.get(e,["ext","cbrs","config","ant","gainInt"],0);if("450"===t.toString()){if(!e)return CONST.PMP_450_CONNECTORIZED;if(8===e)return CONST.PMP_450_INTEGRATED;if(19===e)return CONST.PMP_450_RUGGED_HIGH_GAIN}if("450i"===t)return e?CONST.PMP_450I_INTEGRATED:CONST.PMP_450I_CONNECTORIZED;if("450m"===t){if(20===e)return CONST.PMP_450B_HIGH_GAIN;if(14===e)return CONST.PMP_450B_MID_GAIN}if(t===CONST.PMP_450B_HIGH_GAIN)return CONST.PMP_450B_HIGH_GAIN}return""}function getDeviceName(e){var{mode:r}=e;return(![CONST.MODE_AP,CONST.MODE_RRH].includes(r)||e.opMode===CONST.OP_MODE_BHM?getSmName:getApName)(e)}function setEIRP(e){let{ext:r}=e;_.get(r,["cbrs","config","radio","reqEIRP"],null)||(_.has(r,["cbrs","config","radio"])||_.set(r,["cbrs","config","radio"],{}),_.has(r,["cbrs","config","radio","maxEIRP"])||(r.cbrs.config.radio.maxEIRP=getMaxEirp(e)),r.cbrs.config.radio.reqEIRP=r.cbrs.config.radio.maxEIRP)}function getMaxEirp(n){let i=getDeviceName(n);i=i.toLowerCase().split(" ").join("_");var a=_.get(n,["ext","cbrs","config","radio","chWidth"]),o=_.get(n,["ext","cbrs","config","ant","gainExt"]),s=_.get(CBRS_MAPPING,["device","cbrsFields",i],null);if(!s)return CONST.DEFAULT_MAX_EIRP;try{let e=s.txPower,r=s.antGainInt,t=s.fccGrant;n.mode===CONST.MODE_AP&&s.apOverride&&(e=s.apOverride.txPower,r=s.apOverride.antGainInt,t=s.apOverride.fccGrant);var c=_.get(CBRS_MAPPING,["device","cbrsFields",i,"txPowerPerChBw"],null);c&&!_.isNil(c[`${a}`])&&(e=c[`${a}`]);var C=_.get(CBRS_MAPPING,["device","cbrsFields",i,"mimoGain"],null);_.isNil(C)||(e+=C);c=e+r+o,C=47+10*Math.log(a/10);return t+=10*Math.log10(a/10),Math.round(Math.min([c,C,t])/10)}catch(e){return CONST.DEFAULT_MAX_EIRP}}function getHeartBeatRediskey(e){return _.get(config,["cbrs","heartbeat_redis_key"])+e.replace(/:/g,"-")}function sleep(t){return new Promise((e,r)=>{setTimeout(()=>{e()},1e3*t)})}function fetchFccId(e){let r,{mode:t,eType:n,model:i,opMode:a}=e;return r=t===CONST.MODE_AP&&"450"===i?a&&a===CONST.OP_MODE_BHM?CONST.FCC_CODE_MAP.PMP450SM:CONST.FCC_CODE_MAP.PMP450AP:t===CONST.MODE_AP&&"450m"===i?CONST.FCC_CODE_MAP.PMP450mAP:t===CONST.MODE_SM&&"450"===i?CONST.FCC_CODE_MAP.PMP450SM:"450i"===i?CONST.FCC_CODE_MAP.PMP450i:"450b High Gain"===i?CONST.FCC_CODE_MAP.PMP450bHIGHGAIN:t===CONST.MODE_RRH&&n===CONST.ETYPE_CNRANGER?CONST.FCC_CODE_MAP.LTEPALISADE210RRH:t===CONST.MODE_SM&&n===CONST.ETYPE_CNRANGER?CONST.FCC_CODE_MAP.LTETYNDALL201SM:(t===CONST.MODE_RRH&&e.extDev,null),r}function updateObj(e,r){var[r,t,n]=r;switch(r){case"delete":delete e[t];break;case"set":_.set(e,t,n);break;default:_.set(e,t,n)}}function convertToPerdBmPerMhz(e,r){return Math.trunc(100*parseFloat(e)-100*CONST.EIRP_OFFSET_PER_1MHZ[r])/100}function convertTodBm(e,r){return CONST.EIRP_OFFSET_PER_1MHZ[r]?Math.trunc(100*parseFloat(e)+100*CONST.EIRP_OFFSET_PER_1MHZ[r])/100:0}function setResponseErrorCodeData(e){let r,t=_.get(e,["responseCode"],"");return r=e.responseMessage?Array.isArray(e.responseMessage)?e.responseMessage.join("|"):e.responseMessage:e.responseData?Array.isArray(e.responseData)?e.responseData.join("|"):e.responseData:(t=t.toString(),CONST.HTTP_CODES_TO_MSG[t]),`${t}[${r}]`}module.exports={getHeartBeatRediskey:getHeartBeatRediskey,getMaxEirp:getMaxEirp,getSasVendor:getSasVendor,fetchSaSid:fetchSaSid,fetchCbrsTokenUrl:fetchCbrsTokenUrl,setSaSid:setSaSid,setEIRP:setEIRP,sleep:sleep,initialize:initialize,fetchFccId:fetchFccId,updateObj:updateObj,convertToPerdBmPerMhz:convertToPerdBmPerMhz,convertTodBm:convertTodBm,setResponseErrorCodeData:setResponseErrorCodeData};