"use strict";const logger=require("../logger").getLogger("cns-cbrs-tool.simulatedResp"),resourceMap={"/registration":handleRegistrationRequest,"/grant":handleGrantRequest,"/heartbeat":handleHeartbeatRequest,"/relinquishment":handleRelinqRequest,"/spectrumInquiry":handleSpecInqRequest,"/deregistration":hanldeDeregRequest,"/deregistration/unk-cbsdid":hanldeDeregRequest},flowMap={"/registration":{code:-1,type:"reg",cnt:-1,offset:0},"/grant":{code:-1,type:"grant",cnt:-1,offset:0},"/heartbeat":{code:"502",type:"hrbt",cnt:-1,offset:1},"/relinquishment":{code:-1,type:"relg",cnt:-1,offset:0},"/spectrumInquiry":{code:"circularRef",type:"spIq",cnt:-1,offset:0}},allowCnt={};async function handleReq(s,e){logger.info("Received request to respond from simulated response handler",s,e);try{var r=flowMap[s.endPoint];if(resourceMap[s.endPoint]){try{s.payload=JSON.parse(s.payload)}catch(e){}r=resourceMap[s.endPoint](s.payload,r);return r.error?{error:r.error}:{data:r,headers:{}}}throw new Error(`Unsupported endpoint ${s.endPoint}`)}catch(e){throw logger.error("Error sending simulated response to request",s,"Error:",e),e}}function handleRegistrationRequest(e,s){var r=e.registrationRequest[0].fccId+e.registrationRequest[0].cbsdSerialNumber;let t,n="0";switch(s&&-1!==s.code&&0!==allowCnt[s.type]&&(s.offset?s.offset--:(n=s.code,allowCnt[s.type]||(allowCnt[s.type]=s.cnt||1),allowCnt[s.type]--)),n){case"0":t={registrationResponse:[{cbsdId:r,response:{responseCode:0},measReportConfig:["RECEIVED_POWER_WITHOUT_GRANT"]}]};break;case"RATE-LIMIT-DP-ERR":t={error:{data:{code:"RATELIMIT",error:"High rate of requests"},status:429,statusText:"Too Many Requests"}};break;case"PMAC_NOT_MATCHED":t={error:{data:{code:"PMC",error:""},status:409,statusText:"Parent mac mismatched"},status:409,statusText:"Parent mac mismatched"};break;case"DEREGALL":t={error:{data:{code:"DE_REG_ALL",error:"Account inactive - De-register sector"},status:412,statusText:"Too Many Requests"}};break;case"429":t={code:429,error:"custom domain proxy error "};break;case"103":t={registrationResponse:[{cbsdId:r,response:{responseCode:103,responseData:"cbsid error"},measReportConfig:["RECEIVED_POWER_WITHOUT_GRANT"]}]};break;case"102":t={registrationResponse:[{response:{responseCode:102,responseMessage:"cbsdId"}}]};break;default:t={registrationResponse:[{cbsdId:r,response:{responseCode:0},measReportConfig:["RECEIVED_POWER_WITHOUT_GRANT"]}]}}return t}let grantCnt=1;function handleGrantRequest(e,s){var r=e.grantRequest[0].cbsdId,e=e.grantRequest[0].operationParam.operationFrequencyRange.lowFrequency,t=(new Date).toISOString(),n=r+e;let a,o="3550000000"===e?"0":"0";s&&-1!==s.code&&0!==allowCnt[s.type]&&(s.offset?s.offset--:(o=s.code,allowCnt[s.type]||(allowCnt[s.type]=s.cnt||1),allowCnt[s.type]--));var i=Date.now();switch(o){case"0":a={grantResponse:[{channelType:"GAA",grantId:n,response:{responseCode:0},cbsdId:r,grantExpireTime:t,heartbeatInterval:200}]};break;case"RATE-LIMIT-DP-ERR":a={error:{data:{code:"RATELIMIT",error:"High rate of requests"},status:429,statusText:"Too Many Requests"}};break;case"DEREGALL":a={error:{data:{code:"DE_REG_ALL",error:"Account inactive - De-register sector"},status:412,statusText:"Too Many Requests"}};break;case"PMAC_NOT_FOUND":a={error:{data:{code:"PMC",error:""},status:409,statusText:"Parent mac mismatched"},status:409,statusText:"Parent mac mismatched"};break;case"0withOP":a={grantResponse:[{channelType:"GAA",grantId:n,response:{responseCode:0},cbsdId:r,grantExpireTime:t,heartbeatInterval:200,operationParam:{maxEirp:16,operationFrequencyRange:{lowFrequency:365e7,highFrequency:366e7}}}]};break;case"400withOP":a={grantResponse:[{cbsdId:r,response:{responseCode:400,responseMessage:"Resp with IAP provided operation param"},operationParam:{maxEirp:5,operationFrequencyRange:{lowFrequency:365e7,highFrequency:366e7}}}]};break;case"400":a={grantResponse:[{cbsdId:r,response:{responseCode:400,responseMessage:"Resp with IAP provided operation param"}}]};break;case"401":a={grantResponse:[{cbsdId:r,response:{responseData:["Z8H89FT0028/0fb6e2412d5f6f9ff5288423b8b895e19de9117c/"+i],responseCode:401,responseMessage:`Existing grant with ID 'Z8H89FT0028/0fb6e2412d5f6f9ff5288423b8b895e19de9117c/${i} overlaps with the requested frequency range`}}]};break;case"401withOP":a={grantResponse:[{cbsdId:r,response:{responseData:["Z8H89FT0028/0fb6e2412d5f6f9ff5288423b8b895e19de9117c/"+i],responseCode:401,responseMessage:`Existing grant with ID 'Z8H89FT0028/0fb6e2412d5f6f9ff5288423b8b895e19de9117c/${i}' overlaps with the requested frequency range`},operationParam:{maxEirp:16,operationFrequencyRange:{lowFrequency:365e7,highFrequency:366e7}}}]};break;case"106":a={grantResponse:[{response:{responseCode:106,responseMessage:"RESEND"}}]};break;case"103":a={grantResponse:[{response:{responseCode:103,responseMessage:"cbsdId"}}]};break;case"102":a={grantResponse:[{response:{responseCode:102,responseMessage:"cbsdId"}}]};break;default:a={grantResponse:[{cbsdId:r,grantId:n,response:{responseCode:0},measReportConfig:["RECEIVED_POWER_WITHOUT_GRANT"]}]}}return a}function handleHeartbeatRequest(e,a){const s=e.heartbeatRequest;let o="0",i=!1;if(logger.info(`[Request] - Heartbeat  (${JSON.stringify(s)})`),a&&["RATE-LIMIT-DP-ERR","DEREGALL","PMAC_NOT_MATCHED","CONNECTION_ERROR"].includes(a.code)&&0!==allowCnt[a.type]&&(a.offset?(i=!0,a.offset--):(o=a.code,allowCnt[a.type]||(allowCnt[a.type]=a.cnt||1),allowCnt[a.type]--)),"RATE-LIMIT-DP-ERR"===o)return{error:{data:{code:"RATELIMIT",error:"High rate of requests"},status:429,statusText:"Too Many Requests"},status:429,statusText:"Too Many Requests"};if("DEREGALL"===o)return{error:{data:{code:"DE_REG_ALL",error:"Account inactive - De-register sector"},status:412,statusText:"Account inactive - De-register sector"},status:412,statusText:"Account inactive - De-register sector"};if("PMAC_NOT_MATCHED"===o)return{error:{data:{code:"PMC",error:""},status:409,statusText:"Parent mac mismatched"},status:409,statusText:"Parent mac mismatched"};if("DEVICE_IS_ACTIVE"===o)return{error:{data:{code:"DEVICE_IS_ACTIVE",error:""},status:409,statusText:"CBRS active on device. Tool is not permitted"},status:409,statusText:"CBRS active on device. Tool is not permitted"};if("CONNECTION_ERROR"===o)return{error:{data:{code:"CONNECTION_ERROR",error:""},status:404,statusText:"CBRS active on device. Tool is not permitted"},status:404,statusText:"CBRS active on device. Tool is not permitted"};e={heartbeatResponse:s.map(e=>{logger.info(`[Request] - Heartbeat  (${JSON.stringify(e)})`);var s=e.cbsdId;const r=e.grantId;var t=new Date(Date.now()+36e5).toISOString();let n;switch(r.includes("3550000000")&&(o="0"),a&&-1!==a.code&&0!==allowCnt[a.type]&!i?a.offset?a.offset--:(o=a.code,allowCnt[a.type]||(allowCnt[a.type]=a.cnt||1),allowCnt[a.type]--):o="0",o){case"0":n={cbsdId:s,response:{responseCode:0},grantId:r,transmitExpireTime:t,heartbeatInterval:200};break;case"0withOP":n={cbsdId:s,response:{responseCode:0},grantId:r,transmitExpireTime:Date.now()+864e5,operationParam:{maxEirp:21,operationFrequencyRange:{lowFrequency:365e7,highFrequency:366e7}}};break;case"dp400":n={code:400,error:"pmac is missing"};break;case"501ICP":n={cbsdId:s,response:{responseCode:501,responseData:["Interference Calculations Pending"],responseMessage:"SUSPENDED_GRANT: Interference Calculations Pending"},grantId:r,transmitExpireTime:t};break;case"501SDG":n={cbsdId:s,response:{responseCode:501,responseData:["Interference Calculations Pending"],responseMessage:"SUSPENDED_GRANT: Interference Calculations Pending"},grantId:r,transmitExpireTime:t,operationParam:{maxEirp:21}};break;case"401":n={cbsdId:s,response:{responseData:["Z8H89FT0028/0fb6e2412d5f6f9ff5288423b8b895e19de9117c/"+r],responseCode:401,responseMessage:`Existing grant with ID 'Z8H89FT0028/0fb6e2412d5f6f9ff5288423b8b895e19de9117c/${r} overlaps with the requested frequency range`}};break;case"501IAP":n={cbsdId:s,response:{responseCode:501,responseData:["IAP Pending"],responseMessage:"SUSPENDED_GRANT: IAP Pending"},grantId:r,transmitExpireTime:t};break;case"501IAPO":n={cbsdId:s,response:{responseCode:501,responseData:["IAP Pending","Other"],responseMessage:"SUSPENDED_GRANT: IAP Pending, Other"},grantId:r,transmitExpireTime:t};break;case"500NO":n={cbsdId:s,response:{responseCode:500,grantId:r,transmitExpireTime:t}};break;case"500FWOP":n={cbsdId:s,response:{responseCode:500,responseData:["code:1102","message:Use recommended EIRP and channel (IAP)"]},grantId:r,transmitExpireTime:t,operationParam:{maxEirp:21,operationFrequencyRange:{lowFrequency:365e7,highFrequency:366e7}}};break;case"500GLOP":n={cbsdId:s,response:{responseCode:500,responseMessage:"TERMINATED_GRANT"},grantId:r,transmitExpireTime:t,operationParam:{maxEirp:20,operationFrequencyRange:{lowFrequency:365e7,highFrequency:366e7}}};break;case"500GLOPFREQ":n={cbsdId:s,response:{responseCode:500,responseMessage:"TERMINATED_GRANT"},grantId:r,transmitExpireTime:t,operationParam:{maxEirp:20,operationFrequencyRange:{lowFrequency:356e7,highFrequency:357e7}}};break;case"500GLEIRP":n={cbsdId:s,response:{responseCode:500,responseMessage:"TERMINATED_GRANT"},grantId:r,transmitExpireTime:t,operationParam:{maxEirp:2}};break;case"500GL":n={cbsdId:s,response:{responseCode:500,responseMessage:"TERMINATED_GRANT"},grantId:r,transmitExpireTime:t};break;case"502":n={cbsdId:s,response:{responseCode:502,responseMessage:"UNSYNC_OP_PARAM"},grantId:r,transmitExpireTime:t};break;case"501FW":n={cbsdId:s,response:{responseCode:501,responseData:["Interference Calculations Pending"]},grantId:r,transmitExpireTime:t};break;case"501FWOP":n={cbsdId:s,response:{responseCode:501,responseData:["Interference Calculations Pending"]},grantId:r,transmitExpireTime:t,operationParam:{maxEirp:2,operationFrequencyRange:{lowFrequency:365e7,highFrequency:366e7}}};break;case"103CBSD":n={cbsdId:s,response:{responseCode:103,responseData:"cbsdId"},grantId:r,transmitExpireTime:t};break;case"103GRANT":n={cbsdId:s,response:{responseCode:103,responseData:"grantId"},grantId:r,transmitExpireTime:t};break;default:n={cbsdId:s,response:{responseCode:0},grantId:r,transmitExpireTime:t,heartbeatInterval:200}}return n})};return logger.info(`[Response] - Bulk Heartbeat  (${JSON.stringify(e)})`),e}function handleRelinqRequest(e,s){var r=e.relinquishmentRequest[0].cbsdId,t=e.relinquishmentRequest[0].grantId;logger.info(`[Request] - Reqlinq  (${JSON.stringify(e)})`);let n="0",a;return s&&-1!==s.code&&0!==allowCnt[s.type]&&(s.offset?s.offset--:(n=s.code,allowCnt[s.type]||(allowCnt[s.type]=s.cnt||1),allowCnt[s.type]--)),a=(n,{relinquishmentResponse:[{cbsdId:r,response:{responseCode:0},grantId:t}]}),logger.info(`[Response] - Reqlinq  (${JSON.stringify(a)})`),a}function handleSpecInqRequest(e,s){let r=[];for(let e=3550;e<=3700;e++)r.push({frequencyRange:{highFrequency:1e7*e+1e7,lowFrequency:1e7*e},channelType:"GAA",ruleApplied:"FCC_PART_96"});let t="0";s&&-1!==s.code&&0!==allowCnt[s.type]&&(s.offset?s.offset--:(t=s.code,allowCnt[s.type]||(allowCnt[s.type]=s.cnt||1),allowCnt[s.type]--));var n=e.spectrumInquiryRequest[0].cbsdId;let a;switch(t){case"0":a={spectrumInquiryResponse:[{cbsdId:n,response:{responseCode:0},availableChannel:r}]};break;case"0MaxEirp":{r=[];let s=1;for(let e=3550;e<=3700;e++,s++)r.push({maxEirp:s,frequencyRange:{highFrequency:1e7*e+1e7,lowFrequency:1e7*e},channelType:"GAA",ruleApplied:"FCC_PART_96"});a={spectrumInquiryResponse:[{cbsdId:n,response:{responseCode:0},availableChannel:r}]};break}case"103":a={spectrumInquiryResponse:[{cbsdId:n,response:{responseCode:103,responseData:"cbsid error"},availableChannel:r}]};break;case"600":a={spectrumInquiryResponse:[{cbsdId:n,response:{responseCode:600,responseMessage:"don't know"},availableChannel:[]}]};break;case"circularRef":a={error:{data:{code:"CONNECTION_ERROR",error:""},status:404,statusText:"CBRS active on device. Tool is not permitted"},status:404,statusText:"CBRS active on device. Tool is not permitted"},a.error.resp=a;break;default:a={spectrumInquiryResponse:[{cbsdId:n,response:{responseCode:0},availableChannel:r}]}}return a}function hanldeDeregRequest(e){let s;return logger.info(`[Request] - Dereg  (${JSON.stringify(e)})`),s=e.deregistrationRequest?{deregistrationResponse:[{cbsdId:e.deregistrationRequest[0].cbsdId,response:{responseCode:0}}]}:{deregistrationResponse:[{response:{responseCode:0}}]},logger.info(`[Response] - Dereg  (${JSON.stringify(s)})`),s}module.exports={handleReq:handleReq};