"use strict";const _=require("lodash"),httpsProxyAgent=require("https-proxy-agent"),URL=require("url").URL,axios=require("axios"),CONST=require("../constants"),logger=require("../logger").getLogger("cns-cbrs-tool.request"),simResp=require("./simulatedResp");let SAS_URL,config,proxyAgentCache={};function initialize(e){config=e.config}function fetchSaSUrl(){if(SAS_URL)return SAS_URL;let e=_.get(config,["cbrs","sas_proxy_url"]);var t=e.length-1;return SAS_URL="/"===e[t]?e.slice(0,-1):e,SAS_URL}class DeviceHttpClient{constructor(e,t){var{mode:r,pmac:s,ecgi:a,eType:i}=e;this.device=e||{},this.sasInfo=t,this.pmpSeries=CONST.PMPCANOPY,this.pmac=s,(r===CONST.MODE_RRH||r===CONST.MODE_SM&&i===CONST.ETYPE_CNRANGER)&&([this.pmpSeries,this.pmac]=[CONST.PMPLTE,`ECGI:${a}`])}getAgent(e){if(proxyAgentCache.url===e)return proxyAgentCache.proxyAgent;var t=new httpsProxyAgent(e);return proxyAgentCache={url:e,proxyAgent:t},proxyAgentCache.proxyAgent}getHeaders(){let{mac:e,mode:t,ecgi:r,pmac:s,sn:a,eType:i}=this.device;var o=e.replace(/:/g,"").toLowerCase();let n=(r||s||"").replace(/:/g,""),p,l;var c=process.env.deployment===CONST.BUILD_ENV.NOC?1:0;return n=i===CONST.ETYPE_CNRANGER?`ECGI:${r.replace(/:/g,"")}`:(s||"").replace(/:/g,""),t=[CONST.MODE_AP,CONST.MODE_RRH].includes(t)?"ap":"sm",l=`cbrs ${this.sasInfo.token}|${a}|${o}|${t}|${n}|1|${this.pmpSeries}|${c}`,p={"content-Type":"application/json","Accept-Encoding":null,"Cambium-Authorization":l.trim()},p}getGetUrl(e){let t=fetchSaSUrl();return[t,CONST.CBRS_PROTOCOL_VERSION,e.endPoint].join("")}sleep(r){return new Promise((e,t)=>{setTimeout(()=>{e()},1e3*r)})}isValidUrl(e){try{return new URL(e),!0}catch(e){return!1}}async sendRequest(s,a=0,i=0){var e=this.device.hbtimeout||CONST.SAS_REQ_TIMEOUT,o=this.getHeaders(),n=this.getGetUrl(s);let t,p=null;if(CONST.CBRS_LOCAL_RESPONSE)return simResp.handleReq(s,o);var r,l=Date.now();try{return t=this.sasInfo.proxyUrl&&this.isValidUrl(this.sasInfo.proxyUrl)?(r=this.getAgent(this.sasInfo.proxyUrl),logger.info("CBRS-REQ: Making request to URL",n,"with data",s.payload,"and headers",o,"with proxy",r&&r.proxy||"NA"," request Timeout",e),await axios({method:"POST",baseURL:n,headers:o,httpsAgent:r,proxy:!1,timeout:1e3*e,data:s.payload})):(logger.info("CBRS-REQ: Making request to URL",n,"with data",s.payload,"and headers",o,"without proxy"," sas info ",this.sasInfo),await axios({method:"POST",baseURL:n,headers:o,timeout:1e3*e,data:s.payload})),logger.info(`CBRS-REQ: Received response (in ${Date.now()-l} ms) to request`,n,"with data",s.payload,"and headers",o,t&&t.data),{error:null,data:t.data,postTimeOut:t.headers["HB-Timeout"]}}catch(e){let t;var c=e&&e.response&&e.response.data?e.response.data:e;if(logger.info("Received error on request to URL",n,"with data",s.payload,"and headers",o,"Error is",c),p=e.response?(t=e.response,e.response.status):(t=e,e.code),(500<=p||e&&!e.response)&&0<(a-=1))return await this.sleep(i),await this.sendRequest(s,a,i);let r=null;return r=e.message&&e.message.includes("Cannot connect to proxy.")?"http exception: cannot connect to proxy":e.message&&e.message.includes("Max retries exceeded with url")?"http exception: connection error after max retries":e.message||e,{statusCode:p,error:t,statusText:r}}}}class HttpClient{async validateMessage(e,t){let r=[fetchSaSUrl(),"validate"].join("/"),s={method:"GET",baseURL:r};return s.headers={"Cambium-Authorization":`cbrs ${e}`},t&&(t=new httpsProxyAgent(t),s.httpsAgent=t,s.proxy=!1),await axios(s)}}module.exports={DeviceHttpClient:DeviceHttpClient,HttpClient:new HttpClient,fetchSaSUrl:fetchSaSUrl,initialize:initialize};