!function(){"use strict";const a=require("lodash"),o=require("../logger").getLogger("cns-cbrs-tool.redis.lock"),c=require("util"),i=require("../utils");var n=require("../constants");function s(e){return"CBRS_DEV_LOCK:"+e.replace(/:/g,"-")}function e(e){let t=require("@cambium/cns-redis");this.redisStaticCon=t.getInstance(e)}e.prototype.readValue=function(t){return new Promise((r,i)=>{const e=this.redisStaticCon.getDB();if(!e)return i("Redis is down, Unable to serve key",t);e.get(t,(e,t)=>e?i(e):void r(t))})},e.prototype.setLockExpiry=function(t,o){return new Promise((r,i)=>{const e=this.redisStaticCon.getDB();if(!e)return i("Redis is down, Unable to serve key",t);e.expire(t,o,(e,t)=>e?i(e):void r(t))})},e.prototype.writeValue=function(e,t,r){var i=this.redisStaticCon.getDB();if(!i)return r("Redis is down, Unable to serve key",e);i.set(e,t,function(e,t){r(e,t)})},e.prototype.writeValueWithExpiry=function(e,t,r,i){var o=this.redisStaticCon.getDB();if(!o)return i("Redis is down, Unable to serve key",e);o.set(e,t,"EX",r,function(e,t){i(e,t)})},e.prototype.writeValueClearExpiry=function(t,r,i){var o=this.redisStaticCon.getDB();if(!o)return i("Redis is down, Unable to serve key",t);o.persist(t,e=>{o.set(t,r,i)})},e.prototype.acquire=function(i,e,o,n){var c=this.redisStaticCon.getDB();a.isFunction(e)?(n=e,e=null):a.isFunction(o)&&(n=o),o=o||{},e=a.isNull(e)||a.isUndefined(e)?Date.now():e,c.setnx(i,e,function(e,t){var r=!!t;e||!o.expire||!r&&o.expireIfAcquired?n(e,r):c.expire(i,o.expire,function(e){n(e,r)})})},e.prototype.releaseAll=function(e,t){var r=this.redisStaticCon.getDB();setTimeout(function(){r?r.eval('local keys = redis.call("keys", ARGV[1]); return #keys > 0 and redis.call("del", unpack(keys)) or 0',[0,e],t||a.noop):t&&t()},1e4)},e.prototype.release=function(e,r){this.redisStaticCon.getDB().del(e,function(e,t){r&&r(e,!!t)})},e.prototype.acquireTTLPromise=function(e,t,o){var n=this;return new Promise((r,i)=>{n.acquireTTL(e,t,o,(e,t)=>e?i(new Error(`${e}`)):r(t))})},e.prototype.acquireTTL=function(r,i,o,n){var e,t,c,s=this.redisStaticCon.getDB();if(a.isFunction(o)&&(n=o,o={}),e=o.value&&!a.isObject(o.value)?o.value:Date.now(),o.ts&&(t=parseInt(o.ts+i),(c=Date.now())<t&&(i=t-c)),i<0)return n("Invalid TTL value, "+i);s.setnx(r,e,function(e,t){1!==t&&!o.override||s.pexpire(r,i),n(e,!!t)})},e.prototype.acquireDeviceLock=async function(t,e=n.LOCK_ACTION.PROCEDURE){try{if(!t)return o.error("Lock requested without device mac",{mac:t,actionType:e}),!1;var r=s(t),i=e;if(o.debug("CBRS_DEV_LOCK: Lock requested",{mac:t,actionType:e}),await this.readValue(r)===e)return o.debug("CBRS_DEV_LOCK: Lock already exists for the action. Renewing the lock",{mac:t,actionType:e}),await this.setLockExpiry(r,60),!0;i="OK"===await this.acquireLockWithEx(r,i,60,{nx:!0});return o.debug("CBRS_DEV_LOCK: Lock status",{mac:t,actionType:e,isLockAcquired:i}),i}catch(e){return o.error("Error acquiring device lock for cbrs action",t,"Error is",e),!1}},e.prototype.acquireDeviceLockWithRetry=async function(e,t,r=0){return 2<r?(o.error("CBRS_DEV_LOCK: could not acquire device lock for deregistration after max retry",2,{mac:e,retryCnt:r}),!1):(o.debug("CBRS_DEV_LOCK: Device lock with retry is requested",{mac:e,retryCnt:r,actionType:t}),await this.acquireDeviceLock(e,t)?(o.debug("CBRS_DEV_LOCK: Acquired device lock",{mac:e,retryCnt:r,actionType:t}),!0):(await i.sleep(10),this.acquireDeviceLockWithRetry(e,t,++r)))},e.prototype.releaseDeviceLock=async function(t,e=n.LOCK_ACTION.PROCEDURE){try{var r=(t=!Array.isArray(t)?[t]:t).map(s);o.debug("CBRS_DEV_LOCK: Release of locks requested",{macs:t,actionType:e});const i=this.redisStaticCon.getDB();return await c.promisify(i.del.bind(i,...r))(),!0}catch(e){return o.error("Error releasing device lock for cbrs action",t,"Error is",e),!1}},e.prototype.acquireLockWithEx=function(e,t,r,{nx:i=!0}){const o=this.redisStaticCon.getDB();let n=[e,t=a.isObject(t)?JSON.stringify(t):t,"EX",r];return i&&n.push("NX"),c.promisify(o.set.bind(o,...n))()},e.prototype.acquireSharedLock=async function(e,t,r,{setExpiryOnlyIfNX:i=!0}){const o=this.redisStaticCon.getDB();t=await c.promisify(o.sadd.bind(o,e,t))();if(t||!i)try{await c.promisify(o.expire.bind(o,e,r))()}catch(e){}return t?c.promisify(o.scard.bind(o,e))():-1},e.prototype.releaseSharedLock=async function(e,t){const r=this.redisStaticCon.getDB();await c.promisify(r.srem.bind(r,e,t))();let i=0;try{i=await c.promisify(r.scard.bind(r,e))()}catch(e){}return i},e.prototype.getMLockInfo=function(t){return new Promise((r,i)=>{const e=this.redisStaticCon.getDB();e.mget(t,(e,t)=>{if(e)return i(e);try{return t=t.map(JSON.parse.bind(JSON)),r(t)}catch(e){}r(t)})})},e.prototype.getLockExpiry=function(t){return new Promise((r,i)=>{const e=this.redisStaticCon.getDB();e.ttl(t,(e,t)=>e?i(e):r(t))})},e.prototype.getSectorLock=function(e,r){return new Promise(t=>{this.acquireLockWithEx(e,Date.now(),r,{}).then(e=>{t(e)}).catch(()=>{t(!1)})})},e.prototype.releaseSectorLock=function(t){return new Promise(e=>{this.release(t,()=>{e(!0)})})},module.exports=e}();