Install with:
`npm install @cambium/cns-cbrs-tools`

# Note

Please make sure config, CONST is defined on top of the file before calling `require('@cambium/cns-cbrs-tools')` method.

# Usage Example

```javascript
const CbrsToolsModule = require('@cambium/cns-cbrs-tools');
const config = require('../lib/config');
const CONST = require('../common/constants');
const loggerModule = require('../common/logger');

function initialize(helper) {
  const cbrsTools = new CbrsToolsModule({ CONST, config: config, logger: loggerModule });
  cbrsTools.setAmqpClient(helper);
  cbrsTools.startHbtLoop();
}
```
