"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.RateLimiter=void 0;const EventEmitter=require("events"),async=require("async"),rules_1=__importDefault(require("./rules")),counter_1=require("./counter"),utils_1=require("../common/utils");class RateLimiter extends EventEmitter{constructor(e,t,i){super(),this.id=e,this.rules,this.db=t,this._config=i,this._config.enabled=null===i.enabled||void 0===i.enabled||!!i.enabled,i.sharedWeightEnabled&&(this._maxWeightHKey=["rl",e,"max-weights"].join(":"),this._maxSharedWeightHKey=["rl",i.sharedRateLimiterIds.join("-"),"shared-max-weights"].join(":"),this._shareDemandKey=["rl",i.sharedRateLimiterIds.join("-"),"shared-demand"].join(":")),this._weightCounter=new counter_1.Counter(this.db,["rl",e,"total_weight"].join(":"),["rl",e,"current_weight"].join(":")),this._config.weightSystemEnabled&&this._weightCounter.setMaxValue(this._config.totalWeight)}get enabled(){return this._config.enabled}get limitReachedHttpResCode(){return this._config.limitReachedHttpCode}get limitReachedResData(){return this._config.limitReachedResData}get serviceFailureHttpResCode(){return this._config.serviceFailureHttpResCode}get serviceFailureResData(){return this._config.serviceFailureResData}get weightReachedHttpResCode(){return this._config.weightReachedHttpResCode}get weightReachedHttpResData(){return this._config.weightReachedHttpResData}get isWeightSystemEnabled(){return this._config.weightSystemEnabled}rateOn(e=()=>""){return this.rules=new rules_1.default(this,e,{rateEnabled:!0,weightEnabled:!1}),this.rules}weightOn(e){return this.rules=new rules_1.default(this,e,{rateEnabled:!1,weightEnabled:!0}),this.rules}rateAndWeightOn(e){return this.rules=new rules_1.default(this,e,{rateEnabled:!0,weightEnabled:!0}),this.rules}defineKeyBasedMaxWeight(e){return new Promise((t,i)=>{this.db.hmset(this._maxWeightHKey,e,e=>e?i(e):void t())})}defineKeyBasedMaxSharedWeight(e){return new Promise((t,i)=>{this.db.hmset(this._maxSharedWeightHKey,e,e=>e?i(e):void t())})}updateConfig(e){return this._config=Object.assign(this._config,e),Promise.resolve()}get maxWeightHKey(){return this._maxWeightHKey}_addWeight(e,t,i){return this._config.sharedWeightEnabled?this._weightCounter.add(e,t,i,this.maxWeightHKey,this._config.fixedShareInPercent,{demandKey:this._shareDemandKey,priority:this._config.sharingPriority,maxSharedWtHKey:this._maxSharedWeightHKey,maxSharedWtKey:i,shareInPercent:this._config.shareInPercent,rlId:this.id}):this._weightCounter.add(e,t,i,this.maxWeightHKey,this._config.fixedShareInPercent)}_removeWeight(e,t,i){return this._config.sharedWeightEnabled?this._weightCounter.subtract(e,t,i,this.maxWeightHKey,this._config.fixedShareInPercent,{demandKey:this._shareDemandKey,priority:this._config.sharingPriority,maxSharedWtHKey:this._maxSharedWeightHKey,maxSharedWtKey:i,shareInPercent:this._config.shareInPercent,rlId:this.id}):this._weightCounter.subtract(e,t,i,this.maxWeightHKey,this._config.fixedShareInPercent)}_getHttpMethodWeight(e){switch(e.toLocaleUpperCase()){case"GET":return this._config.getWeight||0;case"POST":return this._config.postWeight||0;case"DELETE":return this._config.deleteWeight||0;case"PUT":return this._config.putWeight||0;case"PATCH":return this._config.patchWeight||0;default:return 0}}get logger(){return this._config.logger||console}static parseRate(e){return utils_1.Utils.parseRate(e)}}exports.RateLimiter=RateLimiter;