"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.Counter=void 0;class Counter{constructor(e,t,r){this.db=e,this.maxValueKey=t,this.currentValueKey=r}setMaxValue(e,t){return new Promise((r,a)=>{if(!e)return r(0);this.db.set(t||this.maxValueKey,e.toFixed(2),(e,t)=>{e?a(e):r("OK"==t?1:0)})})}add(e,t,l,n,d,i){return i?new Promise((r,a)=>{this.db.eval(Counter.SCRIPT_ADD,0,t||this.currentValueKey,l||this.maxValueKey,n||"null",e.toFixed(2),d||100,1,i.maxSharedWtKey,i.maxSharedWtHKey,i.shareInPercent,i.demandKey,i.priority,i.rlId,(e,t)=>{e?a(e):r(Number(t))})}):new Promise((r,a)=>{this.db.eval(Counter.SCRIPT_ADD,0,t||this.currentValueKey,l||this.maxValueKey,n||"null",e.toFixed(2),d||100,0,(e,t)=>{e?a(e):r(Number(t))})})}subtract(e,t,l,n,d,i){return i?new Promise((r,a)=>{this.db.eval(Counter.SCRIPT_SUBTRACT,0,t||this.currentValueKey,l||this.maxValueKey,n||"null",e.toFixed(2),d||100,1,i.maxSharedWtKey,i.maxSharedWtHKey,i.shareInPercent,i.demandKey,i.priority,i.rlId,(e,t)=>{e?a(e):r(Number(t))})}):new Promise((r,a)=>{this.db.eval(Counter.SCRIPT_SUBTRACT,0,t||this.currentValueKey,l||this.maxValueKey,n||"null",e,d||100,0,(e,t)=>{e?a(e):r(Number(t))})})}invalidate(){this.db=null}}exports.Counter=Counter,Counter.SCRIPT_ADD=`
    local currentWtKey = ARGV[1];
    local maxWtKey = ARGV[2];
    local maxWtHKey = ARGV[3];
    local weight = tonumber(ARGV[4]);
    local fixedShareInPercent = tonumber(ARGV[5]);
    local sharedWtEnabled = tonumber(ARGV[6]);
    local maxWt;

    if (maxWtHKey == 'null') then
      maxWt = tonumber(redis.call("get", maxWtKey));
    else
      maxWt = tonumber(redis.call("hget", maxWtHKey, maxWtKey));
    end

    if maxWt == nil then return 0 end

    maxWt = maxWt * fixedShareInPercent / 100;

    local currentWt = tonumber(redis.call("get", currentWtKey));
    if currentWt == nil then currentWt = 0 end

    if sharedWtEnabled == 1 then
      local currentWtSharedKey = currentWtKey .. 'shared';
      local maxSharedWtKey = ARGV[7];
      local maxSharedWtHKey = ARGV[8];
      local sharedInPercent = tonumber(ARGV[9]);
      local demandKey = ARGV[10];
      local priority = tonumber(ARGV[11]);
      local rlId = ARGV[12];

      if (currentWt + weight) <= maxWt then
        redis.call("INCRBYFLOAT", currentWtKey, weight);
        return 1;
      else
        local availableWtFromFixed = 0;

        if (maxWt - currentWt) < weight then 
          availableWtFromFixed = maxWt - currentWt;
          weight = weight - availableWtFromFixed;
        end

        local maxSharedWt = tonumber(redis.call("hget", maxSharedWtHKey, maxSharedWtKey));
        if maxSharedWt == nil then maxSharedWt = 0 end

        local usableShareWt = maxSharedWt * sharedInPercent / 100;
        local alreadyUsedSharedWt = tonumber(redis.call("get", currentWtSharedKey));

        if alreadyUsedSharedWt == nil then alreadyUsedSharedWt = 0 end

        if (alreadyUsedSharedWt + weight) <= usableShareWt then
          local topDemandRankRId = unpack(redis.call("ZREVRANGE", demandKey, 0, 0));

          if (topDemandRankRId == rlId) then
            redis.call("INCRBYFLOAT", currentWtKey, availableWtFromFixed);
            redis.call("INCRBYFLOAT", currentWtSharedKey, weight);
            return 1;
          end
        end

        redis.call("ZADD", demandKey, (usableShareWt / priority), rlId);
        return 0;
      end
  else 
    if (currentWt + weight) <= maxWt then
      redis.call("INCRBYFLOAT", currentWtKey, weight)
      return 1
    else
      return 0
    end
  end  
   `,Counter.SCRIPT_SUBTRACT=`
    local currentWtKey = ARGV[1];
    local maxWtKey = ARGV[2];
    local maxWtHKey = ARGV[3];
    local weight = tonumber(ARGV[4]);
    local fixedShareInPercent = tonumber(ARGV[5]);
    local sharedWtEnabled = tonumber(ARGV[6]);
    local maxWt;

    if (maxWtHKey == 'null') then
      maxWt = tonumber(redis.call("get", maxWtKey));
    else
      maxWt = tonumber(redis.call("hget", maxWtHKey, maxWtKey));
    end

    if maxWt == nil then return 0 end

    maxWt = maxWt * fixedShareInPercent / 100;

    local currentWt = tonumber(redis.call("get", currentWtKey));

    if (sharedWtEnabled == 1) then
      local currentWtSharedKey = currentWtKey .. 'shared'
      local maxSharedWtKey = ARGV[7];
      local maxSharedWtHKey = ARGV[8];
      local sharedInPercent = tonumber(ARGV[9]);
      local demandKey = ARGV[10];
      local priority = ARGV[11];
      local rlId = ARGV[12];
      
      local alreadyUsedSharedWt = tonumber(redis.call("get", currentWtSharedKey));
      local maxSharedWt = tonumber(redis.call("hget", maxSharedWtHKey, maxSharedWtKey));
      local usableShareWt = maxSharedWt * sharedInPercent / 100;

      if (alreadyUsedSharedWt == nil) then 
        alreadyUsedSharedWt = 0;
      end
      
      if (weight <= alreadyUsedSharedWt) then
        redis.call("INCRBYFLOAT", currentWtSharedKey, -weight);
      else
        redis.call("INCRBYFLOAT", currentWtSharedKey, -alreadyUsedSharedWt);
        redis.call("INCRBYFLOAT", currentWtKey, -(weight - alreadyUsedSharedWt));
      end

      redis.call("ZINCRBY", demandKey, -(usableShareWt / priority), rlId)
    else 
      if currentWt == nil then
        redis.call("set", currentWtKey, 0)
        return 1
      else
        if tonumber(redis.call("INCRBYFLOAT", currentWtKey, -weight)) < 0 then
          redis.call("set", currentWtKey, 0)
        end

        return 1
      end
    end
    `;