"use strict";const winston=require("winston"),fs=require("fs"),utils=require("./common/utils"),formats=require("./common/format"),configSchema=require("./schema/config.json"),path=require("path");let initialized=!1,loggerConfig={},isSpecialEnabled=!1;const ignoreExitCodes=["ENOTFOUND"];utils.compileSchema(configSchema);const getProcessLogger=()=>winston.loggers.get(process.name),getSpecialLogger=()=>winston.loggers.get("specialLogger"),checkLoggingLevel=(e,o)=>e.levels[e.level]>=e.levels[o];function Logger(){}Logger.getLogger=s=>{if(!initialized)throw new Error("Logger is not initialized");return new Proxy(getProcessLogger(),{get:(t,r)=>(...o)=>{if(t.writable){if("end"===r)return t&&t[r]?t[r](...o):void 0;let e=t[r];if(isSpecialEnabled&&getSpecialLogger()[r])e=getSpecialLogger()[r];else if(!checkLoggingLevel(t,r))return;return e(...o,{module:s})}}})},Logger.updateConfig=e=>{utils.validateConfig(e);var o=(loggerConfig=e).override||{};const t=getProcessLogger();t.warn(">>>>>>>>>>>>>> Logger configuration reloaded >>>>>>>>>>>>>>",{module:"logger"}),t.level=o[process.name]||e.level},Logger.syslog=()=>require("./syslog"),Logger.initialize=(o,t=!1)=>{if(!initialized){utils.validateConfig(o),loggerConfig=o;var r="production"===process.env.NODE_ENV,s=path.resolve(loggerConfig.filepath);fs.existsSync(s)||fs.mkdirSync(s);o=path.join(s,loggerConfig.fileInitial||"cns_"),s={access:o+(loggerConfig.fileNames.access||"access.log"),beta:o+(loggerConfig.fileNames.beta||"beta.log"),debug:o+(loggerConfig.fileNames.debug||"debug.log"),error:o+(loggerConfig.fileNames.error||"error.log"),exception:o+(loggerConfig.fileNames.exception||"exception.log"),info:o+(loggerConfig.fileNames.info||"info.log"),security:o+(loggerConfig.fileNames.security||"security.log"),stats:o+(loggerConfig.fileNames.stats||"stats.log"),watch:o+(loggerConfig.fileNames.watch||"watch.log")},o=loggerConfig.override||{};const i=utils.createTransportOpts([{opts:{filename:s.error,format:formats.filterFactory("critical")()},levels:["critical"]},{opts:{filename:s.error,format:formats.filterFactory("error")()},levels:["error"]},{opts:{filename:s.info,format:formats.filterFactory("warn")()},levels:["warn"]},{opts:{filename:s.info,format:formats.filterFactory("info")()},levels:["info"]},{opts:{filename:s.debug,format:formats.filterFactory("debug")()},levels:["debug"]},{opts:{filename:s.debug,format:formats.filterFactory("data")()},levels:["data"]}]);let e=i.map(e=>new winston.transports.File(e));r||(winston.addColors(loggerConfig.colors),e.push(new winston.transports.Console({format:formats.consoleFormat})),winston.add(new winston.transports.Console({handleExceptions:!0,format:formats.exceptionFormat}))),winston.add(new winston.transports.File({filename:s.exception,handleExceptions:!0,format:formats.exceptionFormat})),winston.exitOnError=e=>!ignoreExitCodes.includes(e.code),winston.loggers.add(process.name,{level:o[process.name]||loggerConfig.level,levels:loggerConfig.levels,format:formats.getDefaultFormat,defaultMeta:{app:process.name,wname:process.wname||process.title},transports:e}),t&&(isSpecialEnabled=!0,createSpecialLogger(s)),getProcessLogger().on("finish",()=>{setTimeout(()=>{process.exit(1)},500)}),initialized=!0}};const createSpecialLogger=e=>{const o=utils.createTransportOpts([{opts:{filename:e.watch,format:formats.filterFactory("watch")()},levels:["watch"]},{opts:{filename:e.beta,format:formats.filterFactory("beta")()},levels:["beta"]},{opts:{filename:e.access,format:formats.filterFactory("access")()},levels:["access"]},{opts:{filename:e.security,format:formats.filterFactory("security")()},levels:["security"]},{opts:{filename:e.stats,format:formats.filterFactory("stats")()},levels:["stats"]}]);winston.loggers.add("specialLogger",{level:"security",levels:{watch:0,beta:1,access:2,stats:3,security:4},format:formats.getDefaultFormat,defaultMeta:{app:process.name,wname:process.wname||process.title},transports:o.map(e=>new winston.transports.File(e))})};module.exports=Logger;