---
layout: "docs"
page_title: "Encryption"
sidebar_current: "docs-agent-encryption"
description: |-
  The Consul agent supports encrypting all of its network traffic. The exact method of encryption is described on the encryption internals page. There are two separate encryption systems, one for gossip traffic and one for RPC.
---

# Encryption

The Consul agent supports encrypting all of its network traffic. The exact
method of encryption is described on the [encryption internals page](/docs/internals/security.html).
There are two separate encryption systems, one for gossip traffic and one for RPC.
If you are configuring encryption, review this [guide](https://learn.hashicorp.com/consul/security-networking/agent-encryption).

## Gossip Encryption

Enabling gossip encryption only requires that you set an encryption key when
starting the Consul agent. The key can be set via the `encrypt` parameter.

~> **WAN Joined Datacenters Note:** If using multiple WAN joined datacenters, be sure to use _the same encryption key_ in all datacenters.

The key must be 32-bytes, Base64 encoded. As a convenience, Consul provides the
[`consul keygen`](/docs/commands/keygen.html) command to generate a
cryptographically suitable key:

```text
$ consul keygen
pUqJrVyVRj5jsiYEkM/tFQYfWyJIv4s3XkvDwy7Cu5s=
```

With that key, you can enable encryption on the agent. If encryption is enabled,
the output of [`consul agent`](/docs/commands/agent.html) will include "Encrypt: true":

```text
$ cat encrypt.json
{"encrypt": "pUqJrVyVRj5jsiYEkM/tFQYfWyJIv4s3XkvDwy7Cu5s="}

$ consul agent -data-dir=/tmp/consul -config-file=encrypt.json
==> WARNING: LAN keyring exists but -encrypt given, using keyring
==> WARNING: WAN keyring exists but -encrypt given, using keyring
==> Starting Consul agent...
==> Starting Consul agent RPC...
==> Consul agent running!
         Node name: 'Armons-MacBook-Air.local'
        Datacenter: 'dc1'
            Server: false (bootstrap: false)
       Client Addr: 127.0.0.1 (HTTP: 8500, HTTPS: -1, DNS: 8600, RPC: 8400)
      Cluster Addr: 10.1.10.12 (LAN: 8301, WAN: 8302)
    Gossip encrypt: true, RPC-TLS: false, TLS-Incoming: false
...
```

All nodes within a Consul cluster must share the same encryption key in
order to send and receive cluster information.

## Configuring Gossip Encryption on an existing cluster

As of version 0.8.4, Consul supports upshifting to encrypted gossip on a running cluster
through the following process. Review this [step-by-step guide](https://learn.hashicorp.com/consul/security-networking/agent-encryption#enable-gossip-encryption-existing-cluster) 
to encrypt gossip on an existing cluster.

## RPC Encryption with TLS

Consul supports using TLS to verify the authenticity of servers and clients. To enable this,
Consul requires that all clients and servers have key pairs that are generated by a single
Certificate Authority. This can be a private CA, used only internally. The
CA then signs keys for each of the agents, as in
[this tutorial on generating both a CA and signing keys](https://learn.hashicorp.com/consul/security-networking/certificates). 

TLS can be used to verify the authenticity of the servers or verify the authenticity of clients.
These modes are controlled by the [`verify_outgoing`](/docs/agent/options.html#verify_outgoing),
[`verify_server_hostname`](/docs/agent/options.html#verify_server_hostname),
and [`verify_incoming`](/docs/agent/options.html#verify_incoming) options, respectively.

If [`verify_outgoing`](/docs/agent/options.html#verify_outgoing) is set, agents verify the
authenticity of Consul for outgoing connections. Server nodes must present a certificate signed
by a common certificate authority present on all agents, set via the agent's
[`ca_file`](/docs/agent/options.html#ca_file) and [`ca_path`](/docs/agent/options.html#ca_path)
options. All server nodes must have an appropriate key pair set using [`cert_file`]
(/docs/agent/options.html#cert_file) and [`key_file`](/docs/agent/options.html#key_file).

If [`verify_server_hostname`](/docs/agent/options.html#verify_server_hostname) is set, then
outgoing connections perform hostname verification. All servers must have a certificate
valid for `server.<datacenter>.<domain>` or the client will reject the handshake. This is
a new configuration as of 0.5.1, and it is used to prevent a compromised client from being
able to restart in server mode and perform a MITM (Man-In-The-Middle) attack. New deployments should set this
to true, and generate the proper certificates, but this is defaulted to false to avoid breaking
existing deployments.

If [`verify_incoming`](/docs/agent/options.html#verify_incoming) is set, the servers verify the
authenticity of all incoming connections. All clients must have a valid key pair set using
[`cert_file`](/docs/agent/options.html#cert_file) and
[`key_file`](/docs/agent/options.html#key_file). Servers will
also disallow any non-TLS connections. To force clients to use TLS,
[`verify_outgoing`](/docs/agent/options.html#verify_outgoing) must also be set.

TLS is used to secure the RPC calls between agents, but gossip between nodes is done over UDP
and is secured using a symmetric key. See above for enabling gossip encryption.

## Configuring TLS on an existing cluster

As of version 0.8.4, Consul supports migrating to TLS-encrypted traffic on a running cluster
without downtime. This process assumes a starting point with no TLS settings configured and involves
an intermediate step in order to get to full TLS encryption. Review the
[Securing RPC Communication with TLS Encryption guide](https://learn.hashicorp.com/consul/security-networking/certificates)
for the step-by-step process to configure TLS on a new or existing cluster. Note the call outs there
for existing cluster configuration. 

