<img src="https://single-spa.js.org/img/logo-white-bgblue.svg" width="50" height="50">

[![npm version](https://img.shields.io/npm/v/single-spa.svg?style=flat-square)](https://www.npmjs.org/package/single-spa)
[![Build Status](https://img.shields.io/travis/single-spa/single-spa/master.svg?style=flat-square)](https://travis-ci.com/single-spa/single-spa)
[![](https://data.jsdelivr.com/v1/package/npm/single-spa/badge)](https://www.jsdelivr.com/package/npm/single-spa)
[![NPM Downloads](https://badgen.net/npm/dm/single-spa)](https://npmjs.org/package/single-spa)

# single-spa

[Join the chat on Slack](https://join.slack.com/t/single-spa/shared_invite/enQtODAwNTIyMzc4OTE1LWUxMTUwY2M1MTY0ZGMzOTUzMGNkMzI1NzRiYzYwOWM1MTEzZDM1NDAyNWM3ZmViOTAzZThkMDcwMWZmNTFmMWQ)

[Donate to this project](https://opencollective.com/single-spa)

## A javascript framework for front-end microservices

Build micro frontends that coexist and can ([but don't need to](https://single-spa.js.org/docs/faq.html#can-i-use-more-than-one-framework)) be written with their own framework. This allows you to:

- [Use multiple frameworks](/docs/single-spa-ecosystem.md#help-for-frameworks) on the same page [without refreshing the page](/docs/applications.md)
  ([React](https://github.com/single-spa/single-spa-react), [AngularJS](https://github.com/single-spa/single-spa-angular1), [Angular](https://github.com/single-spa/single-spa-angular2), [Ember](https://github.com/single-spa/single-spa-ember), or whatever you're using)
- Write new code, possibly with a new framework, without rewriting your existing app
- Lazy load code for improved initial load time.

## Documentation

You can find the single-spa documentation [on the website](https://single-spa.js.org/).

Check out the [Getting Started](https://single-spa.js.org/docs/getting-started-overview.html) page for a quick overview.

## Demo and examples

Please see the [examples page](https://single-spa.js.org/docs/examples.html) on the website.

## Want to help?

Want to file a bug, contribute some code, or improve documentation? Excellent! Read up on our
guidelines for [contributing](https://single-spa.js.org/docs/contributing-overview.html) on the [single-spa website](https://single-spa.js.org).

## Contributing

The main purpose of this repository is to continue to evolve single-spa, making it better and easier to use. Development of single-spa, and the [single-spa ecosystem](https://single-spa.js.org/docs/ecosystem.html) happens in the open on GitHub, and we are grateful to the community for contributing bugfixes and improvements. Read below to learn how you can take part in improving single-spa.

### [Code of Conduct](https://single-spa.js.org/docs/code-of-conduct.html)

Single-spa has adopted a Code of Conduct that we expect project participants to adhere to. Please read [the full text](https://single-spa.js.org/docs/code-of-conduct.html) so that you can understand what actions will and will not be tolerated.

### [Contributing Guide](https://single-spa.js.org/docs/contributing-overview.html)

Read our [contributing guide](https://single-spa.js.org/docs/contributing-overview.html) to learn about our development process, how to propose bugfixes and improvements, and how to build and test your changes to single-spa.
