import { Observable } from 'rxjs';
import { share } from 'rxjs/operators';
import * as io from 'socket.io-client';
var WrappedSocket = /** @class */ (function () {
    function WrappedSocket(config) {
        this.config = config;
        this.subscribersCounter = 0;
        this.emptyConfig = {
            url: '',
            options: {}
        };
        if (config === undefined)
            config = this.emptyConfig;
        var url = config.url;
        var options = config.options;
        var ioFunc = io.default ? io.default : io;
        this.ioSocket = ioFunc(url, options);
    }
    WrappedSocket.prototype.of = function (namespace) {
        this.ioSocket.of(namespace);
    };
    WrappedSocket.prototype.on = function (eventName, callback) {
        this.ioSocket.on(eventName, callback);
    };
    WrappedSocket.prototype.once = function (eventName, callback) {
        this.ioSocket.once(eventName, callback);
    };
    WrappedSocket.prototype.connect = function () {
        return this.ioSocket.connect();
    };
    WrappedSocket.prototype.disconnect = function (close) {
        return this.ioSocket.disconnect.apply(this.ioSocket, arguments);
    };
    WrappedSocket.prototype.emit = function (eventName, data, callback) {
        return this.ioSocket.emit.apply(this.ioSocket, arguments);
    };
    WrappedSocket.prototype.removeListener = function (eventName, callback) {
        return this.ioSocket.removeListener.apply(this.ioSocket, arguments);
    };
    WrappedSocket.prototype.removeAllListeners = function (eventName) {
        return this.ioSocket.removeAllListeners.apply(this.ioSocket, arguments);
    };
    WrappedSocket.prototype.fromEvent = function (eventName) {
        var _this = this;
        this.subscribersCounter++;
        return Observable.create(function (observer) {
            _this.ioSocket.on(eventName, function (data) {
                observer.next(data);
            });
            return function () {
                if (_this.subscribersCounter === 1)
                    _this.ioSocket.removeListener(eventName);
            };
        }).pipe(share());
    };
    WrappedSocket.prototype.fromOneTimeEvent = function (eventName) {
        var _this = this;
        return new Promise(function (resolve) { return _this.once(eventName, resolve); });
    };
    return WrappedSocket;
}());
export { WrappedSocket };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic29ja2V0LWlvLnNlcnZpY2UuanMiLCJzb3VyY2VSb290Ijoibmc6Ly9uZ3gtc29ja2V0LWlvLyIsInNvdXJjZXMiOlsic3JjL3NvY2tldC1pby5zZXJ2aWNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUNBLE9BQU8sRUFBRSxVQUFVLEVBQUUsTUFBTSxNQUFNLENBQUM7QUFDbEMsT0FBTyxFQUFFLEtBQUssRUFBRSxNQUFNLGdCQUFnQixDQUFDO0FBRXZDLE9BQU8sS0FBSyxFQUFFLE1BQU0sa0JBQWtCLENBQUM7QUFJdkM7SUFRSSx1QkFBb0IsTUFBc0I7UUFBdEIsV0FBTSxHQUFOLE1BQU0sQ0FBZ0I7UUFQMUMsdUJBQWtCLEdBQVksQ0FBQyxDQUFDO1FBRWhDLGdCQUFXLEdBQW1CO1lBQzFCLEdBQUcsRUFBRSxFQUFFO1lBQ1AsT0FBTyxFQUFFLEVBQUU7U0FDZCxDQUFDO1FBR0UsSUFBSSxNQUFNLEtBQUssU0FBUztZQUFFLE1BQU0sR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDO1FBQ3BELElBQU0sR0FBRyxHQUFXLE1BQU0sQ0FBQyxHQUFHLENBQUM7UUFDL0IsSUFBTSxPQUFPLEdBQVEsTUFBTSxDQUFDLE9BQU8sQ0FBQztRQUNwQyxJQUFJLE1BQU0sR0FBSSxFQUFVLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBRSxFQUFVLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUM7UUFDNUQsSUFBSSxDQUFDLFFBQVEsR0FBRyxNQUFNLENBQUMsR0FBRyxFQUFFLE9BQU8sQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFFRCwwQkFBRSxHQUFGLFVBQUcsU0FBaUI7UUFDaEIsSUFBSSxDQUFDLFFBQVEsQ0FBQyxFQUFFLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDaEMsQ0FBQztJQUVELDBCQUFFLEdBQUYsVUFBRyxTQUFpQixFQUFFLFFBQWtCO1FBQ3BDLElBQUksQ0FBQyxRQUFRLENBQUMsRUFBRSxDQUFDLFNBQVMsRUFBRSxRQUFRLENBQUMsQ0FBQztJQUMxQyxDQUFDO0lBRUQsNEJBQUksR0FBSixVQUFLLFNBQWlCLEVBQUUsUUFBa0I7UUFDdEMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLFFBQVEsQ0FBQyxDQUFDO0lBQzVDLENBQUM7SUFFRCwrQkFBTyxHQUFQO1FBQ0ksT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDLE9BQU8sRUFBRSxDQUFDO0lBQ25DLENBQUM7SUFFRCxrQ0FBVSxHQUFWLFVBQVcsS0FBVztRQUNsQixPQUFPLElBQUksQ0FBQyxRQUFRLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsUUFBUSxFQUFFLFNBQVMsQ0FBQyxDQUFDO0lBQ3BFLENBQUM7SUFFRCw0QkFBSSxHQUFKLFVBQUssU0FBaUIsRUFBRSxJQUFVLEVBQUUsUUFBbUI7UUFDbkQsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLFFBQVEsRUFBRSxTQUFTLENBQUMsQ0FBQztJQUM5RCxDQUFDO0lBRUQsc0NBQWMsR0FBZCxVQUFlLFNBQWlCLEVBQUUsUUFBbUI7UUFDakQsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDLGNBQWMsQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLFFBQVEsRUFBRSxTQUFTLENBQUMsQ0FBQztJQUN4RSxDQUFDO0lBRUQsMENBQWtCLEdBQWxCLFVBQW1CLFNBQWtCO1FBQ2pDLE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQyxrQkFBa0IsQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLFFBQVEsRUFBRSxTQUFTLENBQUMsQ0FBQztJQUM1RSxDQUFDO0lBRUQsaUNBQVMsR0FBVCxVQUFhLFNBQWlCO1FBQTlCLGlCQWFDO1FBWkcsSUFBSSxDQUFDLGtCQUFrQixFQUFFLENBQUM7UUFDMUIsT0FBTyxVQUFVLENBQUMsTUFBTSxDQUFFLFVBQUMsUUFBYTtZQUNuQyxLQUFJLENBQUMsUUFBUSxDQUFDLEVBQUUsQ0FBQyxTQUFTLEVBQUUsVUFBQyxJQUFPO2dCQUNoQyxRQUFRLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDO1lBQ3hCLENBQUMsQ0FBQyxDQUFDO1lBQ0gsT0FBTztnQkFDSCxJQUFJLEtBQUksQ0FBQyxrQkFBa0IsS0FBSyxDQUFDO29CQUM5QixLQUFJLENBQUMsUUFBUSxDQUFDLGNBQWMsQ0FBQyxTQUFTLENBQUMsQ0FBQztZQUNoRCxDQUFDLENBQUM7UUFDTixDQUFDLENBQUMsQ0FBQyxJQUFJLENBQ0gsS0FBSyxFQUFFLENBQ1YsQ0FBQztJQUNOLENBQUM7SUFFRCx3Q0FBZ0IsR0FBaEIsVUFBb0IsU0FBaUI7UUFBckMsaUJBRUM7UUFERyxPQUFPLElBQUksT0FBTyxDQUFJLFVBQUEsT0FBTyxJQUFJLE9BQUEsS0FBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsT0FBTyxDQUFDLEVBQTdCLENBQTZCLENBQUMsQ0FBQztJQUNwRSxDQUFDO0lBRUwsb0JBQUM7QUFBRCxDQUFDLEFBbkVELElBbUVDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSW5qZWN0IH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XHJcbmltcG9ydCB7IE9ic2VydmFibGUgfSBmcm9tICdyeGpzJztcclxuaW1wb3J0IHsgc2hhcmUgfSBmcm9tICdyeGpzL29wZXJhdG9ycyc7XHJcblxyXG5pbXBvcnQgKiBhcyBpbyBmcm9tICdzb2NrZXQuaW8tY2xpZW50JztcclxuXHJcbmltcG9ydCB7IFNvY2tldElvQ29uZmlnIH0gZnJvbSAnLi9jb25maWcvc29ja2V0LWlvLmNvbmZpZyc7XHJcblxyXG5leHBvcnQgY2xhc3MgV3JhcHBlZFNvY2tldCB7XHJcbiAgICBzdWJzY3JpYmVyc0NvdW50ZXIgOiBudW1iZXIgPSAwO1xyXG4gICAgaW9Tb2NrZXQ6IGFueTtcclxuICAgIGVtcHR5Q29uZmlnOiBTb2NrZXRJb0NvbmZpZyA9IHtcclxuICAgICAgICB1cmw6ICcnLFxyXG4gICAgICAgIG9wdGlvbnM6IHt9XHJcbiAgICB9O1xyXG5cclxuICAgIGNvbnN0cnVjdG9yKHByaXZhdGUgY29uZmlnOiBTb2NrZXRJb0NvbmZpZykge1xyXG4gICAgICAgIGlmIChjb25maWcgPT09IHVuZGVmaW5lZCkgY29uZmlnID0gdGhpcy5lbXB0eUNvbmZpZztcclxuICAgICAgICBjb25zdCB1cmw6IHN0cmluZyA9IGNvbmZpZy51cmw7XHJcbiAgICAgICAgY29uc3Qgb3B0aW9uczogYW55ID0gY29uZmlnLm9wdGlvbnM7XHJcbiAgICAgICAgdmFyIGlvRnVuYyA9IChpbyBhcyBhbnkpLmRlZmF1bHQgPyAoaW8gYXMgYW55KS5kZWZhdWx0IDogaW87XHJcbiAgICAgICAgdGhpcy5pb1NvY2tldCA9IGlvRnVuYyh1cmwsIG9wdGlvbnMpO1xyXG4gICAgfVxyXG5cclxuICAgIG9mKG5hbWVzcGFjZTogc3RyaW5nKSB7XHJcbiAgICAgICAgdGhpcy5pb1NvY2tldC5vZihuYW1lc3BhY2UpO1xyXG4gICAgfVxyXG5cclxuICAgIG9uKGV2ZW50TmFtZTogc3RyaW5nLCBjYWxsYmFjazogRnVuY3Rpb24pIHtcclxuICAgICAgICB0aGlzLmlvU29ja2V0Lm9uKGV2ZW50TmFtZSwgY2FsbGJhY2spO1xyXG4gICAgfVxyXG5cclxuICAgIG9uY2UoZXZlbnROYW1lOiBzdHJpbmcsIGNhbGxiYWNrOiBGdW5jdGlvbikge1xyXG4gICAgICAgIHRoaXMuaW9Tb2NrZXQub25jZShldmVudE5hbWUsIGNhbGxiYWNrKTtcclxuICAgIH1cclxuXHJcbiAgICBjb25uZWN0KCkge1xyXG4gICAgICAgIHJldHVybiB0aGlzLmlvU29ja2V0LmNvbm5lY3QoKTtcclxuICAgIH1cclxuXHJcbiAgICBkaXNjb25uZWN0KGNsb3NlPzogYW55KSB7XHJcbiAgICAgICAgcmV0dXJuIHRoaXMuaW9Tb2NrZXQuZGlzY29ubmVjdC5hcHBseSh0aGlzLmlvU29ja2V0LCBhcmd1bWVudHMpO1xyXG4gICAgfVxyXG5cclxuICAgIGVtaXQoZXZlbnROYW1lOiBzdHJpbmcsIGRhdGE/OiBhbnksIGNhbGxiYWNrPzogRnVuY3Rpb24pIHtcclxuICAgICAgICByZXR1cm4gdGhpcy5pb1NvY2tldC5lbWl0LmFwcGx5KHRoaXMuaW9Tb2NrZXQsIGFyZ3VtZW50cyk7XHJcbiAgICB9XHJcblxyXG4gICAgcmVtb3ZlTGlzdGVuZXIoZXZlbnROYW1lOiBzdHJpbmcsIGNhbGxiYWNrPzogRnVuY3Rpb24pIHtcclxuICAgICAgICByZXR1cm4gdGhpcy5pb1NvY2tldC5yZW1vdmVMaXN0ZW5lci5hcHBseSh0aGlzLmlvU29ja2V0LCBhcmd1bWVudHMpO1xyXG4gICAgfVxyXG5cclxuICAgIHJlbW92ZUFsbExpc3RlbmVycyhldmVudE5hbWU/OiBzdHJpbmcpIHtcclxuICAgICAgICByZXR1cm4gdGhpcy5pb1NvY2tldC5yZW1vdmVBbGxMaXN0ZW5lcnMuYXBwbHkodGhpcy5pb1NvY2tldCwgYXJndW1lbnRzKTtcclxuICAgIH1cclxuXHJcbiAgICBmcm9tRXZlbnQ8VD4oZXZlbnROYW1lOiBzdHJpbmcpOiBPYnNlcnZhYmxlPFQ+IHtcclxuICAgICAgICB0aGlzLnN1YnNjcmliZXJzQ291bnRlcisrO1xyXG4gICAgICAgIHJldHVybiBPYnNlcnZhYmxlLmNyZWF0ZSggKG9ic2VydmVyOiBhbnkpID0+IHtcclxuICAgICAgICAgICAgIHRoaXMuaW9Tb2NrZXQub24oZXZlbnROYW1lLCAoZGF0YTogVCkgPT4ge1xyXG4gICAgICAgICAgICAgICAgIG9ic2VydmVyLm5leHQoZGF0YSk7XHJcbiAgICAgICAgICAgICB9KTtcclxuICAgICAgICAgICAgIHJldHVybiAoKSA9PiB7XHJcbiAgICAgICAgICAgICAgICAgaWYgKHRoaXMuc3Vic2NyaWJlcnNDb3VudGVyID09PSAxKVxyXG4gICAgICAgICAgICAgICAgICAgIHRoaXMuaW9Tb2NrZXQucmVtb3ZlTGlzdGVuZXIoZXZlbnROYW1lKTtcclxuICAgICAgICAgICAgfTtcclxuICAgICAgICB9KS5waXBlKFxyXG4gICAgICAgICAgICBzaGFyZSgpXHJcbiAgICAgICAgKTtcclxuICAgIH1cclxuXHJcbiAgICBmcm9tT25lVGltZUV2ZW50PFQ+KGV2ZW50TmFtZTogc3RyaW5nKTogUHJvbWlzZTxUPiB7XHJcbiAgICAgICAgcmV0dXJuIG5ldyBQcm9taXNlPFQ+KHJlc29sdmUgPT4gdGhpcy5vbmNlKGV2ZW50TmFtZSwgcmVzb2x2ZSkpO1xyXG4gICAgfVxyXG5cclxufSJdfQ==