import { Observable } from 'rxjs';
import { share } from 'rxjs/operators';
import * as io from 'socket.io-client';
export class WrappedSocket {
    constructor(config) {
        this.config = config;
        this.subscribersCounter = 0;
        this.emptyConfig = {
            url: '',
            options: {}
        };
        if (config === undefined)
            config = this.emptyConfig;
        const url = config.url;
        const options = config.options;
        var ioFunc = io.default ? io.default : io;
        this.ioSocket = ioFunc(url, options);
    }
    of(namespace) {
        this.ioSocket.of(namespace);
    }
    on(eventName, callback) {
        this.ioSocket.on(eventName, callback);
    }
    once(eventName, callback) {
        this.ioSocket.once(eventName, callback);
    }
    connect() {
        return this.ioSocket.connect();
    }
    disconnect(close) {
        return this.ioSocket.disconnect.apply(this.ioSocket, arguments);
    }
    emit(eventName, data, callback) {
        return this.ioSocket.emit.apply(this.ioSocket, arguments);
    }
    removeListener(eventName, callback) {
        return this.ioSocket.removeListener.apply(this.ioSocket, arguments);
    }
    removeAllListeners(eventName) {
        return this.ioSocket.removeAllListeners.apply(this.ioSocket, arguments);
    }
    fromEvent(eventName) {
        this.subscribersCounter++;
        return Observable.create((observer) => {
            this.ioSocket.on(eventName, (data) => {
                observer.next(data);
            });
            return () => {
                if (this.subscribersCounter === 1)
                    this.ioSocket.removeListener(eventName);
            };
        }).pipe(share());
    }
    fromOneTimeEvent(eventName) {
        return new Promise(resolve => this.once(eventName, resolve));
    }
}
//# sourceMappingURL=data:application/json;base64,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