var SocketIoModule_1;
import * as tslib_1 from "tslib";
import { NgModule, InjectionToken } from '@angular/core';
import { WrappedSocket } from './socket-io.service';
/** Socket factory */
export function SocketFactory(config) {
    return new WrappedSocket(config);
}
export const SOCKET_CONFIG_TOKEN = new InjectionToken('__SOCKET_IO_CONFIG__');
let SocketIoModule = SocketIoModule_1 = class SocketIoModule {
    static forRoot(config) {
        return {
            ngModule: SocketIoModule_1,
            providers: [
                { provide: SOCKET_CONFIG_TOKEN, useValue: config },
                {
                    provide: WrappedSocket,
                    useFactory: SocketFactory,
                    deps: [SOCKET_CONFIG_TOKEN]
                }
            ]
        };
    }
};
SocketIoModule = SocketIoModule_1 = tslib_1.__decorate([
    NgModule({})
], SocketIoModule);
export { SocketIoModule };
//# sourceMappingURL=data:application/json;base64,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