(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@angular/core'), require('rxjs'), require('rxjs/operators'), require('socket.io-client')) :
    typeof define === 'function' && define.amd ? define('ngx-socket-io', ['exports', '@angular/core', 'rxjs', 'rxjs/operators', 'socket.io-client'], factory) :
    (global = global || self, factory(global['ngx-socket-io'] = {}, global.ng.core, global.rxjs, global.rxjs.operators, global.io.client));
}(this, function (exports, core, rxjs, operators, io__default) { 'use strict';

    var io__default__default = 'default' in io__default ? io__default['default'] : io__default;

    /*! *****************************************************************************
    Copyright (c) Microsoft Corporation. All rights reserved.
    Licensed under the Apache License, Version 2.0 (the "License"); you may not use
    this file except in compliance with the License. You may obtain a copy of the
    License at http://www.apache.org/licenses/LICENSE-2.0

    THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
    WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
    MERCHANTABLITY OR NON-INFRINGEMENT.

    See the Apache Version 2.0 License for specific language governing permissions
    and limitations under the License.
    ***************************************************************************** */

    function __decorate(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }

    var WrappedSocket = /** @class */ (function () {
        function WrappedSocket(config) {
            this.config = config;
            this.subscribersCounter = 0;
            this.emptyConfig = {
                url: '',
                options: {}
            };
            if (config === undefined)
                config = this.emptyConfig;
            var url = config.url;
            var options = config.options;
            var ioFunc = io__default__default ? io__default__default : io__default;
            this.ioSocket = ioFunc(url, options);
        }
        WrappedSocket.prototype.of = function (namespace) {
            this.ioSocket.of(namespace);
        };
        WrappedSocket.prototype.on = function (eventName, callback) {
            this.ioSocket.on(eventName, callback);
        };
        WrappedSocket.prototype.once = function (eventName, callback) {
            this.ioSocket.once(eventName, callback);
        };
        WrappedSocket.prototype.connect = function () {
            return this.ioSocket.connect();
        };
        WrappedSocket.prototype.disconnect = function (close) {
            return this.ioSocket.disconnect.apply(this.ioSocket, arguments);
        };
        WrappedSocket.prototype.emit = function (eventName, data, callback) {
            return this.ioSocket.emit.apply(this.ioSocket, arguments);
        };
        WrappedSocket.prototype.removeListener = function (eventName, callback) {
            return this.ioSocket.removeListener.apply(this.ioSocket, arguments);
        };
        WrappedSocket.prototype.removeAllListeners = function (eventName) {
            return this.ioSocket.removeAllListeners.apply(this.ioSocket, arguments);
        };
        WrappedSocket.prototype.fromEvent = function (eventName) {
            var _this = this;
            this.subscribersCounter++;
            return rxjs.Observable.create(function (observer) {
                _this.ioSocket.on(eventName, function (data) {
                    observer.next(data);
                });
                return function () {
                    if (_this.subscribersCounter === 1)
                        _this.ioSocket.removeListener(eventName);
                };
            }).pipe(operators.share());
        };
        WrappedSocket.prototype.fromOneTimeEvent = function (eventName) {
            var _this = this;
            return new Promise(function (resolve) { return _this.once(eventName, resolve); });
        };
        return WrappedSocket;
    }());

    /** Socket factory */
    function SocketFactory(config) {
        return new WrappedSocket(config);
    }
    var SOCKET_CONFIG_TOKEN = new core.InjectionToken('__SOCKET_IO_CONFIG__');
    var SocketIoModule = /** @class */ (function () {
        function SocketIoModule() {
        }
        SocketIoModule_1 = SocketIoModule;
        SocketIoModule.forRoot = function (config) {
            return {
                ngModule: SocketIoModule_1,
                providers: [
                    { provide: SOCKET_CONFIG_TOKEN, useValue: config },
                    {
                        provide: WrappedSocket,
                        useFactory: SocketFactory,
                        deps: [SOCKET_CONFIG_TOKEN]
                    }
                ]
            };
        };
        var SocketIoModule_1;
        SocketIoModule = SocketIoModule_1 = __decorate([
            core.NgModule({})
        ], SocketIoModule);
        return SocketIoModule;
    }());

    exports.Socket = WrappedSocket;
    exports.SocketIoModule = SocketIoModule;
    exports.ɵa = SocketFactory;
    exports.ɵb = SOCKET_CONFIG_TOKEN;

    Object.defineProperty(exports, '__esModule', { value: true });

}));
//# sourceMappingURL=ngx-socket-io.umd.js.map
