/*
 * Round icon with some letters on it.
 */
L.LetterIcon = L.Icon.extend({
	options: {
		className: 'leaflet-div-icon',
		color: 'black',
		radius: 11,
		borderWidth: '2px',
		borderColor: 'white',
		textColor: 'white',
		fontSize: '8px',
		riseOnHover: true
	},

	initialize: function(letter, options) {
		this._letter = letter;
		L.setOptions(this, options);
	},

	createIcon: function() {
		var radius = this.options.radius,
			diameter = radius * 2 + 1,
			pad = 16;
		var parentDiv = document.createElement('div'),
			div = document.createElement('div');
			
		div.innerHTML = this._letter;
		div.style.width      = diameter + 'px';
		div.style.height     = diameter + 'px';
		div.style.borderRadius = (radius + 2) + 'px';
		div.style.borderWidth = this.options.borderWidth;
		div.style.borderColor = this.options.borderColor;
		div.style.borderStyle = 'solid';
		div.style.fontSize   = this.options.fontSize;
		div.style.fontFamily = 'sans-serif';
		div.style.textAlign  = 'center';
		div.style.lineHeight = (diameter - 1) + 'px';
		div.style.color      = this.options.textColor;
		div.style.margin 	 = (pad / 2) + 'px';
		div.style.backgroundColor = this.options.color;
		div.style.padding = '0';
		if (this.options.riseOnHover) {
		    div.className = 'grow';
		}

		parentDiv.style.borderStyle = 'none';
		parentDiv.style.backgroundColor = 'transparent';
		parentDiv.style.marginLeft = -radius-(pad/2) + 'px';
		parentDiv.style.marginTop  = -radius-(pad/2) + 'px';
		parentDiv.className = 'leaflet-marker-icon';
		parentDiv.style.width = (diameter + pad) + 'px';
		parentDiv.style.height = (diameter + pad) + 'px';
		parentDiv.style.borderRadius = (radius + pad) + 'px';
		parentDiv.style.lineHeight = (diameter + pad) + 'px';
		parentDiv.style.textAlign = 'center';

		parentDiv.appendChild(div);
		this._setIconStyles(parentDiv, 'icon');
		return parentDiv;
	},

	createShadow: function() { return null; }
});

L.letterIcon = function(letter, options) {
	return new L.LetterIcon(letter, options);
};