"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var rxjs_1 = require("rxjs");
var operators_1 = require("rxjs/operators");
/** Augments UIRouterGlobals with observables for transition starts, successful transitions, and state parameters */
var UIRouterRx = /** @class */ (function () {
    function UIRouterRx(router) {
        this.name = '@uirouter/rx';
        this.deregisterFns = [];
        var start$ = new rxjs_1.ReplaySubject(1);
        var success$ = start$.pipe(operators_1.mergeMap(function (t) { return t.promise.then(function () { return t; }, function () { return null; }); }), operators_1.filter(function (t) { return !!t; }));
        var params$ = success$.pipe(operators_1.map(function (transition) { return transition.params(); }));
        var states$ = new rxjs_1.ReplaySubject(1);
        function onStatesChangedEvent(event, states) {
            var changeEvent = {
                currentStates: router.stateRegistry.get(),
                registered: [],
                deregistered: [],
            };
            if (event)
                changeEvent[event] = states;
            states$.next(changeEvent);
        }
        this.deregisterFns.push(router.transitionService.onStart({}, function (transition) { return start$.next(transition); }));
        this.deregisterFns.push(router.stateRegistry.onStatesChanged(onStatesChangedEvent));
        onStatesChangedEvent(null, null);
        Object.assign(router.globals, { start$: start$, success$: success$, params$: params$, states$: states$ });
    }
    UIRouterRx.prototype.dispose = function () {
        this.deregisterFns.forEach(function (deregisterFn) { return deregisterFn(); });
        this.deregisterFns = [];
    };
    return UIRouterRx;
}());
exports.UIRouterRx = UIRouterRx;
exports.UIRouterRxPlugin = UIRouterRx;
//# sourceMappingURL=ui-router-rx.js.map