import { NgModule, ANALYZE_FOR_ENTRY_COMPONENTS, InjectionToken, APP_INITIALIZER, } from '@angular/core';
import { CommonModule, LocationStrategy, HashLocationStrategy, PathLocationStrategy, } from '@angular/common';
import { _UIROUTER_DIRECTIVES } from './directives/directives';
import { UIView } from './directives/uiView';
import { TransitionService } from '@uirouter/core';
import { _UIROUTER_INSTANCE_PROVIDERS, _UIROUTER_SERVICE_PROVIDERS } from './providers';
import { ROUTES } from '@angular/router';
/** @hidden */ export var UIROUTER_ROOT_MODULE = new InjectionToken('UIRouter Root Module');
/** @hidden */ export var UIROUTER_MODULE_TOKEN = new InjectionToken('UIRouter Module');
/** @hidden */ export var UIROUTER_STATES = new InjectionToken('UIRouter States');
// /** @hidden */ export const ROUTES = UIROUTER_STATES;
// Delay angular bootstrap until first transition is successful, for SSR.
// See https://github.com/ui-router/angular/pull/127
export function onTransitionReady(transitionService, root) {
    var mod = root[0];
    if (!mod || !mod.deferInitialRender) {
        return function () { return Promise.resolve(); };
    }
    return function () {
        return new Promise(function (resolve) {
            var hook = function (trans) {
                trans.promise.then(resolve, resolve);
            };
            transitionService.onStart({}, hook, { invokeLimit: 1 });
        });
    };
}
export function makeRootProviders(module) {
    return [
        { provide: UIROUTER_ROOT_MODULE, useValue: module, multi: true },
        { provide: UIROUTER_MODULE_TOKEN, useValue: module, multi: true },
        { provide: ROUTES, useValue: module.states || [], multi: true },
        { provide: ANALYZE_FOR_ENTRY_COMPONENTS, useValue: module.states || [], multi: true },
        {
            provide: APP_INITIALIZER,
            useFactory: onTransitionReady,
            deps: [TransitionService, UIROUTER_ROOT_MODULE],
            multi: true,
        },
    ];
}
export function makeChildProviders(module) {
    return [
        { provide: UIROUTER_MODULE_TOKEN, useValue: module, multi: true },
        { provide: ROUTES, useValue: module.states || [], multi: true },
        { provide: ANALYZE_FOR_ENTRY_COMPONENTS, useValue: module.states || [], multi: true },
    ];
}
export function locationStrategy(useHash) {
    return { provide: LocationStrategy, useClass: useHash ? HashLocationStrategy : PathLocationStrategy };
}
/**
 * Creates UI-Router Modules
 *
 * This class has two static factory methods which create UIRouter Modules.
 * A UI-Router Module is an [Angular NgModule](https://angular.io/docs/ts/latest/guide/ngmodule.html)
 * with support for UI-Router.
 *
 * ### UIRouter Directives
 *
 * When a UI-Router Module is imported into a `NgModule`, that module's components
 * can use the UIRouter Directives such as [[UIView]], [[UISref]], [[UISrefActive]].
 *
 * ### State Definitions
 *
 * State definitions found in the `states:` property are provided to the Dependency Injector.
 * This enables UI-Router to automatically register the states with the [[StateRegistry]] at bootstrap (and during lazy load).
 *
 * ### Entry Components
 *
 * Any routed components are added as `entryComponents:` so they will get compiled.
 */
var UIRouterModule = /** @class */ (function () {
    function UIRouterModule() {
    }
    /**
     * Creates a UI-Router Module for the root (bootstrapped) application module to import
     *
     * This factory function creates an [Angular NgModule](https://angular.io/docs/ts/latest/guide/ngmodule.html)
     * with UI-Router support.
     *
     * The `forRoot` module should be added to the `imports:` of the `NgModule` being bootstrapped.
     * An application should only create and import a single `NgModule` using `forRoot()`.
     * All other modules should be created using [[UIRouterModule.forChild]].
     *
     * Unlike `forChild`, an `NgModule` returned by this factory provides the [[UIRouter]] singleton object.
     * This factory also accepts root-level router configuration.
     * These are the only differences between `forRoot` and `forChild`.
     *
     * Example:
     * ```js
     * let routerConfig = {
     *   otherwise: '/home',
     *   states: [homeState, aboutState]
     * };
     *
     * @ NgModule({
     *   imports: [
     *     BrowserModule,
     *     UIRouterModule.forRoot(routerConfig),
     *     FeatureModule1
     *   ]
     * })
     * class MyRootAppModule {}
     *
     * browserPlatformDynamic.bootstrapModule(MyRootAppModule);
     * ```
     *
     * @param config declarative UI-Router configuration
     * @returns an `NgModule` which provides the [[UIRouter]] singleton instance
     */
    /**
       * Creates a UI-Router Module for the root (bootstrapped) application module to import
       *
       * This factory function creates an [Angular NgModule](https://angular.io/docs/ts/latest/guide/ngmodule.html)
       * with UI-Router support.
       *
       * The `forRoot` module should be added to the `imports:` of the `NgModule` being bootstrapped.
       * An application should only create and import a single `NgModule` using `forRoot()`.
       * All other modules should be created using [[UIRouterModule.forChild]].
       *
       * Unlike `forChild`, an `NgModule` returned by this factory provides the [[UIRouter]] singleton object.
       * This factory also accepts root-level router configuration.
       * These are the only differences between `forRoot` and `forChild`.
       *
       * Example:
       * ```js
       * let routerConfig = {
       *   otherwise: '/home',
       *   states: [homeState, aboutState]
       * };
       *
       * @ NgModule({
       *   imports: [
       *     BrowserModule,
       *     UIRouterModule.forRoot(routerConfig),
       *     FeatureModule1
       *   ]
       * })
       * class MyRootAppModule {}
       *
       * browserPlatformDynamic.bootstrapModule(MyRootAppModule);
       * ```
       *
       * @param config declarative UI-Router configuration
       * @returns an `NgModule` which provides the [[UIRouter]] singleton instance
       */
    UIRouterModule.forRoot = /**
       * Creates a UI-Router Module for the root (bootstrapped) application module to import
       *
       * This factory function creates an [Angular NgModule](https://angular.io/docs/ts/latest/guide/ngmodule.html)
       * with UI-Router support.
       *
       * The `forRoot` module should be added to the `imports:` of the `NgModule` being bootstrapped.
       * An application should only create and import a single `NgModule` using `forRoot()`.
       * All other modules should be created using [[UIRouterModule.forChild]].
       *
       * Unlike `forChild`, an `NgModule` returned by this factory provides the [[UIRouter]] singleton object.
       * This factory also accepts root-level router configuration.
       * These are the only differences between `forRoot` and `forChild`.
       *
       * Example:
       * ```js
       * let routerConfig = {
       *   otherwise: '/home',
       *   states: [homeState, aboutState]
       * };
       *
       * @ NgModule({
       *   imports: [
       *     BrowserModule,
       *     UIRouterModule.forRoot(routerConfig),
       *     FeatureModule1
       *   ]
       * })
       * class MyRootAppModule {}
       *
       * browserPlatformDynamic.bootstrapModule(MyRootAppModule);
       * ```
       *
       * @param config declarative UI-Router configuration
       * @returns an `NgModule` which provides the [[UIRouter]] singleton instance
       */
    function (config) {
        if (config === void 0) { config = {}; }
        return {
            ngModule: UIRouterModule,
            providers: [
                _UIROUTER_INSTANCE_PROVIDERS,
                _UIROUTER_SERVICE_PROVIDERS,
                locationStrategy(config.useHash)
            ].concat(makeRootProviders(config)),
        };
    };
    /**
     * Creates an `NgModule` for a UIRouter module
     *
     * This function creates an [Angular NgModule](https://angular.io/docs/ts/latest/guide/ngmodule.html)
     * with UI-Router support.
     *
     * #### Example:
     * ```js
     * var homeState = { name: 'home', url: '/home', component: Home };
     * var aboutState = { name: 'about', url: '/about', component: About };
     *
     * @ NgModule({
     *   imports: [
     *     UIRouterModule.forChild({ states: [ homeState, aboutState ] }),
     *     SharedModule,
     *   ],
     *   declarations: [ Home, About ],
     * })
     * export class AppModule {};
     * ```
     *
     * @param module UI-Router module options
     * @returns an `NgModule`
     */
    /**
       * Creates an `NgModule` for a UIRouter module
       *
       * This function creates an [Angular NgModule](https://angular.io/docs/ts/latest/guide/ngmodule.html)
       * with UI-Router support.
       *
       * #### Example:
       * ```js
       * var homeState = { name: 'home', url: '/home', component: Home };
       * var aboutState = { name: 'about', url: '/about', component: About };
       *
       * @ NgModule({
       *   imports: [
       *     UIRouterModule.forChild({ states: [ homeState, aboutState ] }),
       *     SharedModule,
       *   ],
       *   declarations: [ Home, About ],
       * })
       * export class AppModule {};
       * ```
       *
       * @param module UI-Router module options
       * @returns an `NgModule`
       */
    UIRouterModule.forChild = /**
       * Creates an `NgModule` for a UIRouter module
       *
       * This function creates an [Angular NgModule](https://angular.io/docs/ts/latest/guide/ngmodule.html)
       * with UI-Router support.
       *
       * #### Example:
       * ```js
       * var homeState = { name: 'home', url: '/home', component: Home };
       * var aboutState = { name: 'about', url: '/about', component: About };
       *
       * @ NgModule({
       *   imports: [
       *     UIRouterModule.forChild({ states: [ homeState, aboutState ] }),
       *     SharedModule,
       *   ],
       *   declarations: [ Home, About ],
       * })
       * export class AppModule {};
       * ```
       *
       * @param module UI-Router module options
       * @returns an `NgModule`
       */
    function (module) {
        if (module === void 0) { module = {}; }
        return {
            ngModule: UIRouterModule,
            providers: makeChildProviders(module),
        };
    };
    UIRouterModule.decorators = [
        { type: NgModule, args: [{
                    imports: [CommonModule],
                    declarations: [_UIROUTER_DIRECTIVES],
                    exports: [_UIROUTER_DIRECTIVES],
                    entryComponents: [UIView],
                },] },
    ];
    return UIRouterModule;
}());
export { UIRouterModule };
//# sourceMappingURL=uiRouterNgModule.js.map