/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
declare type ModifierKey = 'altKey' | 'shiftKey' | 'ctrlKey' | 'metaKey';
/**
 * Checks whether a modifier key is pressed.
 * @param event Event to be checked.
 */
export declare function hasModifierKey(event: KeyboardEvent, ...modifiers: ModifierKey[]): boolean;
export {};
