"use strict";var assert=require("assert"),Mux=require("../lib/mux").Mux,PassThrough=require("stream").PassThrough||require("readable-stream/passthrough"),latch=require("./util").latch,schedule=require("./util").schedule;function stream(){return new PassThrough({objectMode:!0})}function readAllObjects(e,n){var t=[];function r(){for(var n=e.read();null!==n;)t.push(n),n=e.read()}e.on("end",function(){n(t)}),e.on("readable",r),r()}test("single input",function(e){var n=stream(),t=stream();n.on("end",function(){t.end()}),new Mux(t).pipeFrom(n);var r=[1,2,3,4,5,6,7,8,9];r.forEach(n.write.bind(n)),readAllObjects(t,function(n){assert.deepEqual(r,n),e()}),n.end()}),test("single input, resuming stream",function(e){var n=stream(),t=stream();n.on("end",function(){t.end()}),new Mux(t).pipeFrom(n);var r=n.read;n.read=function(e){var t=r.call(n,e);return"skip"===t?(n.emit("readable"),null):t},[1,2,3,4,"skip",6,7,8,9].forEach(n.write.bind(n)),readAllObjects(t,function(n){assert.deepEqual([1,2,3,4,6,7,8,9],n),e()}),n.end()}),test("two sequential inputs",function(e){var n=stream(),t=stream(),r=stream(),a=new Mux(r);a.pipeFrom(n),a.pipeFrom(t);var i=[1,2,3,4,5,6,7,8,9];i.forEach(function(e){n.write(e)}),n.on("end",function(){i.forEach(function(e){t.write(e)}),t.end()}),t.on("end",function(){r.end()}),n.end(),readAllObjects(r,function(n){assert.equal(2*i.length,n.length),e()})}),test("two interleaved inputs",function(e){var n=stream(),t=stream(),r=stream(),a=new Mux(r);a.pipeFrom(n),a.pipeFrom(t);var i=latch(2,function(){r.end()});n.on("end",i),t.on("end",i);var u=[1,2,3,4,5,6,7,8,9];u.forEach(function(e){n.write(e)}),n.end(),u.forEach(function(e){t.write(e)}),t.end(),readAllObjects(r,function(n){assert.equal(2*u.length,n.length),e()})}),test("unpipe",function(e){var n=stream(),t=stream(),r=new Mux(t),a=[1,2,3,4,5],i=[6,7,8,9];r.pipeFrom(n),schedule(function(){a.forEach(n.write.bind(n)),schedule(function(){r.unpipeFrom(n),schedule(function(){i.forEach(n.write.bind(n)),n.end(),schedule(function(){for(;n.read(););})})})}),n.on("end",function(){t.end()}),readAllObjects(t,function(n){try{assert.deepEqual(a,n),e()}catch(n){e(n)}})}),test("roundrobin",function(e){var n=stream(),t=stream(),r=stream(),a=new Mux(r);a.pipeFrom(n),a.pipeFrom(t);var i=latch(2,function(){r.end()});n.on("end",i),t.on("end",i);[1,1,1,1,1].forEach(function(e){n.write(e)}),n.end();[2,2,2,2,2].forEach(function(e){t.write(e)}),t.end(),readAllObjects(r,function(n){assert.deepEqual([1,2,1,2,1,2,1,2,1,2],n),e()})});