"use strict";var C=require("claire"),Buffer=require("safe-buffer").Buffer,forAll=C.forAll,arb=C.data,transform=C.transform,repeat=C.repeat,label=C.label,sequence=C.sequence,asGenerator=C.asGenerator,sized=C.sized,recursive=C.recursive,choice=C.choice,Undefined=C.Undefined;function choose(t,e){return Math.random()*(e-t)+t}function chooseInt(t,e){return Math.floor(choose(t,e))}function rangeInt(t,e,n){return label(t,asGenerator(function(t){return chooseInt(e,n)}))}function toFloat32(t){var e=Buffer.alloc(4);return e.writeFloatBE(t,0),e.readFloatBE(0)}function floatChooser(t){return function(){for(var e=Number.NaN;isNaN(e);){var n=2*Math.random()-1,r=chooseInt(0,t);e=Math.pow(n,r)}return e}}function explicitType(t,e){return label(t,transform(function(e){return{"!":t,value:e}},e))}var Octet=rangeInt("octet",0,255),ShortStr=label("shortstr",transform(function(t){return t.substr(0,255)},arb.Str)),LongStr=label("longstr",transform(function(t){return Buffer.from(t)},repeat(Octet))),UShort=rangeInt("short-uint",0,65535),ULong=rangeInt("long-uint",0,4294967295),ULongLong=rangeInt("longlong-uint",0,0x10000000000000000),Short=rangeInt("short-int",-32768,32767),Long=rangeInt("long-int",-2147483648,2147483647),LongLong=rangeInt("longlong-int",-0x8000000000000000,0x8000000000000000),Bit=label("bit",arb.Bool),Double=label("double",asGenerator(floatChooser(308))),Float=label("float",transform(toFloat32,floatChooser(38))),Timestamp=label("timestamp",transform(function(t){return{"!":"timestamp",value:t}},ULongLong)),Decimal=label("decimal",transform(function(t){return{"!":"decimal",value:{places:t[1],digits:t[0]}}},sequence(arb.UInt,Octet))),Byte=rangeInt("byte",-128,127),ExByte=explicitType("byte",Byte),ExInt8=explicitType("int8",Byte),ExShort=explicitType("short",Short),ExInt16=explicitType("int16",Short),ExInt=explicitType("int",Long),ExInt32=explicitType("int32",Long),ExLong=explicitType("long",LongLong),ExInt64=explicitType("int64",LongLong),FieldArray=label("field-array",recursive(function(){return arb.Array(arb.Null,LongStr,ShortStr,Octet,UShort,ULong,ULongLong,Byte,Short,Long,LongLong,ExByte,ExInt8,ExShort,ExInt16,ExInt,ExInt32,ExLong,ExInt64,Bit,Float,Double,FieldTable,FieldArray)})),FieldTable=label("table",recursive(function(){return sized(function(){return 5},arb.Object(arb.Null,LongStr,ShortStr,Octet,UShort,ULong,ULongLong,Byte,Short,Long,LongLong,ExByte,ExInt8,ExShort,ExInt16,ExInt,ExInt32,ExLong,ExInt64,Bit,Float,Double,FieldArray,FieldTable))})),domainProps=[[Octet,function(t){return t>=0&&t<256}],[ShortStr,function(t){return"string"==typeof t&&t.length<256}],[LongStr,function(t){return Buffer.isBuffer(t)}],[UShort,function(t){return t>=0&&t<=65535}],[ULong,function(t){return t>=0&&t<=4294967295}],[ULongLong,function(t){return t>=0&&t<=0x10000000000000000}],[Short,function(t){return t>=-32768&&t<=32768}],[Long,function(t){return t>=-2147483648&&t<2147483648}],[LongLong,function(t){return t>=-0x8000000000000000&&t<0x8000000000000000}],[Bit,function(t){return"boolean"==typeof t}],[Double,function(t){return!isNaN(t)&&isFinite(t)}],[Float,function(t){return!isNaN(t)&&isFinite(t)&&Math.log(Math.abs(t))*Math.LOG10E<309}],[Decimal,function(t){return"decimal"===t["!"]&&t.value.places<=255&&t.value.digits<=4294967295}],[Timestamp,function(t){return"timestamp"===t["!"]}],[FieldTable,function(t){return"object"==typeof t}],[FieldArray,function(t){return Array.isArray(t)}]];suite("Domains",function(){domainProps.forEach(function(t){test(t[0]+" domain",forAll(t[0]).satisfy(t[1]).asTest({times:500}))})});var ArgTimestamp=label("timestamp",ULongLong),ARG_TYPES={octet:Octet,shortstr:ShortStr,longstr:LongStr,short:UShort,long:ULong,longlong:ULongLong,bit:Bit,table:FieldTable,timestamp:ArgTimestamp};function argtype(t){return void 0===t.default?ARG_TYPES[t.type]:choice(ARG_TYPES[t.type],Undefined)}function zipObject(t,e){var n={};return t.forEach(function(t,r){n[e[r]]=t}),n}function name(t){return t.name}var defs=require("../lib/defs");function method(t){var e=sequence.apply(null,t.args.map(argtype)),n=t.args.map(name);return label(t.name,transform(function(e){return{id:t.id,fields:zipObject(e,n)}},e))}function properties(t){var e=t.args.map(argtype);e.unshift(ULongLong);var n=sequence.apply(null,e),r=t.args.map(name);return label(t.name,transform(function(e){return{id:t.id,size:e[0],fields:zipObject(e.slice(1),r)}},n))}var methods=[],propertieses=[];for(var k in defs)"methodInfo"===k.substr(0,10)?(methods.push(method(defs[k])),methods[defs[k].name]=method(defs[k])):"propertiesInfo"===k.substr(0,14)&&(propertieses.push(properties(defs[k])),propertieses[defs[k].name]=properties(defs[k]));module.exports={Octet:Octet,ShortStr:ShortStr,LongStr:LongStr,UShort:UShort,ULong:ULong,ULongLong:ULongLong,Short:Short,Long:Long,LongLong:LongLong,Bit:Bit,Double:Double,Float:Float,Timestamp:Timestamp,Decimal:Decimal,FieldArray:FieldArray,FieldTable:FieldTable,methods:methods,properties:propertieses},module.exports.rangeInt=rangeInt;