"use strict";var assert=require("assert"),defs=require("../lib/defs"),Buffer=require("safe-buffer").Buffer,Connection=require("../lib/connection").Connection,HEARTBEAT=require("../lib/frame").HEARTBEAT,HB_BUF=require("../lib/frame").HEARTBEAT_BUF,util=require("./util"),succeed=util.succeed,fail=util.fail,latch=util.latch,completes=util.completes,kCallback=util.kCallback,LOG_ERRORS=process.env.LOG_ERRORS,OPEN_OPTS={clientProperties:{},mechanism:"PLAIN",response:Buffer.from(["","guest","guest"].join(String.fromCharCode(0))),locale:"en_US",channelMax:0,frameMax:0,heartbeat:0,virtualHost:"/",capabilities:"",insist:0};function happy_open(e,n){return e(defs.ConnectionStart,{versionMajor:0,versionMinor:9,serverProperties:{},mechanisms:Buffer.from("PLAIN"),locales:Buffer.from("en_US")}),n(defs.ConnectionStartOk)().then(function(n){e(defs.ConnectionTune,{channelMax:0,heartbeat:0,frameMax:0})}).then(n(defs.ConnectionTuneOk)).then(n(defs.ConnectionOpen)).then(function(n){e(defs.ConnectionOpenOk,{knownHosts:""})})}function connectionTest(e,n){return function(o){var t=latch(2,o),c=util.socketPair(),i=new Connection(c.client);LOG_ERRORS&&i.on("error",console.warn),e(i,t);var s=c.server.read(8);assert.deepEqual(Buffer.from("AMQP"+String.fromCharCode(0,0,9,1)),s);util.runServer(c.server,function(e,o){n(e,o,t,c.server)})}}module.exports.OPEN_OPTS=OPEN_OPTS,module.exports.connection_handshake=happy_open,suite("Connection errors",function(){test("socket close during open",function(e){var n=util.socketPair(),o=new Connection(n.client);n.server.on("readable",function(){n.server.end()}),o.open({},kCallback(fail(e),succeed(e)))}),test("bad frame during open",function(e){var n=util.socketPair(),o=new(require("../lib/connection").Connection)(n.client);n.server.on("readable",function(){n.server.write(Buffer.from([0,0,0,0,0,0,0,0,0,0]))}),o.open({},kCallback(fail(e),succeed(e)))})}),suite("Connection open",function(){test("happy",connectionTest(function(e,n){e.open(OPEN_OPTS,kCallback(succeed(n),fail(n)))},function(e,n,o){happy_open(e,n).then(succeed(o),fail(o))})),test("wrong first frame",connectionTest(function(e,n){e.open(OPEN_OPTS,kCallback(fail(n),succeed(n)))},function(e,n,o){completes(function(){e(defs.ConnectionTune,{channelMax:0,heartbeat:0,frameMax:0})},o)})),test("unexpected socket close",connectionTest(function(e,n){e.open(OPEN_OPTS,kCallback(fail(n),succeed(n)))},function(e,n,o,t){return e(defs.ConnectionStart,{versionMajor:0,versionMinor:9,serverProperties:{},mechanisms:Buffer.from("PLAIN"),locales:Buffer.from("en_US")}),n(defs.ConnectionStartOk)().then(function(){t.end()}).then(succeed(o),fail(o))}))}),suite("Connection running",function(){test("wrong frame on channel 0",connectionTest(function(e,n){e.on("error",succeed(n)),e.open(OPEN_OPTS)},function(e,n,o){happy_open(e,n).then(function(){e(defs.ChannelOpenOk,{channelId:Buffer.from("")},0)}).then(n(defs.ConnectionClose)).then(function(n){e(defs.ConnectionCloseOk,{},0)}).then(succeed(o),fail(o))})),test("unopened channel",connectionTest(function(e,n){e.on("error",succeed(n)),e.open(OPEN_OPTS)},function(e,n,o){happy_open(e,n).then(function(){e(defs.ChannelOpenOk,{channelId:Buffer.from("")},3)}).then(n(defs.ConnectionClose)).then(function(n){e(defs.ConnectionCloseOk,{},0)}).then(succeed(o),fail(o))})),test("unexpected socket close",connectionTest(function(e,n){var o=latch(2,n);e.on("error",succeed(o)),e.on("close",succeed(o)),e.open(OPEN_OPTS,kCallback(function(){e.sendHeartbeat()},fail(o)))},function(e,n,o,t){happy_open(e,n).then(n()).then(function(){t.end()}).then(succeed(o))})),test("connection.blocked",connectionTest(function(e,n){e.on("blocked",succeed(n)),e.open(OPEN_OPTS)},function(e,n,o,t){happy_open(e,n).then(function(){e(defs.ConnectionBlocked,{reason:"felt like it"},0)}).then(succeed(o))})),test("connection.unblocked",connectionTest(function(e,n){e.on("unblocked",succeed(n)),e.open(OPEN_OPTS)},function(e,n,o,t){happy_open(e,n).then(function(){e(defs.ConnectionUnblocked,{},0)}).then(succeed(o))}))}),suite("Connection close",function(){test("happy",connectionTest(function(e,n){var o=latch(2,n);e.on("close",o),e.open(OPEN_OPTS,kCallback(function(n){e.close(kCallback(succeed(o),fail(o)))},function(){}))},function(e,n,o){happy_open(e,n).then(n(defs.ConnectionClose)).then(function(n){e(defs.ConnectionCloseOk,{})}).then(succeed(o),fail(o))})),test("interleaved close frames",connectionTest(function(e,n){var o=latch(2,n);e.on("close",o),e.open(OPEN_OPTS,kCallback(function(n){e.close(kCallback(succeed(o),fail(o)))},o))},function(e,n,o){happy_open(e,n).then(n(defs.ConnectionClose)).then(function(n){e(defs.ConnectionClose,{replyText:"Ha!",replyCode:defs.constants.REPLY_SUCCESS,methodId:0,classId:0})}).then(n(defs.ConnectionCloseOk)).then(function(n){e(defs.ConnectionCloseOk,{})}).then(succeed(o),fail(o))})),test("server error close",connectionTest(function(e,n){var o=latch(2,n);e.on("close",succeed(o)),e.on("error",succeed(o)),e.open(OPEN_OPTS)},function(e,n,o){happy_open(e,n).then(function(n){e(defs.ConnectionClose,{replyText:"Begone",replyCode:defs.constants.INTERNAL_ERROR,methodId:0,classId:0})}).then(n(defs.ConnectionCloseOk)).then(succeed(o),fail(o))})),test("operator-intiated close",connectionTest(function(e,n){e.on("close",succeed(n)),e.on("error",fail(n)),e.open(OPEN_OPTS)},function(e,n,o){happy_open(e,n).then(function(n){e(defs.ConnectionClose,{replyText:"Begone",replyCode:defs.constants.CONNECTION_FORCED,methodId:0,classId:0})}).then(n(defs.ConnectionCloseOk)).then(succeed(o),fail(o))})),test("double close",connectionTest(function(e,n){e.open(OPEN_OPTS,kCallback(function(){e.close(),assert.throws(function(){e.close()}),n()},n))},function(e,n,o){happy_open(e,n).then(n(defs.ConnectionClose)).then(function(){e(defs.ConnectionCloseOk,{})}).then(succeed(o),fail(o))}))}),suite("heartbeats",function(){var e=require("../lib/heartbeat");setup(function(){e.UNITS_TO_MS=20}),teardown(function(){e.UNITS_TO_MS=1e3}),test("send heartbeat after open",connectionTest(function(e,n){completes(function(){var n=Object.create(OPEN_OPTS);n.heartbeat=1,e.on("error",function(){}),e.open(n)},n)},function(n,o,t,c){var i;happy_open(n,o).then(function(){i=setInterval(function(){c.write(HB_BUF)},e.UNITS_TO_MS)}).then(o()).then(function(e){e===HEARTBEAT?t():t("Next frame after silence not a heartbeat"),clearInterval(i)})})),test("detect lack of heartbeats",connectionTest(function(e,n){var o=Object.create(OPEN_OPTS);o.heartbeat=1,e.on("error",succeed(n)),e.open(o)},function(e,n,o,t){happy_open(e,n).then(succeed(o),fail(o))}))});