"use strict";var connect=require("../lib/connect").connect,Buffer=require("safe-buffer").Buffer,credentialsFromUrl=require("../lib/connect").credentialsFromUrl,assert=require("assert"),util=require("./util"),net=require("net"),fail=util.fail,succeed=util.succeed,kCallback=util.kCallback,succeedIfAttributeEquals=util.succeedIfAttributeEquals,format=require("util").format,URL=process.env.URL||"amqp://localhost",urlparse=require("url-parse");suite("Credentials",function(){function e(e,r,t,s){return"PLAIN"!=e.mechanism?s("expected mechanism PLAIN"):e.username!=r||e.password!=t?s(format("expected '%s', '%s'; got '%s', '%s'",r,t,e.username,e.password)):void s()}test("no creds",function(r){var t=urlparse("amqp://localhost");e(credentialsFromUrl(t),"guest","guest",r)}),test("usual user:pass",function(r){var t=urlparse("amqp://user:pass@localhost");e(credentialsFromUrl(t),"user","pass",r)}),test("missing user",function(r){var t=urlparse("amqps://:password@localhost");e(credentialsFromUrl(t),"","password",r)}),test("missing password",function(r){var t=urlparse("amqps://username:@localhost");e(credentialsFromUrl(t),"username","",r)}),test("escaped colons",function(r){var t=urlparse("amqp://user%3Aname:pass%3Aword@localhost");e(credentialsFromUrl(t),"user:name","pass:word",r)})}),suite("Connect API",function(){test("Connection refused",function(e){connect("amqp://localhost:23450",{},kCallback(fail(e),succeed(e)))}),test("bad URL",function(){assert.throws(function(){connect("blurble")})}),test("wrongly typed open option",function(e){var r=require("url"),t=r.parse(URL,!0),s=t.query||{};s.frameMax="NOT A NUMBER",t.query=s;var a=r.format(t);connect(a,{},kCallback(fail(e),succeed(e)))}),test("serverProperties",function(e){var r=require("url").parse(URL,!0).query||{};connect(r,{},function(r,t){if(r)return e(r);assert.equal(t.serverProperties.product,"RabbitMQ"),e()})}),test("using custom heartbeat option",function(e){var r=require("url").parse(URL,!0).query||{};r.heartbeat=20,connect(r,{},kCallback(succeedIfAttributeEquals("heartbeat",20,e),fail(e)))}),test("wrongly typed heartbeat option",function(e){var r=require("url").parse(URL,!0).query||{};r.heartbeat="NOT A NUMBER",connect(r,{},kCallback(fail(e),succeed(e)))}),test("using plain credentials",function(e){var r=require("url").parse(URL,!0),t="guest",s="guest";if(r.auth){var a=r.auth.split(":");t=a[0],s=a[1]}connect(URL,{credentials:require("../lib/credentials").plain(t,s)},kCallback(succeed(e),fail(e)))}),test("using amqplain credentials",function(e){var r=require("url").parse(URL,!0),t="guest",s="guest";if(r.auth){var a=r.auth.split(":");t=a[0],s=a[1]}connect(URL,{credentials:require("../lib/credentials").amqplain(t,s)},kCallback(succeed(e),fail(e)))}),test("using unsupported mechanism",function(e){connect(URL,{credentials:{mechanism:"UNSUPPORTED",response:function(){return Buffer.from("")}}},kCallback(fail(e),succeed(e)))}),test("with a given connection timeout",function(e){var r=net.createServer(function(){}).listen(31991);connect("amqp://localhost:31991",{timeout:50},function(t,s){r.close(),s?e(new Error("Expected connection timeout, did not")):e()})})});