"use strict";var assert=require("assert"),api=require("../channel_api"),util=require("./util"),succeed=util.succeed,fail=util.fail,schedule=util.schedule,randomString=util.randomString,Promise=require("bluebird"),Buffer=require("safe-buffer").Buffer,URL=process.env.URL||"amqp://localhost";function connect(){return api.connect(URL)}function expectFail(e){return new Promise(function(n,t){return e.then(t).catch(n)})}function ignore(){}function ignoreErrors(e){return e.on("error",ignore),e}function logErrors(e){return e.on("error",console.warn),e}function channel_test(e,n,t){test(n,function(n){connect(URL).then(logErrors).then(function(r){r[e]().then(ignoreErrors).then(t).then(succeed(n),fail(n)).finally(function(){r.close()})})})}var chtest=channel_test.bind(null,"createChannel");suite("connect",function(){test("at all",function(e){connect(URL).then(function(e){return e.close()}).then(succeed(e),fail(e))}),chtest("create channel",ignore)});var QUEUE_OPTS={durable:!1},EX_OPTS={durable:!1};function waitForQueue(e,n){return connect(URL).then(function(t){return t.createChannel().then(function(r){return r.checkQueue(e).then(function(u){return function u(){return r.checkQueue(e).then(function(e){if(n(e))return t.close(),e;schedule(u)})}()})})})}function waitForMessages(e,n){var t=void 0===n?1:n;return waitForQueue(e,function(e){return e.messageCount>=t})}suite("assert, check, delete",function(){chtest("assert and check queue",function(e){return e.assertQueue("test.check-queue",QUEUE_OPTS).then(function(n){return e.checkQueue("test.check-queue")})}),chtest("assert and check exchange",function(e){return e.assertExchange("test.check-exchange","direct",EX_OPTS).then(function(n){return assert.equal("test.check-exchange",n.exchange),e.checkExchange("test.check-exchange")})}),chtest("fail on reasserting queue with different options",function(e){var n="test.reassert-queue";return e.assertQueue(n,{durable:!1,autoDelete:!0}).then(function(){return expectFail(e.assertQueue(n,{durable:!1,autoDelete:!1}))})}),chtest("fail on checking a queue that's not there",function(e){return expectFail(e.checkQueue("test.random-"+randomString()))}),chtest("fail on checking an exchange that's not there",function(e){return expectFail(e.checkExchange("test.random-"+randomString()))}),chtest("fail on reasserting exchange with different type",function(e){var n="test.reassert-ex";return e.assertExchange(n,"fanout",EX_OPTS).then(function(){return expectFail(e.assertExchange(n,"direct",EX_OPTS))})}),chtest("channel break on publishing to non-exchange",function(e){return new Promise(function(n){e.on("error",n),e.publish(randomString(),"",Buffer.from("foobar"))})}),chtest("delete queue",function(e){var n="test.delete-queue";return Promise.join(e.assertQueue(n,QUEUE_OPTS),e.checkQueue(n)).then(function(){return e.deleteQueue(n)}).then(function(){return expectFail(e.checkQueue(n))})}),chtest("delete exchange",function(e){var n="test.delete-exchange";return Promise.join(e.assertExchange(n,"fanout",EX_OPTS),e.checkExchange(n)).then(function(){return e.deleteExchange(n)}).then(function(){return expectFail(e.checkExchange(n))})})}),suite("sendMessage",function(){chtest("send to queue and get from queue",function(e){var n="test.send-to-q",t=randomString();return Promise.join(e.assertQueue(n,QUEUE_OPTS),e.purgeQueue(n)).then(function(){return e.sendToQueue(n,Buffer.from(t)),waitForMessages(n)}).then(function(){return e.get(n,{noAck:!0})}).then(function(e){assert(e),assert.equal(t,e.content.toString())})}),chtest("send (and get) zero content to queue",function(e){var n="test.send-to-q",t=Buffer.alloc(0);return Promise.join(e.assertQueue(n,QUEUE_OPTS),e.purgeQueue(n)).then(function(){return e.sendToQueue(n,t),waitForMessages(n)}).then(function(){return e.get(n,{noAck:!0})}).then(function(e){assert(e),assert.deepEqual(t,e.content)})})}),suite("binding, consuming",function(){chtest("route message",function(e){var n="test.route-message",t="test.route-message-q",r=randomString();return Promise.join(e.assertExchange(n,"fanout",EX_OPTS),e.assertQueue(t,QUEUE_OPTS),e.purgeQueue(t),e.bindQueue(t,n,"",{})).then(function(){return e.publish(n,"",Buffer.from(r)),waitForMessages(t)}).then(function(){return e.get(t,{noAck:!0})}).then(function(e){assert(e),assert.equal(r,e.content.toString())})}),chtest("purge queue",function(e){var n="test.purge-queue";return e.assertQueue(n,{durable:!1}).then(function(){return e.sendToQueue(n,Buffer.from("foobar")),waitForMessages(n)}).then(function(){return e.purgeQueue(n),e.get(n,{noAck:!0})}).then(function(e){assert(!e)})}),chtest("unbind queue",function(e){var n="test.unbind-queue-ex",t="test.unbind-queue",r=randomString(),u=randomString();return Promise.join(e.assertExchange(n,"fanout",EX_OPTS),e.assertQueue(t,QUEUE_OPTS),e.purgeQueue(t),e.bindQueue(t,n,"",{})).then(function(){return e.publish(n,"",Buffer.from("foobar")),waitForMessages(t)}).then(function(){return e.get(t,{noAck:!0}).then(function(e){assert(e)})}).then(function(){return e.unbindQueue(t,n,"",{})}).then(function(){return e.publish(n,"",Buffer.from(r)),e.sendToQueue(t,Buffer.from(u)),waitForMessages(t)}).then(function(){return e.get(t)}).then(function(e){assert.equal(u,e.content.toString())})}),chtest("consume via exchange-exchange binding",function(e){var n="test.ex-ex-binding1",t="test.ex-ex-binding2",r="test.ex-ex-binding-q",u="test.routing.key",o=randomString();return Promise.join(e.assertExchange(n,"direct",EX_OPTS),e.assertExchange(t,"fanout",{durable:!1,internal:!0}),e.assertQueue(r,QUEUE_OPTS),e.purgeQueue(r),e.bindExchange(t,n,u,{}),e.bindQueue(r,t,"",{})).then(function(){return new Promise(function(t,s){e.consume(r,function(e){e.content.toString()===o?t():s(new Error("Wrong message"))},{noAck:!0}).then(function(){e.publish(n,u,Buffer.from(o))})})})}),chtest("unbind exchange",function(e){var n="test.unbind-ex-source",t="test.unbind-ex-dest",r="test.unbind-ex-queue",u=randomString(),o=randomString();return Promise.join(e.assertExchange(n,"fanout",EX_OPTS),e.assertExchange(t,"fanout",EX_OPTS),e.assertQueue(r,QUEUE_OPTS),e.purgeQueue(r),e.bindExchange(t,n,"",{}),e.bindQueue(r,t,"",{})).then(function(){return e.publish(n,"",Buffer.from("foobar")),waitForMessages(r)}).then(function(){return e.get(r,{noAck:!0}).then(function(e){assert(e)})}).then(function(){return e.unbindExchange(t,n,"",{})}).then(function(){return e.publish(n,"",Buffer.from(u)),e.sendToQueue(r,Buffer.from(o)),waitForMessages(r)}).then(function(){return e.get(r)}).then(function(e){assert.equal(o,e.content.toString())})}),chtest("cancel consumer",function(e){var n,t="test.consumer-cancel";return new Promise(function(r,u){Promise.join(e.assertQueue(t,QUEUE_OPTS),e.purgeQueue(t),e.consume(t,r,{noAck:!0}).then(function(r){n=r.consumerTag,e.sendToQueue(t,Buffer.from("foo"))}))}).then(function(){return expectFail(Promise.join(e.cancel(n).then(function(){return e.sendToQueue(t,Buffer.from("bar"))}),waitForMessages(t)).then(function(){return e.get(t,{noAck:!0})}).then(function(e){if("bar"===e.content.toString())throw new Error}))})}),chtest("cancelled consumer",function(e){var n="test.cancelled-consumer";return new Promise(function(t,r){return Promise.join(e.assertQueue(n),e.purgeQueue(n),e.consume(n,function(e){null===e?t():r(new Error("Message not expected"))})).then(function(){return e.deleteQueue(n)})})}),chtest("ack",function(e){var n="test.ack",t=randomString(),r=randomString();return Promise.join(e.assertQueue(n,QUEUE_OPTS),e.purgeQueue(n)).then(function(){return e.sendToQueue(n,Buffer.from(t)),e.sendToQueue(n,Buffer.from(r)),waitForMessages(n,2)}).then(function(){return e.get(n,{noAck:!1})}).then(function(r){return assert.equal(t,r.content.toString()),e.ack(r),e.get(n)}).then(function(e){assert(e),assert.equal(r,e.content.toString())})}),chtest("nack",function(e){var n="test.nack",t=randomString();return Promise.join(e.assertQueue(n,QUEUE_OPTS),e.purgeQueue(n)).then(function(){return e.sendToQueue(n,Buffer.from(t)),waitForMessages(n)}).then(function(){return e.get(n,{noAck:!1})}).then(function(r){return assert.equal(t,r.content.toString()),e.nack(r),waitForMessages(n)}).then(function(){return e.get(n)}).then(function(e){assert(e),assert.equal(t,e.content.toString())})}),chtest("reject",function(e){var n="test.reject",t=randomString();return Promise.join(e.assertQueue(n,QUEUE_OPTS),e.purgeQueue(n)).then(function(){return e.sendToQueue(n,Buffer.from(t)),waitForMessages(n)}).then(function(){return e.get(n,{noAck:!1})}).then(function(r){return assert.equal(t,r.content.toString()),e.reject(r),waitForMessages(n)}).then(function(){return e.get(n)}).then(function(e){assert(e),assert.equal(t,e.content.toString())})}),chtest("prefetch",function(e){var n="test.prefetch";return Promise.join(e.assertQueue(n,QUEUE_OPTS),e.purgeQueue(n),e.prefetch(1)).then(function(){return e.sendToQueue(n,Buffer.from("foobar")),e.sendToQueue(n,Buffer.from("foobar")),waitForMessages(n,2)}).then(function(){return new Promise(function(t){var r=0;return e.consume(n,function(n){e.ack(n),++r>1&&t(r)},{noAck:!1})})}).then(function(e){return assert.equal(2,e)})}),chtest("close",function(e){return e.close()})});var confirmtest=channel_test.bind(null,"createConfirmChannel");suite("confirms",function(){confirmtest("message is confirmed",function(e){var n="test.confirm-message";return Promise.join(e.assertQueue(n,QUEUE_OPTS),e.purgeQueue(n)).then(function(){return e.sendToQueue(n,Buffer.from("bleep"))})}),confirmtest("multiple confirms",function(e){var n="test.multiple-confirms";return Promise.join(e.assertQueue(n,QUEUE_OPTS),e.purgeQueue(n)).then(function(){var t=!1;return e.on("ack",function(e){e.multiple&&(t=!0)}),function r(u){var o,s=[];for(var c=0;c<u;c++)o=Promise.fromCallback(function(t){return e.sendToQueue(n,Buffer.from("bleep"),{},t)}),s.push(o);return Promise.all(s).then(function(){if(t)return!0;if(u>500)throw new Error("Couldn't provoke the server into multi-acking with "+u+" messages; giving up");return r(2*u)})}(5)})}),confirmtest("wait for confirms",function(e){for(var n=0;n<1e3;n++)e.publish("","",Buffer.from("foobar"),{});return e.waitForConfirms()}),confirmtest("works when channel is closed",function(e){for(var n=0;n<1e3;n++)e.publish("","",Buffer.from("foobar"),{});return e.close().then(function(){return e.waitForConfirms()}).then(function(){assert.strictEqual(!0,!1,"Wait should have failed.")},function(e){assert.strictEqual(e.message,"channel closed")})})});