"use strict";var assert=require("assert"),Promise=require("bluebird"),Channel=require("../lib/channel").Channel,Connection=require("../lib/connection").Connection,util=require("./util"),succeed=util.succeed,fail=util.fail,latch=util.latch,completes=util.completes,defs=require("../lib/defs"),conn_handshake=require("./connection").connection_handshake,OPEN_OPTS=require("./connection").OPEN_OPTS,Buffer=require("safe-buffer").Buffer,LOG_ERRORS=process.env.LOG_ERRORS;function baseChannelTest(e,n){return function(t){var s=latch(2,t),c=util.socketPair(),o=new Connection(c.client);LOG_ERRORS&&o.on("error",console.warn),o.open(OPEN_OPTS,function(n,t){null===n?e(o,s):fail(s)}),c.server.read(8);util.runServer(c.server,function(e,t){conn_handshake(e,t).then(function(){n(e,t,s)},fail(s))})}}function channelTest(e,n){return baseChannelTest(function(n,t){var s=new Channel(n);LOG_ERRORS&&s.on("error",console.warn),e(s,t,n)},function(e,t,s){channel_handshake(e,t).then(function(c){return n(e,t,s,c)}).then(null,fail(s))})}function channel_handshake(e,n){return n(defs.ChannelOpen)().then(function(n){return assert.notEqual(0,n.channel),e(defs.ChannelOpenOk,{channelId:Buffer.from("")},n.channel),n.channel})}var DELIVER_FIELDS={consumerTag:"fake",deliveryTag:1,redelivered:!1,exchange:"foo",routingKey:"bar",replyCode:defs.constants.NO_ROUTE,replyText:"derp"};function open(e){return Promise.try(function(){return e.allocate(),Promise.fromCallback(function(n){e._rpc(defs.ChannelOpen,{outOfBand:""},defs.ChannelOpenOk,n)})})}suite("channel open and close",function(){test("open",channelTest(function(e,n){open(e).then(succeed(n),fail(n))},function(e,n,t){t()})),test("bad server",baseChannelTest(function(e,n){open(new Channel(e)).then(fail(n),succeed(n))},function(e,n,t){return n(defs.ChannelOpen)().then(function(n){e(defs.ChannelCloseOk,{},n.channel)}).then(succeed(t),fail(t))})),test("open, close",channelTest(function(e,n){open(e).then(function(){return new Promise(function(n){e.closeBecause("Bye",defs.constants.REPLY_SUCCESS,n)})}).then(succeed(n),fail(n))},function(e,n,t,s){return n(defs.ChannelClose)().then(function(n){e(defs.ChannelCloseOk,{},s)}).then(succeed(t),fail(t))})),test("server close",channelTest(function(e,n){e.on("error",function(e){assert.strictEqual(504,e.code),assert.strictEqual(0,e.classId),assert.strictEqual(0,e.methodId),succeed(n)()}),open(e)},function(e,n,t,s){e(defs.ChannelClose,{replyText:"Forced close",replyCode:defs.constants.CHANNEL_ERROR,classId:0,methodId:0},s),n(defs.ChannelCloseOk)().then(succeed(t),fail(t))})),test("overlapping channel/server close",channelTest(function(e,n,t){var s=latch(2,n);t.on("error",succeed(s)),e.on("close",succeed(s)),open(e).then(function(){e.closeBecause("Bye",defs.constants.REPLY_SUCCESS)},fail(s))},function(e,n,t,s){n(defs.ChannelClose)().then(function(){e(defs.ConnectionClose,{replyText:"Got there first",replyCode:defs.constants.INTERNAL_ERROR,classId:0,methodId:0},0)}).then(n(defs.ConnectionCloseOk)).then(succeed(t),fail(t))})),test("double close",channelTest(function(e,n){open(e).then(function(){e.closeBecause("First close",defs.constants.REPLY_SUCCESS),assert.throws(function(){e.closeBecause("Second close",defs.constants.REPLY_SUCCESS)})}).then(succeed(n),fail(n))},function(e,n,t,s){n(defs.ChannelClose)().then(function(){e(defs.ChannelCloseOk,{},s)}).then(succeed(t),fail(t))}))}),suite("channel machinery",function(){function e(e,n){return test("confirm "+e,channelTest(function(n,t){n.on(e,function(e){completes(function(){assert.equal(1,e.deliveryTag)},t)}),open(n)},function(e,t,s,c){completes(function(){e(n,{deliveryTag:1,multiple:!1},c)},s)}))}test("RPC",channelTest(function(e,n){var t=latch(3,n);open(e).then(function(){function n(e,n){null!==e?t(e):t()}var s={prefetchCount:10,prefetchSize:0,global:!1};e._rpc(defs.BasicQos,s,defs.BasicQosOk,n),e._rpc(defs.BasicQos,s,defs.BasicQosOk,n),e._rpc(defs.BasicQos,s,defs.BasicQosOk,n)}).then(null,fail(t))},function(e,n,t,s){function c(n){e(defs.BasicQosOk,{},s)}return n(defs.BasicQos)().then(c).then(n(defs.BasicQos)).then(c).then(n(defs.BasicQos)).then(c).then(succeed(t),fail(t))})),test("Bad RPC",channelTest(function(e,n){var t=latch(2,n);e.on("error",function(e){assert.strictEqual(505,e.code),assert.strictEqual(60,e.classId),assert.strictEqual(72,e.methodId),succeed(t)()}),open(e).then(function(){e._rpc(defs.BasicRecover,{requeue:!0},defs.BasicRecoverOk,function(e){null!==e?t():t(new Error("Expected RPC failure"))})},fail(t))},function(e,n,t,s){return n()().then(function(){e(defs.BasicGetEmpty,{clusterId:""},s)}).then(n(defs.ChannelClose)).then(function(){e(defs.ChannelCloseOk,{},s)}).then(succeed(t),fail(t))})),test("RPC on closed channel",channelTest(function(e,n){open(e);var t=new Promise(function(n){e.on("error",function(e){assert.strictEqual(504,e.code),assert.strictEqual(0,e.classId),assert.strictEqual(0,e.methodId),n()})});function s(e,n){return function(t){null!==t?e():n()}}var c=new Promise(function(n,t){return e._rpc(defs.BasicRecover,{requeue:!0},defs.BasicRecoverOk,s(n,t))}),o=new Promise(function(n,t){return e._rpc(defs.BasicRecover,{requeue:!0},defs.BasicRecoverOk,s(n,t))});Promise.join(t,c,o).then(succeed(n)).catch(fail(n))},function(e,n,t,s){n(defs.BasicRecover)().then(function(){return e(defs.ChannelClose,{replyText:"Nuh-uh!",replyCode:defs.constants.CHANNEL_ERROR,methodId:0,classId:0},s),n(defs.ChannelCloseOk)}).then(succeed(t)).catch(fail(t))})),test("publish all < single chunk threshold",channelTest(function(e,n){open(e).then(function(){e.sendMessage({exchange:"foo",routingKey:"bar",mandatory:!1,immediate:!1,ticket:0},{},Buffer.from("foobar"))}).then(succeed(n),fail(n))},function(e,n,t,s){n(defs.BasicPublish)().then(n(defs.BasicProperties)).then(n(void 0)).then(function(e){assert.equal("foobar",e.content.toString())}).then(succeed(t),fail(t))})),test("publish content > single chunk threshold",channelTest(function(e,n){open(e),completes(function(){e.sendMessage({exchange:"foo",routingKey:"bar",mandatory:!1,immediate:!1,ticket:0},{},Buffer.alloc(3e3))},n)},function(e,n,t,s){n(defs.BasicPublish)().then(n(defs.BasicProperties)).then(n(void 0)).then(function(e){assert.equal(3e3,e.content.length)}).then(succeed(t),fail(t))})),test("publish method & headers > threshold",channelTest(function(e,n){open(e),completes(function(){e.sendMessage({exchange:"foo",routingKey:"bar",mandatory:!1,immediate:!1,ticket:0},{headers:{foo:Buffer.alloc(3e3)}},Buffer.from("foobar"))},n)},function(e,n,t,s){n(defs.BasicPublish)().then(n(defs.BasicProperties)).then(n(void 0)).then(function(e){assert.equal("foobar",e.content.toString())}).then(succeed(t),fail(t))})),test("publish zero-length message",channelTest(function(e,n){open(e),completes(function(){e.sendMessage({exchange:"foo",routingKey:"bar",mandatory:!1,immediate:!1,ticket:0},{},Buffer.alloc(0)),e.sendMessage({exchange:"foo",routingKey:"bar",mandatory:!1,immediate:!1,ticket:0},{},Buffer.alloc(0))},n)},function(e,n,t,s){n(defs.BasicPublish)().then(n(defs.BasicProperties)).then(n(defs.BasicPublish)).then(succeed(t),fail(t))})),test("delivery",channelTest(function(e,n){open(e),e.on("delivery",function(e){completes(function(){assert.equal("barfoo",e.content.toString())},n)})},function(e,n,t,s){completes(function(){e(defs.BasicDeliver,DELIVER_FIELDS,s,Buffer.from("barfoo"))},t)})),test("zero byte msg",channelTest(function(e,n){open(e),e.on("delivery",function(e){completes(function(){assert.deepEqual(Buffer.alloc(0),e.content)},n)})},function(e,n,t,s){completes(function(){e(defs.BasicDeliver,DELIVER_FIELDS,s,Buffer.from(""))},t)})),test("bad delivery",channelTest(function(e,n){var t=latch(2,n);e.on("error",function(e){assert.strictEqual(505,e.code),assert.strictEqual(60,e.classId),assert.strictEqual(60,e.methodId),succeed(t)()}),e.on("close",succeed(t)),open(e)},function(e,n,t,s){return e(defs.BasicDeliver,DELIVER_FIELDS,s),e(defs.BasicDeliver,DELIVER_FIELDS,s),n(defs.ChannelClose)().then(function(){e(defs.ChannelCloseOk,{},s)}).then(succeed(t),fail(t))})),test("bad content send",channelTest(function(e,n){completes(function(){open(e),assert.throws(function(){e.sendMessage({routingKey:"foo",exchange:"amq.direct"},{},null)})},n)},function(e,n,t,s){t()})),test("bad properties send",channelTest(function(e,n){completes(function(){open(e),assert.throws(function(){e.sendMessage({routingKey:"foo",exchange:"amq.direct"},{contentEncoding:7},Buffer.from("foobar"))})},n)},function(e,n,t,s){t()})),test("bad consumer",channelTest(function(e,n){var t=latch(2,n);e.on("delivery",function(){throw new Error("I am a bad consumer")}),e.on("error",function(e){assert.strictEqual(541,e.code),assert.strictEqual(void 0,e.classId),assert.strictEqual(void 0,e.methodId),succeed(t)()}),e.on("close",succeed(t)),open(e)},function(e,n,t,s){return e(defs.BasicDeliver,DELIVER_FIELDS,s,Buffer.from("barfoo")),n(defs.ChannelClose)().then(function(){e(defs.ChannelCloseOk,{},s)}).then(succeed(t),fail(t))})),test("bad send in consumer",channelTest(function(e,n){var t=latch(2,n);e.on("close",succeed(t)),e.on("error",function(e){assert.strictEqual(541,e.code),assert.strictEqual(void 0,e.classId),assert.strictEqual(void 0,e.methodId),succeed(t)()}),e.on("delivery",function(){e.sendMessage({routingKey:"foo",exchange:"amq.direct"},{},null)}),open(e)},function(e,n,t,s){return completes(function(){e(defs.BasicDeliver,DELIVER_FIELDS,s,Buffer.from("barfoo"))},t),n(defs.ChannelClose)().then(function(){e(defs.ChannelCloseOk,{},s)}).then(succeed(t),fail(t))})),test("return",channelTest(function(e,n){e.on("return",function(e){completes(function(){assert.equal("barfoo",e.content.toString())},n)}),open(e)},function(e,n,t,s){completes(function(){e(defs.BasicReturn,DELIVER_FIELDS,s,Buffer.from("barfoo"))},t)})),test("cancel",channelTest(function(e,n){e.on("cancel",function(e){completes(function(){assert.equal("product of society",e.consumerTag)},n)}),open(e)},function(e,n,t,s){completes(function(){e(defs.BasicCancel,{consumerTag:"product of society",nowait:!1},s)},t)})),e("ack",defs.BasicAck),e("nack",defs.BasicNack),test("out-of-order acks",channelTest(function(e,n){var t=latch(3,function(){completes(function(){assert.equal(0,e.unconfirmed.length),assert.equal(4,e.lwm)},n)});e.pushConfirmCallback(t),e.pushConfirmCallback(t),e.pushConfirmCallback(t),open(e)},function(e,n,t,s){completes(function(){e(defs.BasicAck,{deliveryTag:2,multiple:!1},s),e(defs.BasicAck,{deliveryTag:3,multiple:!1},s),e(defs.BasicAck,{deliveryTag:1,multiple:!1},s)},t)})),test("not all out-of-order acks",channelTest(function(e,n){var t=latch(2,function(){completes(function(){assert.equal(1,e.unconfirmed.length),assert.equal(3,e.lwm)},n)});e.pushConfirmCallback(t),e.pushConfirmCallback(t),e.pushConfirmCallback(function(){n(new Error("Confirm callback should not be called"))}),open(e)},function(e,n,t,s){completes(function(){e(defs.BasicAck,{deliveryTag:2,multiple:!1},s),e(defs.BasicAck,{deliveryTag:1,multiple:!1},s)},t)}))});