"use strict";var assert=require("assert"),crypto=require("crypto"),api=require("../callback_api"),util=require("./util"),schedule=util.schedule,randomString=util.randomString,kCallback=util.kCallback,domain=require("domain"),Buffer=require("safe-buffer").Buffer,URL=process.env.URL||"amqp://localhost";function connect(e){api.connect(URL,{},e)}function doneCallback(e){return function(n,t){null==n?e():e(n)}}function ignore(){}function twice(e){var n=function(n){void 0==n?t=e:(t=ignore,e(n))},t=function(t){void 0==t?n=e:(n=ignore,e(t))};return{first:function(e){n(e)},second:function(e){t(e)}}}function failCallback(e){return function(n,t){null==n?e(new Error("Expected failure, got "+val)):e()}}function waitForMessages(e,n,t){e.checkQueue(n,function(c,o){return null!=c?t(c):o.messageCount>0?t(null,o):void schedule(waitForMessages.bind(null,e,n,t))})}function channel_test_fn(e){return function(n,t){test(n,function(n){connect(kCallback(function(c){c[e](kCallback(function(e){t(e,n)},n))},n))})}}suite("connect",function(){test("at all",function(e){connect(doneCallback(e))})});var channel_test=channel_test_fn("createChannel"),confirm_channel_test=channel_test_fn("createConfirmChannel");suite("channel open",function(){channel_test("at all",function(e,n){n()}),channel_test("open and close",function(e,n){e.close(doneCallback(n))})}),suite("assert, check, delete",function(){channel_test("assert, check, delete queue",function(e,n){e.assertQueue("test.cb.queue",{},kCallback(function(t){e.checkQueue("test.cb.queue",kCallback(function(t){e.deleteQueue("test.cb.queue",{},doneCallback(n))},n))},n))}),channel_test("assert, check, delete exchange",function(e,n){e.assertExchange("test.cb.exchange","topic",{},kCallback(function(t){e.checkExchange("test.cb.exchange",kCallback(function(t){e.deleteExchange("test.cb.exchange",{},doneCallback(n))},n))},n))}),channel_test("fail on check non-queue",function(e,n){var t=twice(n);e.on("error",failCallback(t.first)),e.checkQueue("test.cb.nothere",failCallback(t.second))}),channel_test("fail on check non-exchange",function(e,n){var t=twice(n);e.on("error",failCallback(t.first)),e.checkExchange("test.cb.nothere",failCallback(t.second))})}),suite("bindings",function(){channel_test("bind queue",function(e,n){e.assertQueue("test.cb.bindq",{},kCallback(function(t){e.assertExchange("test.cb.bindex","fanout",{},kCallback(function(c){e.bindQueue(t.queue,c.exchange,"",{},doneCallback(n))},n))},n))}),channel_test("bind exchange",function(e,n){e.assertExchange("test.cb.bindex1","fanout",{},kCallback(function(t){e.assertExchange("test.cb.bindex2","fanout",{},kCallback(function(c){e.bindExchange(t.exchange,c.exchange,"",{},doneCallback(n))},n))},n))})}),suite("sending messages",function(){channel_test("send to queue and consume noAck",function(e,n){var t=randomString();e.assertQueue("",{exclusive:!0},function(c,o){if(null!==c)return n(c);e.consume(o.queue,function(e){e.content.toString()==t?n():n(new Error("message content doesn't match:"+t+" =/= "+e.content.toString()))},{noAck:!0,exclusive:!0}),e.sendToQueue(o.queue,Buffer.from(t))})}),channel_test("send to queue and consume ack",function(e,n){var t=randomString();e.assertQueue("",{exclusive:!0},function(c,o){if(null!==c)return n(c);e.consume(o.queue,function(c){c.content.toString()==t?(e.ack(c),n()):n(new Error("message content doesn't match:"+t+" =/= "+c.content.toString()))},{noAck:!1,exclusive:!0}),e.sendToQueue(o.queue,Buffer.from(t))})}),channel_test("send to and get from queue",function(e,n){e.assertQueue("",{exclusive:!0},function(t,c){if(null!=t)return n(t);var o=randomString();e.sendToQueue(c.queue,Buffer.from(o)),waitForMessages(e,c.queue,function(t,r){if(null!=t)return n(t);e.get(c.queue,{noAck:!0},function(e,t){return null!=e?n(e):t?t.content.toString()==o?n():n(new Error("Messages do not match: "+o+" =/= "+t.content.toString())):n(new Error("Empty (false) not expected"))})})})})}),suite("ConfirmChannel",function(){confirm_channel_test("Receive confirmation",function(e,n){e.publish("","",Buffer.from("foo"),{},n)}),confirm_channel_test("Wait for confirms",function(e,n){for(var t=0;t<1e3;t++)e.publish("","",Buffer.from("foo"),{});e.waitForConfirms(n)})}),suite("Error handling",function(){function e(e,n){test(e,function(e){var t=domain.createDomain();t.run(function(){connect(kCallback(function(c){t.add(c),c.createChannel(kCallback(function(c){n(c,e,t)},e))},e))})})}util.versionGreaterThan(process.versions.node,"0.8")&&test("Throw error in connection open callback",function(e){var n=domain.createDomain();n.on("error",failCallback(e)),connect(n.bind(function(e,n){throw new Error("Spurious connection open callback error")}))}),e("Channel open callback throws an error",function(e,n,t){throw t.on("error",failCallback(n)),new Error("Error in open callback")}),e("RPC callback throws error",function(e,n,t){t.on("error",failCallback(n)),e.prefetch(0,!1,function(e,n){throw new Error("Spurious callback error")})}),e("Get callback throws error",function(e,n,t){t.on("error",failCallback(n)),e.assertQueue("test.cb.get-with-error",{},function(n,t){e.get("test.cb.get-with-error",{noAck:!0},function(){throw new Error("Spurious callback error")})})}),e("Consume callback throws error",function(e,n,t){t.on("error",failCallback(n)),e.assertQueue("test.cb.consume-with-error",{},function(n,t){e.consume("test.cb.consume-with-error",ignore,{noAck:!0},function(){throw new Error("Spurious callback error")})})}),e("Get from non-queue invokes error k",function(e,n,t){var c=twice(failCallback(n));t.on("error",c.first),e.get("",{},c.second)}),e("Consume from non-queue invokes error k",function(e,n,t){var c=twice(failCallback(n));t.on("error",c.first),e.consume("",c.second)})});