"use strict";var defs=require("./defs"),constants=defs.constants,frame=require("./frame"),HEARTBEAT=frame.HEARTBEAT,Mux=require("./mux").Mux,Buffer=require("safe-buffer").Buffer,Duplex=require("stream").Duplex||require("readable-stream/duplex"),EventEmitter=require("events").EventEmitter,Heart=require("./heartbeat").Heart,methodName=require("./format").methodName,closeMsg=require("./format").closeMessage,inspect=require("./format").inspect,BitSet=require("./bitset").BitSet,inherits=require("util").inherits,fmt=require("util").format,PassThrough=require("stream").PassThrough||require("readable-stream/passthrough"),IllegalOperationError=require("./error").IllegalOperationError,stackCapture=require("./error").stackCapture,DEFAULT_WRITE_HWM=1024,SINGLE_CHUNK_THRESHOLD=2048;function Connection(e){EventEmitter.call(this);var t=this.stream=wrapStream(e);this.muxer=new Mux(t),this.rest=Buffer.alloc(0),this.frameMax=constants.FRAME_MIN_SIZE,this.sentSinceLastCheck=!1,this.recvSinceLastCheck=!1,this.expectSocketClose=!1,this.freeChannels=new BitSet,this.channels=[{channel:{accept:channel0(this)},buffer:e}]}inherits(Connection,EventEmitter);var C=Connection.prototype;function mainAccept(e){var t=this.channels[e.channel];if(t)return t.channel.accept(e);this.closeWithError(fmt("Frame on unknown channel %d",e.channel),constants.CHANNEL_ERROR,new Error(fmt("Frame on unknown channel: %s",inspect(e,!1))))}function channel0(e){return function(t){if(t===HEARTBEAT);else if(t.id===defs.ConnectionClose){e.sendMethod(0,defs.ConnectionCloseOk,{});var n=fmt("Connection closed: %s",closeMsg(t)),r=stackCapture(n),s=new Error(n);s.code=t.fields.replyCode,isFatalError(s)&&e.emit("error",s),e.toClosed(r,s)}else t.id===defs.ConnectionBlocked?e.emit("blocked",t.fields.reason):t.id===defs.ConnectionUnblocked?e.emit("unblocked"):e.closeWithError(fmt("Unexpected frame on channel 0"),constants.UNEXPECTED_FRAME,new Error(fmt("Unexpected frame on channel 0: %s",inspect(t,!1))))}}function invalidOp(e,t){return function(){throw new IllegalOperationError(e,t)}}function invalidateSend(e,t,n){e.sendMethod=e.sendContent=e.sendMessage=invalidOp(t,n)}C.sendProtocolHeader=function(){this.sendBytes(frame.PROTOCOL_HEADER)},C.open=function(e,t){var n=this,r=t||function(){},s=Object.create(e);function o(e){n.step(function(t,n){null!==t?i(t):0!==n.channel?i(new Error(fmt("Frame on channel != 0 during handshake: %s",inspect(n,!1)))):e(n)})}function a(e,t){o(function(n){n.id===e?t(n):i(new Error(fmt("Expected %s; got %s",methodName(e),inspect(n,!1))))})}function i(e){r(e)}function c(e){try{n.sendMethod(0,e,s)}catch(e){i(e)}}function h(e,t){return 0===e||0===t?Math.max(e,t):Math.min(e,t)}function f(t){switch(t.id){case defs.ConnectionSecure:i(new Error("Wasn't expecting to have to go through secure"));break;case defs.ConnectionClose:i(new Error(fmt("Handshake terminated by server: %s",closeMsg(t))));break;case defs.ConnectionTune:var n=t.fields;s.frameMax=h(n.frameMax,e.frameMax),s.channelMax=h(n.channelMax,e.channelMax),s.heartbeat=h(n.heartbeat,e.heartbeat),c(defs.ConnectionTuneOk),c(defs.ConnectionOpen),a(defs.ConnectionOpenOk,l);break;default:i(new Error(fmt("Expected connection.secure, connection.close, or connection.tune during handshake; got %s",inspect(t,!1))))}}function l(e){var t;n.channelMax=s.channelMax||65535,n.frameMax=s.frameMax||4294967295,n.heartbeat=s.heartbeat,n.heartbeater=n.startHeartbeater(),n.accept=mainAccept,t=e,n.stream.removeListener("end",u),n.stream.removeListener("error",u),n.stream.on("error",n.onSocketError.bind(n)),n.stream.on("end",n.onSocketError.bind(n,new Error("Unexpected close"))),n.on("frameError",n.onSocketError.bind(n)),n.acceptLoop(),r(null,t)}function u(e){i(e||new Error("Socket closed abruptly during opening handshake"))}this.stream.on("end",u),this.stream.on("error",u),this.sendProtocolHeader(),a(defs.ConnectionStart,function(t){t.fields.mechanisms.toString().split(" ").indexOf(e.mechanism)<0?i(new Error(fmt("SASL mechanism %s is not provided by the server",e.mechanism))):(n.serverProperties=t.fields.serverProperties,c(defs.ConnectionStartOk),o(f))})},C.close=function(e){var t=e&&function(){e(null)};this.closeBecause("Cheers, thanks",constants.REPLY_SUCCESS,t)},C.closeBecause=function(e,t,n){this.sendMethod(0,defs.ConnectionClose,{replyText:e,replyCode:t,methodId:0,classId:0});var r=stackCapture("closeBecause called: "+e);this.toClosing(r,n)},C.closeWithError=function(e,t,n){this.emit("error",n),this.closeBecause(e,t)},C.onSocketError=function(e){if(!this.expectSocketClose){this.expectSocketClose=!0,this.emit("error",e);var t=stackCapture("Socket error");this.toClosed(t,e)}},C.toClosing=function(e,t){var n=this.sendMethod.bind(this);this.accept=function(e){if(e.id===defs.ConnectionCloseOk){t&&t();var r=stackCapture("ConnectionCloseOk received");this.toClosed(r,void 0)}else e.id===defs.ConnectionClose&&n(0,defs.ConnectionCloseOk,{})},invalidateSend(this,"Connection closing",e)},C._closeChannels=function(e){for(var t=1;t<this.channels.length;t++){var n=this.channels[t];null!==n&&n.channel.toClosed(e)}},C.toClosed=function(e,t){this._closeChannels(e);var n=fmt("Connection closed (%s)",t?t.toString():"by client");invalidateSend(this,n,e),this.accept=invalidOp(n,e),this.close=function(t){t&&t(new IllegalOperationError(n,e))},this.heartbeater&&this.heartbeater.clear(),this.expectSocketClose=!0,this.stream.end(),this.emit("close",t)},C.startHeartbeater=function(){if(0===this.heartbeat)return null;var e=this,t=new Heart(this.heartbeat,this.checkSend.bind(this),this.checkRecv.bind(this));return t.on("timeout",function(){var t=new Error("Heartbeat timeout");e.emit("error",t);var n=stackCapture("Heartbeat timeout");e.toClosed(n,t)}),t.on("beat",function(){e.sendHeartbeat()}),t},C.freshChannel=function(e,t){var n=this.freeChannels.nextClearBit(1);if(n<0||n>this.channelMax)throw new Error("No channels left to allocate");this.freeChannels.set(n);var r=t&&t.highWaterMark||DEFAULT_WRITE_HWM,s=new PassThrough({objectMode:!0,highWaterMark:r});return this.channels[n]={channel:e,buffer:s},s.on("drain",function(){e.onBufferDrain()}),this.muxer.pipeFrom(s),n},C.releaseChannel=function(e){this.freeChannels.clear(e),this.channels[e].buffer.end(),this.channels[e]=null},C.acceptLoop=function(){var e=this;function t(){try{for(var t;t=e.recvFrame();)e.accept(t)}catch(t){e.emit("frameError",t)}}e.stream.on("readable",t),t()},C.step=function(e){var t=this;!function n(){var r;try{r=t.recvFrame()}catch(t){return void e(t,null)}r?e(null,r):t.stream.once("readable",n)}()},C.checkSend=function(){var e=this.sentSinceLastCheck;return this.sentSinceLastCheck=!1,e},C.checkRecv=function(){var e=this.recvSinceLastCheck;return this.recvSinceLastCheck=!1,e},C.sendBytes=function(e){this.sentSinceLastCheck=!0,this.stream.write(e)},C.sendHeartbeat=function(){return this.sendBytes(frame.HEARTBEAT_BUF)};var encodeMethod=defs.encodeMethod,encodeProperties=defs.encodeProperties;C.sendMethod=function(e,t,n){var r=encodeMethod(t,e,n);return this.sentSinceLastCheck=!0,this.channels[e].buffer.write(r)},C.sendMessage=function(e,t,n,r,s,o){if(!Buffer.isBuffer(o))throw new TypeError("content is not a buffer");var a=encodeMethod(t,e,n),i=encodeProperties(r,e,o.length,s),c=this.channels[e].buffer;this.sentSinceLastCheck=!0;var h=a.length+i.length,f=o.length>0?o.length+FRAME_OVERHEAD:0,l=h+f;if(l<SINGLE_CHUNK_THRESHOLD){var u=Buffer.alloc(l),d=a.copy(u,0);return d+=i.copy(u,d),f>0&&makeBodyFrame(e,o).copy(u,d),c.write(u)}if(h<SINGLE_CHUNK_THRESHOLD){var m=Buffer.alloc(h);d=a.copy(m,0);i.copy(m,d),c.write(m)}else c.write(a),c.write(i);return this.sendContent(e,o)};var FRAME_OVERHEAD=defs.FRAME_OVERHEAD,makeBodyFrame=frame.makeBodyFrame;C.sendContent=function(e,t){if(!Buffer.isBuffer(t))throw new TypeError(fmt("Expected buffer; got %s",t));for(var n=!0,r=this.channels[e].buffer,s=this.frameMax-FRAME_OVERHEAD,o=0;o<t.length;o+=s){var a=o+s,i=a>t.length?t.slice(o):t.slice(o,a),c=makeBodyFrame(e,i);n=r.write(c)}return this.sentSinceLastCheck=!0,n};var parseFrame=frame.parseFrame,decodeFrame=frame.decodeFrame;function wrapStream(e){if(e instanceof Duplex)return e;var t=new Duplex;return t.wrap(e),t._write=function(t,n,r){return e.write(t,n,r)},t}function isFatalError(e){switch(e&&e.code){case defs.constants.CONNECTION_FORCED:case defs.constants.REPLY_SUCCESS:return!1;default:return!0}}C.recvFrame=function(){var e=parseFrame(this.rest,this.frameMax);if(e)return this.rest=e.rest,decodeFrame(e);var t=this.stream.read();return null!==t&&(this.recvSinceLastCheck=!0,this.rest=Buffer.concat([this.rest,t]),this.recvFrame())},module.exports.Connection=Connection,module.exports.isFatalError=isFatalError;