"use strict";var defs=require("./defs"),closeMsg=require("./format").closeMessage,inspect=require("./format").inspect,methodName=require("./format").methodName,assert=require("assert"),inherits=require("util").inherits,EventEmitter=require("events").EventEmitter,fmt=require("util").format,IllegalOperationError=require("./error").IllegalOperationError,stackCapture=require("./error").stackCapture,Buffer=require("safe-buffer").Buffer;function Channel(e){EventEmitter.call(this),this.connection=e,this.reply=null,this.pending=[],this.lwm=1,this.unconfirmed=[],this.on("ack",this.handleConfirm.bind(this,function(e){e&&e(null)})),this.on("nack",this.handleConfirm.bind(this,function(e){e&&e(new Error("message nacked"))})),this.on("close",function(){for(var e;e=this.unconfirmed.shift();)e&&e(new Error("channel closed"))}),this.handleMessage=acceptDeliveryOrReturn}inherits(Channel,EventEmitter),module.exports.Channel=Channel,module.exports.acceptMessage=acceptMessage;var C=Channel.prototype;function invalidOp(e,n){return function(){throw new IllegalOperationError(e,n)}}function invalidateSend(e,n,t){e.sendImmediately=e.sendOrEnqueue=e.sendMessage=invalidOp(n,t)}function acceptDeliveryOrReturn(e){var n;if(e.id===defs.BasicDeliver)n="delivery";else{if(e.id!==defs.BasicReturn)throw fmt("Expected BasicDeliver or BasicReturn; got %s",inspect(e));n="return"}var t=this,s=e.fields;return acceptMessage(function(e){e.fields=s,t.emit(n,e)})}function acceptMessage(e){var n=0,t=0,s=null,i={fields:null,properties:null,content:null};return function(s){if(s.id===defs.BasicProperties)return i.properties=s.fields,0===(n=t=s.size)?(i.content=Buffer.alloc(0),e(i),acceptDeliveryOrReturn):r;throw"Expected headers frame after delivery"};function r(o){if(o.content){var l=o.content.length;if(0===(t-=l))return null!==s?(s.push(o.content),i.content=Buffer.concat(s)):i.content=o.content,e(i),acceptDeliveryOrReturn;if(t<0)throw fmt("Too much content sent! Expected %d bytes",n);return null!==s?s.push(o.content):s=[o.content],r}throw"Expected content frame after headers"}}function BaseChannel(e){Channel.call(this,e),this.consumers={}}C.allocate=function(){return this.ch=this.connection.freshChannel(this),this},C.sendImmediately=function(e,n){return this.connection.sendMethod(this.ch,e,n)},C.sendOrEnqueue=function(e,n,t){this.reply?this.pending.push({method:e,fields:n,reply:t}):(assert(0===this.pending.length),this.reply=t,this.sendImmediately(e,n))},C.sendMessage=function(e,n,t){return this.connection.sendMessage(this.ch,defs.BasicPublish,e,defs.BasicProperties,n,t)},C._rpc=function(e,n,t,s){var i=this;this.sendOrEnqueue(e,n,function(n,r){if(null===n){if(r.id===t)return s(null,r);var o=methodName(t),l=new Error(fmt("Expected %s; got %s",o,inspect(r,!1)));return i.closeWithError(r.id,fmt("Expected %s; got %s",o,methodName(r.id)),defs.constants.UNEXPECTED_FRAME,l),s(l)}if(n instanceof Error)return s(n);var a=(n.fields.classId<<16)+n.fields.methodId,c=(l=e===a?fmt("Operation failed: %s; %s",methodName(e),closeMsg(n)):fmt("Channel closed by server: %s",closeMsg(n)),new Error(l));return c.code=n.fields.replyCode,c.classId=n.fields.classId,c.methodId=n.fields.methodId,s(c)})},C.toClosed=function(e){this._rejectPending(),invalidateSend(this,"Channel closed",e),this.accept=invalidOp("Channel closed",e),this.connection.releaseChannel(this.ch),this.emit("close")},C.toClosing=function(e,n){var t=this.sendImmediately.bind(this);invalidateSend(this,"Channel closing",e),this.accept=function(e){if(e.id===defs.ChannelCloseOk){n&&n();var s=stackCapture("ChannelCloseOk frame received");this.toClosed(s)}else e.id===defs.ChannelClose&&t(defs.ChannelCloseOk,{})}},C._rejectPending=function(){function e(e){e(new Error("Channel ended, no reply will be forthcoming"))}var n;for(null!==this.reply&&e(this.reply),this.reply=null;n=this.pending.shift();)e(n.reply);this.pending=null},C.closeBecause=function(e,n,t){this.sendImmediately(defs.ChannelClose,{replyText:e,replyCode:n,methodId:0,classId:0});var s=stackCapture("closeBecause called: "+e);this.toClosing(s,t)},C.closeWithError=function(e,n,t,s){var i=this;this.closeBecause(n,t,function(){s.code=t,e&&(s.classId=defs.info(e).classId,s.methodId=defs.info(e).methodId),i.emit("error",s)})},C.acceptMessageFrame=function(e){try{this.handleMessage=this.handleMessage(e)}catch(n){"string"==typeof n?this.closeWithError(e.id,n,defs.constants.UNEXPECTED_FRAME,new Error(n)):n instanceof Error?this.closeWithError(e.id,"Error while processing message",defs.constants.INTERNAL_ERROR,n):this.closeWithError(e.id,"Internal error while processing message",defs.constants.INTERNAL_ERROR,new Error(n.toString()))}},C.handleConfirm=function(e,n){var t=n.deliveryTag;if(n.multiple){var s=this.unconfirmed.splice(0,t-this.lwm+1);this.lwm=t+1,s.forEach(e)}else{var i;if(t===this.lwm)for(i=this.unconfirmed.shift(),this.lwm++;null===this.unconfirmed[0];)this.unconfirmed.shift(),this.lwm++;else i=this.unconfirmed[t-this.lwm],this.unconfirmed[t-this.lwm]=null;e(i)}},C.pushConfirmCallback=function(e){this.unconfirmed.push(e||!1)},C.accept=function(e){switch(e.id){case void 0:case defs.BasicDeliver:case defs.BasicReturn:case defs.BasicProperties:return this.acceptMessageFrame(e);case defs.BasicAck:return this.emit("ack",e.fields);case defs.BasicNack:return this.emit("nack",e.fields);case defs.BasicCancel:return this.emit("cancel",e.fields);case defs.ChannelClose:if(this.reply){var n=this.reply;this.reply=null,n(e)}var t="Channel closed by server: "+closeMsg(e);this.sendImmediately(defs.ChannelCloseOk,{});var s=new Error(t);s.code=e.fields.replyCode,s.classId=e.fields.classId,s.methodId=e.fields.methodId,this.emit("error",s);var i=stackCapture(t);return void this.toClosed(i);case defs.BasicFlow:return this.closeWithError(e.id,"Flow not implemented",defs.constants.NOT_IMPLEMENTED,new Error("Flow not implemented"));default:n=this.reply;if(this.reply=null,this.pending.length>0){var r=this.pending.shift();this.reply=r.reply,this.sendImmediately(r.method,r.fields)}return n(null,e)}},C.onBufferDrain=function(){this.emit("drain")},inherits(BaseChannel,Channel),module.exports.BaseChannel=BaseChannel,BaseChannel.prototype.registerConsumer=function(e,n){this.consumers[e]=n},BaseChannel.prototype.unregisterConsumer=function(e){delete this.consumers[e]},BaseChannel.prototype.dispatchMessage=function(e,n){var t=e.consumerTag,s=this.consumers[t];if(s)return s(n);throw new Error("Unknown consumer: "+t)},BaseChannel.prototype.handleDelivery=function(e){return this.dispatchMessage(e.fields,e)},BaseChannel.prototype.handleCancel=function(e){return this.dispatchMessage(e,null)};