"use strict";const winston=require("winston"),fs=require("fs"),utils=require("./common/utils"),formats=require("./common/format"),configSchema=require("./schema/config.json"),path=require("path");let initialized=!1,loggerConfig={},isSpecialEnabled=!1;const ignoreExitCodes=["ENOTFOUND"];utils.compileSchema(configSchema);const getProcessLogger=()=>winston.loggers.get(process.name),getSpecialLogger=()=>winston.loggers.get("specialLogger"),checkLoggingLevel=(e,o)=>e.levels[e.level]>=e.levels[o];function Logger(){}Logger.getLogger=(e=>{if(!initialized)throw new Error("Logger is not initialized");return new Proxy(getProcessLogger(),{get:(o,t)=>(...r)=>{if(!o.writable)return;if("end"===t)return o&&o[t]?o[t](...r):void 0;let s=o[t];if(isSpecialEnabled&&getSpecialLogger()[t])s=getSpecialLogger()[t];else if(!checkLoggingLevel(o,t))return;return s(...r,{module:e})}})}),Logger.updateConfig=(e=>{utils.validateConfig(e),loggerConfig=e;const o=e.override||{},t=getProcessLogger();t.warn(">>>>>>>>>>>>>> Logger configuration reloaded >>>>>>>>>>>>>>",{module:"logger"}),t.level=o[process.name]||e.level}),Logger.syslog=(()=>require("./syslog")),Logger.initialize=((e,o=!1)=>{if(initialized)return;utils.validateConfig(e),loggerConfig=e;const t="production"===process.env.NODE_ENV,r=path.resolve(loggerConfig.filepath);fs.existsSync(r)||fs.mkdirSync(r);const s=path.join(r,loggerConfig.fileInitial||"cns_"),i={access:s+(loggerConfig.fileNames.access||"access.log"),beta:s+(loggerConfig.fileNames.beta||"beta.log"),debug:s+(loggerConfig.fileNames.debug||"debug.log"),error:s+(loggerConfig.fileNames.error||"error.log"),exception:s+(loggerConfig.fileNames.exception||"exception.log"),info:s+(loggerConfig.fileNames.info||"info.log"),security:s+(loggerConfig.fileNames.security||"security.log"),stats:s+(loggerConfig.fileNames.stats||"stats.log"),watch:s+(loggerConfig.fileNames.watch||"watch.log")},a=loggerConfig.override||{};let l=utils.createTransportOpts([{opts:{filename:i.error,format:formats.filterFactory("critical")()},levels:["critical"]},{opts:{filename:i.error,format:formats.filterFactory("error")()},levels:["error"]},{opts:{filename:i.info,format:formats.filterFactory("warn")()},levels:["warn"]},{opts:{filename:i.info,format:formats.filterFactory("info")()},levels:["info"]},{opts:{filename:i.debug,format:formats.filterFactory("debug")()},levels:["debug"]},{opts:{filename:i.debug,format:formats.filterFactory("data")()},levels:["data"]}]).map(e=>new winston.transports.File(e));t||(winston.addColors(loggerConfig.colors),l.push(new winston.transports.Console({format:formats.consoleFormat})),winston.add(new winston.transports.Console({handleExceptions:!0,format:formats.exceptionFormat}))),winston.add(new winston.transports.File({filename:i.exception,handleExceptions:!0,format:formats.exceptionFormat})),winston.exitOnError=(e=>!ignoreExitCodes.includes(e.code)),winston.loggers.add(process.name,{level:a[process.name]||loggerConfig.level,levels:loggerConfig.levels,format:formats.getDefaultFormat,defaultMeta:{app:process.name,wname:process.wname||process.title},transports:l}),o&&(isSpecialEnabled=!0,createSpecialLogger(i)),getProcessLogger().on("finish",()=>{setTimeout(()=>{process.exit(1)},500)}),initialized=!0});const createSpecialLogger=e=>{const o=utils.createTransportOpts([{opts:{filename:e.watch,format:formats.filterFactory("watch")()},levels:["watch"]},{opts:{filename:e.beta,format:formats.filterFactory("beta")()},levels:["beta"]},{opts:{filename:e.access,format:formats.filterFactory("access")()},levels:["access"]},{opts:{filename:e.security,format:formats.filterFactory("security")()},levels:["security"]},{opts:{filename:e.stats,format:formats.filterFactory("stats")()},levels:["stats"]}]);winston.loggers.add("specialLogger",{level:"security",levels:{watch:0,beta:1,access:2,stats:3,security:4},format:formats.getDefaultFormat,defaultMeta:{app:process.name,wname:process.wname||process.title},transports:o.map(e=>new winston.transports.File(e))})};module.exports=Logger;