import UnicodeTrie from 'unicode-trie';
import base64 from 'base64-js';

var categories=["Cc","Zs","Po","Sc","Ps","Pe","Sm","Pd","Nd","Lu","Sk","Pc","Ll","So","Lo","Pi","Cf","No","Pf","Lt","Lm","Mn","Me","Mc","Nl","Zl","Zp","Cs","Co"];var combiningClasses=["Not_Reordered","Above","Above_Right","Below","Attached_Above_Right","Attached_Below","Overlay","Iota_Subscript","Double_Below","Double_Above","Below_Right","Above_Left","CCC10","CCC11","CCC12","CCC13","CCC14","CCC15","CCC16","CCC17","CCC18","CCC19","CCC20","CCC21","CCC22","CCC23","CCC24","CCC25","CCC30","CCC31","CCC32","CCC27","CCC28","CCC29","CCC33","CCC34","CCC35","CCC36","Nukta","Virama","CCC84","CCC91","CCC103","CCC107","CCC118","CCC122","CCC129","CCC130","CCC132","Attached_Above","Below_Left","Left","Kana_Voicing","CCC26","Right"];var scripts=["Common","Latin","Bopomofo","Inherited","Greek","Coptic","Cyrillic","Armenian","Hebrew","Arabic","Syriac","Thaana","Nko","Samaritan","Mandaic","Devanagari","Bengali","Gurmukhi","Gujarati","Oriya","Tamil","Telugu","Kannada","Malayalam","Sinhala","Thai","Lao","Tibetan","Myanmar","Georgian","Hangul","Ethiopic","Cherokee","Canadian_Aboriginal","Ogham","Runic","Tagalog","Hanunoo","Buhid","Tagbanwa","Khmer","Mongolian","Limbu","Tai_Le","New_Tai_Lue","Buginese","Tai_Tham","Balinese","Sundanese","Batak","Lepcha","Ol_Chiki","Braille","Glagolitic","Tifinagh","Han","Hiragana","Katakana","Yi","Lisu","Vai","Bamum","Syloti_Nagri","Phags_Pa","Saurashtra","Kayah_Li","Rejang","Javanese","Cham","Tai_Viet","Meetei_Mayek","null","Linear_B","Lycian","Carian","Old_Italic","Gothic","Old_Permic","Ugaritic","Old_Persian","Deseret","Shavian","Osmanya","Elbasan","Caucasian_Albanian","Linear_A","Cypriot","Imperial_Aramaic","Palmyrene","Nabataean","Hatran","Phoenician","Lydian","Meroitic_Hieroglyphs","Meroitic_Cursive","Kharoshthi","Old_South_Arabian","Old_North_Arabian","Manichaean","Avestan","Inscriptional_Parthian","Inscriptional_Pahlavi","Psalter_Pahlavi","Old_Turkic","Old_Hungarian","Brahmi","Kaithi","Sora_Sompeng","Chakma","Mahajani","Sharada","Khojki","Multani","Khudawadi","Grantha","Tirhuta","Siddham","Modi","Takri","Ahom","Warang_Citi","Pau_Cin_Hau","Cuneiform","Egyptian_Hieroglyphs","Anatolian_Hieroglyphs","Mro","Bassa_Vah","Pahawh_Hmong","Miao","Duployan","SignWriting","Mende_Kikakui"];var eaw=["N","Na","A","W","H","F"];var data = {categories:categories,combiningClasses:combiningClasses,scripts:scripts,eaw:eaw};

var data$1="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";var trieData = {data:data$1};

var log2 = Math.log2 || (n => Math.log(n) / Math.LN2);

var bits = n => log2(n) + 1 | 0;

var buildUnicodeProperties = (data, trie) => {
  // compute the number of bits stored for each field
  var CATEGORY_BITS = bits(data.categories.length - 1);
  var COMBINING_BITS = bits(data.combiningClasses.length - 1);
  var SCRIPT_BITS = bits(data.scripts.length - 1);
  var EAW_BITS = bits(data.eaw.length - 1);
  var NUMBER_BITS = 10; // compute shift and mask values for each field

  var CATEGORY_SHIFT = COMBINING_BITS + SCRIPT_BITS + EAW_BITS + NUMBER_BITS;
  var COMBINING_SHIFT = SCRIPT_BITS + EAW_BITS + NUMBER_BITS;
  var SCRIPT_SHIFT = EAW_BITS + NUMBER_BITS;
  var EAW_SHIFT = NUMBER_BITS;
  var CATEGORY_MASK = (1 << CATEGORY_BITS) - 1;
  var COMBINING_MASK = (1 << COMBINING_BITS) - 1;
  var SCRIPT_MASK = (1 << SCRIPT_BITS) - 1;
  var EAW_MASK = (1 << EAW_BITS) - 1;
  var NUMBER_MASK = (1 << NUMBER_BITS) - 1;

  var getCategory = codePoint => {
    var val = trie.get(codePoint);
    return data.categories[val >> CATEGORY_SHIFT & CATEGORY_MASK];
  };

  var getCombiningClass = codePoint => {
    var val = trie.get(codePoint);
    return data.combiningClasses[val >> COMBINING_SHIFT & COMBINING_MASK];
  };

  var getScript = codePoint => {
    var val = trie.get(codePoint);
    return data.scripts[val >> SCRIPT_SHIFT & SCRIPT_MASK];
  };

  var getEastAsianWidth = codePoint => {
    var val = trie.get(codePoint);
    return data.eaw[val >> EAW_SHIFT & EAW_MASK];
  };

  var getNumericValue = codePoint => {
    var val = trie.get(codePoint);
    var num = val & NUMBER_MASK;

    if (num === 0) {
      return null;
    } else if (num <= 50) {
      return num - 1;
    } else if (num < 0x1e0) {
      var numerator = (num >> 4) - 12;
      var denominator = (num & 0xf) + 1;
      return numerator / denominator;
    } else if (num < 0x300) {
      val = (num >> 5) - 14;
      var exp = (num & 0x1f) + 2;

      while (exp > 0) {
        val *= 10;
        exp--;
      }

      return val;
    } else {
      val = (num >> 2) - 0xbf;

      var _exp = (num & 3) + 1;

      while (_exp > 0) {
        val *= 60;
        _exp--;
      }

      return val;
    }
  };

  var isAlphabetic = codePoint => {
    var category = getCategory(codePoint);
    return category === 'Lu' || category === 'Ll' || category === 'Lt' || category === 'Lm' || category === 'Lo' || category === 'Nl';
  };

  var isDigit = codePoint => getCategory(codePoint) === 'Nd';

  var isPunctuation = codePoint => {
    var category = getCategory(codePoint);
    return category === 'Pc' || category === 'Pd' || category === 'Pe' || category === 'Pf' || category === 'Pi' || category === 'Po' || category === 'Ps';
  };

  var isLowerCase = codePoint => {
    return getCategory(codePoint) === 'Ll';
  };

  var isUpperCase = codePoint => getCategory(codePoint) === 'Lu';

  var isTitleCase = codePoint => getCategory(codePoint) === 'Lt';

  var isWhiteSpace = codePoint => {
    var category = getCategory(codePoint);
    return category === 'Zs' || category === 'Zl' || category === 'Zp';
  };

  var isBaseForm = codePoint => {
    var category = getCategory(codePoint);
    return category === 'Nd' || category === 'No' || category === 'Nl' || category === 'Lu' || category === 'Ll' || category === 'Lt' || category === 'Lm' || category === 'Lo' || category === 'Me' || category === 'Mc';
  };

  var isMark = codePoint => {
    var category = getCategory(codePoint);
    return category === 'Mn' || category === 'Me' || category === 'Mc';
  };

  return {
    getCategory,
    getCombiningClass,
    getScript,
    getEastAsianWidth,
    getNumericValue,
    isAlphabetic,
    isDigit,
    isPunctuation,
    isLowerCase,
    isUpperCase,
    isTitleCase,
    isWhiteSpace,
    isBaseForm,
    isMark
  };
};

var trie = new UnicodeTrie(base64.toByteArray(trieData.data));
var unicodeProperties = buildUnicodeProperties(data, trie);

export default unicodeProperties;
//# sourceMappingURL=unicode-properties.browser.es.js.map
