"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var CSVError_1 = __importDefault(require("./CSVError"));
var set_1 = __importDefault(require("lodash/set"));
var numReg = /^[-+]?[0-9]*\.?[0-9]+([eE][-+]?[0-9]+)?$/;
function default_1(csvRows, conv) {
    var res = [];
    for (var i = 0, len = csvRows.length; i < len; i++) {
        var r = processRow(csvRows[i], conv, i);
        if (r) {
            res.push(r);
        }
    }
    return res;
}
exports.default = default_1;
;
function processRow(row, conv, index) {
    if (conv.parseParam.checkColumn && conv.parseRuntime.headers && row.length !== conv.parseRuntime.headers.length) {
        throw (CSVError_1.default.column_mismatched(conv.parseRuntime.parsedLineNumber + index));
    }
    var headRow = conv.parseRuntime.headers || [];
    var resultRow = convertRowToJson(row, headRow, conv);
    if (resultRow) {
        return resultRow;
    }
    else {
        return null;
    }
}
function convertRowToJson(row, headRow, conv) {
    var hasValue = false;
    var resultRow = {};
    for (var i = 0, len = row.length; i < len; i++) {
        var item = row[i];
        if (conv.parseParam.ignoreEmpty && item === '') {
            continue;
        }
        hasValue = true;
        var head = headRow[i];
        if (!head || head === "") {
            head = headRow[i] = "field" + (i + 1);
        }
        var convFunc = getConvFunc(head, i, conv);
        if (convFunc) {
            var convRes = convFunc(item, head, resultRow, row, i);
            if (convRes !== undefined) {
                setPath(resultRow, head, convRes, conv, i);
            }
        }
        else {
            // var flag = getFlag(head, i, param);
            // if (flag === 'omit') {
            //   continue;
            // }
            if (conv.parseParam.checkType) {
                var convertFunc = checkType(item, head, i, conv);
                item = convertFunc(item);
            }
            if (item !== undefined) {
                setPath(resultRow, head, item, conv, i);
            }
        }
    }
    if (hasValue) {
        return resultRow;
    }
    else {
        return null;
    }
}
var builtInConv = {
    "string": stringType,
    "number": numberType,
    "omit": function () { }
};
function getConvFunc(head, i, conv) {
    if (conv.parseRuntime.columnConv[i] !== undefined) {
        return conv.parseRuntime.columnConv[i];
    }
    else {
        var flag = conv.parseParam.colParser[head];
        if (flag === undefined) {
            return conv.parseRuntime.columnConv[i] = null;
        }
        if (typeof flag === "object") {
            flag = flag.cellParser || "string";
        }
        if (typeof flag === "string") {
            flag = flag.trim().toLowerCase();
            var builtInFunc = builtInConv[flag];
            if (builtInFunc) {
                return conv.parseRuntime.columnConv[i] = builtInFunc;
            }
            else {
                return conv.parseRuntime.columnConv[i] = null;
            }
        }
        else if (typeof flag === "function") {
            return conv.parseRuntime.columnConv[i] = flag;
        }
        else {
            return conv.parseRuntime.columnConv[i] = null;
        }
    }
}
function setPath(resultJson, head, value, conv, headIdx) {
    if (!conv.parseRuntime.columnValueSetter[headIdx]) {
        if (conv.parseParam.flatKeys) {
            conv.parseRuntime.columnValueSetter[headIdx] = flatSetter;
        }
        else {
            if (head.indexOf(".") > -1) {
                if (conv.parseParam.colParser[head] && conv.parseParam.colParser[head].flat) {
                    conv.parseRuntime.columnValueSetter[headIdx] = flatSetter;
                }
                else {
                    conv.parseRuntime.columnValueSetter[headIdx] = jsonSetter;
                }
            }
            else {
                conv.parseRuntime.columnValueSetter[headIdx] = flatSetter;
            }
        }
    }
    conv.parseRuntime.columnValueSetter[headIdx](resultJson, head, value);
    // flatSetter(resultJson, head, value);
}
function flatSetter(resultJson, head, value) {
    resultJson[head] = value;
}
function jsonSetter(resultJson, head, value) {
    set_1.default(resultJson, head, value);
}
function checkType(item, head, headIdx, conv) {
    if (conv.parseRuntime.headerType[headIdx]) {
        return conv.parseRuntime.headerType[headIdx];
    }
    else if (head.indexOf('number#!') > -1) {
        return conv.parseRuntime.headerType[headIdx] = numberType;
    }
    else if (head.indexOf('string#!') > -1) {
        return conv.parseRuntime.headerType[headIdx] = stringType;
    }
    else if (conv.parseParam.checkType) {
        return conv.parseRuntime.headerType[headIdx] = dynamicType;
    }
    else {
        return conv.parseRuntime.headerType[headIdx] = stringType;
    }
}
function numberType(item) {
    var rtn = parseFloat(item);
    if (isNaN(rtn)) {
        return item;
    }
    return rtn;
}
function stringType(item) {
    return item.toString();
}
function dynamicType(item) {
    var trimed = item.trim();
    if (trimed === "") {
        return stringType(item);
    }
    if (numReg.test(trimed)) {
        return numberType(item);
    }
    else if (trimed.length === 5 && trimed.toLowerCase() === "false" || trimed.length === 4 && trimed.toLowerCase() === "true") {
        return booleanType(item);
    }
    else if (trimed[0] === "{" && trimed[trimed.length - 1] === "}" || trimed[0] === "[" && trimed[trimed.length - 1] === "]") {
        return jsonType(item);
    }
    else {
        return stringType(item);
    }
}
function booleanType(item) {
    var trimed = item.trim();
    if (trimed.length === 5 && trimed.toLowerCase() === "false") {
        return false;
    }
    else {
        return true;
    }
}
function jsonType(item) {
    try {
        return JSON.parse(item);
    }
    catch (e) {
        return item;
    }
}
//# sourceMappingURL=lineToJson.js.map