"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var bluebird_1 = __importDefault(require("bluebird"));
var Result = /** @class */ (function () {
    function Result(converter) {
        this.converter = converter;
        this.finalResult = [];
    }
    Object.defineProperty(Result.prototype, "needEmitLine", {
        get: function () {
            return !!this.converter.parseRuntime.subscribe && !!this.converter.parseRuntime.subscribe.onNext || this.needPushDownstream;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Result.prototype, "needPushDownstream", {
        get: function () {
            if (this._needPushDownstream === undefined) {
                this._needPushDownstream = this.converter.listeners("data").length > 0 || this.converter.listeners("readable").length > 0;
            }
            return this._needPushDownstream;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Result.prototype, "needEmitAll", {
        get: function () {
            return !!this.converter.parseRuntime.then;
        },
        enumerable: true,
        configurable: true
    });
    Result.prototype.processResult = function (resultLines) {
        var _this = this;
        var startPos = this.converter.parseRuntime.parsedLineNumber;
        // let prom: P<any>;
        return new bluebird_1.default(function (resolve, reject) {
            if (_this.needEmitLine) {
                processLineByLine(resultLines, _this.converter, 0, _this.needPushDownstream, function (err) {
                    if (err) {
                        reject(err);
                    }
                    else {
                        _this.appendFinalResult(resultLines);
                        resolve();
                    }
                });
                // resolve();
            }
            else {
                _this.appendFinalResult(resultLines);
                resolve();
            }
        });
    };
    Result.prototype.appendFinalResult = function (lines) {
        if (this.needEmitAll) {
            this.finalResult = this.finalResult.concat(lines);
        }
        this.converter.parseRuntime.parsedLineNumber += lines.length;
    };
    Result.prototype.processError = function (err) {
        if (this.converter.parseRuntime.subscribe && this.converter.parseRuntime.subscribe.onError) {
            this.converter.parseRuntime.subscribe.onError(err);
        }
        if (this.converter.parseRuntime.then && this.converter.parseRuntime.then.onrejected) {
            this.converter.parseRuntime.then.onrejected(err);
        }
    };
    Result.prototype.endProcess = function () {
        if (this.needEmitAll) {
            if (this.converter.parseRuntime.then && this.converter.parseRuntime.then.onfulfilled) {
                this.converter.parseRuntime.then.onfulfilled(this.finalResult);
            }
        }
        if (this.converter.parseRuntime.subscribe && this.converter.parseRuntime.subscribe.onCompleted) {
            this.converter.parseRuntime.subscribe.onCompleted();
        }
    };
    return Result;
}());
exports.Result = Result;
function processLineByLine(lines, conv, offset, needPushDownstream, cb) {
    if (offset >= lines.length) {
        cb();
    }
    else {
        if (conv.parseRuntime.subscribe && conv.parseRuntime.subscribe.onNext) {
            var hook_1 = conv.parseRuntime.subscribe.onNext;
            var nextLine_1 = lines[offset];
            var res = hook_1(nextLine_1, conv.parseRuntime.parsedLineNumber + offset);
            offset++;
            // if (isAsync === undefined) {
            if (res && res.then) {
                res.then(function () {
                    processRecursive(lines, hook_1, conv, offset, needPushDownstream, cb, nextLine_1);
                }, cb);
            }
            else {
                // processRecursive(lines, hook, conv, offset, needPushDownstream, cb, nextLine, false);
                if (needPushDownstream) {
                    pushDownstream(conv, nextLine_1);
                }
                while (offset < lines.length) {
                    var line = lines[offset];
                    hook_1(line, conv.parseRuntime.parsedLineNumber + offset);
                    offset++;
                    if (needPushDownstream) {
                        pushDownstream(conv, line);
                    }
                }
                cb();
            }
            // } else if (isAsync === true) {
            //   (res as PromiseLike<void>).then(function () {
            //     processRecursive(lines, hook, conv, offset, needPushDownstream, cb, nextLine, true);
            //   }, cb);
            // } else if (isAsync === false) {
            //   processRecursive(lines, hook, conv, offset, needPushDownstream, cb, nextLine, false);
            // }
        }
        else {
            if (needPushDownstream) {
                while (offset < lines.length) {
                    var line = lines[offset++];
                    pushDownstream(conv, line);
                }
            }
            cb();
        }
    }
}
function processRecursive(lines, hook, conv, offset, needPushDownstream, cb, res) {
    if (needPushDownstream) {
        pushDownstream(conv, res);
    }
    processLineByLine(lines, conv, offset, needPushDownstream, cb);
}
function pushDownstream(conv, res) {
    if (typeof res === "object" && !conv.options.objectMode) {
        conv.push(JSON.stringify(res) + "\n", "utf8");
    }
    else {
        conv.push(res);
    }
}
//# sourceMappingURL=Result.js.map