// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: envoy/api/v2/cds.proto

package v2

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import auth "github.com/envoyproxy/go-control-plane/envoy/api/v2/auth"
import cluster "github.com/envoyproxy/go-control-plane/envoy/api/v2/cluster"
import core "github.com/envoyproxy/go-control-plane/envoy/api/v2/core"
import _type "github.com/envoyproxy/go-control-plane/envoy/type"
import _ "github.com/gogo/googleapis/google/api"
import _ "github.com/gogo/protobuf/gogoproto"
import types "github.com/gogo/protobuf/types"
import _ "github.com/lyft/protoc-gen-validate/validate"

import time "time"

import bytes "bytes"

import context "golang.org/x/net/context"
import grpc "google.golang.org/grpc"

import github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Refer to :ref:`service discovery type <arch_overview_service_discovery_types>`
// for an explanation on each type.
type Cluster_DiscoveryType int32

const (
	// Refer to the :ref:`static discovery type<arch_overview_service_discovery_types_static>`
	// for an explanation.
	Cluster_STATIC Cluster_DiscoveryType = 0
	// Refer to the :ref:`strict DNS discovery
	// type<arch_overview_service_discovery_types_strict_dns>`
	// for an explanation.
	Cluster_STRICT_DNS Cluster_DiscoveryType = 1
	// Refer to the :ref:`logical DNS discovery
	// type<arch_overview_service_discovery_types_logical_dns>`
	// for an explanation.
	Cluster_LOGICAL_DNS Cluster_DiscoveryType = 2
	// Refer to the :ref:`service discovery type<arch_overview_service_discovery_types_sds>`
	// for an explanation.
	Cluster_EDS Cluster_DiscoveryType = 3
	// Refer to the :ref:`original destination discovery
	// type<arch_overview_service_discovery_types_original_destination>`
	// for an explanation.
	Cluster_ORIGINAL_DST Cluster_DiscoveryType = 4
)

var Cluster_DiscoveryType_name = map[int32]string{
	0: "STATIC",
	1: "STRICT_DNS",
	2: "LOGICAL_DNS",
	3: "EDS",
	4: "ORIGINAL_DST",
}
var Cluster_DiscoveryType_value = map[string]int32{
	"STATIC":       0,
	"STRICT_DNS":   1,
	"LOGICAL_DNS":  2,
	"EDS":          3,
	"ORIGINAL_DST": 4,
}

func (x Cluster_DiscoveryType) String() string {
	return proto.EnumName(Cluster_DiscoveryType_name, int32(x))
}
func (Cluster_DiscoveryType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cds_c9aad078b729c273, []int{0, 0}
}

// Refer to :ref:`load balancer type <arch_overview_load_balancing_types>` architecture
// overview section for information on each type.
type Cluster_LbPolicy int32

const (
	// Refer to the :ref:`round robin load balancing
	// policy<arch_overview_load_balancing_types_round_robin>`
	// for an explanation.
	Cluster_ROUND_ROBIN Cluster_LbPolicy = 0
	// Refer to the :ref:`least request load balancing
	// policy<arch_overview_load_balancing_types_least_request>`
	// for an explanation.
	Cluster_LEAST_REQUEST Cluster_LbPolicy = 1
	// Refer to the :ref:`ring hash load balancing
	// policy<arch_overview_load_balancing_types_ring_hash>`
	// for an explanation.
	Cluster_RING_HASH Cluster_LbPolicy = 2
	// Refer to the :ref:`random load balancing
	// policy<arch_overview_load_balancing_types_random>`
	// for an explanation.
	Cluster_RANDOM Cluster_LbPolicy = 3
	// Refer to the :ref:`original destination load balancing
	// policy<arch_overview_load_balancing_types_original_destination>`
	// for an explanation.
	Cluster_ORIGINAL_DST_LB Cluster_LbPolicy = 4
	// Refer to the :ref:`Maglev load balancing policy<arch_overview_load_balancing_types_maglev>`
	// for an explanation.
	Cluster_MAGLEV Cluster_LbPolicy = 5
)

var Cluster_LbPolicy_name = map[int32]string{
	0: "ROUND_ROBIN",
	1: "LEAST_REQUEST",
	2: "RING_HASH",
	3: "RANDOM",
	4: "ORIGINAL_DST_LB",
	5: "MAGLEV",
}
var Cluster_LbPolicy_value = map[string]int32{
	"ROUND_ROBIN":     0,
	"LEAST_REQUEST":   1,
	"RING_HASH":       2,
	"RANDOM":          3,
	"ORIGINAL_DST_LB": 4,
	"MAGLEV":          5,
}

func (x Cluster_LbPolicy) String() string {
	return proto.EnumName(Cluster_LbPolicy_name, int32(x))
}
func (Cluster_LbPolicy) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cds_c9aad078b729c273, []int{0, 1}
}

// When V4_ONLY is selected, the DNS resolver will only perform a lookup for
// addresses in the IPv4 family. If V6_ONLY is selected, the DNS resolver will
// only perform a lookup for addresses in the IPv6 family. If AUTO is
// specified, the DNS resolver will first perform a lookup for addresses in
// the IPv6 family and fallback to a lookup for addresses in the IPv4 family.
// For cluster types other than
// :ref:`STRICT_DNS<envoy_api_enum_value_Cluster.DiscoveryType.STRICT_DNS>` and
// :ref:`LOGICAL_DNS<envoy_api_enum_value_Cluster.DiscoveryType.LOGICAL_DNS>`,
// this setting is
// ignored.
type Cluster_DnsLookupFamily int32

const (
	Cluster_AUTO    Cluster_DnsLookupFamily = 0
	Cluster_V4_ONLY Cluster_DnsLookupFamily = 1
	Cluster_V6_ONLY Cluster_DnsLookupFamily = 2
)

var Cluster_DnsLookupFamily_name = map[int32]string{
	0: "AUTO",
	1: "V4_ONLY",
	2: "V6_ONLY",
}
var Cluster_DnsLookupFamily_value = map[string]int32{
	"AUTO":    0,
	"V4_ONLY": 1,
	"V6_ONLY": 2,
}

func (x Cluster_DnsLookupFamily) String() string {
	return proto.EnumName(Cluster_DnsLookupFamily_name, int32(x))
}
func (Cluster_DnsLookupFamily) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cds_c9aad078b729c273, []int{0, 2}
}

type Cluster_ClusterProtocolSelection int32

const (
	// Cluster can only operate on one of the possible upstream protocols (HTTP1.1, HTTP2).
	// If :ref:`http2_protocol_options <envoy_api_field_Cluster.http2_protocol_options>` are
	// present, HTTP2 will be used, otherwise HTTP1.1 will be used.
	Cluster_USE_CONFIGURED_PROTOCOL Cluster_ClusterProtocolSelection = 0
	// Use HTTP1.1 or HTTP2, depending on which one is used on the downstream connection.
	Cluster_USE_DOWNSTREAM_PROTOCOL Cluster_ClusterProtocolSelection = 1
)

var Cluster_ClusterProtocolSelection_name = map[int32]string{
	0: "USE_CONFIGURED_PROTOCOL",
	1: "USE_DOWNSTREAM_PROTOCOL",
}
var Cluster_ClusterProtocolSelection_value = map[string]int32{
	"USE_CONFIGURED_PROTOCOL": 0,
	"USE_DOWNSTREAM_PROTOCOL": 1,
}

func (x Cluster_ClusterProtocolSelection) String() string {
	return proto.EnumName(Cluster_ClusterProtocolSelection_name, int32(x))
}
func (Cluster_ClusterProtocolSelection) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cds_c9aad078b729c273, []int{0, 3}
}

// If NO_FALLBACK is selected, a result
// equivalent to no healthy hosts is reported. If ANY_ENDPOINT is selected,
// any cluster endpoint may be returned (subject to policy, health checks,
// etc). If DEFAULT_SUBSET is selected, load balancing is performed over the
// endpoints matching the values from the default_subset field.
type Cluster_LbSubsetConfig_LbSubsetFallbackPolicy int32

const (
	Cluster_LbSubsetConfig_NO_FALLBACK    Cluster_LbSubsetConfig_LbSubsetFallbackPolicy = 0
	Cluster_LbSubsetConfig_ANY_ENDPOINT   Cluster_LbSubsetConfig_LbSubsetFallbackPolicy = 1
	Cluster_LbSubsetConfig_DEFAULT_SUBSET Cluster_LbSubsetConfig_LbSubsetFallbackPolicy = 2
)

var Cluster_LbSubsetConfig_LbSubsetFallbackPolicy_name = map[int32]string{
	0: "NO_FALLBACK",
	1: "ANY_ENDPOINT",
	2: "DEFAULT_SUBSET",
}
var Cluster_LbSubsetConfig_LbSubsetFallbackPolicy_value = map[string]int32{
	"NO_FALLBACK":    0,
	"ANY_ENDPOINT":   1,
	"DEFAULT_SUBSET": 2,
}

func (x Cluster_LbSubsetConfig_LbSubsetFallbackPolicy) String() string {
	return proto.EnumName(Cluster_LbSubsetConfig_LbSubsetFallbackPolicy_name, int32(x))
}
func (Cluster_LbSubsetConfig_LbSubsetFallbackPolicy) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cds_c9aad078b729c273, []int{0, 2, 0}
}

// Configuration for a single upstream cluster.
// [#comment:next free field: 36]
type Cluster struct {
	// Supplies the name of the cluster which must be unique across all clusters.
	// The cluster name is used when emitting
	// :ref:`statistics <config_cluster_manager_cluster_stats>` if :ref:`alt_stat_name
	// <envoy_api_field_Cluster.alt_stat_name>` is not provided.
	// Any ``:`` in the cluster name will be converted to ``_`` when emitting statistics.
	// By default, the maximum length of a cluster name is limited to 60
	// characters. This limit can be increased by setting the
	// :option:`--max-obj-name-len` command line argument to the desired value.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// An optional alternative to the cluster name to be used while emitting stats.
	// Any ``:`` in the name will be converted to ``_`` when emitting statistics. This should not be
	// confused with :ref:`Router Filter Header
	// <config_http_filters_router_x-envoy-upstream-alt-stat-name>`.
	AltStatName string `protobuf:"bytes,28,opt,name=alt_stat_name,json=altStatName,proto3" json:"alt_stat_name,omitempty"`
	// The :ref:`service discovery type <arch_overview_service_discovery_types>`
	// to use for resolving the cluster.
	Type Cluster_DiscoveryType `protobuf:"varint,2,opt,name=type,proto3,enum=envoy.api.v2.Cluster_DiscoveryType" json:"type,omitempty"`
	// Configuration to use for EDS updates for the Cluster.
	EdsClusterConfig *Cluster_EdsClusterConfig `protobuf:"bytes,3,opt,name=eds_cluster_config,json=edsClusterConfig" json:"eds_cluster_config,omitempty"`
	// The timeout for new network connections to hosts in the cluster.
	ConnectTimeout time.Duration `protobuf:"bytes,4,opt,name=connect_timeout,json=connectTimeout,stdduration" json:"connect_timeout"`
	// Soft limit on size of the cluster’s connections read and write buffers. If
	// unspecified, an implementation defined default is applied (1MiB).
	PerConnectionBufferLimitBytes *types.UInt32Value `protobuf:"bytes,5,opt,name=per_connection_buffer_limit_bytes,json=perConnectionBufferLimitBytes" json:"per_connection_buffer_limit_bytes,omitempty"`
	// The :ref:`load balancer type <arch_overview_load_balancing_types>` to use
	// when picking a host in the cluster.
	LbPolicy Cluster_LbPolicy `protobuf:"varint,6,opt,name=lb_policy,json=lbPolicy,proto3,enum=envoy.api.v2.Cluster_LbPolicy" json:"lb_policy,omitempty"`
	// If the service discovery type is
	// :ref:`STATIC<envoy_api_enum_value_Cluster.DiscoveryType.STATIC>`,
	// :ref:`STRICT_DNS<envoy_api_enum_value_Cluster.DiscoveryType.STRICT_DNS>`
	// or :ref:`LOGICAL_DNS<envoy_api_enum_value_Cluster.DiscoveryType.LOGICAL_DNS>`,
	// then hosts is required.
	//
	// .. attention::
	//
	//   **This field is deprecated**. Set the
	//   :ref:`load_assignment<envoy_api_field_Cluster.load_assignment>` field instead.
	//
	Hosts []*core.Address `protobuf:"bytes,7,rep,name=hosts" json:"hosts,omitempty"` // Deprecated: Do not use.
	// Setting this is required for specifying members of
	// :ref:`STATIC<envoy_api_enum_value_Cluster.DiscoveryType.STATIC>`,
	// :ref:`STRICT_DNS<envoy_api_enum_value_Cluster.DiscoveryType.STRICT_DNS>`
	// or :ref:`LOGICAL_DNS<envoy_api_enum_value_Cluster.DiscoveryType.LOGICAL_DNS>` clusters.
	// This field supersedes :ref:`hosts<envoy_api_field_Cluster.hosts>` field.
	// [#comment:TODO(dio): Deprecate the hosts field and add it to DEPRECATED.md
	// once load_assignment is implemented.]
	//
	// .. attention::
	//
	//   Setting this allows non-EDS cluster types to contain embedded EDS equivalent
	//   :ref:`endpoint assignments<envoy_api_msg_ClusterLoadAssignment>`.
	//   Setting this overrides :ref:`hosts<envoy_api_field_Cluster.hosts>` values.
	//
	LoadAssignment *ClusterLoadAssignment `protobuf:"bytes,33,opt,name=load_assignment,json=loadAssignment" json:"load_assignment,omitempty"`
	// Optional :ref:`active health checking <arch_overview_health_checking>`
	// configuration for the cluster. If no
	// configuration is specified no health checking will be done and all cluster
	// members will be considered healthy at all times.
	HealthChecks []*core.HealthCheck `protobuf:"bytes,8,rep,name=health_checks,json=healthChecks" json:"health_checks,omitempty"`
	// Optional maximum requests for a single upstream connection. This parameter
	// is respected by both the HTTP/1.1 and HTTP/2 connection pool
	// implementations. If not specified, there is no limit. Setting this
	// parameter to 1 will effectively disable keep alive.
	MaxRequestsPerConnection *types.UInt32Value `protobuf:"bytes,9,opt,name=max_requests_per_connection,json=maxRequestsPerConnection" json:"max_requests_per_connection,omitempty"`
	// Optional :ref:`circuit breaking <arch_overview_circuit_break>` for the cluster.
	CircuitBreakers *cluster.CircuitBreakers `protobuf:"bytes,10,opt,name=circuit_breakers,json=circuitBreakers" json:"circuit_breakers,omitempty"`
	// The TLS configuration for connections to the upstream cluster. If no TLS
	// configuration is specified, TLS will not be used for new connections.
	//
	// .. attention::
	//
	//   Server certificate verification is not enabled by default. Configure
	//   :ref:`trusted_ca<envoy_api_field_auth.CertificateValidationContext.trusted_ca>` to enable
	//   verification.
	TlsContext *auth.UpstreamTlsContext `protobuf:"bytes,11,opt,name=tls_context,json=tlsContext" json:"tls_context,omitempty"`
	// Additional options when handling HTTP requests. These options will be applicable to both
	// HTTP1 and HTTP2 requests.
	CommonHttpProtocolOptions *core.HttpProtocolOptions `protobuf:"bytes,29,opt,name=common_http_protocol_options,json=commonHttpProtocolOptions" json:"common_http_protocol_options,omitempty"`
	// Additional options when handling HTTP1 requests.
	HttpProtocolOptions *core.Http1ProtocolOptions `protobuf:"bytes,13,opt,name=http_protocol_options,json=httpProtocolOptions" json:"http_protocol_options,omitempty"`
	// Even if default HTTP2 protocol options are desired, this field must be
	// set so that Envoy will assume that the upstream supports HTTP/2 when
	// making new HTTP connection pool connections. Currently, Envoy only
	// supports prior knowledge for upstream connections. Even if TLS is used
	// with ALPN, `http2_protocol_options` must be specified. As an aside this allows HTTP/2
	// connections to happen over plain text.
	Http2ProtocolOptions *core.Http2ProtocolOptions `protobuf:"bytes,14,opt,name=http2_protocol_options,json=http2ProtocolOptions" json:"http2_protocol_options,omitempty"`
	// The extension_protocol_options field is used to provide extension-specific protocol options
	// for upstream connections. The key should match the extension filter name, such as
	// "envoy.filters.network.thrift_proxy". See the extension's documentation for details on
	// specific options.
	ExtensionProtocolOptions map[string]*types.Struct `protobuf:"bytes,35,rep,name=extension_protocol_options,json=extensionProtocolOptions" json:"extension_protocol_options,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
	// If the DNS refresh rate is specified and the cluster type is either
	// :ref:`STRICT_DNS<envoy_api_enum_value_Cluster.DiscoveryType.STRICT_DNS>`,
	// or :ref:`LOGICAL_DNS<envoy_api_enum_value_Cluster.DiscoveryType.LOGICAL_DNS>`,
	// this value is used as the cluster’s DNS refresh
	// rate. If this setting is not specified, the value defaults to 5000. For
	// cluster types other than
	// :ref:`STRICT_DNS<envoy_api_enum_value_Cluster.DiscoveryType.STRICT_DNS>`
	// and :ref:`LOGICAL_DNS<envoy_api_enum_value_Cluster.DiscoveryType.LOGICAL_DNS>`
	// this setting is ignored.
	DnsRefreshRate *time.Duration `protobuf:"bytes,16,opt,name=dns_refresh_rate,json=dnsRefreshRate,stdduration" json:"dns_refresh_rate,omitempty"`
	// The DNS IP address resolution policy. If this setting is not specified, the
	// value defaults to
	// :ref:`AUTO<envoy_api_enum_value_Cluster.DnsLookupFamily.AUTO>`.
	DnsLookupFamily Cluster_DnsLookupFamily `protobuf:"varint,17,opt,name=dns_lookup_family,json=dnsLookupFamily,proto3,enum=envoy.api.v2.Cluster_DnsLookupFamily" json:"dns_lookup_family,omitempty"`
	// If DNS resolvers are specified and the cluster type is either
	// :ref:`STRICT_DNS<envoy_api_enum_value_Cluster.DiscoveryType.STRICT_DNS>`,
	// or :ref:`LOGICAL_DNS<envoy_api_enum_value_Cluster.DiscoveryType.LOGICAL_DNS>`,
	// this value is used to specify the cluster’s dns resolvers.
	// If this setting is not specified, the value defaults to the default
	// resolver, which uses /etc/resolv.conf for configuration. For cluster types
	// other than
	// :ref:`STRICT_DNS<envoy_api_enum_value_Cluster.DiscoveryType.STRICT_DNS>`
	// and :ref:`LOGICAL_DNS<envoy_api_enum_value_Cluster.DiscoveryType.LOGICAL_DNS>`
	// this setting is ignored.
	DnsResolvers []*core.Address `protobuf:"bytes,18,rep,name=dns_resolvers,json=dnsResolvers" json:"dns_resolvers,omitempty"`
	// If specified, outlier detection will be enabled for this upstream cluster.
	// Each of the configuration values can be overridden via
	// :ref:`runtime values <config_cluster_manager_cluster_runtime_outlier_detection>`.
	OutlierDetection *cluster.OutlierDetection `protobuf:"bytes,19,opt,name=outlier_detection,json=outlierDetection" json:"outlier_detection,omitempty"`
	// The interval for removing stale hosts from a cluster type
	// :ref:`ORIGINAL_DST<envoy_api_enum_value_Cluster.DiscoveryType.ORIGINAL_DST>`.
	// Hosts are considered stale if they have not been used
	// as upstream destinations during this interval. New hosts are added
	// to original destination clusters on demand as new connections are
	// redirected to Envoy, causing the number of hosts in the cluster to
	// grow over time. Hosts that are not stale (they are actively used as
	// destinations) are kept in the cluster, which allows connections to
	// them remain open, saving the latency that would otherwise be spent
	// on opening new connections. If this setting is not specified, the
	// value defaults to 5000ms. For cluster types other than
	// :ref:`ORIGINAL_DST<envoy_api_enum_value_Cluster.DiscoveryType.ORIGINAL_DST>`
	// this setting is ignored.
	CleanupInterval *time.Duration `protobuf:"bytes,20,opt,name=cleanup_interval,json=cleanupInterval,stdduration" json:"cleanup_interval,omitempty"`
	// Optional configuration used to bind newly established upstream connections.
	// This overrides any bind_config specified in the bootstrap proto.
	// If the address and port are empty, no bind will be performed.
	UpstreamBindConfig *core.BindConfig `protobuf:"bytes,21,opt,name=upstream_bind_config,json=upstreamBindConfig" json:"upstream_bind_config,omitempty"`
	// Configuration for load balancing subsetting.
	LbSubsetConfig *Cluster_LbSubsetConfig `protobuf:"bytes,22,opt,name=lb_subset_config,json=lbSubsetConfig" json:"lb_subset_config,omitempty"`
	// Optional configuration for the load balancing algorithm selected by
	// LbPolicy. Currently only
	// :ref:`RING_HASH<envoy_api_enum_value_Cluster.LbPolicy.RING_HASH>`
	// has additional configuration options.
	// Specifying ring_hash_lb_config without setting the LbPolicy to
	// :ref:`RING_HASH<envoy_api_enum_value_Cluster.LbPolicy.RING_HASH>`
	// will generate an error at runtime.
	//
	// Types that are valid to be assigned to LbConfig:
	//	*Cluster_RingHashLbConfig_
	//	*Cluster_OriginalDstLbConfig_
	LbConfig isCluster_LbConfig `protobuf_oneof:"lb_config"`
	// Common configuration for all load balancer implementations.
	CommonLbConfig *Cluster_CommonLbConfig `protobuf:"bytes,27,opt,name=common_lb_config,json=commonLbConfig" json:"common_lb_config,omitempty"`
	// Optional custom transport socket implementation to use for upstream connections.
	TransportSocket *core.TransportSocket `protobuf:"bytes,24,opt,name=transport_socket,json=transportSocket" json:"transport_socket,omitempty"`
	// The Metadata field can be used to provide additional information about the
	// cluster. It can be used for stats, logging, and varying filter behavior.
	// Fields should use reverse DNS notation to denote which entity within Envoy
	// will need the information. For instance, if the metadata is intended for
	// the Router filter, the filter name should be specified as *envoy.router*.
	Metadata *core.Metadata `protobuf:"bytes,25,opt,name=metadata" json:"metadata,omitempty"`
	// Determines how Envoy selects the protocol used to speak to upstream hosts.
	ProtocolSelection Cluster_ClusterProtocolSelection `protobuf:"varint,26,opt,name=protocol_selection,json=protocolSelection,proto3,enum=envoy.api.v2.Cluster_ClusterProtocolSelection" json:"protocol_selection,omitempty"`
	// Optional options for upstream connections.
	UpstreamConnectionOptions *UpstreamConnectionOptions `protobuf:"bytes,30,opt,name=upstream_connection_options,json=upstreamConnectionOptions" json:"upstream_connection_options,omitempty"`
	// If an upstream host becomes unhealthy (as determined by the configured health checks
	// or outlier detection), immediately close all connections to the failed host.
	//
	// .. note::
	//
	//   This is currently only supported for connections created by tcp_proxy.
	//
	// .. note::
	//
	//   The current implementation of this feature closes all connections immediately when
	//   the unhealthy status is detected. If there are a large number of connections open
	//   to an upstream host that becomes unhealthy, Envoy may spend a substantial amount of
	//   time exclusively closing these connections, and not processing any other traffic.
	CloseConnectionsOnHostHealthFailure bool `protobuf:"varint,31,opt,name=close_connections_on_host_health_failure,json=closeConnectionsOnHostHealthFailure,proto3" json:"close_connections_on_host_health_failure,omitempty"`
	// If this cluster uses EDS or STRICT_DNS to configure its hosts, immediately drain
	// connections from any hosts that are removed from service discovery.
	//
	// This only affects behavior for hosts that are being actively health checked.
	// If this flag is not set to true, Envoy will wait until the hosts fail active health
	// checking before removing it from the cluster.
	DrainConnectionsOnHostRemoval bool     `protobuf:"varint,32,opt,name=drain_connections_on_host_removal,json=drainConnectionsOnHostRemoval,proto3" json:"drain_connections_on_host_removal,omitempty"`
	XXX_NoUnkeyedLiteral          struct{} `json:"-"`
	XXX_unrecognized              []byte   `json:"-"`
	XXX_sizecache                 int32    `json:"-"`
}

func (m *Cluster) Reset()         { *m = Cluster{} }
func (m *Cluster) String() string { return proto.CompactTextString(m) }
func (*Cluster) ProtoMessage()    {}
func (*Cluster) Descriptor() ([]byte, []int) {
	return fileDescriptor_cds_c9aad078b729c273, []int{0}
}
func (m *Cluster) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Cluster) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Cluster.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Cluster) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster.Merge(dst, src)
}
func (m *Cluster) XXX_Size() int {
	return m.Size()
}
func (m *Cluster) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster proto.InternalMessageInfo

type isCluster_LbConfig interface {
	isCluster_LbConfig()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type Cluster_RingHashLbConfig_ struct {
	RingHashLbConfig *Cluster_RingHashLbConfig `protobuf:"bytes,23,opt,name=ring_hash_lb_config,json=ringHashLbConfig,oneof"`
}
type Cluster_OriginalDstLbConfig_ struct {
	OriginalDstLbConfig *Cluster_OriginalDstLbConfig `protobuf:"bytes,34,opt,name=original_dst_lb_config,json=originalDstLbConfig,oneof"`
}

func (*Cluster_RingHashLbConfig_) isCluster_LbConfig()    {}
func (*Cluster_OriginalDstLbConfig_) isCluster_LbConfig() {}

func (m *Cluster) GetLbConfig() isCluster_LbConfig {
	if m != nil {
		return m.LbConfig
	}
	return nil
}

func (m *Cluster) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Cluster) GetAltStatName() string {
	if m != nil {
		return m.AltStatName
	}
	return ""
}

func (m *Cluster) GetType() Cluster_DiscoveryType {
	if m != nil {
		return m.Type
	}
	return Cluster_STATIC
}

func (m *Cluster) GetEdsClusterConfig() *Cluster_EdsClusterConfig {
	if m != nil {
		return m.EdsClusterConfig
	}
	return nil
}

func (m *Cluster) GetConnectTimeout() time.Duration {
	if m != nil {
		return m.ConnectTimeout
	}
	return 0
}

func (m *Cluster) GetPerConnectionBufferLimitBytes() *types.UInt32Value {
	if m != nil {
		return m.PerConnectionBufferLimitBytes
	}
	return nil
}

func (m *Cluster) GetLbPolicy() Cluster_LbPolicy {
	if m != nil {
		return m.LbPolicy
	}
	return Cluster_ROUND_ROBIN
}

// Deprecated: Do not use.
func (m *Cluster) GetHosts() []*core.Address {
	if m != nil {
		return m.Hosts
	}
	return nil
}

func (m *Cluster) GetLoadAssignment() *ClusterLoadAssignment {
	if m != nil {
		return m.LoadAssignment
	}
	return nil
}

func (m *Cluster) GetHealthChecks() []*core.HealthCheck {
	if m != nil {
		return m.HealthChecks
	}
	return nil
}

func (m *Cluster) GetMaxRequestsPerConnection() *types.UInt32Value {
	if m != nil {
		return m.MaxRequestsPerConnection
	}
	return nil
}

func (m *Cluster) GetCircuitBreakers() *cluster.CircuitBreakers {
	if m != nil {
		return m.CircuitBreakers
	}
	return nil
}

func (m *Cluster) GetTlsContext() *auth.UpstreamTlsContext {
	if m != nil {
		return m.TlsContext
	}
	return nil
}

func (m *Cluster) GetCommonHttpProtocolOptions() *core.HttpProtocolOptions {
	if m != nil {
		return m.CommonHttpProtocolOptions
	}
	return nil
}

func (m *Cluster) GetHttpProtocolOptions() *core.Http1ProtocolOptions {
	if m != nil {
		return m.HttpProtocolOptions
	}
	return nil
}

func (m *Cluster) GetHttp2ProtocolOptions() *core.Http2ProtocolOptions {
	if m != nil {
		return m.Http2ProtocolOptions
	}
	return nil
}

func (m *Cluster) GetExtensionProtocolOptions() map[string]*types.Struct {
	if m != nil {
		return m.ExtensionProtocolOptions
	}
	return nil
}

func (m *Cluster) GetDnsRefreshRate() *time.Duration {
	if m != nil {
		return m.DnsRefreshRate
	}
	return nil
}

func (m *Cluster) GetDnsLookupFamily() Cluster_DnsLookupFamily {
	if m != nil {
		return m.DnsLookupFamily
	}
	return Cluster_AUTO
}

func (m *Cluster) GetDnsResolvers() []*core.Address {
	if m != nil {
		return m.DnsResolvers
	}
	return nil
}

func (m *Cluster) GetOutlierDetection() *cluster.OutlierDetection {
	if m != nil {
		return m.OutlierDetection
	}
	return nil
}

func (m *Cluster) GetCleanupInterval() *time.Duration {
	if m != nil {
		return m.CleanupInterval
	}
	return nil
}

func (m *Cluster) GetUpstreamBindConfig() *core.BindConfig {
	if m != nil {
		return m.UpstreamBindConfig
	}
	return nil
}

func (m *Cluster) GetLbSubsetConfig() *Cluster_LbSubsetConfig {
	if m != nil {
		return m.LbSubsetConfig
	}
	return nil
}

func (m *Cluster) GetRingHashLbConfig() *Cluster_RingHashLbConfig {
	if x, ok := m.GetLbConfig().(*Cluster_RingHashLbConfig_); ok {
		return x.RingHashLbConfig
	}
	return nil
}

func (m *Cluster) GetOriginalDstLbConfig() *Cluster_OriginalDstLbConfig {
	if x, ok := m.GetLbConfig().(*Cluster_OriginalDstLbConfig_); ok {
		return x.OriginalDstLbConfig
	}
	return nil
}

func (m *Cluster) GetCommonLbConfig() *Cluster_CommonLbConfig {
	if m != nil {
		return m.CommonLbConfig
	}
	return nil
}

func (m *Cluster) GetTransportSocket() *core.TransportSocket {
	if m != nil {
		return m.TransportSocket
	}
	return nil
}

func (m *Cluster) GetMetadata() *core.Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Cluster) GetProtocolSelection() Cluster_ClusterProtocolSelection {
	if m != nil {
		return m.ProtocolSelection
	}
	return Cluster_USE_CONFIGURED_PROTOCOL
}

func (m *Cluster) GetUpstreamConnectionOptions() *UpstreamConnectionOptions {
	if m != nil {
		return m.UpstreamConnectionOptions
	}
	return nil
}

func (m *Cluster) GetCloseConnectionsOnHostHealthFailure() bool {
	if m != nil {
		return m.CloseConnectionsOnHostHealthFailure
	}
	return false
}

func (m *Cluster) GetDrainConnectionsOnHostRemoval() bool {
	if m != nil {
		return m.DrainConnectionsOnHostRemoval
	}
	return false
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Cluster) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Cluster_OneofMarshaler, _Cluster_OneofUnmarshaler, _Cluster_OneofSizer, []interface{}{
		(*Cluster_RingHashLbConfig_)(nil),
		(*Cluster_OriginalDstLbConfig_)(nil),
	}
}

func _Cluster_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Cluster)
	// lb_config
	switch x := m.LbConfig.(type) {
	case *Cluster_RingHashLbConfig_:
		_ = b.EncodeVarint(23<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RingHashLbConfig); err != nil {
			return err
		}
	case *Cluster_OriginalDstLbConfig_:
		_ = b.EncodeVarint(34<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.OriginalDstLbConfig); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Cluster.LbConfig has unexpected type %T", x)
	}
	return nil
}

func _Cluster_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Cluster)
	switch tag {
	case 23: // lb_config.ring_hash_lb_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Cluster_RingHashLbConfig)
		err := b.DecodeMessage(msg)
		m.LbConfig = &Cluster_RingHashLbConfig_{msg}
		return true, err
	case 34: // lb_config.original_dst_lb_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Cluster_OriginalDstLbConfig)
		err := b.DecodeMessage(msg)
		m.LbConfig = &Cluster_OriginalDstLbConfig_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Cluster_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Cluster)
	// lb_config
	switch x := m.LbConfig.(type) {
	case *Cluster_RingHashLbConfig_:
		s := proto.Size(x.RingHashLbConfig)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Cluster_OriginalDstLbConfig_:
		s := proto.Size(x.OriginalDstLbConfig)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Only valid when discovery type is EDS.
type Cluster_EdsClusterConfig struct {
	// Configuration for the source of EDS updates for this Cluster.
	EdsConfig *core.ConfigSource `protobuf:"bytes,1,opt,name=eds_config,json=edsConfig" json:"eds_config,omitempty"`
	// Optional alternative to cluster name to present to EDS. This does not
	// have the same restrictions as cluster name, i.e. it may be arbitrary
	// length.
	ServiceName          string   `protobuf:"bytes,2,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Cluster_EdsClusterConfig) Reset()         { *m = Cluster_EdsClusterConfig{} }
func (m *Cluster_EdsClusterConfig) String() string { return proto.CompactTextString(m) }
func (*Cluster_EdsClusterConfig) ProtoMessage()    {}
func (*Cluster_EdsClusterConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_cds_c9aad078b729c273, []int{0, 0}
}
func (m *Cluster_EdsClusterConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Cluster_EdsClusterConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Cluster_EdsClusterConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Cluster_EdsClusterConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster_EdsClusterConfig.Merge(dst, src)
}
func (m *Cluster_EdsClusterConfig) XXX_Size() int {
	return m.Size()
}
func (m *Cluster_EdsClusterConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster_EdsClusterConfig.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster_EdsClusterConfig proto.InternalMessageInfo

func (m *Cluster_EdsClusterConfig) GetEdsConfig() *core.ConfigSource {
	if m != nil {
		return m.EdsConfig
	}
	return nil
}

func (m *Cluster_EdsClusterConfig) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

// Optionally divide the endpoints in this cluster into subsets defined by
// endpoint metadata and selected by route and weighted cluster metadata.
type Cluster_LbSubsetConfig struct {
	// The behavior used when no endpoint subset matches the selected route's
	// metadata. The value defaults to
	// :ref:`NO_FALLBACK<envoy_api_enum_value_Cluster.LbSubsetConfig.LbSubsetFallbackPolicy.NO_FALLBACK>`.
	FallbackPolicy Cluster_LbSubsetConfig_LbSubsetFallbackPolicy `protobuf:"varint,1,opt,name=fallback_policy,json=fallbackPolicy,proto3,enum=envoy.api.v2.Cluster_LbSubsetConfig_LbSubsetFallbackPolicy" json:"fallback_policy,omitempty"`
	// Specifies the default subset of endpoints used during fallback if
	// fallback_policy is
	// :ref:`DEFAULT_SUBSET<envoy_api_enum_value_Cluster.LbSubsetConfig.LbSubsetFallbackPolicy.DEFAULT_SUBSET>`.
	// Each field in default_subset is
	// compared to the matching LbEndpoint.Metadata under the *envoy.lb*
	// namespace. It is valid for no hosts to match, in which case the behavior
	// is the same as a fallback_policy of
	// :ref:`NO_FALLBACK<envoy_api_enum_value_Cluster.LbSubsetConfig.LbSubsetFallbackPolicy.NO_FALLBACK>`.
	DefaultSubset *types.Struct `protobuf:"bytes,2,opt,name=default_subset,json=defaultSubset" json:"default_subset,omitempty"`
	// For each entry, LbEndpoint.Metadata's
	// *envoy.lb* namespace is traversed and a subset is created for each unique
	// combination of key and value. For example:
	//
	// .. code-block:: json
	//
	//   { "subset_selectors": [
	//       { "keys": [ "version" ] },
	//       { "keys": [ "stage", "hardware_type" ] }
	//   ]}
	//
	// A subset is matched when the metadata from the selected route and
	// weighted cluster contains the same keys and values as the subset's
	// metadata. The same host may appear in multiple subsets.
	SubsetSelectors []*Cluster_LbSubsetConfig_LbSubsetSelector `protobuf:"bytes,3,rep,name=subset_selectors,json=subsetSelectors" json:"subset_selectors,omitempty"`
	// If true, routing to subsets will take into account the localities and locality weights of the
	// endpoints when making the routing decision.
	//
	// There are some potential pitfalls associated with enabling this feature, as the resulting
	// traffic split after applying both a subset match and locality weights might be undesirable.
	//
	// Consider for example a situation in which you have 50/50 split across two localities X/Y
	// which have 100 hosts each without subsetting. If the subset LB results in X having only 1
	// host selected but Y having 100, then a lot more load is being dumped on the single host in X
	// than originally anticipated in the load balancing assignment delivered via EDS.
	LocalityWeightAware  bool     `protobuf:"varint,4,opt,name=locality_weight_aware,json=localityWeightAware,proto3" json:"locality_weight_aware,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Cluster_LbSubsetConfig) Reset()         { *m = Cluster_LbSubsetConfig{} }
func (m *Cluster_LbSubsetConfig) String() string { return proto.CompactTextString(m) }
func (*Cluster_LbSubsetConfig) ProtoMessage()    {}
func (*Cluster_LbSubsetConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_cds_c9aad078b729c273, []int{0, 2}
}
func (m *Cluster_LbSubsetConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Cluster_LbSubsetConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Cluster_LbSubsetConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Cluster_LbSubsetConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster_LbSubsetConfig.Merge(dst, src)
}
func (m *Cluster_LbSubsetConfig) XXX_Size() int {
	return m.Size()
}
func (m *Cluster_LbSubsetConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster_LbSubsetConfig.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster_LbSubsetConfig proto.InternalMessageInfo

func (m *Cluster_LbSubsetConfig) GetFallbackPolicy() Cluster_LbSubsetConfig_LbSubsetFallbackPolicy {
	if m != nil {
		return m.FallbackPolicy
	}
	return Cluster_LbSubsetConfig_NO_FALLBACK
}

func (m *Cluster_LbSubsetConfig) GetDefaultSubset() *types.Struct {
	if m != nil {
		return m.DefaultSubset
	}
	return nil
}

func (m *Cluster_LbSubsetConfig) GetSubsetSelectors() []*Cluster_LbSubsetConfig_LbSubsetSelector {
	if m != nil {
		return m.SubsetSelectors
	}
	return nil
}

func (m *Cluster_LbSubsetConfig) GetLocalityWeightAware() bool {
	if m != nil {
		return m.LocalityWeightAware
	}
	return false
}

// Specifications for subsets.
type Cluster_LbSubsetConfig_LbSubsetSelector struct {
	// List of keys to match with the weighted cluster metadata.
	Keys                 []string `protobuf:"bytes,1,rep,name=keys" json:"keys,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Cluster_LbSubsetConfig_LbSubsetSelector) Reset() {
	*m = Cluster_LbSubsetConfig_LbSubsetSelector{}
}
func (m *Cluster_LbSubsetConfig_LbSubsetSelector) String() string { return proto.CompactTextString(m) }
func (*Cluster_LbSubsetConfig_LbSubsetSelector) ProtoMessage()    {}
func (*Cluster_LbSubsetConfig_LbSubsetSelector) Descriptor() ([]byte, []int) {
	return fileDescriptor_cds_c9aad078b729c273, []int{0, 2, 0}
}
func (m *Cluster_LbSubsetConfig_LbSubsetSelector) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Cluster_LbSubsetConfig_LbSubsetSelector) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Cluster_LbSubsetConfig_LbSubsetSelector.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Cluster_LbSubsetConfig_LbSubsetSelector) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster_LbSubsetConfig_LbSubsetSelector.Merge(dst, src)
}
func (m *Cluster_LbSubsetConfig_LbSubsetSelector) XXX_Size() int {
	return m.Size()
}
func (m *Cluster_LbSubsetConfig_LbSubsetSelector) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster_LbSubsetConfig_LbSubsetSelector.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster_LbSubsetConfig_LbSubsetSelector proto.InternalMessageInfo

func (m *Cluster_LbSubsetConfig_LbSubsetSelector) GetKeys() []string {
	if m != nil {
		return m.Keys
	}
	return nil
}

// Specific configuration for the :ref:`RingHash<arch_overview_load_balancing_types_ring_hash>`
// load balancing policy.
type Cluster_RingHashLbConfig struct {
	// Minimum hash ring size, i.e. total virtual nodes. A larger size
	// will provide better request distribution since each host in the
	// cluster will have more virtual nodes. Defaults to 1024. In the case
	// that total number of hosts is greater than the minimum, each host will
	// be allocated a single virtual node. This field is limited to 8M to bound
	// resource use.
	MinimumRingSize *types.UInt64Value `protobuf:"bytes,1,opt,name=minimum_ring_size,json=minimumRingSize" json:"minimum_ring_size,omitempty"`
	// Deprecated settings from v1 config.
	// [#not-implemented-hide:] Hide from docs.
	DeprecatedV1         *Cluster_RingHashLbConfig_DeprecatedV1 `protobuf:"bytes,2,opt,name=deprecated_v1,json=deprecatedV1" json:"deprecated_v1,omitempty"` // Deprecated: Do not use.
	XXX_NoUnkeyedLiteral struct{}                               `json:"-"`
	XXX_unrecognized     []byte                                 `json:"-"`
	XXX_sizecache        int32                                  `json:"-"`
}

func (m *Cluster_RingHashLbConfig) Reset()         { *m = Cluster_RingHashLbConfig{} }
func (m *Cluster_RingHashLbConfig) String() string { return proto.CompactTextString(m) }
func (*Cluster_RingHashLbConfig) ProtoMessage()    {}
func (*Cluster_RingHashLbConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_cds_c9aad078b729c273, []int{0, 3}
}
func (m *Cluster_RingHashLbConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Cluster_RingHashLbConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Cluster_RingHashLbConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Cluster_RingHashLbConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster_RingHashLbConfig.Merge(dst, src)
}
func (m *Cluster_RingHashLbConfig) XXX_Size() int {
	return m.Size()
}
func (m *Cluster_RingHashLbConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster_RingHashLbConfig.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster_RingHashLbConfig proto.InternalMessageInfo

func (m *Cluster_RingHashLbConfig) GetMinimumRingSize() *types.UInt64Value {
	if m != nil {
		return m.MinimumRingSize
	}
	return nil
}

// Deprecated: Do not use.
func (m *Cluster_RingHashLbConfig) GetDeprecatedV1() *Cluster_RingHashLbConfig_DeprecatedV1 {
	if m != nil {
		return m.DeprecatedV1
	}
	return nil
}

// [#not-implemented-hide:] Hide from docs.
type Cluster_RingHashLbConfig_DeprecatedV1 struct {
	// Defaults to true, meaning that std::hash is used to hash hosts onto
	// the ketama ring. std::hash can vary by platform. For this reason,
	// Envoy will eventually use `xxHash <https://github.com/Cyan4973/xxHash>`_
	// by default. This field exists for
	// migration purposes and will eventually be deprecated. Set it to false
	// to use `xxHash <https://github.com/Cyan4973/xxHash>`_ now.
	UseStdHash           *types.BoolValue `protobuf:"bytes,1,opt,name=use_std_hash,json=useStdHash" json:"use_std_hash,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Cluster_RingHashLbConfig_DeprecatedV1) Reset()         { *m = Cluster_RingHashLbConfig_DeprecatedV1{} }
func (m *Cluster_RingHashLbConfig_DeprecatedV1) String() string { return proto.CompactTextString(m) }
func (*Cluster_RingHashLbConfig_DeprecatedV1) ProtoMessage()    {}
func (*Cluster_RingHashLbConfig_DeprecatedV1) Descriptor() ([]byte, []int) {
	return fileDescriptor_cds_c9aad078b729c273, []int{0, 3, 0}
}
func (m *Cluster_RingHashLbConfig_DeprecatedV1) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Cluster_RingHashLbConfig_DeprecatedV1) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Cluster_RingHashLbConfig_DeprecatedV1.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Cluster_RingHashLbConfig_DeprecatedV1) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster_RingHashLbConfig_DeprecatedV1.Merge(dst, src)
}
func (m *Cluster_RingHashLbConfig_DeprecatedV1) XXX_Size() int {
	return m.Size()
}
func (m *Cluster_RingHashLbConfig_DeprecatedV1) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster_RingHashLbConfig_DeprecatedV1.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster_RingHashLbConfig_DeprecatedV1 proto.InternalMessageInfo

func (m *Cluster_RingHashLbConfig_DeprecatedV1) GetUseStdHash() *types.BoolValue {
	if m != nil {
		return m.UseStdHash
	}
	return nil
}

// Specific configuration for the
// :ref:`Original Destination <arch_overview_load_balancing_types_original_destination>`
// load balancing policy.
type Cluster_OriginalDstLbConfig struct {
	// When true, :ref:`x-envoy-orignal-dst-host
	// <config_http_conn_man_headers_x-envoy-original-dst-host>` can be used to override destination
	// address.
	//
	// .. attention::
	//
	//   This header isn't sanitized by default, so enabling this feature allows HTTP clients to
	//   route traffic to arbitrary hosts and/or ports, which may have serious security
	//   consequences.
	UseHttpHeader        bool     `protobuf:"varint,1,opt,name=use_http_header,json=useHttpHeader,proto3" json:"use_http_header,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Cluster_OriginalDstLbConfig) Reset()         { *m = Cluster_OriginalDstLbConfig{} }
func (m *Cluster_OriginalDstLbConfig) String() string { return proto.CompactTextString(m) }
func (*Cluster_OriginalDstLbConfig) ProtoMessage()    {}
func (*Cluster_OriginalDstLbConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_cds_c9aad078b729c273, []int{0, 4}
}
func (m *Cluster_OriginalDstLbConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Cluster_OriginalDstLbConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Cluster_OriginalDstLbConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Cluster_OriginalDstLbConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster_OriginalDstLbConfig.Merge(dst, src)
}
func (m *Cluster_OriginalDstLbConfig) XXX_Size() int {
	return m.Size()
}
func (m *Cluster_OriginalDstLbConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster_OriginalDstLbConfig.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster_OriginalDstLbConfig proto.InternalMessageInfo

func (m *Cluster_OriginalDstLbConfig) GetUseHttpHeader() bool {
	if m != nil {
		return m.UseHttpHeader
	}
	return false
}

// Common configuration for all load balancer implementations.
type Cluster_CommonLbConfig struct {
	// Configures the :ref:`healthy panic threshold <arch_overview_load_balancing_panic_threshold>`.
	// If not specified, the default is 50%.
	//
	// .. note::
	//   The specified percent will be truncated to the nearest 1%.
	HealthyPanicThreshold *_type.Percent `protobuf:"bytes,1,opt,name=healthy_panic_threshold,json=healthyPanicThreshold" json:"healthy_panic_threshold,omitempty"`
	// Types that are valid to be assigned to LocalityConfigSpecifier:
	//	*Cluster_CommonLbConfig_ZoneAwareLbConfig_
	//	*Cluster_CommonLbConfig_LocalityWeightedLbConfig_
	LocalityConfigSpecifier isCluster_CommonLbConfig_LocalityConfigSpecifier `protobuf_oneof:"locality_config_specifier"`
	// If set, all health check/weight/metadata updates that happen within this duration will be
	// merged and delivered in one shot when the duration expires. The start of the duration is when
	// the first update happens. This is useful for big clusters, with potentially noisy deploys
	// that might trigger excessive CPU usage due to a constant stream of healthcheck state changes
	// or metadata updates. By default, this is not configured and updates apply immediately. Also,
	// the first set of updates to be seen apply immediately as well (e.g.: a new cluster).
	//
	// Note: merging does not apply to cluster membership changes (e.g.: adds/removes); this is
	// because merging those updates isn't currently safe. See
	// https://github.com/envoyproxy/envoy/pull/3941.
	UpdateMergeWindow    *types.Duration `protobuf:"bytes,4,opt,name=update_merge_window,json=updateMergeWindow" json:"update_merge_window,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *Cluster_CommonLbConfig) Reset()         { *m = Cluster_CommonLbConfig{} }
func (m *Cluster_CommonLbConfig) String() string { return proto.CompactTextString(m) }
func (*Cluster_CommonLbConfig) ProtoMessage()    {}
func (*Cluster_CommonLbConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_cds_c9aad078b729c273, []int{0, 5}
}
func (m *Cluster_CommonLbConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Cluster_CommonLbConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Cluster_CommonLbConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Cluster_CommonLbConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster_CommonLbConfig.Merge(dst, src)
}
func (m *Cluster_CommonLbConfig) XXX_Size() int {
	return m.Size()
}
func (m *Cluster_CommonLbConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster_CommonLbConfig.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster_CommonLbConfig proto.InternalMessageInfo

type isCluster_CommonLbConfig_LocalityConfigSpecifier interface {
	isCluster_CommonLbConfig_LocalityConfigSpecifier()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type Cluster_CommonLbConfig_ZoneAwareLbConfig_ struct {
	ZoneAwareLbConfig *Cluster_CommonLbConfig_ZoneAwareLbConfig `protobuf:"bytes,2,opt,name=zone_aware_lb_config,json=zoneAwareLbConfig,oneof"`
}
type Cluster_CommonLbConfig_LocalityWeightedLbConfig_ struct {
	LocalityWeightedLbConfig *Cluster_CommonLbConfig_LocalityWeightedLbConfig `protobuf:"bytes,3,opt,name=locality_weighted_lb_config,json=localityWeightedLbConfig,oneof"`
}

func (*Cluster_CommonLbConfig_ZoneAwareLbConfig_) isCluster_CommonLbConfig_LocalityConfigSpecifier() {}
func (*Cluster_CommonLbConfig_LocalityWeightedLbConfig_) isCluster_CommonLbConfig_LocalityConfigSpecifier() {
}

func (m *Cluster_CommonLbConfig) GetLocalityConfigSpecifier() isCluster_CommonLbConfig_LocalityConfigSpecifier {
	if m != nil {
		return m.LocalityConfigSpecifier
	}
	return nil
}

func (m *Cluster_CommonLbConfig) GetHealthyPanicThreshold() *_type.Percent {
	if m != nil {
		return m.HealthyPanicThreshold
	}
	return nil
}

func (m *Cluster_CommonLbConfig) GetZoneAwareLbConfig() *Cluster_CommonLbConfig_ZoneAwareLbConfig {
	if x, ok := m.GetLocalityConfigSpecifier().(*Cluster_CommonLbConfig_ZoneAwareLbConfig_); ok {
		return x.ZoneAwareLbConfig
	}
	return nil
}

func (m *Cluster_CommonLbConfig) GetLocalityWeightedLbConfig() *Cluster_CommonLbConfig_LocalityWeightedLbConfig {
	if x, ok := m.GetLocalityConfigSpecifier().(*Cluster_CommonLbConfig_LocalityWeightedLbConfig_); ok {
		return x.LocalityWeightedLbConfig
	}
	return nil
}

func (m *Cluster_CommonLbConfig) GetUpdateMergeWindow() *types.Duration {
	if m != nil {
		return m.UpdateMergeWindow
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Cluster_CommonLbConfig) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Cluster_CommonLbConfig_OneofMarshaler, _Cluster_CommonLbConfig_OneofUnmarshaler, _Cluster_CommonLbConfig_OneofSizer, []interface{}{
		(*Cluster_CommonLbConfig_ZoneAwareLbConfig_)(nil),
		(*Cluster_CommonLbConfig_LocalityWeightedLbConfig_)(nil),
	}
}

func _Cluster_CommonLbConfig_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Cluster_CommonLbConfig)
	// locality_config_specifier
	switch x := m.LocalityConfigSpecifier.(type) {
	case *Cluster_CommonLbConfig_ZoneAwareLbConfig_:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ZoneAwareLbConfig); err != nil {
			return err
		}
	case *Cluster_CommonLbConfig_LocalityWeightedLbConfig_:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.LocalityWeightedLbConfig); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Cluster_CommonLbConfig.LocalityConfigSpecifier has unexpected type %T", x)
	}
	return nil
}

func _Cluster_CommonLbConfig_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Cluster_CommonLbConfig)
	switch tag {
	case 2: // locality_config_specifier.zone_aware_lb_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Cluster_CommonLbConfig_ZoneAwareLbConfig)
		err := b.DecodeMessage(msg)
		m.LocalityConfigSpecifier = &Cluster_CommonLbConfig_ZoneAwareLbConfig_{msg}
		return true, err
	case 3: // locality_config_specifier.locality_weighted_lb_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Cluster_CommonLbConfig_LocalityWeightedLbConfig)
		err := b.DecodeMessage(msg)
		m.LocalityConfigSpecifier = &Cluster_CommonLbConfig_LocalityWeightedLbConfig_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Cluster_CommonLbConfig_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Cluster_CommonLbConfig)
	// locality_config_specifier
	switch x := m.LocalityConfigSpecifier.(type) {
	case *Cluster_CommonLbConfig_ZoneAwareLbConfig_:
		s := proto.Size(x.ZoneAwareLbConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Cluster_CommonLbConfig_LocalityWeightedLbConfig_:
		s := proto.Size(x.LocalityWeightedLbConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Configuration for :ref:`zone aware routing
// <arch_overview_load_balancing_zone_aware_routing>`.
type Cluster_CommonLbConfig_ZoneAwareLbConfig struct {
	// Configures percentage of requests that will be considered for zone aware routing
	// if zone aware routing is configured. If not specified, the default is 100%.
	// * :ref:`runtime values <config_cluster_manager_cluster_runtime_zone_routing>`.
	// * :ref:`Zone aware routing support <arch_overview_load_balancing_zone_aware_routing>`.
	RoutingEnabled *_type.Percent `protobuf:"bytes,1,opt,name=routing_enabled,json=routingEnabled" json:"routing_enabled,omitempty"`
	// Configures minimum upstream cluster size required for zone aware routing
	// If upstream cluster size is less than specified, zone aware routing is not performed
	// even if zone aware routing is configured. If not specified, the default is 6.
	// * :ref:`runtime values <config_cluster_manager_cluster_runtime_zone_routing>`.
	// * :ref:`Zone aware routing support <arch_overview_load_balancing_zone_aware_routing>`.
	MinClusterSize       *types.UInt64Value `protobuf:"bytes,2,opt,name=min_cluster_size,json=minClusterSize" json:"min_cluster_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) Reset() {
	*m = Cluster_CommonLbConfig_ZoneAwareLbConfig{}
}
func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) String() string { return proto.CompactTextString(m) }
func (*Cluster_CommonLbConfig_ZoneAwareLbConfig) ProtoMessage()    {}
func (*Cluster_CommonLbConfig_ZoneAwareLbConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_cds_c9aad078b729c273, []int{0, 5, 0}
}
func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Cluster_CommonLbConfig_ZoneAwareLbConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Cluster_CommonLbConfig_ZoneAwareLbConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster_CommonLbConfig_ZoneAwareLbConfig.Merge(dst, src)
}
func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) XXX_Size() int {
	return m.Size()
}
func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster_CommonLbConfig_ZoneAwareLbConfig.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster_CommonLbConfig_ZoneAwareLbConfig proto.InternalMessageInfo

func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) GetRoutingEnabled() *_type.Percent {
	if m != nil {
		return m.RoutingEnabled
	}
	return nil
}

func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) GetMinClusterSize() *types.UInt64Value {
	if m != nil {
		return m.MinClusterSize
	}
	return nil
}

// Configuration for :ref:`locality weighted load balancing
// <arch_overview_load_balancing_locality_weighted_lb>`
type Cluster_CommonLbConfig_LocalityWeightedLbConfig struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig) Reset() {
	*m = Cluster_CommonLbConfig_LocalityWeightedLbConfig{}
}
func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig) String() string {
	return proto.CompactTextString(m)
}
func (*Cluster_CommonLbConfig_LocalityWeightedLbConfig) ProtoMessage() {}
func (*Cluster_CommonLbConfig_LocalityWeightedLbConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_cds_c9aad078b729c273, []int{0, 5, 1}
}
func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Cluster_CommonLbConfig_LocalityWeightedLbConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Cluster_CommonLbConfig_LocalityWeightedLbConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster_CommonLbConfig_LocalityWeightedLbConfig.Merge(dst, src)
}
func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig) XXX_Size() int {
	return m.Size()
}
func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster_CommonLbConfig_LocalityWeightedLbConfig.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster_CommonLbConfig_LocalityWeightedLbConfig proto.InternalMessageInfo

// An extensible structure containing the address Envoy should bind to when
// establishing upstream connections.
type UpstreamBindConfig struct {
	// The address Envoy should bind to when establishing upstream connections.
	SourceAddress        *core.Address `protobuf:"bytes,1,opt,name=source_address,json=sourceAddress" json:"source_address,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *UpstreamBindConfig) Reset()         { *m = UpstreamBindConfig{} }
func (m *UpstreamBindConfig) String() string { return proto.CompactTextString(m) }
func (*UpstreamBindConfig) ProtoMessage()    {}
func (*UpstreamBindConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_cds_c9aad078b729c273, []int{1}
}
func (m *UpstreamBindConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpstreamBindConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpstreamBindConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *UpstreamBindConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpstreamBindConfig.Merge(dst, src)
}
func (m *UpstreamBindConfig) XXX_Size() int {
	return m.Size()
}
func (m *UpstreamBindConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_UpstreamBindConfig.DiscardUnknown(m)
}

var xxx_messageInfo_UpstreamBindConfig proto.InternalMessageInfo

func (m *UpstreamBindConfig) GetSourceAddress() *core.Address {
	if m != nil {
		return m.SourceAddress
	}
	return nil
}

type UpstreamConnectionOptions struct {
	// If set then set SO_KEEPALIVE on the socket to enable TCP Keepalives.
	TcpKeepalive         *core.TcpKeepalive `protobuf:"bytes,1,opt,name=tcp_keepalive,json=tcpKeepalive" json:"tcp_keepalive,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *UpstreamConnectionOptions) Reset()         { *m = UpstreamConnectionOptions{} }
func (m *UpstreamConnectionOptions) String() string { return proto.CompactTextString(m) }
func (*UpstreamConnectionOptions) ProtoMessage()    {}
func (*UpstreamConnectionOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_cds_c9aad078b729c273, []int{2}
}
func (m *UpstreamConnectionOptions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpstreamConnectionOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpstreamConnectionOptions.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *UpstreamConnectionOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpstreamConnectionOptions.Merge(dst, src)
}
func (m *UpstreamConnectionOptions) XXX_Size() int {
	return m.Size()
}
func (m *UpstreamConnectionOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_UpstreamConnectionOptions.DiscardUnknown(m)
}

var xxx_messageInfo_UpstreamConnectionOptions proto.InternalMessageInfo

func (m *UpstreamConnectionOptions) GetTcpKeepalive() *core.TcpKeepalive {
	if m != nil {
		return m.TcpKeepalive
	}
	return nil
}

func init() {
	proto.RegisterType((*Cluster)(nil), "envoy.api.v2.Cluster")
	proto.RegisterMapType((map[string]*types.Struct)(nil), "envoy.api.v2.Cluster.ExtensionProtocolOptionsEntry")
	proto.RegisterType((*Cluster_EdsClusterConfig)(nil), "envoy.api.v2.Cluster.EdsClusterConfig")
	proto.RegisterType((*Cluster_LbSubsetConfig)(nil), "envoy.api.v2.Cluster.LbSubsetConfig")
	proto.RegisterType((*Cluster_LbSubsetConfig_LbSubsetSelector)(nil), "envoy.api.v2.Cluster.LbSubsetConfig.LbSubsetSelector")
	proto.RegisterType((*Cluster_RingHashLbConfig)(nil), "envoy.api.v2.Cluster.RingHashLbConfig")
	proto.RegisterType((*Cluster_RingHashLbConfig_DeprecatedV1)(nil), "envoy.api.v2.Cluster.RingHashLbConfig.DeprecatedV1")
	proto.RegisterType((*Cluster_OriginalDstLbConfig)(nil), "envoy.api.v2.Cluster.OriginalDstLbConfig")
	proto.RegisterType((*Cluster_CommonLbConfig)(nil), "envoy.api.v2.Cluster.CommonLbConfig")
	proto.RegisterType((*Cluster_CommonLbConfig_ZoneAwareLbConfig)(nil), "envoy.api.v2.Cluster.CommonLbConfig.ZoneAwareLbConfig")
	proto.RegisterType((*Cluster_CommonLbConfig_LocalityWeightedLbConfig)(nil), "envoy.api.v2.Cluster.CommonLbConfig.LocalityWeightedLbConfig")
	proto.RegisterType((*UpstreamBindConfig)(nil), "envoy.api.v2.UpstreamBindConfig")
	proto.RegisterType((*UpstreamConnectionOptions)(nil), "envoy.api.v2.UpstreamConnectionOptions")
	proto.RegisterEnum("envoy.api.v2.Cluster_DiscoveryType", Cluster_DiscoveryType_name, Cluster_DiscoveryType_value)
	proto.RegisterEnum("envoy.api.v2.Cluster_LbPolicy", Cluster_LbPolicy_name, Cluster_LbPolicy_value)
	proto.RegisterEnum("envoy.api.v2.Cluster_DnsLookupFamily", Cluster_DnsLookupFamily_name, Cluster_DnsLookupFamily_value)
	proto.RegisterEnum("envoy.api.v2.Cluster_ClusterProtocolSelection", Cluster_ClusterProtocolSelection_name, Cluster_ClusterProtocolSelection_value)
	proto.RegisterEnum("envoy.api.v2.Cluster_LbSubsetConfig_LbSubsetFallbackPolicy", Cluster_LbSubsetConfig_LbSubsetFallbackPolicy_name, Cluster_LbSubsetConfig_LbSubsetFallbackPolicy_value)
}
func (this *Cluster) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Cluster)
	if !ok {
		that2, ok := that.(Cluster)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.AltStatName != that1.AltStatName {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if !this.EdsClusterConfig.Equal(that1.EdsClusterConfig) {
		return false
	}
	if this.ConnectTimeout != that1.ConnectTimeout {
		return false
	}
	if !this.PerConnectionBufferLimitBytes.Equal(that1.PerConnectionBufferLimitBytes) {
		return false
	}
	if this.LbPolicy != that1.LbPolicy {
		return false
	}
	if len(this.Hosts) != len(that1.Hosts) {
		return false
	}
	for i := range this.Hosts {
		if !this.Hosts[i].Equal(that1.Hosts[i]) {
			return false
		}
	}
	if !this.LoadAssignment.Equal(that1.LoadAssignment) {
		return false
	}
	if len(this.HealthChecks) != len(that1.HealthChecks) {
		return false
	}
	for i := range this.HealthChecks {
		if !this.HealthChecks[i].Equal(that1.HealthChecks[i]) {
			return false
		}
	}
	if !this.MaxRequestsPerConnection.Equal(that1.MaxRequestsPerConnection) {
		return false
	}
	if !this.CircuitBreakers.Equal(that1.CircuitBreakers) {
		return false
	}
	if !this.TlsContext.Equal(that1.TlsContext) {
		return false
	}
	if !this.CommonHttpProtocolOptions.Equal(that1.CommonHttpProtocolOptions) {
		return false
	}
	if !this.HttpProtocolOptions.Equal(that1.HttpProtocolOptions) {
		return false
	}
	if !this.Http2ProtocolOptions.Equal(that1.Http2ProtocolOptions) {
		return false
	}
	if len(this.ExtensionProtocolOptions) != len(that1.ExtensionProtocolOptions) {
		return false
	}
	for i := range this.ExtensionProtocolOptions {
		if !this.ExtensionProtocolOptions[i].Equal(that1.ExtensionProtocolOptions[i]) {
			return false
		}
	}
	if this.DnsRefreshRate != nil && that1.DnsRefreshRate != nil {
		if *this.DnsRefreshRate != *that1.DnsRefreshRate {
			return false
		}
	} else if this.DnsRefreshRate != nil {
		return false
	} else if that1.DnsRefreshRate != nil {
		return false
	}
	if this.DnsLookupFamily != that1.DnsLookupFamily {
		return false
	}
	if len(this.DnsResolvers) != len(that1.DnsResolvers) {
		return false
	}
	for i := range this.DnsResolvers {
		if !this.DnsResolvers[i].Equal(that1.DnsResolvers[i]) {
			return false
		}
	}
	if !this.OutlierDetection.Equal(that1.OutlierDetection) {
		return false
	}
	if this.CleanupInterval != nil && that1.CleanupInterval != nil {
		if *this.CleanupInterval != *that1.CleanupInterval {
			return false
		}
	} else if this.CleanupInterval != nil {
		return false
	} else if that1.CleanupInterval != nil {
		return false
	}
	if !this.UpstreamBindConfig.Equal(that1.UpstreamBindConfig) {
		return false
	}
	if !this.LbSubsetConfig.Equal(that1.LbSubsetConfig) {
		return false
	}
	if that1.LbConfig == nil {
		if this.LbConfig != nil {
			return false
		}
	} else if this.LbConfig == nil {
		return false
	} else if !this.LbConfig.Equal(that1.LbConfig) {
		return false
	}
	if !this.CommonLbConfig.Equal(that1.CommonLbConfig) {
		return false
	}
	if !this.TransportSocket.Equal(that1.TransportSocket) {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if this.ProtocolSelection != that1.ProtocolSelection {
		return false
	}
	if !this.UpstreamConnectionOptions.Equal(that1.UpstreamConnectionOptions) {
		return false
	}
	if this.CloseConnectionsOnHostHealthFailure != that1.CloseConnectionsOnHostHealthFailure {
		return false
	}
	if this.DrainConnectionsOnHostRemoval != that1.DrainConnectionsOnHostRemoval {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Cluster_RingHashLbConfig_) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Cluster_RingHashLbConfig_)
	if !ok {
		that2, ok := that.(Cluster_RingHashLbConfig_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RingHashLbConfig.Equal(that1.RingHashLbConfig) {
		return false
	}
	return true
}
func (this *Cluster_OriginalDstLbConfig_) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Cluster_OriginalDstLbConfig_)
	if !ok {
		that2, ok := that.(Cluster_OriginalDstLbConfig_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.OriginalDstLbConfig.Equal(that1.OriginalDstLbConfig) {
		return false
	}
	return true
}
func (this *Cluster_EdsClusterConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Cluster_EdsClusterConfig)
	if !ok {
		that2, ok := that.(Cluster_EdsClusterConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.EdsConfig.Equal(that1.EdsConfig) {
		return false
	}
	if this.ServiceName != that1.ServiceName {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Cluster_LbSubsetConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Cluster_LbSubsetConfig)
	if !ok {
		that2, ok := that.(Cluster_LbSubsetConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.FallbackPolicy != that1.FallbackPolicy {
		return false
	}
	if !this.DefaultSubset.Equal(that1.DefaultSubset) {
		return false
	}
	if len(this.SubsetSelectors) != len(that1.SubsetSelectors) {
		return false
	}
	for i := range this.SubsetSelectors {
		if !this.SubsetSelectors[i].Equal(that1.SubsetSelectors[i]) {
			return false
		}
	}
	if this.LocalityWeightAware != that1.LocalityWeightAware {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Cluster_LbSubsetConfig_LbSubsetSelector) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Cluster_LbSubsetConfig_LbSubsetSelector)
	if !ok {
		that2, ok := that.(Cluster_LbSubsetConfig_LbSubsetSelector)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Keys) != len(that1.Keys) {
		return false
	}
	for i := range this.Keys {
		if this.Keys[i] != that1.Keys[i] {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Cluster_RingHashLbConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Cluster_RingHashLbConfig)
	if !ok {
		that2, ok := that.(Cluster_RingHashLbConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.MinimumRingSize.Equal(that1.MinimumRingSize) {
		return false
	}
	if !this.DeprecatedV1.Equal(that1.DeprecatedV1) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Cluster_RingHashLbConfig_DeprecatedV1) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Cluster_RingHashLbConfig_DeprecatedV1)
	if !ok {
		that2, ok := that.(Cluster_RingHashLbConfig_DeprecatedV1)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.UseStdHash.Equal(that1.UseStdHash) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Cluster_OriginalDstLbConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Cluster_OriginalDstLbConfig)
	if !ok {
		that2, ok := that.(Cluster_OriginalDstLbConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.UseHttpHeader != that1.UseHttpHeader {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Cluster_CommonLbConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Cluster_CommonLbConfig)
	if !ok {
		that2, ok := that.(Cluster_CommonLbConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.HealthyPanicThreshold.Equal(that1.HealthyPanicThreshold) {
		return false
	}
	if that1.LocalityConfigSpecifier == nil {
		if this.LocalityConfigSpecifier != nil {
			return false
		}
	} else if this.LocalityConfigSpecifier == nil {
		return false
	} else if !this.LocalityConfigSpecifier.Equal(that1.LocalityConfigSpecifier) {
		return false
	}
	if !this.UpdateMergeWindow.Equal(that1.UpdateMergeWindow) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Cluster_CommonLbConfig_ZoneAwareLbConfig_) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Cluster_CommonLbConfig_ZoneAwareLbConfig_)
	if !ok {
		that2, ok := that.(Cluster_CommonLbConfig_ZoneAwareLbConfig_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ZoneAwareLbConfig.Equal(that1.ZoneAwareLbConfig) {
		return false
	}
	return true
}
func (this *Cluster_CommonLbConfig_LocalityWeightedLbConfig_) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Cluster_CommonLbConfig_LocalityWeightedLbConfig_)
	if !ok {
		that2, ok := that.(Cluster_CommonLbConfig_LocalityWeightedLbConfig_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.LocalityWeightedLbConfig.Equal(that1.LocalityWeightedLbConfig) {
		return false
	}
	return true
}
func (this *Cluster_CommonLbConfig_ZoneAwareLbConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Cluster_CommonLbConfig_ZoneAwareLbConfig)
	if !ok {
		that2, ok := that.(Cluster_CommonLbConfig_ZoneAwareLbConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RoutingEnabled.Equal(that1.RoutingEnabled) {
		return false
	}
	if !this.MinClusterSize.Equal(that1.MinClusterSize) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Cluster_CommonLbConfig_LocalityWeightedLbConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Cluster_CommonLbConfig_LocalityWeightedLbConfig)
	if !ok {
		that2, ok := that.(Cluster_CommonLbConfig_LocalityWeightedLbConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *UpstreamBindConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*UpstreamBindConfig)
	if !ok {
		that2, ok := that.(UpstreamBindConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.SourceAddress.Equal(that1.SourceAddress) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *UpstreamConnectionOptions) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*UpstreamConnectionOptions)
	if !ok {
		that2, ok := that.(UpstreamConnectionOptions)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.TcpKeepalive.Equal(that1.TcpKeepalive) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for ClusterDiscoveryService service

type ClusterDiscoveryServiceClient interface {
	StreamClusters(ctx context.Context, opts ...grpc.CallOption) (ClusterDiscoveryService_StreamClustersClient, error)
	IncrementalClusters(ctx context.Context, opts ...grpc.CallOption) (ClusterDiscoveryService_IncrementalClustersClient, error)
	FetchClusters(ctx context.Context, in *DiscoveryRequest, opts ...grpc.CallOption) (*DiscoveryResponse, error)
}

type clusterDiscoveryServiceClient struct {
	cc *grpc.ClientConn
}

func NewClusterDiscoveryServiceClient(cc *grpc.ClientConn) ClusterDiscoveryServiceClient {
	return &clusterDiscoveryServiceClient{cc}
}

func (c *clusterDiscoveryServiceClient) StreamClusters(ctx context.Context, opts ...grpc.CallOption) (ClusterDiscoveryService_StreamClustersClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ClusterDiscoveryService_serviceDesc.Streams[0], "/envoy.api.v2.ClusterDiscoveryService/StreamClusters", opts...)
	if err != nil {
		return nil, err
	}
	x := &clusterDiscoveryServiceStreamClustersClient{stream}
	return x, nil
}

type ClusterDiscoveryService_StreamClustersClient interface {
	Send(*DiscoveryRequest) error
	Recv() (*DiscoveryResponse, error)
	grpc.ClientStream
}

type clusterDiscoveryServiceStreamClustersClient struct {
	grpc.ClientStream
}

func (x *clusterDiscoveryServiceStreamClustersClient) Send(m *DiscoveryRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *clusterDiscoveryServiceStreamClustersClient) Recv() (*DiscoveryResponse, error) {
	m := new(DiscoveryResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *clusterDiscoveryServiceClient) IncrementalClusters(ctx context.Context, opts ...grpc.CallOption) (ClusterDiscoveryService_IncrementalClustersClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ClusterDiscoveryService_serviceDesc.Streams[1], "/envoy.api.v2.ClusterDiscoveryService/IncrementalClusters", opts...)
	if err != nil {
		return nil, err
	}
	x := &clusterDiscoveryServiceIncrementalClustersClient{stream}
	return x, nil
}

type ClusterDiscoveryService_IncrementalClustersClient interface {
	Send(*IncrementalDiscoveryRequest) error
	Recv() (*IncrementalDiscoveryResponse, error)
	grpc.ClientStream
}

type clusterDiscoveryServiceIncrementalClustersClient struct {
	grpc.ClientStream
}

func (x *clusterDiscoveryServiceIncrementalClustersClient) Send(m *IncrementalDiscoveryRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *clusterDiscoveryServiceIncrementalClustersClient) Recv() (*IncrementalDiscoveryResponse, error) {
	m := new(IncrementalDiscoveryResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *clusterDiscoveryServiceClient) FetchClusters(ctx context.Context, in *DiscoveryRequest, opts ...grpc.CallOption) (*DiscoveryResponse, error) {
	out := new(DiscoveryResponse)
	err := c.cc.Invoke(ctx, "/envoy.api.v2.ClusterDiscoveryService/FetchClusters", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ClusterDiscoveryService service

type ClusterDiscoveryServiceServer interface {
	StreamClusters(ClusterDiscoveryService_StreamClustersServer) error
	IncrementalClusters(ClusterDiscoveryService_IncrementalClustersServer) error
	FetchClusters(context.Context, *DiscoveryRequest) (*DiscoveryResponse, error)
}

func RegisterClusterDiscoveryServiceServer(s *grpc.Server, srv ClusterDiscoveryServiceServer) {
	s.RegisterService(&_ClusterDiscoveryService_serviceDesc, srv)
}

func _ClusterDiscoveryService_StreamClusters_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(ClusterDiscoveryServiceServer).StreamClusters(&clusterDiscoveryServiceStreamClustersServer{stream})
}

type ClusterDiscoveryService_StreamClustersServer interface {
	Send(*DiscoveryResponse) error
	Recv() (*DiscoveryRequest, error)
	grpc.ServerStream
}

type clusterDiscoveryServiceStreamClustersServer struct {
	grpc.ServerStream
}

func (x *clusterDiscoveryServiceStreamClustersServer) Send(m *DiscoveryResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *clusterDiscoveryServiceStreamClustersServer) Recv() (*DiscoveryRequest, error) {
	m := new(DiscoveryRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _ClusterDiscoveryService_IncrementalClusters_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(ClusterDiscoveryServiceServer).IncrementalClusters(&clusterDiscoveryServiceIncrementalClustersServer{stream})
}

type ClusterDiscoveryService_IncrementalClustersServer interface {
	Send(*IncrementalDiscoveryResponse) error
	Recv() (*IncrementalDiscoveryRequest, error)
	grpc.ServerStream
}

type clusterDiscoveryServiceIncrementalClustersServer struct {
	grpc.ServerStream
}

func (x *clusterDiscoveryServiceIncrementalClustersServer) Send(m *IncrementalDiscoveryResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *clusterDiscoveryServiceIncrementalClustersServer) Recv() (*IncrementalDiscoveryRequest, error) {
	m := new(IncrementalDiscoveryRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _ClusterDiscoveryService_FetchClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DiscoveryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterDiscoveryServiceServer).FetchClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/envoy.api.v2.ClusterDiscoveryService/FetchClusters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterDiscoveryServiceServer).FetchClusters(ctx, req.(*DiscoveryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ClusterDiscoveryService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "envoy.api.v2.ClusterDiscoveryService",
	HandlerType: (*ClusterDiscoveryServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "FetchClusters",
			Handler:    _ClusterDiscoveryService_FetchClusters_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamClusters",
			Handler:       _ClusterDiscoveryService_StreamClusters_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "IncrementalClusters",
			Handler:       _ClusterDiscoveryService_IncrementalClusters_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "envoy/api/v2/cds.proto",
}

func (m *Cluster) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Cluster) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCds(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.Type != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.Type))
	}
	if m.EdsClusterConfig != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.EdsClusterConfig.Size()))
		n1, err := m.EdsClusterConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintCds(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(m.ConnectTimeout)))
	n2, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(m.ConnectTimeout, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	if m.PerConnectionBufferLimitBytes != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.PerConnectionBufferLimitBytes.Size()))
		n3, err := m.PerConnectionBufferLimitBytes.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.LbPolicy != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.LbPolicy))
	}
	if len(m.Hosts) > 0 {
		for _, msg := range m.Hosts {
			dAtA[i] = 0x3a
			i++
			i = encodeVarintCds(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.HealthChecks) > 0 {
		for _, msg := range m.HealthChecks {
			dAtA[i] = 0x42
			i++
			i = encodeVarintCds(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.MaxRequestsPerConnection != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.MaxRequestsPerConnection.Size()))
		n4, err := m.MaxRequestsPerConnection.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.CircuitBreakers != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.CircuitBreakers.Size()))
		n5, err := m.CircuitBreakers.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.TlsContext != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.TlsContext.Size()))
		n6, err := m.TlsContext.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.HttpProtocolOptions != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.HttpProtocolOptions.Size()))
		n7, err := m.HttpProtocolOptions.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.Http2ProtocolOptions != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.Http2ProtocolOptions.Size()))
		n8, err := m.Http2ProtocolOptions.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.DnsRefreshRate != nil {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.DnsRefreshRate)))
		n9, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.DnsRefreshRate, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if m.DnsLookupFamily != 0 {
		dAtA[i] = 0x88
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.DnsLookupFamily))
	}
	if len(m.DnsResolvers) > 0 {
		for _, msg := range m.DnsResolvers {
			dAtA[i] = 0x92
			i++
			dAtA[i] = 0x1
			i++
			i = encodeVarintCds(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.OutlierDetection != nil {
		dAtA[i] = 0x9a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.OutlierDetection.Size()))
		n10, err := m.OutlierDetection.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if m.CleanupInterval != nil {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.CleanupInterval)))
		n11, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.CleanupInterval, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	if m.UpstreamBindConfig != nil {
		dAtA[i] = 0xaa
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.UpstreamBindConfig.Size()))
		n12, err := m.UpstreamBindConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	if m.LbSubsetConfig != nil {
		dAtA[i] = 0xb2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.LbSubsetConfig.Size()))
		n13, err := m.LbSubsetConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	if m.LbConfig != nil {
		nn14, err := m.LbConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn14
	}
	if m.TransportSocket != nil {
		dAtA[i] = 0xc2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.TransportSocket.Size()))
		n15, err := m.TransportSocket.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	if m.Metadata != nil {
		dAtA[i] = 0xca
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.Metadata.Size()))
		n16, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	if m.ProtocolSelection != 0 {
		dAtA[i] = 0xd0
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.ProtocolSelection))
	}
	if m.CommonLbConfig != nil {
		dAtA[i] = 0xda
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.CommonLbConfig.Size()))
		n17, err := m.CommonLbConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	if len(m.AltStatName) > 0 {
		dAtA[i] = 0xe2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(len(m.AltStatName)))
		i += copy(dAtA[i:], m.AltStatName)
	}
	if m.CommonHttpProtocolOptions != nil {
		dAtA[i] = 0xea
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.CommonHttpProtocolOptions.Size()))
		n18, err := m.CommonHttpProtocolOptions.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n18
	}
	if m.UpstreamConnectionOptions != nil {
		dAtA[i] = 0xf2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.UpstreamConnectionOptions.Size()))
		n19, err := m.UpstreamConnectionOptions.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n19
	}
	if m.CloseConnectionsOnHostHealthFailure {
		dAtA[i] = 0xf8
		i++
		dAtA[i] = 0x1
		i++
		if m.CloseConnectionsOnHostHealthFailure {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.DrainConnectionsOnHostRemoval {
		dAtA[i] = 0x80
		i++
		dAtA[i] = 0x2
		i++
		if m.DrainConnectionsOnHostRemoval {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.LoadAssignment != nil {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.LoadAssignment.Size()))
		n20, err := m.LoadAssignment.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n20
	}
	if len(m.ExtensionProtocolOptions) > 0 {
		for k, _ := range m.ExtensionProtocolOptions {
			dAtA[i] = 0x9a
			i++
			dAtA[i] = 0x2
			i++
			v := m.ExtensionProtocolOptions[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovCds(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovCds(uint64(len(k))) + msgSize
			i = encodeVarintCds(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintCds(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintCds(dAtA, i, uint64(v.Size()))
				n21, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n21
			}
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Cluster_RingHashLbConfig_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RingHashLbConfig != nil {
		dAtA[i] = 0xba
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.RingHashLbConfig.Size()))
		n22, err := m.RingHashLbConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n22
	}
	return i, nil
}
func (m *Cluster_OriginalDstLbConfig_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.OriginalDstLbConfig != nil {
		dAtA[i] = 0x92
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.OriginalDstLbConfig.Size()))
		n23, err := m.OriginalDstLbConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n23
	}
	return i, nil
}
func (m *Cluster_EdsClusterConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Cluster_EdsClusterConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.EdsConfig != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.EdsConfig.Size()))
		n24, err := m.EdsConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n24
	}
	if len(m.ServiceName) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCds(dAtA, i, uint64(len(m.ServiceName)))
		i += copy(dAtA[i:], m.ServiceName)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Cluster_LbSubsetConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Cluster_LbSubsetConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.FallbackPolicy != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.FallbackPolicy))
	}
	if m.DefaultSubset != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.DefaultSubset.Size()))
		n25, err := m.DefaultSubset.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n25
	}
	if len(m.SubsetSelectors) > 0 {
		for _, msg := range m.SubsetSelectors {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintCds(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.LocalityWeightAware {
		dAtA[i] = 0x20
		i++
		if m.LocalityWeightAware {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Cluster_LbSubsetConfig_LbSubsetSelector) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Cluster_LbSubsetConfig_LbSubsetSelector) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Keys) > 0 {
		for _, s := range m.Keys {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Cluster_RingHashLbConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Cluster_RingHashLbConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.MinimumRingSize != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.MinimumRingSize.Size()))
		n26, err := m.MinimumRingSize.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n26
	}
	if m.DeprecatedV1 != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.DeprecatedV1.Size()))
		n27, err := m.DeprecatedV1.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n27
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Cluster_RingHashLbConfig_DeprecatedV1) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Cluster_RingHashLbConfig_DeprecatedV1) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.UseStdHash != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.UseStdHash.Size()))
		n28, err := m.UseStdHash.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n28
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Cluster_OriginalDstLbConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Cluster_OriginalDstLbConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.UseHttpHeader {
		dAtA[i] = 0x8
		i++
		if m.UseHttpHeader {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Cluster_CommonLbConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Cluster_CommonLbConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.HealthyPanicThreshold != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.HealthyPanicThreshold.Size()))
		n29, err := m.HealthyPanicThreshold.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n29
	}
	if m.LocalityConfigSpecifier != nil {
		nn30, err := m.LocalityConfigSpecifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn30
	}
	if m.UpdateMergeWindow != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.UpdateMergeWindow.Size()))
		n31, err := m.UpdateMergeWindow.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n31
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ZoneAwareLbConfig != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.ZoneAwareLbConfig.Size()))
		n32, err := m.ZoneAwareLbConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n32
	}
	return i, nil
}
func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.LocalityWeightedLbConfig != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.LocalityWeightedLbConfig.Size()))
		n33, err := m.LocalityWeightedLbConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n33
	}
	return i, nil
}
func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RoutingEnabled != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.RoutingEnabled.Size()))
		n34, err := m.RoutingEnabled.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n34
	}
	if m.MinClusterSize != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.MinClusterSize.Size()))
		n35, err := m.MinClusterSize.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n35
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *UpstreamBindConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpstreamBindConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.SourceAddress != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.SourceAddress.Size()))
		n36, err := m.SourceAddress.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n36
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *UpstreamConnectionOptions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpstreamConnectionOptions) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.TcpKeepalive != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.TcpKeepalive.Size()))
		n37, err := m.TcpKeepalive.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n37
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintCds(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Cluster) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovCds(uint64(l))
	}
	if m.Type != 0 {
		n += 1 + sovCds(uint64(m.Type))
	}
	if m.EdsClusterConfig != nil {
		l = m.EdsClusterConfig.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	l = github_com_gogo_protobuf_types.SizeOfStdDuration(m.ConnectTimeout)
	n += 1 + l + sovCds(uint64(l))
	if m.PerConnectionBufferLimitBytes != nil {
		l = m.PerConnectionBufferLimitBytes.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.LbPolicy != 0 {
		n += 1 + sovCds(uint64(m.LbPolicy))
	}
	if len(m.Hosts) > 0 {
		for _, e := range m.Hosts {
			l = e.Size()
			n += 1 + l + sovCds(uint64(l))
		}
	}
	if len(m.HealthChecks) > 0 {
		for _, e := range m.HealthChecks {
			l = e.Size()
			n += 1 + l + sovCds(uint64(l))
		}
	}
	if m.MaxRequestsPerConnection != nil {
		l = m.MaxRequestsPerConnection.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.CircuitBreakers != nil {
		l = m.CircuitBreakers.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.TlsContext != nil {
		l = m.TlsContext.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.HttpProtocolOptions != nil {
		l = m.HttpProtocolOptions.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.Http2ProtocolOptions != nil {
		l = m.Http2ProtocolOptions.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.DnsRefreshRate != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.DnsRefreshRate)
		n += 2 + l + sovCds(uint64(l))
	}
	if m.DnsLookupFamily != 0 {
		n += 2 + sovCds(uint64(m.DnsLookupFamily))
	}
	if len(m.DnsResolvers) > 0 {
		for _, e := range m.DnsResolvers {
			l = e.Size()
			n += 2 + l + sovCds(uint64(l))
		}
	}
	if m.OutlierDetection != nil {
		l = m.OutlierDetection.Size()
		n += 2 + l + sovCds(uint64(l))
	}
	if m.CleanupInterval != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.CleanupInterval)
		n += 2 + l + sovCds(uint64(l))
	}
	if m.UpstreamBindConfig != nil {
		l = m.UpstreamBindConfig.Size()
		n += 2 + l + sovCds(uint64(l))
	}
	if m.LbSubsetConfig != nil {
		l = m.LbSubsetConfig.Size()
		n += 2 + l + sovCds(uint64(l))
	}
	if m.LbConfig != nil {
		n += m.LbConfig.Size()
	}
	if m.TransportSocket != nil {
		l = m.TransportSocket.Size()
		n += 2 + l + sovCds(uint64(l))
	}
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 2 + l + sovCds(uint64(l))
	}
	if m.ProtocolSelection != 0 {
		n += 2 + sovCds(uint64(m.ProtocolSelection))
	}
	if m.CommonLbConfig != nil {
		l = m.CommonLbConfig.Size()
		n += 2 + l + sovCds(uint64(l))
	}
	l = len(m.AltStatName)
	if l > 0 {
		n += 2 + l + sovCds(uint64(l))
	}
	if m.CommonHttpProtocolOptions != nil {
		l = m.CommonHttpProtocolOptions.Size()
		n += 2 + l + sovCds(uint64(l))
	}
	if m.UpstreamConnectionOptions != nil {
		l = m.UpstreamConnectionOptions.Size()
		n += 2 + l + sovCds(uint64(l))
	}
	if m.CloseConnectionsOnHostHealthFailure {
		n += 3
	}
	if m.DrainConnectionsOnHostRemoval {
		n += 3
	}
	if m.LoadAssignment != nil {
		l = m.LoadAssignment.Size()
		n += 2 + l + sovCds(uint64(l))
	}
	if len(m.ExtensionProtocolOptions) > 0 {
		for k, v := range m.ExtensionProtocolOptions {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovCds(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovCds(uint64(len(k))) + l
			n += mapEntrySize + 2 + sovCds(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Cluster_RingHashLbConfig_) Size() (n int) {
	var l int
	_ = l
	if m.RingHashLbConfig != nil {
		l = m.RingHashLbConfig.Size()
		n += 2 + l + sovCds(uint64(l))
	}
	return n
}
func (m *Cluster_OriginalDstLbConfig_) Size() (n int) {
	var l int
	_ = l
	if m.OriginalDstLbConfig != nil {
		l = m.OriginalDstLbConfig.Size()
		n += 2 + l + sovCds(uint64(l))
	}
	return n
}
func (m *Cluster_EdsClusterConfig) Size() (n int) {
	var l int
	_ = l
	if m.EdsConfig != nil {
		l = m.EdsConfig.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	l = len(m.ServiceName)
	if l > 0 {
		n += 1 + l + sovCds(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Cluster_LbSubsetConfig) Size() (n int) {
	var l int
	_ = l
	if m.FallbackPolicy != 0 {
		n += 1 + sovCds(uint64(m.FallbackPolicy))
	}
	if m.DefaultSubset != nil {
		l = m.DefaultSubset.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if len(m.SubsetSelectors) > 0 {
		for _, e := range m.SubsetSelectors {
			l = e.Size()
			n += 1 + l + sovCds(uint64(l))
		}
	}
	if m.LocalityWeightAware {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Cluster_LbSubsetConfig_LbSubsetSelector) Size() (n int) {
	var l int
	_ = l
	if len(m.Keys) > 0 {
		for _, s := range m.Keys {
			l = len(s)
			n += 1 + l + sovCds(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Cluster_RingHashLbConfig) Size() (n int) {
	var l int
	_ = l
	if m.MinimumRingSize != nil {
		l = m.MinimumRingSize.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.DeprecatedV1 != nil {
		l = m.DeprecatedV1.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Cluster_RingHashLbConfig_DeprecatedV1) Size() (n int) {
	var l int
	_ = l
	if m.UseStdHash != nil {
		l = m.UseStdHash.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Cluster_OriginalDstLbConfig) Size() (n int) {
	var l int
	_ = l
	if m.UseHttpHeader {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Cluster_CommonLbConfig) Size() (n int) {
	var l int
	_ = l
	if m.HealthyPanicThreshold != nil {
		l = m.HealthyPanicThreshold.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.LocalityConfigSpecifier != nil {
		n += m.LocalityConfigSpecifier.Size()
	}
	if m.UpdateMergeWindow != nil {
		l = m.UpdateMergeWindow.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig_) Size() (n int) {
	var l int
	_ = l
	if m.ZoneAwareLbConfig != nil {
		l = m.ZoneAwareLbConfig.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	return n
}
func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig_) Size() (n int) {
	var l int
	_ = l
	if m.LocalityWeightedLbConfig != nil {
		l = m.LocalityWeightedLbConfig.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	return n
}
func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) Size() (n int) {
	var l int
	_ = l
	if m.RoutingEnabled != nil {
		l = m.RoutingEnabled.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.MinClusterSize != nil {
		l = m.MinClusterSize.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig) Size() (n int) {
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UpstreamBindConfig) Size() (n int) {
	var l int
	_ = l
	if m.SourceAddress != nil {
		l = m.SourceAddress.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UpstreamConnectionOptions) Size() (n int) {
	var l int
	_ = l
	if m.TcpKeepalive != nil {
		l = m.TcpKeepalive.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovCds(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozCds(x uint64) (n int) {
	return sovCds(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Cluster) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Cluster: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Cluster: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (Cluster_DiscoveryType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EdsClusterConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EdsClusterConfig == nil {
				m.EdsClusterConfig = &Cluster_EdsClusterConfig{}
			}
			if err := m.EdsClusterConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnectTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(&m.ConnectTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PerConnectionBufferLimitBytes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PerConnectionBufferLimitBytes == nil {
				m.PerConnectionBufferLimitBytes = &types.UInt32Value{}
			}
			if err := m.PerConnectionBufferLimitBytes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LbPolicy", wireType)
			}
			m.LbPolicy = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LbPolicy |= (Cluster_LbPolicy(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hosts", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hosts = append(m.Hosts, &core.Address{})
			if err := m.Hosts[len(m.Hosts)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HealthChecks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HealthChecks = append(m.HealthChecks, &core.HealthCheck{})
			if err := m.HealthChecks[len(m.HealthChecks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxRequestsPerConnection", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MaxRequestsPerConnection == nil {
				m.MaxRequestsPerConnection = &types.UInt32Value{}
			}
			if err := m.MaxRequestsPerConnection.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CircuitBreakers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CircuitBreakers == nil {
				m.CircuitBreakers = &cluster.CircuitBreakers{}
			}
			if err := m.CircuitBreakers.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TlsContext", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TlsContext == nil {
				m.TlsContext = &auth.UpstreamTlsContext{}
			}
			if err := m.TlsContext.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpProtocolOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HttpProtocolOptions == nil {
				m.HttpProtocolOptions = &core.Http1ProtocolOptions{}
			}
			if err := m.HttpProtocolOptions.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Http2ProtocolOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Http2ProtocolOptions == nil {
				m.Http2ProtocolOptions = &core.Http2ProtocolOptions{}
			}
			if err := m.Http2ProtocolOptions.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsRefreshRate", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DnsRefreshRate == nil {
				m.DnsRefreshRate = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.DnsRefreshRate, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsLookupFamily", wireType)
			}
			m.DnsLookupFamily = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DnsLookupFamily |= (Cluster_DnsLookupFamily(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsResolvers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DnsResolvers = append(m.DnsResolvers, &core.Address{})
			if err := m.DnsResolvers[len(m.DnsResolvers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 19:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OutlierDetection", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OutlierDetection == nil {
				m.OutlierDetection = &cluster.OutlierDetection{}
			}
			if err := m.OutlierDetection.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CleanupInterval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CleanupInterval == nil {
				m.CleanupInterval = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.CleanupInterval, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpstreamBindConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UpstreamBindConfig == nil {
				m.UpstreamBindConfig = &core.BindConfig{}
			}
			if err := m.UpstreamBindConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LbSubsetConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LbSubsetConfig == nil {
				m.LbSubsetConfig = &Cluster_LbSubsetConfig{}
			}
			if err := m.LbSubsetConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 23:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RingHashLbConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Cluster_RingHashLbConfig{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.LbConfig = &Cluster_RingHashLbConfig_{v}
			iNdEx = postIndex
		case 24:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TransportSocket", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TransportSocket == nil {
				m.TransportSocket = &core.TransportSocket{}
			}
			if err := m.TransportSocket.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 25:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &core.Metadata{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 26:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProtocolSelection", wireType)
			}
			m.ProtocolSelection = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ProtocolSelection |= (Cluster_ClusterProtocolSelection(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 27:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommonLbConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CommonLbConfig == nil {
				m.CommonLbConfig = &Cluster_CommonLbConfig{}
			}
			if err := m.CommonLbConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 28:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AltStatName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AltStatName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 29:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommonHttpProtocolOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CommonHttpProtocolOptions == nil {
				m.CommonHttpProtocolOptions = &core.HttpProtocolOptions{}
			}
			if err := m.CommonHttpProtocolOptions.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 30:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpstreamConnectionOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UpstreamConnectionOptions == nil {
				m.UpstreamConnectionOptions = &UpstreamConnectionOptions{}
			}
			if err := m.UpstreamConnectionOptions.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 31:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CloseConnectionsOnHostHealthFailure", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CloseConnectionsOnHostHealthFailure = bool(v != 0)
		case 32:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DrainConnectionsOnHostRemoval", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DrainConnectionsOnHostRemoval = bool(v != 0)
		case 33:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LoadAssignment", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LoadAssignment == nil {
				m.LoadAssignment = &ClusterLoadAssignment{}
			}
			if err := m.LoadAssignment.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 34:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OriginalDstLbConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Cluster_OriginalDstLbConfig{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.LbConfig = &Cluster_OriginalDstLbConfig_{v}
			iNdEx = postIndex
		case 35:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExtensionProtocolOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExtensionProtocolOptions == nil {
				m.ExtensionProtocolOptions = make(map[string]*types.Struct)
			}
			var mapkey string
			var mapvalue *types.Struct
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowCds
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowCds
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthCds
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowCds
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthCds
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthCds
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &types.Struct{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipCds(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthCds
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ExtensionProtocolOptions[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Cluster_EdsClusterConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EdsClusterConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EdsClusterConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EdsConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EdsConfig == nil {
				m.EdsConfig = &core.ConfigSource{}
			}
			if err := m.EdsConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServiceName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServiceName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Cluster_LbSubsetConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LbSubsetConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LbSubsetConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FallbackPolicy", wireType)
			}
			m.FallbackPolicy = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FallbackPolicy |= (Cluster_LbSubsetConfig_LbSubsetFallbackPolicy(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultSubset", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DefaultSubset == nil {
				m.DefaultSubset = &types.Struct{}
			}
			if err := m.DefaultSubset.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubsetSelectors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubsetSelectors = append(m.SubsetSelectors, &Cluster_LbSubsetConfig_LbSubsetSelector{})
			if err := m.SubsetSelectors[len(m.SubsetSelectors)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalityWeightAware", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.LocalityWeightAware = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Cluster_LbSubsetConfig_LbSubsetSelector) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LbSubsetSelector: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LbSubsetSelector: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Keys", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Keys = append(m.Keys, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Cluster_RingHashLbConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RingHashLbConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RingHashLbConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinimumRingSize", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MinimumRingSize == nil {
				m.MinimumRingSize = &types.UInt64Value{}
			}
			if err := m.MinimumRingSize.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeprecatedV1", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeprecatedV1 == nil {
				m.DeprecatedV1 = &Cluster_RingHashLbConfig_DeprecatedV1{}
			}
			if err := m.DeprecatedV1.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Cluster_RingHashLbConfig_DeprecatedV1) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeprecatedV1: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeprecatedV1: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UseStdHash", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UseStdHash == nil {
				m.UseStdHash = &types.BoolValue{}
			}
			if err := m.UseStdHash.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Cluster_OriginalDstLbConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OriginalDstLbConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OriginalDstLbConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UseHttpHeader", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UseHttpHeader = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Cluster_CommonLbConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommonLbConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommonLbConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HealthyPanicThreshold", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HealthyPanicThreshold == nil {
				m.HealthyPanicThreshold = &_type.Percent{}
			}
			if err := m.HealthyPanicThreshold.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ZoneAwareLbConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Cluster_CommonLbConfig_ZoneAwareLbConfig{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.LocalityConfigSpecifier = &Cluster_CommonLbConfig_ZoneAwareLbConfig_{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalityWeightedLbConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Cluster_CommonLbConfig_LocalityWeightedLbConfig{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.LocalityConfigSpecifier = &Cluster_CommonLbConfig_LocalityWeightedLbConfig_{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpdateMergeWindow", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UpdateMergeWindow == nil {
				m.UpdateMergeWindow = &types.Duration{}
			}
			if err := m.UpdateMergeWindow.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ZoneAwareLbConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ZoneAwareLbConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RoutingEnabled", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RoutingEnabled == nil {
				m.RoutingEnabled = &_type.Percent{}
			}
			if err := m.RoutingEnabled.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinClusterSize", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MinClusterSize == nil {
				m.MinClusterSize = &types.UInt64Value{}
			}
			if err := m.MinClusterSize.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LocalityWeightedLbConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LocalityWeightedLbConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpstreamBindConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpstreamBindConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpstreamBindConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceAddress", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SourceAddress == nil {
				m.SourceAddress = &core.Address{}
			}
			if err := m.SourceAddress.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpstreamConnectionOptions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpstreamConnectionOptions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpstreamConnectionOptions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TcpKeepalive", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TcpKeepalive == nil {
				m.TcpKeepalive = &core.TcpKeepalive{}
			}
			if err := m.TcpKeepalive.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipCds(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowCds
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCds
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCds
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthCds
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowCds
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipCds(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthCds = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowCds   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("envoy/api/v2/cds.proto", fileDescriptor_cds_c9aad078b729c273) }

var fileDescriptor_cds_c9aad078b729c273 = []byte{
	// 2344 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x58, 0xcd, 0x6f, 0x1b, 0xc7,
	0x15, 0xd7, 0x52, 0x72, 0x2c, 0x3d, 0x89, 0xe4, 0x6a, 0xe4, 0x8f, 0x35, 0x65, 0xcb, 0x32, 0xf3,
	0x51, 0xd5, 0x68, 0xa9, 0x46, 0x4e, 0xd2, 0x22, 0x4d, 0x52, 0xf0, 0x4b, 0x16, 0x13, 0x9a, 0x54,
	0x77, 0x29, 0x0b, 0x69, 0x1a, 0x4c, 0x86, 0xbb, 0x23, 0x72, 0xab, 0xe5, 0xee, 0x66, 0x67, 0x56,
	0xb6, 0x7c, 0x28, 0x82, 0x9c, 0x7a, 0x2f, 0x50, 0xb4, 0xff, 0x41, 0xd1, 0x3f, 0xa1, 0xa7, 0x1e,
	0x73, 0x6c, 0xd1, 0x63, 0x81, 0xb6, 0x30, 0x72, 0x68, 0xff, 0x8b, 0x62, 0x66, 0x67, 0x69, 0x7e,
	0xac, 0x6c, 0x05, 0xe8, 0x89, 0x9c, 0xf7, 0x7e, 0xef, 0x37, 0x33, 0x6f, 0xdf, 0x7b, 0xf3, 0x66,
	0xe0, 0x06, 0xf5, 0xcf, 0x82, 0xf3, 0x5d, 0x12, 0xba, 0xbb, 0x67, 0x7b, 0xbb, 0xb6, 0xc3, 0x2a,
	0x61, 0x14, 0xf0, 0x00, 0xad, 0x49, 0x79, 0x85, 0x84, 0x6e, 0xe5, 0x6c, 0xaf, 0x74, 0x77, 0x1a,
	0x15, 0x44, 0x74, 0x97, 0x38, 0x4e, 0x44, 0x99, 0x82, 0x97, 0x6e, 0x4f, 0x01, 0x48, 0xcc, 0x87,
	0xbb, 0x36, 0x8d, 0x78, 0xa6, 0x56, 0x9a, 0xf7, 0x09, 0xa3, 0x4a, 0xfb, 0xe6, 0xbc, 0xd6, 0x0e,
	0xfc, 0x13, 0x77, 0x80, 0x59, 0x10, 0x47, 0x36, 0xcd, 0x24, 0x71, 0x5c, 0x66, 0x07, 0x67, 0x34,
	0x3a, 0x57, 0xda, 0x37, 0xe6, 0x49, 0x86, 0x94, 0x78, 0x7c, 0x88, 0xed, 0x21, 0xb5, 0x4f, 0x15,
	0x6a, 0x7b, 0x1e, 0x25, 0x15, 0x76, 0xe0, 0x29, 0xc4, 0xfd, 0x69, 0x84, 0x17, 0x33, 0x4e, 0xa3,
	0x5d, 0xdb, 0x8d, 0xec, 0xd8, 0xe5, 0xb8, 0x1f, 0x51, 0x72, 0x4a, 0x23, 0x85, 0xfd, 0x41, 0x26,
	0x36, 0x88, 0xb9, 0xe7, 0xd2, 0x08, 0x3b, 0x94, 0x53, 0x9b, 0xbb, 0x81, 0xaf, 0xd0, 0xd3, 0x9e,
	0xa6, 0xa9, 0xa7, 0x4b, 0x46, 0x22, 0xe7, 0xe7, 0x21, 0xdd, 0x0d, 0x69, 0x64, 0x53, 0x7f, 0xec,
	0xb6, 0x41, 0x10, 0x0c, 0x3c, 0x2a, 0x4d, 0x88, 0xef, 0x07, 0x9c, 0x08, 0xba, 0xd4, 0x6e, 0x4b,
	0x69, 0xe5, 0xa8, 0x1f, 0x9f, 0xec, 0x3a, 0x71, 0x44, 0x26, 0xe6, 0xbb, 0x3d, 0xab, 0x67, 0x3c,
	0x8a, 0x6d, 0x7e, 0x91, 0xf5, 0x93, 0x88, 0x84, 0x21, 0x8d, 0x52, 0xf6, 0x9b, 0x67, 0xc4, 0x73,
	0x1d, 0xc2, 0xe9, 0x6e, 0xfa, 0x47, 0x29, 0xae, 0x0d, 0x82, 0x41, 0x20, 0xff, 0xee, 0x8a, 0x7f,
	0x89, 0xb4, 0xfc, 0xed, 0x1b, 0x70, 0xb5, 0x9e, 0x38, 0x00, 0xdd, 0x81, 0x25, 0x9f, 0x8c, 0xa8,
	0xa1, 0x6d, 0x6b, 0x3b, 0x2b, 0xb5, 0x95, 0x3f, 0xff, 0xf7, 0x2f, 0x8b, 0x4b, 0x51, 0x6e, 0x5b,
	0x33, 0xa5, 0x18, 0xd5, 0x61, 0x49, 0xec, 0xd5, 0xc8, 0x6d, 0x6b, 0x3b, 0x85, 0xbd, 0xd7, 0x2b,
	0x93, 0x81, 0x56, 0x51, 0x1c, 0x95, 0x46, 0xfa, 0x79, 0x7b, 0xe7, 0x21, 0xad, 0x81, 0xe0, 0xb8,
	0xf2, 0xb5, 0x96, 0xd3, 0x35, 0x53, 0x1a, 0xa3, 0x1e, 0x20, 0xea, 0x30, 0xac, 0x7c, 0x8e, 0x93,
	0x78, 0x31, 0x16, 0xb7, 0xb5, 0x9d, 0xd5, 0xbd, 0xb7, 0xb2, 0x29, 0x9b, 0x0e, 0x53, 0x7f, 0xeb,
	0x12, 0x6d, 0xea, 0x74, 0x46, 0x82, 0x1e, 0x43, 0xd1, 0x0e, 0x7c, 0x9f, 0xda, 0x1c, 0x73, 0x77,
	0x44, 0x83, 0x98, 0x1b, 0x4b, 0x92, 0xf2, 0x56, 0x25, 0x71, 0x57, 0x25, 0x75, 0x57, 0xa5, 0xa1,
	0x9c, 0x5d, 0x43, 0xdf, 0xfc, 0xf3, 0xee, 0xc2, 0xef, 0xff, 0x75, 0x57, 0x93, 0x6b, 0xfc, 0x93,
	0x96, 0xbb, 0xbf, 0x60, 0x16, 0x14, 0x4b, 0x2f, 0x21, 0x41, 0x27, 0x70, 0x2f, 0x4c, 0x56, 0xe9,
	0x27, 0x21, 0x81, 0xfb, 0xf1, 0xc9, 0x09, 0x8d, 0xb0, 0xe7, 0x8e, 0x44, 0x54, 0x9d, 0x73, 0xca,
	0x8c, 0x2b, 0x72, 0xa6, 0xdb, 0x73, 0x33, 0x1d, 0xb5, 0x7c, 0xfe, 0x60, 0xef, 0x31, 0xf1, 0x62,
	0x6a, 0xde, 0x09, 0xe5, 0x5a, 0x15, 0x4b, 0x4d, 0x92, 0xb4, 0x05, 0x47, 0x4d, 0x50, 0xa0, 0x87,
	0xb0, 0xe2, 0xf5, 0x71, 0x18, 0x78, 0xae, 0x7d, 0x6e, 0xbc, 0x26, 0xfd, 0xbb, 0x95, 0xed, 0x8c,
	0x76, 0xff, 0x50, 0xa2, 0xa6, 0x5c, 0xbb, 0xec, 0x29, 0x29, 0x7a, 0x07, 0xae, 0x0c, 0x03, 0xc6,
	0x99, 0x71, 0x75, 0x7b, 0x71, 0x67, 0x75, 0xaf, 0x34, 0x4d, 0x22, 0xf2, 0xa6, 0x52, 0x4d, 0xf2,
	0xbf, 0x96, 0x33, 0x34, 0x33, 0x01, 0xa3, 0x3a, 0xe4, 0x27, 0x73, 0x8e, 0x19, 0xcb, 0xd2, 0x7a,
	0x2b, 0xc3, 0xfa, 0x40, 0xe2, 0xea, 0x02, 0x66, 0xae, 0x0d, 0x5f, 0x0c, 0x18, 0xfa, 0x0c, 0x36,
	0x47, 0xe4, 0x29, 0x8e, 0xe8, 0x97, 0x31, 0x65, 0x9c, 0xe1, 0x69, 0xc7, 0x19, 0x2b, 0x97, 0xf0,
	0x92, 0x31, 0x22, 0x4f, 0x4d, 0x65, 0x7f, 0x38, 0xe9, 0x30, 0x74, 0x08, 0xfa, 0x4c, 0x2a, 0x33,
	0x03, 0x24, 0xe3, 0x9b, 0x33, 0x8b, 0x54, 0x7e, 0xaa, 0x27, 0xe8, 0x9a, 0x02, 0x9b, 0x45, 0x7b,
	0x5a, 0x80, 0xf6, 0x61, 0x95, 0x7b, 0x4c, 0xac, 0x90, 0xd3, 0xa7, 0xdc, 0x58, 0xcd, 0x22, 0x13,
	0xe5, 0xb0, 0x72, 0x14, 0x32, 0x1e, 0x51, 0x32, 0xea, 0x79, 0xac, 0x9e, 0x80, 0x4d, 0xe0, 0xe3,
	0xff, 0xe8, 0x33, 0xb8, 0x3e, 0xe4, 0x3c, 0xc4, 0x69, 0x39, 0xc2, 0x41, 0x28, 0x93, 0xdd, 0xc8,
	0x4b, 0xc6, 0xef, 0x65, 0xf9, 0x90, 0xf3, 0xf0, 0xed, 0x43, 0x85, 0xef, 0x26, 0x70, 0x73, 0x43,
	0xb0, 0xcc, 0x08, 0xd1, 0xe7, 0x70, 0x43, 0x88, 0xf7, 0xe6, 0xd9, 0x0b, 0x2f, 0x65, 0xdf, 0x9b,
	0x65, 0xbf, 0x36, 0xcc, 0x90, 0x22, 0x0b, 0x74, 0xc7, 0x67, 0x38, 0xa2, 0x27, 0x11, 0x65, 0x43,
	0x1c, 0x11, 0x4e, 0x0d, 0xfd, 0x55, 0x79, 0x53, 0x98, 0xcd, 0x19, 0xc7, 0x67, 0x66, 0xc2, 0x60,
	0x12, 0x4e, 0xd1, 0xe7, 0xb0, 0x2e, 0x48, 0xbd, 0x20, 0x38, 0x8d, 0x43, 0x7c, 0x42, 0x46, 0xae,
	0x77, 0x6e, 0xac, 0xcb, 0x98, 0x7e, 0xf3, 0x82, 0x9a, 0xe1, 0xb3, 0xb6, 0x44, 0xef, 0x4b, 0xf0,
	0x54, 0x68, 0x17, 0x9d, 0x69, 0x25, 0xfa, 0x19, 0xe4, 0x93, 0x35, 0xb3, 0xc0, 0x3b, 0x13, 0x61,
	0x80, 0x5e, 0x15, 0xe9, 0xe6, 0x9a, 0x5c, 0xa1, 0xc2, 0x23, 0x0b, 0xd6, 0xe7, 0x2a, 0xbd, 0xb1,
	0x91, 0x55, 0x80, 0xd2, 0x58, 0xea, 0x26, 0xf0, 0x46, 0x8a, 0x36, 0xf5, 0x60, 0x46, 0x82, 0x7a,
	0xa0, 0xdb, 0x1e, 0x25, 0x7e, 0x1c, 0x62, 0xd7, 0xe7, 0x34, 0x3a, 0x23, 0x9e, 0x71, 0xed, 0xbb,
	0x7a, 0xb2, 0xa8, 0x28, 0x5a, 0x8a, 0x01, 0x75, 0xe1, 0x5a, 0xac, 0xa2, 0x0f, 0xf7, 0x5d, 0xdf,
	0x49, 0xcb, 0xe5, 0x75, 0xc9, 0x7c, 0x27, 0x63, 0xcb, 0x35, 0xd7, 0x77, 0x54, 0x95, 0x44, 0xa9,
	0xe9, 0x0b, 0x19, 0xea, 0x80, 0xee, 0xf5, 0x31, 0x8b, 0xfb, 0x8c, 0xf2, 0x94, 0xec, 0x86, 0x24,
	0x7b, 0xe3, 0xa2, 0x72, 0x63, 0x49, 0xb0, 0xe2, 0x2c, 0x78, 0x53, 0x63, 0x74, 0x0c, 0x1b, 0x91,
	0xeb, 0x0f, 0xf0, 0x90, 0xb0, 0x21, 0xf6, 0xfa, 0x29, 0xe5, 0xcd, 0x97, 0x95, 0x73, 0xd3, 0xf5,
	0x07, 0x07, 0x84, 0x0d, 0xdb, 0xfd, 0x84, 0xe4, 0x60, 0xc1, 0xd4, 0xa3, 0x19, 0x19, 0x7a, 0x04,
	0x3a, 0x8f, 0x88, 0xcf, 0xc2, 0x20, 0xe2, 0x98, 0x05, 0xf6, 0x29, 0xe5, 0x86, 0x21, 0x59, 0xcb,
	0x19, 0xbb, 0xee, 0xa5, 0x50, 0x4b, 0x22, 0xcd, 0x22, 0x9f, 0x16, 0xa0, 0x1f, 0xc3, 0xf2, 0x88,
	0x72, 0xe2, 0x10, 0x4e, 0x8c, 0x5b, 0x92, 0x66, 0x33, 0x83, 0xe6, 0x91, 0x82, 0x98, 0x63, 0x30,
	0xfa, 0x1c, 0xd0, 0x38, 0xf5, 0x18, 0xf5, 0x54, 0xb4, 0x94, 0x64, 0x34, 0x57, 0xb2, 0xf7, 0xa7,
	0x7e, 0xd3, 0x5c, 0xb3, 0x52, 0x2b, 0x73, 0x3d, 0x9c, 0x15, 0x89, 0xef, 0x61, 0x07, 0xa3, 0x51,
	0xe0, 0x4f, 0x38, 0x6f, 0xf3, 0x65, 0xdf, 0xa3, 0x2e, 0xd1, 0xa9, 0x9b, 0xc4, 0x79, 0x35, 0x39,
	0x46, 0x65, 0xc8, 0x13, 0x8f, 0x63, 0xc6, 0x09, 0xc7, 0xf2, 0x28, 0xbf, 0x2d, 0x8e, 0x72, 0x73,
	0x95, 0x78, 0xdc, 0xe2, 0x84, 0x77, 0xc4, 0x31, 0x3e, 0x80, 0xdb, 0x6a, 0xce, 0xec, 0xba, 0x75,
	0x27, 0x33, 0x15, 0xd2, 0xca, 0x32, 0x5b, 0x58, 0x6e, 0x25, 0x5c, 0x19, 0x2a, 0x34, 0x80, 0xcd,
	0x71, 0xf4, 0x4e, 0x9c, 0xa0, 0xe9, 0x3c, 0x5b, 0x59, 0x15, 0x2c, 0x2d, 0xb6, 0x2f, 0x4a, 0xff,
	0x78, 0xa2, 0xf8, 0x22, 0x15, 0x3a, 0x82, 0x1d, 0xdb, 0x0b, 0x18, 0x9d, 0x98, 0x85, 0x61, 0xb1,
	0xbf, 0x80, 0x71, 0xac, 0x0e, 0xb6, 0x13, 0xe2, 0x7a, 0x71, 0x44, 0x8d, 0xbb, 0xdb, 0xda, 0xce,
	0xb2, 0xf9, 0xba, 0xc4, 0xbf, 0x60, 0x62, 0x5d, 0xff, 0x20, 0x60, 0x3c, 0x39, 0xdc, 0xf6, 0x13,
	0x28, 0x3a, 0x80, 0x7b, 0x4e, 0x44, 0x5c, 0x3f, 0x93, 0x36, 0xa2, 0xa3, 0x40, 0x24, 0xf9, 0xb6,
	0xe4, 0xbb, 0x23, 0x81, 0x73, 0x7c, 0x66, 0x02, 0x42, 0x6d, 0x28, 0x7a, 0x01, 0x71, 0x30, 0x61,
	0xcc, 0x1d, 0xf8, 0x23, 0xea, 0x73, 0xe3, 0x9e, 0xdc, 0x7d, 0x76, 0x13, 0xd5, 0x0e, 0x88, 0x53,
	0x1d, 0x43, 0xcd, 0x82, 0x37, 0x35, 0x46, 0x5f, 0xc0, 0x8d, 0x20, 0x72, 0x07, 0xae, 0x4f, 0x3c,
	0xec, 0x30, 0x3e, 0x11, 0x3a, 0x65, 0x49, 0xfa, 0xfd, 0xec, 0xd0, 0xe9, 0x2a, 0x9b, 0x06, 0xe3,
	0x13, 0xa9, 0xb7, 0x11, 0xcc, 0x8b, 0xd1, 0x97, 0x50, 0xa2, 0x4f, 0x39, 0xf5, 0x99, 0xf8, 0x5e,
	0x73, 0x01, 0xf2, 0xba, 0x2c, 0xb8, 0x0f, 0x2e, 0x68, 0xd6, 0x52, 0xbb, 0x99, 0x68, 0x68, 0xfa,
	0x3c, 0x3a, 0x37, 0x0d, 0x7a, 0x81, 0xba, 0x14, 0x83, 0x3e, 0xdb, 0xe7, 0xa1, 0x8f, 0x00, 0x64,
	0xaf, 0x98, 0x6c, 0x4e, 0x93, 0x9b, 0xbb, 0x9b, 0x11, 0x97, 0x09, 0xdc, 0x92, 0x77, 0x0e, 0x73,
	0x45, 0x34, 0x87, 0x89, 0xfd, 0x3d, 0x58, 0x63, 0x34, 0x3a, 0x73, 0x6d, 0x9a, 0x24, 0x43, 0x2e,
	0x49, 0x06, 0x25, 0x13, 0xc9, 0x50, 0x72, 0xe0, 0xce, 0x4b, 0x57, 0x8c, 0x74, 0x58, 0x3c, 0xa5,
	0xe7, 0x49, 0x4b, 0x6c, 0x8a, 0xbf, 0xe8, 0x87, 0x70, 0xe5, 0x4c, 0x74, 0x2b, 0x92, 0x6e, 0x75,
	0xef, 0xe6, 0x5c, 0x7d, 0xb7, 0x64, 0xbb, 0x6e, 0x26, 0xa8, 0xf7, 0x73, 0x3f, 0xd1, 0x4a, 0x7f,
	0x5b, 0x84, 0xc2, 0x74, 0x25, 0x45, 0x21, 0x14, 0x4f, 0x88, 0xe7, 0xf5, 0x89, 0x7d, 0x9a, 0xf6,
	0x7d, 0x9a, 0xac, 0x2a, 0x3f, 0xbd, 0x4c, 0x21, 0x1e, 0x0f, 0xf7, 0x15, 0x47, 0x46, 0x53, 0x58,
	0x38, 0x99, 0xd2, 0xa1, 0x8f, 0xa0, 0xe0, 0xd0, 0x13, 0x12, 0x8b, 0xfa, 0x20, 0x6d, 0x5f, 0xb5,
	0x81, 0xbc, 0x82, 0x27, 0x33, 0xa1, 0x2f, 0x40, 0x57, 0x07, 0x47, 0x52, 0x08, 0x83, 0x88, 0x19,
	0x8b, 0x32, 0x14, 0xde, 0xfd, 0x4e, 0x4b, 0xb6, 0x94, 0xb5, 0x59, 0x64, 0x53, 0x63, 0x86, 0xf6,
	0xe0, 0xba, 0x17, 0xd8, 0xc4, 0x73, 0xf9, 0x39, 0x7e, 0x42, 0xdd, 0xc1, 0x90, 0x63, 0xf2, 0x84,
	0x44, 0x54, 0xf6, 0xf2, 0xcb, 0xe6, 0x46, 0xaa, 0x3c, 0x96, 0xba, 0xaa, 0x50, 0x95, 0xde, 0x02,
	0x7d, 0x96, 0x18, 0x21, 0x58, 0x3a, 0xa5, 0xe7, 0xcc, 0xd0, 0xb6, 0x17, 0x77, 0x56, 0x4c, 0xf9,
	0xbf, 0xdc, 0x85, 0x1b, 0xd9, 0x3e, 0x43, 0x45, 0x58, 0xed, 0x74, 0xf1, 0x7e, 0xb5, 0xdd, 0xae,
	0x55, 0xeb, 0x9f, 0xe8, 0x0b, 0x48, 0x87, 0xb5, 0x6a, 0xe7, 0x53, 0xdc, 0xec, 0x34, 0x0e, 0xbb,
	0xad, 0x4e, 0x4f, 0xd7, 0x10, 0x82, 0x42, 0xa3, 0xb9, 0x5f, 0x3d, 0x6a, 0xf7, 0xb0, 0x75, 0x54,
	0xb3, 0x9a, 0x3d, 0x3d, 0x57, 0xfa, 0x5d, 0x0e, 0xf4, 0xd9, 0xa3, 0x0c, 0x3d, 0x86, 0xf5, 0x91,
	0xeb, 0xbb, 0xa3, 0x78, 0x84, 0xe5, 0xb9, 0xc8, 0xdc, 0x67, 0x54, 0x05, 0x6e, 0x76, 0xe7, 0xfb,
	0xde, 0x3b, 0xb2, 0xf3, 0xad, 0xad, 0x89, 0x0f, 0x77, 0x75, 0xef, 0x8a, 0xf1, 0xd5, 0x57, 0x5f,
	0x2d, 0x99, 0x45, 0x45, 0x22, 0xf8, 0x2d, 0xf7, 0x19, 0x45, 0xbf, 0x84, 0xbc, 0x43, 0xc3, 0x88,
	0xda, 0x84, 0x53, 0x07, 0x9f, 0xbd, 0xad, 0x3e, 0xdd, 0x83, 0xcb, 0x9d, 0xb0, 0x95, 0xc6, 0xd8,
	0xf6, 0xf1, 0xdb, 0xb2, 0xef, 0x5f, 0x73, 0x26, 0x24, 0xa5, 0x36, 0xac, 0x4d, 0x22, 0xd0, 0x07,
	0xb0, 0x16, 0x33, 0x8a, 0x19, 0x77, 0xe4, 0xc1, 0xae, 0x36, 0x50, 0x9a, 0xdb, 0x40, 0x2d, 0x08,
	0xbc, 0xa4, 0x71, 0x87, 0x98, 0x51, 0x8b, 0x3b, 0x62, 0xd2, 0xd2, 0x87, 0xb0, 0x91, 0x51, 0x6a,
	0xd0, 0x5b, 0x50, 0x14, 0xa4, 0xf2, 0xcc, 0x19, 0x52, 0xe2, 0xd0, 0x48, 0xf2, 0x2e, 0x9b, 0xf9,
	0x98, 0x51, 0x71, 0x7c, 0x1c, 0x48, 0x61, 0xe9, 0x3f, 0x4b, 0x50, 0x98, 0x3e, 0xe5, 0xd0, 0x27,
	0x70, 0x33, 0xa9, 0xe2, 0xe7, 0x38, 0x24, 0xbe, 0x6b, 0x63, 0x3e, 0x14, 0xdd, 0x66, 0xe0, 0x39,
	0x6a, 0x69, 0x1b, 0xca, 0x0f, 0xe2, 0x86, 0x59, 0x39, 0x4c, 0xae, 0xe2, 0xe6, 0x75, 0x65, 0x73,
	0x28, 0x4c, 0x7a, 0xa9, 0x05, 0x72, 0xe1, 0xda, 0xb3, 0xc0, 0xa7, 0x49, 0x64, 0x4d, 0xd4, 0xce,
	0xc4, 0xa3, 0xef, 0x5d, 0xe6, 0xd8, 0xad, 0xfc, 0x22, 0xf0, 0xa9, 0x0c, 0xbf, 0x89, 0x42, 0xba,
	0xfe, 0x6c, 0x56, 0x88, 0x7e, 0x0d, 0x9b, 0x33, 0xf1, 0x4c, 0x9d, 0x89, 0x19, 0x93, 0x4b, 0xef,
	0x87, 0x97, 0x9a, 0xb1, 0x3d, 0x15, 0xfa, 0xd4, 0x99, 0x98, 0xd8, 0xf0, 0x2e, 0xd0, 0xa1, 0x16,
	0x6c, 0xc4, 0xa1, 0x43, 0x38, 0xc5, 0x23, 0x1a, 0x0d, 0x28, 0x7e, 0xe2, 0xfa, 0x4e, 0xf0, 0xe4,
	0x95, 0x37, 0x63, 0x73, 0x3d, 0xb1, 0x7a, 0x24, 0x8c, 0x8e, 0xa5, 0x4d, 0xe9, 0x0f, 0x1a, 0xac,
	0xcf, 0xed, 0x1a, 0x7d, 0x00, 0xc5, 0x28, 0x88, 0xb9, 0x88, 0x74, 0xea, 0x93, 0xbe, 0x47, 0x5f,
	0xfa, 0x41, 0x0a, 0x0a, 0xdb, 0x4c, 0xa0, 0x68, 0x1f, 0xf4, 0x91, 0x38, 0x5d, 0xd5, 0x53, 0x80,
	0xcc, 0x95, 0xdc, 0xab, 0x73, 0xc5, 0x2c, 0x8c, 0x5c, 0x5f, 0xb9, 0x49, 0x24, 0x47, 0xa9, 0x04,
	0xc6, 0x45, 0xee, 0xa9, 0x6d, 0xc2, 0xad, 0xf1, 0x27, 0x48, 0xdf, 0xa6, 0x42, 0x6a, 0xbb, 0x27,
	0x2e, 0x8d, 0xca, 0xc7, 0x90, 0x9f, 0x7a, 0xae, 0x40, 0x00, 0xaf, 0x59, 0xbd, 0x6a, 0xaf, 0x55,
	0xd7, 0x17, 0x50, 0x01, 0xc0, 0xea, 0x99, 0xad, 0x7a, 0x0f, 0x37, 0x3a, 0x96, 0xae, 0x89, 0x32,
	0xd1, 0xee, 0x3e, 0x6c, 0xd5, 0xab, 0x6d, 0x29, 0xc8, 0xa1, 0xab, 0xb0, 0xd8, 0x6c, 0x58, 0xfa,
	0xa2, 0xa8, 0x17, 0x5d, 0xb3, 0xf5, 0xb0, 0xd5, 0x11, 0x2a, 0xab, 0xa7, 0x2f, 0x95, 0x7f, 0x05,
	0xcb, 0xe9, 0x3d, 0x5d, 0xd8, 0x99, 0xdd, 0xa3, 0x4e, 0x03, 0x9b, 0xdd, 0x5a, 0xab, 0xa3, 0x2f,
	0xa0, 0x75, 0xc8, 0xb7, 0x9b, 0x55, 0xab, 0x87, 0xcd, 0xe6, 0xcf, 0x8f, 0x9a, 0x96, 0xa8, 0x2f,
	0x79, 0x58, 0x31, 0x5b, 0x9d, 0x87, 0xf8, 0xa0, 0x6a, 0x1d, 0xe8, 0x39, 0xb1, 0x0c, 0xb3, 0xda,
	0x69, 0x74, 0x1f, 0xe9, 0x8b, 0x68, 0x03, 0x8a, 0x93, 0xe4, 0xb8, 0x5d, 0xd3, 0x97, 0x04, 0xe0,
	0x51, 0xf5, 0x61, 0xbb, 0xf9, 0x58, 0xbf, 0x52, 0x7e, 0x17, 0x8a, 0x33, 0xf7, 0x27, 0xb4, 0x0c,
	0x4b, 0xd5, 0xa3, 0x5e, 0x57, 0x5f, 0x40, 0xab, 0x70, 0xf5, 0xf1, 0x3b, 0xb8, 0xdb, 0x69, 0x7f,
	0xaa, 0x6b, 0x72, 0xf0, 0x5e, 0x32, 0xc8, 0x95, 0x7b, 0x60, 0x5c, 0xd4, 0xa8, 0xa2, 0x4d, 0xb8,
	0x79, 0x64, 0x35, 0x71, 0xbd, 0xdb, 0xd9, 0x6f, 0x3d, 0x3c, 0x32, 0x9b, 0x0d, 0x7c, 0x68, 0x76,
	0x7b, 0xdd, 0x7a, 0xb7, 0xad, 0x2f, 0xa4, 0xca, 0x46, 0xf7, 0xb8, 0x63, 0xf5, 0xcc, 0x66, 0xf5,
	0xd1, 0x0b, 0xa5, 0x56, 0x5b, 0x95, 0xef, 0x18, 0x89, 0xa3, 0x3f, 0x5e, 0x5a, 0x5e, 0xd3, 0xf3,
	0x1f, 0x2f, 0x2d, 0x17, 0x75, 0xbd, 0x7c, 0x0c, 0xe8, 0x68, 0xfe, 0x3a, 0x52, 0x85, 0x42, 0xf2,
	0x52, 0x88, 0xd5, 0xa3, 0xe4, 0xb8, 0xd4, 0x5c, 0x7c, 0x99, 0xcb, 0x27, 0x16, 0x6a, 0x58, 0x26,
	0x70, 0xeb, 0xc2, 0x9e, 0x11, 0x35, 0x20, 0xcf, 0xed, 0x10, 0x9f, 0x52, 0x1a, 0x12, 0xcf, 0x3d,
	0xa3, 0x2f, 0xe9, 0x21, 0x7a, 0x76, 0xf8, 0x49, 0x0a, 0x33, 0xd7, 0xf8, 0xc4, 0x68, 0xef, 0x1f,
	0x39, 0xb8, 0xa9, 0x7c, 0x35, 0x0e, 0x17, 0x2b, 0xe9, 0x21, 0xd0, 0x31, 0x14, 0xac, 0x64, 0xf2,
	0x04, 0xc0, 0xd0, 0xcc, 0xa3, 0xc9, 0xd8, 0x42, 0xbd, 0x6b, 0x94, 0xee, 0x5e, 0xa8, 0x67, 0x61,
	0xe0, 0x33, 0x5a, 0x5e, 0xd8, 0xd1, 0x7e, 0xa4, 0xa1, 0x08, 0x36, 0x5a, 0xbe, 0x1d, 0x51, 0xd1,
	0xf1, 0x11, 0x6f, 0xcc, 0x3e, 0xd3, 0xdb, 0x4d, 0x40, 0xe6, 0x26, 0xba, 0x7f, 0x19, 0xe8, 0xd4,
	0x9c, 0x0c, 0xf2, 0xfb, 0x94, 0xdb, 0xc3, 0xff, 0xdf, 0x5e, 0xee, 0x7d, 0xfd, 0xf7, 0x6f, 0x7f,
	0x9b, 0xdb, 0x2c, 0xdf, 0x98, 0x7a, 0xf9, 0x7d, 0x5f, 0xa5, 0x3c, 0x7b, 0x5f, 0xbb, 0x5f, 0xdb,
	0xf8, 0xe3, 0xf3, 0x2d, 0xed, 0x9b, 0xe7, 0x5b, 0xda, 0x5f, 0x9f, 0x6f, 0x69, 0xff, 0x7e, 0xbe,
	0xa5, 0xfd, 0x46, 0xd3, 0xfa, 0xaf, 0xc9, 0xc4, 0x7f, 0xf0, 0xbf, 0x00, 0x00, 0x00, 0xff, 0xff,
	0x1a, 0x9e, 0x33, 0x67, 0xe5, 0x16, 0x00, 0x00,
}
